/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.nsh;

import com.tridium.nsh.Exec;
import com.tridium.nsh.Expr;
import com.tridium.sys.NreLib;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintStream;
import java.util.HashMap;
import java.util.Iterator;
import javax.baja.nre.util.Array;
import javax.baja.nre.util.SortUtil;
import javax.baja.nre.util.TextUtil;
import javax.baja.sys.BModule;
import javax.baja.sys.Sys;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class NShell {
    static final BModule module;
    PrintStream out;
    File cd;
    HashMap env;
    boolean debug;
    Exec exec;
    static /* synthetic */ Class class$com$tridium$nsh$NShell;
    static /* synthetic */ Class class$java$lang$String;

    public PrintStream out() {
        return this.out;
    }

    public String getenv(String string) {
        return (String)this.env.get(TextUtil.toUpperCase((String)string));
    }

    public void setenv(String string, String string2) {
        if (string2 == null) {
            this.env.remove(TextUtil.toUpperCase((String)string));
        } else {
            this.env.put(TextUtil.toUpperCase((String)string), string2);
        }
    }

    public String[] envp() {
        String[] stringArray = new String[this.env.size()];
        Iterator iterator = this.env.keySet().iterator();
        int n = 0;
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            String string2 = (String)this.env.get(string);
            stringArray[n] = string + '=' + string2;
            ++n;
        }
        return stringArray;
    }

    public boolean isDebug() {
        return this.debug;
    }

    public void setDebug(boolean bl) {
        this.debug = bl;
    }

    public void debug(String string) {
        this.out.println("-- " + string);
    }

    public void debug(Expr expr) {
        if (expr.help()) {
            this.out.println();
            this.out.println(" debug [on | off]");
            this.out.println("   Turn debug on and off");
            this.out.println();
            return;
        }
        if (expr.args.length > 0) {
            String string = TextUtil.toUpperCase((String)expr.args[0]);
            if (string.equals("ON") || string.equals("TRUE")) {
                this.debug = true;
            }
            if (string.equals("OFF") || string.equals("FALSE")) {
                this.debug = false;
            }
        }
        this.out.println("debug = " + (this.debug ? "on" : "off"));
    }

    public File cd() {
        return this.cd;
    }

    public void cd(Expr expr) {
        if (expr.help()) {
            this.out.println();
            this.out.println(" cd");
            this.out.println("   Dump current working directory");
            this.out.println(" cd <dir>");
            this.out.println("   Change to the specified directory");
            this.out.println();
            return;
        }
        if (expr.args.length > 0) {
            File file = this.cd;
            String string = expr.args[0];
            if (this.debug) {
                this.debug("filename: " + string);
            }
            if (this.debug) {
                this.debug("old: " + file);
            }
            try {
                boolean bl;
                boolean bl2 = false;
                if (string.startsWith("/") || string.startsWith("\\") || string.length() >= 2 && string.charAt(1) == ':') {
                    bl2 = bl = true;
                }
                if (this.debug) {
                    this.debug("abs: " + bl);
                }
                this.cd = bl ? new File(string) : new File(file, string);
                if (this.debug) {
                    this.debug("new: " + this.cd);
                }
                this.cd = new File(this.cd.getCanonicalPath());
                if (this.debug) {
                    this.debug("canonical: " + this.cd);
                }
                if (!this.cd.exists()) {
                    throw new IOException();
                }
            }
            catch (IOException iOException) {
                this.out.println("Cannot find path specified");
                if (this.debug) {
                    this.debug("fallback:  " + this.cd);
                }
                this.cd = file;
            }
        } else {
            this.out.println(this.cd.toString());
        }
    }

    public void set(Expr expr) {
        if (expr.help()) {
            this.out.println();
            this.out.println(" set");
            this.out.println("   Dumps all the environment variables");
            this.out.println(" set <prefix>");
            this.out.println("   Dumps all the environment variables starting with prefix");
            this.out.println(" set <name>=");
            this.out.println("   Removes the specified environment variable");
            this.out.println(" set <name>=<value>");
            this.out.println("   Sets the specified environment variable");
            this.out.println();
            return;
        }
        if (expr.args.length == 0) {
            this.setdump("");
            return;
        }
        String string = expr.args[0];
        int n = string.indexOf(61);
        if (n < 0) {
            this.setdump(string);
            return;
        }
        String string2 = string.substring(0, n);
        String string3 = string.substring(n + 1);
        if (string3.length() == 0) {
            if (this.debug) {
                this.debug("set remove " + string2);
            }
            this.setenv(string2, null);
        } else {
            if (this.debug) {
                this.debug("set " + string2 + '=' + string3);
            }
            this.setenv(string2, string3);
        }
    }

    private final void setdump(String string) {
        string = TextUtil.toUpperCase((String)string);
        Object[] objectArray = this.envp();
        SortUtil.sort((Object[])objectArray);
        int n = 0;
        while (n < objectArray.length) {
            if (TextUtil.toUpperCase((String)objectArray[n]).startsWith(string)) {
                this.out.println("  " + (String)objectArray[n]);
            }
            ++n;
        }
    }

    /*
     * Unable to fully structure code
     */
    public void reset(Expr var1_1) {
        if (var1_1 != null && var1_1.help()) {
            this.out.println();
            this.out.println(" reset");
            this.out.println("   Reset the environment to its default state");
            this.out.println();
            return;
        }
        this.env = new HashMap<K, V>();
        this.env.put("BAJAHOME", Sys.getBajaHome().toString());
        this.mapenv("PATH");
        if (System.getProperty("os.name").toLowerCase().startsWith("win")) {
            this.mapenv("USERDNSDOMAIN");
            this.mapenv("USERDOMAIN");
            this.mapenv("USERNAME");
            this.mapenv("SYSTEMROOT");
        } else {
            this.mapenv("LD_LIBRARY_PATH");
            this.env.put("NIAGARA_HOME", Sys.getBajaHome().toString());
        }
        var2_2 = this.getenv("PATH");
        var3_3 = Sys.getBajaHome().toString() + File.separator + "bin";
        var4_4 = true;
        if (var2_2 != null && var2_2.indexOf(var3_3) != -1) {
            var4_4 = false;
        }
        if (var4_4) {
            this.setenv("PATH", var3_3 + File.pathSeparator + this.getenv("PATH"));
        }
        if ((var5_5 = System.getProperty("sedona.home")) == null) {
            var5_5 = Sys.getBajaHome().toString() + File.separator + "sedona";
        }
        try {
            var5_5 = new File(var5_5).getCanonicalPath();
        }
        catch (IOException var6_6) {
            ** while (var5_5.indexOf((String)new String((String)(File.separator + File.separator))) != -1)
        }
lbl-1000:
        // 1 sources

        {
            var5_5 = TextUtil.replace((String)var5_5, (String)new String(File.separator + File.separator), (String)File.separator);
            continue;
        }
lbl36:
        // 2 sources

        var6_7 = var5_5 + File.separator + "bin";
        var2_2 = this.getenv("PATH");
        var4_4 = true;
        if (var2_2 != null && var2_2.indexOf(var6_7) != -1) {
            var4_4 = false;
        }
        if (var4_4) {
            this.setenv("PATH", var6_7 + File.pathSeparator + this.getenv("PATH"));
        }
        this.cd = Sys.getBajaHome();
    }

    private final void mapenv(String string) {
        this.setenv(string, NreLib.getenv((String)string));
    }

    public File[] path() {
        String string = this.getenv("PATH");
        if (string == null) {
            return new File[0];
        }
        String[] stringArray = TextUtil.split((String)string, (char)File.pathSeparatorChar);
        File[] fileArray = new File[stringArray.length];
        int n = 0;
        while (n < stringArray.length) {
            fileArray[n] = new File(stringArray[n]);
            ++n;
        }
        return fileArray;
    }

    public File which(String string) {
        File file = new File(string);
        if (file.exists()) {
            return file;
        }
        File[] fileArray = this.path();
        int n = 0;
        while (n < fileArray.length) {
            file = new File(fileArray[n], string);
            if (file.exists()) {
                return file;
            }
            ++n;
        }
        return null;
    }

    public void which(Expr expr) {
        if (expr.help() || expr.args.length == 0) {
            this.out.println();
            this.out.println(" which <filename>");
            this.out.println("   Find the first occurance of filename in path list");
            this.out.println();
            return;
        }
        File file = this.which(expr.args[0]);
        if (file == null) {
            this.out.println("Not found");
        } else {
            this.out.println(file);
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run(Expr expr) throws Exception {
        File file = this.which(expr.cmd);
        if (file == null) {
            this.out.print("Not Found: " + expr.cmd);
            return;
        }
        BufferedReader bufferedReader = new BufferedReader(new FileReader(file));
        try {
            String string;
            while ((string = bufferedReader.readLine()) != null) {
                if ((string = string.trim()).length() == 0 || string.startsWith("#")) continue;
                this.exec(string);
            }
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            bufferedReader.close();
            throw throwable;
        }
        {
            Object var5_7 = null;
        }
        bufferedReader.close();
    }

    public void print(Expr expr) {
        if (expr.help()) {
            this.out.println();
            this.out.println(" print <message>");
            this.out.println("   Echo message to output stream");
            this.out.println();
            return;
        }
        String string = expr.string;
        int n = string.indexOf(32);
        String string2 = "";
        if (n > 0) {
            string2 = string.substring(n + 1);
        }
        this.out.println(string2);
    }

    public void help(Expr expr) {
        if (expr.help()) {
            this.out.println();
            this.out.println(" help");
            this.out.println("   Display help summary");
            this.out.println();
            return;
        }
        this.out.println();
        this.out.println("Niagara Shell Help (Version " + module.getVendorVersion() + ')');
        this.out.println("  cd     View and change current directory");
        this.out.println("  debug  Turn debug tracing on and off");
        this.out.println("  print  Print to the output stream");
        this.out.println("  reset  Reset the environment to its default state");
        this.out.println("  set    View and modify environment variables");
        this.out.println("  which  Resolve a filename in path");
        this.out.println();
        this.out.println("Additional help available via <cmd> -?");
        this.out.println();
    }

    public void exec(String string) throws Exception {
        if (string.equals("")) {
            return;
        }
        Expr expr = Expr.parse(this, string);
        String string2 = expr.cmd;
        if (string2.equals("?")) {
            this.help(expr);
            return;
        }
        if (string2.equals("cd")) {
            this.cd(expr);
            return;
        }
        if (string2.equals("debug")) {
            this.debug(expr);
            return;
        }
        if (string2.equals("help")) {
            this.help(expr);
            return;
        }
        if (string2.equals("print")) {
            this.print(expr);
            return;
        }
        if (string2.equals("reset")) {
            this.reset(expr);
            return;
        }
        if (string2.equals("set")) {
            this.set(expr);
            return;
        }
        if (string2.equals("which")) {
            this.which(expr);
            return;
        }
        if (string2.endsWith(".nsh")) {
            this.run(expr);
            return;
        }
        String[] stringArray = System.getProperty("os.name").toLowerCase().startsWith("win") ? new String[]{"cmd", "/c", "\"" + string + '\"'} : NShell.splitIgnoreSpacesInQuotes(string);
        this.exec = new Exec(this, stringArray, this.envp(), this.cd, this.out);
        this.exec.start();
    }

    static String[] splitIgnoreSpacesInQuotes(String string) {
        char[] cArray = string.toCharArray();
        Class clazz = class$java$lang$String;
        if (clazz == null) {
            clazz = class$java$lang$String = NShell.class("[Ljava.lang.String;", false);
        }
        Array array = new Array(clazz);
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        int n = 0;
        while (n < cArray.length) {
            if (cArray[n] == '\"') {
                if (!bl && cArray[n + 1] == '\"') {
                    array.add((Object)"\"\"");
                }
                bl ^= true;
            } else if (!bl && cArray[n] == ' ') {
                if (stringBuffer.length() > 0) {
                    array.add((Object)stringBuffer.toString());
                    stringBuffer.setLength(0);
                }
            } else {
                stringBuffer.append(cArray[n]);
            }
            ++n;
        }
        if (stringBuffer.length() > 0) {
            array.add((Object)stringBuffer.toString());
        }
        return (String[])array.trim();
    }

    public boolean inExec() {
        boolean bl = false;
        if (this.exec != null) {
            bl = true;
        }
        return bl;
    }

    public void execWaitUntilDone() throws Exception {
        this.exec.waitUntilDone();
    }

    public void execDone(int n) {
        this.exec = null;
    }

    public void execKill() {
        this.out.println("***Kill***");
        if (this.exec != null) {
            this.exec.kill();
        }
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public NShell(PrintStream printStream) {
        this.out = printStream;
        this.reset(null);
    }

    static {
        Class clazz = class$com$tridium$nsh$NShell;
        if (clazz == null) {
            clazz = class$com$tridium$nsh$NShell = NShell.class("[Lcom.tridium.nsh.NShell;", false);
        }
        module = Sys.getModuleForClass((Class)clazz);
    }
}

