/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.nsh;

import com.tridium.nsh.Expr;
import com.tridium.nsh.NShell;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;

public class Main {
    public static void usage(PrintWriter printWriter) {
        printWriter.println("usage: nsh [file] [options]");
        printWriter.println("  Execute the specified nsh file; if no file");
        printWriter.println("  specified then enter interactive console.");
        printWriter.println("options:");
        printWriter.println("  /?      Display this usage");
        printWriter.println("  /debug  Turn on debug tracing");
        printWriter.flush();
    }

    public static void runFile(NShell nShell, String[] stringArray) throws Exception {
        String string = "";
        int n = 0;
        while (n < stringArray.length) {
            if (n > 0) {
                string = string + ' ';
            }
            string = string + stringArray[0];
            ++n;
        }
        Expr expr = Expr.parse(nShell, string);
        nShell.run(expr);
    }

    public static void runConsole(NShell nShell, InputStream inputStream) {
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
        while (true) {
            try {
                nShell.out.print("nsh|" + nShell.cd + '>');
                nShell.out.flush();
                String string = bufferedReader.readLine().trim();
                if (string.length() == 0) continue;
                if (string.equals("quit")) {
                    return;
                }
                if (string.equals("exit")) {
                    return;
                }
                nShell.exec(string);
                continue;
            }
            catch (Throwable throwable) {
                throwable.printStackTrace(nShell.out);
                continue;
            }
            break;
        }
    }

    public static void main(String[] stringArray) throws Exception {
        NShell nShell = new NShell(System.out);
        String string = null;
        int n = 0;
        while (n < stringArray.length) {
            String string2 = stringArray[n].intern();
            if (string2 == "/?" || string2 == "/help") {
                Main.usage(new PrintWriter(System.out));
                return;
            }
            if (string2 == "/debug") {
                nShell.setDebug(true);
            } else {
                string = string2;
            }
            ++n;
        }
        if (string == null) {
            Main.runConsole(nShell, System.in);
        } else {
            Main.runFile(nShell, stringArray);
        }
    }
}

