/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.nsh;

import com.tridium.nsh.NShell;
import java.util.ArrayList;
import javax.baja.nre.util.TextUtil;

public class Expr {
    public String string;
    public String cmd;
    public String[] args;
    public String[] options;

    public static Expr parse(NShell nShell, String string) {
        if (nShell.debug) {
            nShell.debug("Expr.parse: \"" + string + '\"');
        }
        string = Expr.resolve(nShell, string);
        String[] stringArray = TextUtil.split((String)string, (char)' ');
        ArrayList<String> arrayList = new ArrayList<String>();
        ArrayList<String> arrayList2 = new ArrayList<String>();
        int n = 1;
        while (n < stringArray.length) {
            String string2 = stringArray[n];
            if (string2.length() >= 2 && string2.charAt(0) == '-') {
                arrayList2.add(string2.substring(1));
            } else {
                arrayList.add(string2);
            }
            ++n;
        }
        Expr expr = new Expr();
        expr.string = string;
        expr.cmd = TextUtil.toLowerCase((String)stringArray[0]);
        expr.args = arrayList.toArray(new String[arrayList.size()]);
        expr.options = arrayList2.toArray(new String[arrayList2.size()]);
        if (nShell.debug) {
            nShell.debug("  cmd    = " + expr.cmd);
            int n2 = 0;
            while (n2 < expr.args.length) {
                nShell.debug("  arg[" + n2 + "] = " + expr.args[n2]);
                ++n2;
            }
            n2 = 0;
            while (n2 < expr.options.length) {
                nShell.debug("  opt[" + n2 + "] = " + expr.options[n2]);
                ++n2;
            }
        }
        return expr;
    }

    public static String resolve(NShell nShell, String string) {
        try {
            int n = 1;
            while (true) {
                String string2;
                if ((string2 = Expr.onePassResolve(nShell, string)).equals(string)) {
                    return string;
                }
                if (nShell.debug) {
                    nShell.debug("    resolve(" + n + ") -> \"" + string2 + '\"');
                }
                string = string2;
                ++n;
            }
        }
        catch (Exception exception) {
            return string;
        }
    }

    private static final String onePassResolve(NShell nShell, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        StringBuffer stringBuffer2 = new StringBuffer();
        int n = string.length();
        int n2 = 0;
        while (n2 < n) {
            char c = string.charAt(n2);
            if (c != '%') {
                stringBuffer.append(c);
            } else if ((c = string.charAt(++n2)) == '%') {
                stringBuffer.append('%');
            } else {
                stringBuffer2.setLength(0);
                int n3 = n2;
                while ((c = string.charAt(n3++)) != '%') {
                    stringBuffer2.append(c);
                }
                String string2 = stringBuffer2.toString();
                String string3 = nShell.getenv(string2);
                if (string3 == null) {
                    string3 = "";
                }
                stringBuffer.append(string3);
                n2 = n3 - 1;
            }
            ++n2;
        }
        return stringBuffer.toString();
    }

    public boolean help() {
        boolean bl = false;
        if (this.has("?") || this.has("help")) {
            bl = true;
        }
        return bl;
    }

    public boolean has(String string) {
        int n = 0;
        while (n < this.options.length) {
            if (string.equals(this.options[n])) {
                return true;
            }
            ++n;
        }
        return false;
    }
}

