/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.mbus.utils;

import com.tridium.mbus.BAbstractMbusNetwork;
import com.tridium.mbus.BMbusDevice;
import com.tridium.mbus.comm.MBusTxTimings;
import com.tridium.mbus.db.BMbusPointData;
import com.tridium.mbus.enums.BMbusDescription;
import com.tridium.mbus.enums.BMbusDeviceTypeId;
import com.tridium.mbus.enums.BMbusFunction;
import com.tridium.mbus.enums.BMbusHeaderTypes;
import com.tridium.mbus.enums.BMbusNumberType;
import com.tridium.mbus.enums.BMbusOrthogonalDescription;
import com.tridium.mbus.enums.BMbusUnit;
import com.tridium.mbus.messages.MbusReqUd2Message;
import com.tridium.mbus.messages.MbusResponseMessage;
import com.tridium.mbus.utils.MbusDataDecoderIEC870;
import com.tridium.mbus.utils.MbusEnhancedVifExtensionConvertor;
import com.tridium.mbus.utils.MbusExtendedIndicatorVifConvertor;
import com.tridium.mbus.utils.MbusExtendedVifConvertor;
import com.tridium.mbus.utils.MbusLogInputOutput;
import com.tridium.mbus.utils.MbusTextUtil;
import com.tridium.mbus.utils.MbusToolkit;
import com.tridium.mbus.utils.MbusVifConvertor;
import java.util.ArrayList;
import javax.baja.io.ByteBuffer;
import javax.baja.serial.BBaudRate;
import javax.baja.status.BStatus;
import javax.baja.status.BStatusBoolean;
import javax.baja.status.BStatusEnum;
import javax.baja.status.BStatusNumeric;
import javax.baja.status.BStatusString;
import javax.baja.status.BStatusValue;
import javax.baja.util.TextUtil;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public final class MbusDecodeVariableFrame {
    String identNumber;
    String secondaryAddress;
    String manufacturer;
    String fabricationNumber;
    int versionNumber;
    BMbusDeviceTypeId deviceTypeId;
    int difeUnit;
    int access;
    String status;
    int storageNumber;
    BMbusFunction function;
    int difeTariff;
    int dataType;
    String description;
    BMbusOrthogonalDescription orthogonalDescription;
    BMbusUnit unitType;
    int exponent;
    double offset;
    boolean vifStringFlag;
    boolean status5;
    boolean status6;
    boolean status7;
    String vifString;
    BStatusValue value;
    int finishedAtIndex;
    int recordNumber;
    int lastRecordNumber;
    BMbusDevice device;
    BAbstractMbusNetwork network;
    int inputSlot;
    long blockSize;
    long blockDate;
    long blockInterval;
    boolean manufacturersData;
    int manufacturersIndex;
    boolean specialFunctionFound;
    int maxSpecialFunctionQty;
    int specialFunctionQty;
    private ArrayList activedataInformation;

    private final void init(int[] nArray, BAbstractMbusNetwork bAbstractMbusNetwork, BMbusDevice bMbusDevice, boolean bl, boolean bl2, int n, DecoderOverrides decoderOverrides) {
        if (MbusToolkit.isTraceOn()) {
            MbusToolkit.trace(" IN MbusDecodeVariableFrame ");
        }
        int n2 = 0;
        this.device = bMbusDevice;
        this.network = bAbstractMbusNetwork;
        this.maxSpecialFunctionQty = n;
        this.specialFunctionQty = 0;
        if (this.device != null) {
            if (this.device.getHeaderType().equals((Object)BMbusHeaderTypes.zeroLength)) {
                nArray[6] = 120;
            } else if (this.device.getHeaderType().equals((Object)BMbusHeaderTypes.byte4)) {
                nArray[6] = 122;
            }
            if (this.device.getHeaderType().equals((Object)BMbusHeaderTypes.byte12)) {
                nArray[6] = 114;
            }
            if (this.device.getHeaderType().equals((Object)BMbusHeaderTypes.byte12Mode2)) {
                nArray[6] = 118;
            }
        }
        n2 = this.decodeFixedDataHeader(nArray);
        if (MbusToolkit.isTraceOn()) {
            MbusToolkit.trace(" Returned from decodeFixedDataHeader ");
        }
        this.decodeVariableDataBlocks(nArray, n2, bMbusDevice, bl, bl2, n, decoderOverrides);
    }

    public final int decodeFixedDataHeader(int[] nArray) {
        if (MbusToolkit.isTraceOn()) {
            MbusToolkit.trace(" IN decodeFixedDataHeader ");
        }
        int n = 7;
        int n2 = 0;
        int n3 = 0;
        if (nArray[6] == 122 || nArray[6] == 114) {
            if (nArray[6] == 122) {
                n2 = nArray[7];
                n3 = nArray[8];
                n = 11;
            } else {
                if (MbusToolkit.isTraceOn()) {
                    MbusToolkit.trace(" IN 12 Byte Header ");
                }
                this.identNumber = MbusTextUtil.intToHexString((nArray[10] & 0xF0) >> 4, 1);
                this.identNumber = this.identNumber + MbusTextUtil.intToHexString(nArray[10] & 0xF, 1);
                this.identNumber = this.identNumber + MbusTextUtil.intToHexString((nArray[9] & 0xF0) >> 4, 1);
                this.identNumber = this.identNumber + MbusTextUtil.intToHexString(nArray[9] & 0xF, 1);
                this.identNumber = this.identNumber + MbusTextUtil.intToHexString((nArray[8] & 0xF0) >> 4, 1);
                this.identNumber = this.identNumber + MbusTextUtil.intToHexString(nArray[8] & 0xF, 1);
                this.identNumber = this.identNumber + MbusTextUtil.intToHexString((nArray[7] & 0xF0) >> 4, 1);
                this.identNumber = this.identNumber + MbusTextUtil.intToHexString(nArray[7] & 0xF, 1);
                this.secondaryAddress = MbusTextUtil.intToHexString((nArray[11] & 0xF0) >> 4, 1);
                this.secondaryAddress = this.secondaryAddress + MbusTextUtil.intToHexString(nArray[11] & 0xF, 1);
                this.secondaryAddress = this.secondaryAddress + MbusTextUtil.intToHexString((nArray[12] & 0xF0) >> 4, 1);
                this.secondaryAddress = this.secondaryAddress + MbusTextUtil.intToHexString(nArray[12] & 0xF, 1);
                this.secondaryAddress = this.secondaryAddress + MbusTextUtil.intToHexString((nArray[13] & 0xF0) >> 4, 1);
                this.secondaryAddress = this.secondaryAddress + MbusTextUtil.intToHexString(nArray[13] & 0xF, 1);
                this.secondaryAddress = this.secondaryAddress + MbusTextUtil.intToHexString((nArray[14] & 0xF0) >> 4, 1);
                this.secondaryAddress = this.secondaryAddress + MbusTextUtil.intToHexString(nArray[14] & 0xF, 1);
                this.secondaryAddress = this.identNumber + this.secondaryAddress;
                int n4 = nArray[11] | nArray[12] << 8;
                byte[] byArray = new byte[3];
                byArray[2] = (byte)((n4 & 0x1F) + 64);
                byArray[1] = (byte)((n4 >> 5 & 0x1F) + 64);
                byArray[0] = (byte)((n4 >> 10 & 0x1F) + 64);
                this.manufacturer = new String(byArray);
                this.versionNumber = nArray[13];
                this.deviceTypeId = nArray[14] <= 25 ? BMbusDeviceTypeId.make(nArray[14]) : BMbusDeviceTypeId.reserved;
                n2 = nArray[15];
                n3 = nArray[16];
                n = 19;
            }
            if (MbusToolkit.isTraceOn()) {
                MbusToolkit.trace(" IN Common Header ");
            }
            this.access = n2;
            if ((n3 & 0xF) == 0) {
                this.status = this.status + "No Application Error; ";
            } else if ((n3 & 0xF) == 1) {
                this.status = this.status + "Application Busy; ";
            } else if ((n3 & 0xF) == 2) {
                this.status = this.status + "Application Error; ";
            } else if ((n3 & 0xF) == 3) {
                this.status = this.status + "Application Reserved State; ";
            }
            if ((n3 & 8) != 0) {
                this.status = this.status + "Permanent Error; ";
            }
            if ((n3 & 0x10) != 0) {
                this.status = this.status + "Temporary Error; ";
            }
            this.status5 = (n3 & 0x20) != 0;
            this.status6 = (n3 & 0x40) != 0;
            this.status7 = (n3 & 0x80) != 0;
        }
        return n;
    }

    public final void decodeVariableDataBlocks(int[] nArray, int n, BMbusDevice bMbusDevice, boolean bl, boolean bl2, int n2) {
        this.decodeVariableDataBlocks(nArray, n, bMbusDevice, bl, bl2, n2, null);
    }

    public final void decodeVariableDataBlocks(int[] nArray, int n, BMbusDevice bMbusDevice, boolean bl, boolean bl2, int n2, DecoderOverrides decoderOverrides) {
        if (MbusToolkit.isTraceOn()) {
            MbusToolkit.trace(" IN decodeVariableDataBlocks ");
        }
        int[] nArray2 = nArray;
        int n3 = n;
        boolean bl3 = true;
        this.manufacturersData = false;
        boolean bl4 = false;
        if (bMbusDevice == null) {
            bl4 = true;
        }
        if (decoderOverrides != null) {
            this.recordNumber = decoderOverrides.recordNumber;
            this.inputSlot = decoderOverrides.inputSlot;
        }
        while (bl3) {
            Object object;
            this.finishedAtIndex = this.decodeDataInformationBlock(nArray2, n3, bl4, bl2);
            if (this.finishedAtIndex == -1) {
                ++n3;
                continue;
            }
            if (MbusToolkit.isTraceOn()) {
                MbusToolkit.trace(" Returned from decodeDataInformationBlock ");
            }
            if (this.recordNumber > this.lastRecordNumber && bl && this.specialFunctionQty < n2) {
                if (MbusToolkit.isTraceOn()) {
                    MbusToolkit.trace("MBUSDECODEVARIABLEFRAME: recordNumber = " + this.recordNumber + "  and lastRecordNumber= " + this.lastRecordNumber);
                }
                if (this.device != null && this.recordNumber > this.device.getMaxInputsPerCycleCount()) {
                    this.device.setMaxInputsPerCycleCount(this.recordNumber);
                }
                this.lastRecordNumber = this.recordNumber;
                if (this.network != null) {
                    MbusReqUd2Message mbusReqUd2Message = new MbusReqUd2Message(this.device, this.network);
                    if (this.device != null) {
                        mbusReqUd2Message.setMessageBaudRate(this.device.getBaudRate());
                    } else {
                        mbusReqUd2Message.setMessageBaudRate(this.network.getSearchBaudRate());
                    }
                    object = null;
                    if (this.network.getSendLockActive() == null && MbusLogInputOutput.log.isLoggable(2)) {
                        MbusLogInputOutput.log.warning("No lock active while reading continuation data");
                    }
                    long l = MBusTxTimings.calculateTxRxTime(261L, (BBaudRate)mbusReqUd2Message.getMessageBaudRate());
                    object = (MbusResponseMessage)this.network.sendMBusSyncActiveParams(mbusReqUd2Message, l += MBusTxTimings.calculateTxRxTime(mbusReqUd2Message, (BBaudRate)mbusReqUd2Message.getMessageBaudRate()));
                    if (object != null && object.getSuccessfulResponse()) {
                        if (MbusLogInputOutput.log.isTraceOn()) {
                            MbusLogInputOutput.log.trace("Input(Multiple Records):- " + ((MbusResponseMessage)((Object)object)).toDebugString());
                        }
                        byte[] byArray = ((MbusResponseMessage)((Object)object)).getBytes();
                        int[] nArray3 = new int[byArray.length];
                        if (byArray.length > 8) {
                            int n4 = 0;
                            while (n4 < byArray.length) {
                                nArray3[n4] = byArray[n4] & 0xFF;
                                ++n4;
                            }
                            n3 = this.decodeFixedDataHeader(nArray3);
                            nArray2 = nArray3;
                            continue;
                        }
                        bl3 = false;
                        continue;
                    }
                    bl3 = false;
                    continue;
                }
                bl3 = false;
                continue;
            }
            if (this.manufacturersIndex == -1 && !this.specialFunctionFound) {
                int n5 = 0;
                if (this.alreadyExists(this.description, this.orthogonalDescription, this.unitType, this.recordNumber, this.function, this.exponent)) {
                    n5 = this.inputSlot;
                }
                if (this.storageNumber == 1) {
                    n5 = 0;
                }
                object = new BMbusPointData();
                object.setUnit(this.unitType);
                object.setDescription(this.description);
                object.setExponent(this.exponent);
                object.setValue((BStatusValue)this.value.newCopy());
                object.setStorageNumber(this.storageNumber);
                object.setFunction(this.function);
                object.setOrthogonalDescription(this.orthogonalDescription);
                object.setRecordNumber(this.recordNumber);
                object.setMessageSlotNumber(n5);
                if (this.description.equals(BMbusDescription.sizeOfStorageBlock.toString())) {
                    this.blockSize = (long)((BStatusNumeric)this.value).getValue();
                }
                if (this.description.equals(BMbusDescription.date.toString()) || this.description.equals(BMbusDescription.dateAndTime.toString()) || this.orthogonalDescription.equals((Object)BMbusOrthogonalDescription.startDate)) {
                    object.setNumberType(BMbusNumberType.dateIp);
                } else if (this.value instanceof BStatusNumeric) {
                    object.setNumberType(BMbusNumberType.numericIp);
                } else if (this.value instanceof BStatusBoolean) {
                    object.setNumberType(BMbusNumberType.booleanIp);
                } else if (this.value instanceof BStatusEnum) {
                    object.setNumberType(BMbusNumberType.enumIp);
                } else if (this.value instanceof BStatusString) {
                    object.setNumberType(BMbusNumberType.stringIp);
                } else {
                    object.setNumberType(BMbusNumberType.notKnown);
                }
                if (this.value.getStatus().equals((Object)BStatus.ok)) {
                    this.activedataInformation.add(object);
                    ++this.inputSlot;
                }
            }
            if (this.finishedAtIndex > nArray2.length - 3) {
                if (MbusToolkit.isTraceOn()) {
                    if (this.finishedAtIndex - 1 < nArray2.length) {
                        MbusToolkit.trace("MBUSDECODEVARIABLEFRAME-END-1: index = [" + (this.finishedAtIndex - 1) + "] with value 0x" + TextUtil.byteToHexString((int)nArray2[this.finishedAtIndex - 1]) + " which is " + nArray2[this.finishedAtIndex - 1]);
                    }
                    if (this.finishedAtIndex < nArray2.length) {
                        MbusToolkit.trace("MBUSDECODEVARIABLEFRAME-END+0: index = [" + this.finishedAtIndex + "] with value 0x" + TextUtil.byteToHexString((int)nArray2[this.finishedAtIndex]) + " which is " + nArray2[this.finishedAtIndex]);
                    }
                    if (this.finishedAtIndex + 1 < nArray2.length) {
                        MbusToolkit.trace("MBUSDECODEVARIABLEFRAME-END+1: index = [" + (this.finishedAtIndex + 1) + "] with value 0x" + TextUtil.byteToHexString((int)nArray2[this.finishedAtIndex + 1]) + " which is " + nArray2[this.finishedAtIndex + 1]);
                    }
                }
                bl3 = false;
                continue;
            }
            n3 = this.finishedAtIndex;
        }
        if (decoderOverrides != null) {
            decoderOverrides.recordNumber = this.recordNumber;
            decoderOverrides.inputSlot = this.inputSlot;
        }
    }

    private final int decodeDataInformationBlock(int[] nArray, int n, boolean bl, boolean bl2) {
        String string;
        Object object;
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        if (MbusToolkit.isTraceOn()) {
            MbusToolkit.trace(" IN decodeDataInformationBlock ");
            ByteBuffer byteBuffer = new ByteBuffer(nArray.length);
            n6 = 0;
            while (n6 < nArray.length) {
                byteBuffer.write(nArray[n6]);
                ++n6;
            }
            MbusToolkit.trace(" IN RAW : 0x" + byteBuffer.dumpToString());
        }
        int n7 = n;
        n6 = 0;
        int n8 = nArray[n7];
        this.orthogonalDescription = BMbusOrthogonalDescription.none;
        this.description = "None";
        this.manufacturersIndex = -1;
        this.difeTariff = 0;
        this.difeUnit = 0;
        int n9 = 0;
        if ((n8 & 0xF) == 15) {
            switch (n8) {
                case 31: {
                    if (MbusToolkit.isTraceOn()) {
                        MbusToolkit.trace(" Found Special Functions  Data ");
                    }
                    this.specialFunctionFound = true;
                    ++this.specialFunctionQty;
                    ++this.recordNumber;
                    return nArray.length;
                }
                case 15: {
                    if (MbusToolkit.isTraceOn()) {
                        MbusToolkit.trace(" Found Manufactures Data at " + n);
                    }
                    this.manufacturersIndex = n + 1;
                    return nArray.length;
                }
                case 47: {
                    if (MbusToolkit.isTraceOn()) {
                        MbusToolkit.trace(" Found Idle Filler at " + n);
                    }
                    return n + 1;
                }
            }
        } else if (MbusToolkit.isTraceOn()) {
            MbusToolkit.trace(" Decoding DIF Byte 0x" + TextUtil.byteToHexString((int)n8));
        }
        this.specialFunctionFound = false;
        if ((n8 & 0x80) != 0) {
            n6 = 1;
        }
        this.storageNumber = (n8 & 0x40) != 0 ? 1 : 0;
        if (MbusToolkit.isTraceOn()) {
            MbusToolkit.trace(" Decoding DIF Byte Storage number is " + this.storageNumber);
        }
        this.function = BMbusFunction.make(n8 >> 4 & 3);
        if (MbusToolkit.isTraceOn()) {
            MbusToolkit.trace(" Decoding DIF Byte Function is " + (Object)((Object)this.function));
        }
        this.dataType = n8 & 0xF;
        int n10 = 0;
        int n11 = n7 + 1;
        int n12 = 0;
        int n13 = 1;
        while (n6 != 0) {
            n12 = nArray[n11];
            if (MbusToolkit.isTraceOn()) {
                MbusToolkit.trace(" Processing DIF Extension 0x" + TextUtil.byteToHexString((int)n12) + " at index " + n11);
            }
            if ((n12 & 0x80) == 0) {
                n6 = 0;
            }
            n5 = 0;
            if ((n12 & 0x40) != 0) {
                n5 = 1;
            }
            this.difeUnit |= (n5 <<= n9);
            ++n9;
            n4 = n12 >> 4 & 3;
            this.difeTariff = this.difeTariff << 2 | n4;
            long l = (long)(n12 & 0xF) << n13;
            n13 += 4;
            this.storageNumber = (int)((long)this.storageNumber | l) & Short.MAX_VALUE;
            ++n11;
            if (++n10 <= 9) continue;
            n6 = 0;
        }
        n4 = n5 = n11;
        n10 = 0;
        n6 = 0;
        int n14 = nArray[n5];
        if (MbusToolkit.isTraceOn()) {
            MbusToolkit.trace(" Processing VIF 0x" + TextUtil.byteToHexString((int)n14) + " at index " + n5);
        }
        int n15 = 0;
        if ((n14 & 0x80) != 0) {
            n6 = 1;
        }
        int n16 = n5 + 1;
        int n17 = n6;
        if (n17 != 0) {
            n16 = n5;
            while (n17 != 0) {
                n3 = nArray[n16];
                if ((n3 & 0x80) != 0) {
                    n17 = 1;
                    ++n16;
                    continue;
                }
                n17 = 0;
            }
            ++n16;
        }
        if (MbusToolkit.isTraceOn()) {
            MbusToolkit.trace(" Expected data start position = " + n16);
        }
        n3 = n14 & 0x7F;
        if (n6 != 0) {
            if (n14 == 253) {
                if (MbusToolkit.isTraceOn()) {
                    MbusToolkit.trace(" Processing VIFE 1 0xFD");
                }
                n3 = nArray[++n4] & 0x7F;
                if (MbusToolkit.isTraceOn()) {
                    MbusToolkit.trace(" Processing VIFE 2 0x" + TextUtil.byteToHexString((int)n3) + " at index " + n4);
                }
                if ((nArray[n4] & 0x80) == 0) {
                    n6 = 0;
                }
                this.description = MbusExtendedVifConvertor.getDescription(n3).toString();
                this.unitType = MbusExtendedVifConvertor.getUnits(n3);
                this.exponent = MbusExtendedVifConvertor.getValueExponent(n3);
                ++n5;
            } else if (n14 == 251) {
                if (MbusToolkit.isTraceOn()) {
                    MbusToolkit.trace(" Processing VIFE 1 0xFB");
                }
                n3 = nArray[++n4] & 0x7F;
                if (MbusToolkit.isTraceOn()) {
                    MbusToolkit.trace(" Processing VIFE 2 0x" + TextUtil.byteToHexString((int)n3) + " at index " + n4);
                }
                if ((nArray[n4] & 0x80) == 0) {
                    n6 = 0;
                }
                this.description = MbusExtendedIndicatorVifConvertor.getDescription(n3).toString();
                this.unitType = MbusExtendedIndicatorVifConvertor.getUnits(n3);
                this.exponent = MbusExtendedIndicatorVifConvertor.getValueExponent(n3);
                ++n5;
            } else if (n14 == 252) {
                if (MbusToolkit.isTraceOn()) {
                    MbusToolkit.trace(" Processing VIFE 1 0xFC");
                }
                n2 = nArray[n5 + 1];
                object = new char[n2];
                int n18 = 0;
                while (n18 < n2) {
                    object[n2 - n18 - 1] = (char)nArray[n18 + n5 + 2];
                    ++n18;
                }
                string = new String((char[])object);
                this.value = new BStatusString(string, BStatus.ok);
                n5 += nArray[n5 + 1];
                if ((nArray[n4] & 0x80) != 0) {
                    n6 = 1;
                }
                ++n5;
            } else if (n14 == 255) {
                if (MbusToolkit.isTraceOn()) {
                    MbusToolkit.trace(" Processing VIFE 1 0xFF");
                }
                n3 = nArray[++n4] & 0x7F;
                if (MbusToolkit.isTraceOn()) {
                    MbusToolkit.trace(" Processing VIFE 2 0x" + TextUtil.byteToHexString((int)n3) + " at index " + n4);
                }
                if ((nArray[n4] & 0x80) == 0) {
                    n6 = 0;
                }
                this.description = "ManufacturerSpecific";
                this.orthogonalDescription = MbusEnhancedVifExtensionConvertor.getDescription(127, nArray[n4]);
                this.unitType = BMbusUnit.none;
                this.exponent = 0;
                ++n5;
            } else if (n14 < 251) {
                if (MbusToolkit.isTraceOn()) {
                    MbusToolkit.trace(" Processing VIFE 1 0x" + TextUtil.byteToHexString((int)n14) + " at index " + n4);
                }
                this.description = MbusVifConvertor.getDescription(n3, false).toString();
                this.unitType = MbusVifConvertor.getUnits(n3, false);
                this.exponent = MbusVifConvertor.getValueExponent(n3);
                ++n5;
            }
            if (n6 != 0) {
                n3 = nArray[++n4];
                if (MbusToolkit.isTraceOn()) {
                    MbusToolkit.trace(" Processing VIFE 3 0x" + TextUtil.byteToHexString((int)n3) + " at index " + n4);
                }
                if ((nArray[n4] & 0x80) == 0) {
                    n6 = 0;
                }
                if (n3 == 61) {
                    this.unitType = MbusVifConvertor.getUnits(n3, true);
                    this.description = MbusVifConvertor.getDescription(n3, true).toString();
                } else if ((n3 = nArray[n4++] & 0x7F) == 125) {
                    this.exponent += 3;
                } else if (n3 > 111 && n3 < 120) {
                    n2 = n3 & 7;
                    this.exponent = this.exponent + n2 - 6;
                } else if (n3 > 119 && n3 < 124) {
                    this.offset = (double)(n3 & 3) - (double)3;
                } else {
                    this.orthogonalDescription = n3 == 127 ? MbusEnhancedVifExtensionConvertor.getDescription(n3, nArray[n4]) : MbusEnhancedVifExtensionConvertor.getDescription(n3, 0);
                }
            }
        } else if (n3 < 123) {
            this.description = MbusVifConvertor.getDescription(n3, false).toString();
            this.unitType = MbusVifConvertor.getUnits(n3, false);
            this.exponent = MbusVifConvertor.getValueExponent(n3);
            if (n3 == 120) {
                this.fabricationNumber = MbusTextUtil.intToHexString((nArray[n5 + 4] & 0xF0) >> 4, 1);
                this.fabricationNumber = this.fabricationNumber + MbusTextUtil.intToHexString(nArray[n5 + 4] & 0xF, 1);
                this.fabricationNumber = this.fabricationNumber + MbusTextUtil.intToHexString((nArray[n5 + 3] & 0xF0) >> 4, 1);
                this.fabricationNumber = this.fabricationNumber + MbusTextUtil.intToHexString(nArray[n5 + 3] & 0xF, 1);
                this.fabricationNumber = this.fabricationNumber + MbusTextUtil.intToHexString((nArray[n5 + 2] & 0xF0) >> 4, 1);
                this.fabricationNumber = this.fabricationNumber + MbusTextUtil.intToHexString(nArray[n5 + 2] & 0xF, 1);
                this.fabricationNumber = this.fabricationNumber + MbusTextUtil.intToHexString((nArray[n5 + 1] & 0xF0) >> 4, 1);
                this.fabricationNumber = this.fabricationNumber + MbusTextUtil.intToHexString(nArray[n5 + 1] & 0xF, 1);
            }
        } else if (n3 == 124) {
            char[] cArray = new char[nArray[n5 + 1]];
            int n19 = cArray.length;
            int n20 = 0;
            while (n20 < n19) {
                cArray[n19 - n20 - 1] = (char)nArray[n20 + n5 + 2];
                ++n20;
            }
            String string2 = new String(cArray) + "  ";
            n5 = n5 + nArray[n5 + 1] + 2;
            char[] cArray2 = new char[nArray[n5]];
            n19 = cArray2.length;
            ++n5;
            if (this.dataType == 13) {
                int n21 = 0;
                while (n21 < n19) {
                    cArray2[n19 - n21 - 1] = (char)nArray[n21 + n5];
                    ++n21;
                }
            } else {
                MbusDataDecoderIEC870.ValueData valueData = MbusDataDecoderIEC870.decode(n5 - 1, nArray, this.dataType, bl, bl2);
                String string3 = new String(valueData.getValue().toString());
                string2 = string2 + string3;
                this.value = new BStatusString(string2, BStatus.ok);
                return valueData.getIndex();
            }
            String string4 = new String(cArray2);
            string2 = string2 + string4;
            this.value = new BStatusString(string2, BStatus.ok);
            return n5 += n19;
        }
        n4 = n5 + 1;
        while (n6 != 0) {
            n15 = nArray[n4];
            if (MbusToolkit.isTraceOn()) {
                MbusToolkit.trace(" Processing addition VIFE 0x" + TextUtil.byteToHexString((int)n15) + " at index " + n4);
            }
            if (n15 == 255) {
                this.orthogonalDescription = MbusEnhancedVifExtensionConvertor.getDescription(127, nArray[n4 + 1]);
            }
            if ((n15 & 0x80) == 0) {
                n6 = 0;
            }
            ++n4;
            if (++n10 <= 9) continue;
            n6 = 0;
        }
        n2 = n4;
        if (MbusToolkit.isTraceOn()) {
            MbusToolkit.trace(" Processing data from index " + n2);
        }
        if (this.description.equals(BMbusDescription.date.toString()) && this.dataType == 2) {
            this.dataType = 18;
        } else if (this.description.equals(BMbusDescription.dateAndTime.toString())) {
            if (this.dataType == 4) {
                this.dataType = 19;
            } else if (this.dataType == 3) {
                this.dataType = 21;
            } else if (this.dataType == 6) {
                this.dataType = 20;
            }
        }
        if (this.orthogonalDescription.equals((Object)BMbusOrthogonalDescription.startDate)) {
            this.dataType = this.dataType == 2 ? 18 : 19;
        }
        object = MbusDataDecoderIEC870.decode(n16, nArray, this.dataType, bl, bl2);
        this.value = ((MbusDataDecoderIEC870.ValueData)object).getValue();
        if (this.value instanceof BStatusNumeric) {
            string = (BStatusNumeric)this.value;
            this.value = new BStatusNumeric((string.getValue() + this.offset) * Math.pow(10.0, this.exponent), BStatus.ok);
        }
        if (this.difeTariff != 0) {
            this.description = this.description + " Tariff " + this.difeTariff;
        }
        if (this.difeUnit != 0) {
            this.description = this.description + " SubUnit " + this.difeUnit;
        }
        return ((MbusDataDecoderIEC870.ValueData)object).getIndex();
    }

    private final boolean alreadyExists(String string, BMbusOrthogonalDescription bMbusOrthogonalDescription, BMbusUnit bMbusUnit, int n, BMbusFunction bMbusFunction, int n2) {
        boolean bl = false;
        int n3 = 0;
        while (n3 < this.activedataInformation.size()) {
            BMbusPointData bMbusPointData = (BMbusPointData)((Object)this.activedataInformation.get(n3));
            if (bMbusPointData.getUnit().equals((Object)bMbusUnit) && bMbusPointData.getDescription().equals(string) && bMbusPointData.getRecordNumber() == n && bMbusPointData.getFunction() == bMbusFunction && bMbusPointData.getOrthogonalDescription().equals((Object)bMbusOrthogonalDescription)) {
                bl = true;
                break;
            }
            ++n3;
        }
        return bl;
    }

    public final String getIdentNumber() {
        return this.identNumber;
    }

    public final String getSecondaryAddress() {
        return this.secondaryAddress;
    }

    public final String getManufacturer() {
        return this.manufacturer;
    }

    public final int getVersionNumber() {
        return this.versionNumber;
    }

    public final BMbusDeviceTypeId getDeviceTypeId() {
        return this.deviceTypeId;
    }

    public final int getAccess() {
        return this.access;
    }

    public final String getStatus() {
        return this.status;
    }

    public final boolean getStatusBit5() {
        return this.status5;
    }

    public final boolean getStatusBit6() {
        return this.status6;
    }

    public final boolean getStatusBit7() {
        return this.status7;
    }

    public final int getDifeUnit() {
        return this.difeUnit;
    }

    public final int getDifeTariff() {
        return this.difeTariff;
    }

    public final ArrayList getData() {
        return this.activedataInformation;
    }

    public final long getStorageBlockSize() {
        return this.blockSize;
    }

    public final long getStorageBlockDate() {
        return this.blockDate;
    }

    public final long getStorageBlockInterval() {
        return this.blockInterval;
    }

    public final int getManufacturersIndex() {
        return this.manufacturersIndex;
    }

    public final String getFabricationNumber() {
        return this.fabricationNumber;
    }

    public final boolean getSpecialFunctionFound() {
        return this.specialFunctionFound;
    }

    public final int getInputSlot() {
        return this.inputSlot;
    }

    public final void overrideParser(int n) {
        this.inputSlot = n;
    }

    private final /* synthetic */ void this() {
        this.identNumber = "";
        this.secondaryAddress = "";
        this.manufacturer = "No Manufacturer";
        this.fabricationNumber = "";
        this.versionNumber = 0;
        this.deviceTypeId = BMbusDeviceTypeId.other;
        this.difeUnit = 0;
        this.access = 0;
        this.status = "";
        this.storageNumber = 0;
        this.function = BMbusFunction.instantaneous;
        this.difeTariff = 0;
        this.dataType = 0;
        this.description = "None";
        this.orthogonalDescription = BMbusOrthogonalDescription.none;
        this.unitType = BMbusUnit.none;
        this.exponent = 0;
        this.offset = 0.0;
        this.vifStringFlag = false;
        this.status5 = false;
        this.status6 = false;
        this.status7 = false;
        this.vifString = "";
        this.value = new BStatusString("No Data", BStatus.ok);
        this.finishedAtIndex = 0;
        this.recordNumber = 1;
        this.lastRecordNumber = 1;
        this.device = null;
        this.network = null;
        this.inputSlot = 1;
        this.blockSize = 0L;
        this.blockDate = 0L;
        this.blockInterval = 0L;
        this.manufacturersData = false;
        this.manufacturersIndex = -1;
        this.specialFunctionFound = false;
        this.maxSpecialFunctionQty = 0;
        this.specialFunctionQty = 0;
        this.activedataInformation = new ArrayList();
    }

    public MbusDecodeVariableFrame(byte[] byArray, BAbstractMbusNetwork bAbstractMbusNetwork, BMbusDevice bMbusDevice, boolean bl, boolean bl2, int n) {
        this(byArray, bAbstractMbusNetwork, bMbusDevice, bl, bl2, n, (DecoderOverrides)null);
    }

    public MbusDecodeVariableFrame(byte[] byArray, BAbstractMbusNetwork bAbstractMbusNetwork, BMbusDevice bMbusDevice, boolean bl, boolean bl2, int n, DecoderOverrides decoderOverrides) {
        this.this();
        int[] nArray = new int[byArray.length];
        int n2 = 0;
        while (n2 < byArray.length) {
            nArray[n2] = byArray[n2] & 0xFF;
            ++n2;
        }
        this.init(nArray, bAbstractMbusNetwork, bMbusDevice, bl, bl2, n, decoderOverrides);
    }

    public MbusDecodeVariableFrame(int[] nArray, BAbstractMbusNetwork bAbstractMbusNetwork, BMbusDevice bMbusDevice, boolean bl, boolean bl2, int n) {
        this.this();
        this.init(nArray, bAbstractMbusNetwork, bMbusDevice, bl, bl2, n, null);
    }

    public MbusDecodeVariableFrame(int[] nArray, BAbstractMbusNetwork bAbstractMbusNetwork, BMbusDevice bMbusDevice, boolean bl, boolean bl2, int n, DecoderOverrides decoderOverrides) {
        this.this();
        this.init(nArray, bAbstractMbusNetwork, bMbusDevice, bl, bl2, n, decoderOverrides);
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public static class DecoderOverrides {
        public int inputSlot;
        public int recordNumber;

        private final /* synthetic */ void this() {
            this.inputSlot = 1;
            this.recordNumber = 1;
        }

        public DecoderOverrides() {
            this.this();
        }
    }
}

