/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.mbus.utils;

import com.tridium.mbus.enums.BMbusCommandCodes;
import com.tridium.mbus.utils.MbusLogInputOutput;
import com.tridium.mbus.utils.MbusToolkit;
import javax.baja.status.BStatus;
import javax.baja.status.BStatusNumeric;
import javax.baja.status.BStatusString;
import javax.baja.status.BStatusValue;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BMonth;
import javax.baja.util.TextUtil;

public final class MbusDataDecoderIEC870 {
    public static final ValueData decode(int n, int[] nArray, int n2, boolean bl, boolean bl2) {
        BStatusNumeric bStatusNumeric;
        int n3;
        block120: {
            block121: {
                block119: {
                    if (MbusToolkit.isTraceOn()) {
                        MbusToolkit.trace("In MbusDataDecoderIEC870(),index = " + n + "  Code= " + n2 + "  Value= " + nArray[n]);
                    }
                    n3 = 0;
                    bStatusNumeric = new BStatusNumeric(0.0, BStatus.fault);
                    switch (n2) {
                        case 0: {
                            if (MbusToolkit.isTraceOn()) {
                                MbusToolkit.trace("NO DATA");
                            }
                            n3 = 0;
                            break;
                        }
                        case 1: 
                        case 9: {
                            n3 = 1;
                            if (!MbusToolkit.isTraceOn()) break;
                            MbusDataDecoderIEC870.traceRawData(n3, "INT_8BIT || BCD_2DIGIT", nArray, n);
                            break;
                        }
                        case 2: 
                        case 10: 
                        case 18: {
                            n3 = 2;
                            if (!MbusToolkit.isTraceOn()) break;
                            MbusDataDecoderIEC870.traceRawData(n3, "INT_16BIT || BCD_4DIGIT || CP_16DATE", nArray, n);
                            break;
                        }
                        case 3: 
                        case 11: 
                        case 21: {
                            n3 = 3;
                            if (!MbusToolkit.isTraceOn() || !MbusToolkit.isTraceOn()) break;
                            MbusDataDecoderIEC870.traceRawData(n3, "INT_24BIT || BCD_6DIGIT || TIME_OF_DAY", nArray, n);
                            break;
                        }
                        case 4: 
                        case 5: 
                        case 12: 
                        case 19: 
                        case 22: {
                            n3 = 4;
                            if (!MbusToolkit.isTraceOn() || !MbusToolkit.isTraceOn()) break;
                            MbusDataDecoderIEC870.traceRawData(n3, "INT_32BIT || REAL_32DIGIT || BCD_8DIGIT || CP_32DATE || DAYLIGHT_SAVING", nArray, n);
                            break;
                        }
                        case 6: 
                        case 14: 
                        case 20: {
                            n3 = 6;
                            if (!MbusToolkit.isTraceOn() || !MbusToolkit.isTraceOn()) break;
                            MbusDataDecoderIEC870.traceRawData(n3, "INT_48BIT || BCD_12DIGIT || YEAR_TO_SECOND", nArray, n);
                            break;
                        }
                        case 7: {
                            n3 = 8;
                            if (!MbusToolkit.isTraceOn() || !MbusToolkit.isTraceOn()) break;
                            MbusDataDecoderIEC870.traceRawData(n3, "INT_64BIT", nArray, n);
                            break;
                        }
                        case 8: {
                            n3 = 1;
                            if (!MbusToolkit.isTraceOn() || !MbusToolkit.isTraceOn()) break;
                            MbusDataDecoderIEC870.traceRawData(n3, "READOUT_SELECTION", nArray, n);
                            break;
                        }
                        case 13: 
                        case 16: {
                            n3 = nArray[n] + 1;
                            if (!MbusToolkit.isTraceOn() || !MbusToolkit.isTraceOn()) break;
                            MbusDataDecoderIEC870.traceRawData(n3, "VAR_LENGTH || STRING", nArray, n);
                            break;
                        }
                        case 15: {
                            n3 = nArray.length - n;
                            if (!MbusToolkit.isTraceOn() || !MbusToolkit.isTraceOn()) break;
                            MbusDataDecoderIEC870.traceRawData(n3, "SPECIAL FUNCTIONS", nArray, n);
                            break;
                        }
                        case 17: {
                            n3 = nArray.length - n;
                            if (!MbusToolkit.isTraceOn() || !MbusToolkit.isTraceOn()) break;
                            MbusDataDecoderIEC870.traceRawData(n3, "CP_16UNITS_AND_INFO", nArray, n);
                            break;
                        }
                        default: {
                            n3 = 1;
                        }
                    }
                    if (n + n3 <= nArray.length) break block119;
                    bStatusNumeric = new BStatusString("Number Out of bounds", BStatus.fault);
                    break block120;
                }
                if (bl) break block121;
                if (bl2) {
                    if (MbusToolkit.isTraceOn()) {
                        MbusToolkit.trace("Apply MODE 2 ACTIVE during decode");
                    }
                    MbusDataDecoderIEC870.mode2Swap(nArray, n, n3);
                }
                double d = 1.0;
                switch (n2) {
                    case 0: {
                        bStatusNumeric = new BStatusNumeric(0.0, BStatus.ok);
                        break;
                    }
                    case 1: {
                        bStatusNumeric = new BStatusNumeric((double)((byte)nArray[n]), BStatus.ok);
                        break;
                    }
                    case 2: {
                        int n4 = nArray[n + 1] << 8 | nArray[n];
                        bStatusNumeric = new BStatusNumeric((double)((short)n4), BStatus.ok);
                        break;
                    }
                    case 3: {
                        int n5 = nArray[n + 2] << 16 | nArray[n + 1] << 8 | nArray[n];
                        if ((n5 & 0x800000) != 0) {
                            n5 |= 0xFF000000;
                        }
                        bStatusNumeric = new BStatusNumeric((double)n5, BStatus.ok);
                        break;
                    }
                    case 4: {
                        int n6 = nArray[n + 3] << 24 | nArray[n + 2] << 16 | nArray[n + 1] << 8 | nArray[n];
                        bStatusNumeric = new BStatusNumeric((double)n6, BStatus.ok);
                        break;
                    }
                    case 5: {
                        int n7 = nArray[n + 3] << 24 | nArray[n + 2] << 16 | nArray[n + 1] << 8 | nArray[n];
                        float f = Float.intBitsToFloat(n7);
                        bStatusNumeric = new BStatusNumeric((double)f, BStatus.ok);
                        break;
                    }
                    case 6: {
                        long l = nArray[n];
                        long l2 = nArray[n + 1];
                        long l3 = nArray[n + 2];
                        long l4 = nArray[n + 3];
                        long l5 = nArray[n + 4];
                        long l6 = nArray[n + 5];
                        long l7 = l | l2 << 8 | l3 << 16 | l4 << 24 | l5 << 32 | l6 << 40;
                        if ((l7 & 0x800000000000L) != 0L) {
                            l7 |= 0xFFFF000000000000L;
                        }
                        bStatusNumeric = new BStatusNumeric((double)l7, BStatus.ok);
                        break;
                    }
                    case 7: {
                        long l = nArray[n];
                        long l8 = nArray[n + 1];
                        long l9 = nArray[n + 2];
                        long l10 = nArray[n + 3];
                        long l11 = nArray[n + 4];
                        long l12 = nArray[n + 5];
                        long l13 = nArray[n + 6];
                        long l14 = nArray[n + 7];
                        long l15 = l | l8 << 8 | l9 << 16 | l10 << 24 | l11 << 32 | l12 << 40 | l13 << 48 | l14 << 56;
                        bStatusNumeric = new BStatusNumeric((double)l15, BStatus.ok);
                        break;
                    }
                    case 8: {
                        bStatusNumeric = new BStatusNumeric(0.0, BStatus.ok);
                        break;
                    }
                    case 9: {
                        int n8 = nArray[n] & 0xF;
                        int n9 = nArray[n] >> 4 & 0xF;
                        if (n9 == 15) {
                            d = -1.0;
                            n9 = 0;
                        }
                        bStatusNumeric = new BStatusNumeric((double)(n9 * 10 + n8) * d, BStatus.ok);
                        break;
                    }
                    case 10: {
                        int n10 = nArray[n] & 0xF;
                        int n11 = nArray[n] >> 4 & 0xF;
                        int n12 = nArray[n + 1] & 0xF;
                        int n13 = nArray[n + 1] >> 4 & 0xF;
                        if (n13 == 15) {
                            d = -1.0;
                            n13 = 0;
                        }
                        int n14 = n10 + n11 * 10 + n12 * 100 + n13 * 1000;
                        bStatusNumeric = new BStatusNumeric((double)n14 * d, BStatus.ok);
                        break;
                    }
                    case 11: {
                        int n15 = nArray[n] & 0xF;
                        int n16 = nArray[n] >> 4 & 0xF;
                        int n17 = nArray[n + 1] & 0xF;
                        int n18 = nArray[n + 1] >> 4 & 0xF;
                        int n19 = nArray[n + 2] & 0xF;
                        int n20 = nArray[n + 2] >> 4 & 0xF;
                        if (n20 == 15) {
                            d = -1.0;
                            n20 = 0;
                        }
                        int n21 = n15 + n16 * 10 + n17 * 100 + n18 * 1000 + n19 * 10000 + n20 * 100000;
                        bStatusNumeric = new BStatusNumeric((double)n21 * d, BStatus.ok);
                        break;
                    }
                    case 12: {
                        int n22 = nArray[n] & 0xF;
                        int n23 = nArray[n] >> 4 & 0xF;
                        int n24 = nArray[n + 1] & 0xF;
                        int n25 = nArray[n + 1] >> 4 & 0xF;
                        int n26 = nArray[n + 2] & 0xF;
                        int n27 = nArray[n + 2] >> 4 & 0xF;
                        int n28 = nArray[n + 3] & 0xF;
                        int n29 = nArray[n + 3] >> 4 & 0xF;
                        if (n29 == 15) {
                            d = -1.0;
                            n29 = 0;
                        }
                        int n30 = n22 + n23 * 10 + n24 * 100 + n25 * 1000 + n26 * 10000 + n27 * 100000 + n28 * 1000000 + n29 * 10000000;
                        bStatusNumeric = new BStatusNumeric((double)n30 * d, BStatus.ok);
                        break;
                    }
                    case 13: {
                        int n31 = nArray[n] & 0xFF;
                        int n32 = 0;
                        int n33 = 0;
                        if (n31 < 192) {
                            char[] cArray = new char[n31];
                            n32 = 0;
                            while (n32 < n31) {
                                cArray[n31 - n32 - 1] = (char)nArray[n32 + n + 1];
                                ++n32;
                            }
                            String string = new String(cArray);
                            bStatusNumeric = new BStatusString(string, BStatus.ok);
                            break;
                        }
                        if (n31 < 208) {
                            int n34 = 0;
                            char[] cArray = new char[n31 -= 192];
                            n32 = 0;
                            while (n32 < n31) {
                                n33 = n32 & 1;
                                n34 = n33 != 0 ? nArray[n + n32 / 2 + 1] >> 4 & 0xF : nArray[n + n32 / 2 + 1] & 0xF;
                                cArray[n31 - n32 - 1] = (char)(n34 + 48);
                                ++n32;
                            }
                            String string = new String(cArray);
                            bStatusNumeric = new BStatusString(string, BStatus.ok);
                            break;
                        }
                        if (n31 < 224) {
                            int n35 = 0;
                            char[] cArray = new char[n31 -= 208];
                            n32 = 0;
                            while (n32 < n31) {
                                n33 = n32 & 1;
                                n35 = n33 != 0 ? nArray[n + n32 / 2 + 1] >> 4 & 0xF : nArray[n + n32 / 2 + 1] & 0xF;
                                cArray[n31 - n32 - 1] = (char)(n35 + 48);
                                ++n32;
                            }
                            String string = "-" + new String(cArray);
                            bStatusNumeric = new BStatusString(string, BStatus.ok);
                            break;
                        }
                        if (n31 < 240) {
                            int n36 = 0;
                            char[] cArray = new char[n31 -= 224];
                            n32 = 0;
                            while (n32 < n31) {
                                n33 = n32 & 1;
                                n36 = n33 != 0 ? nArray[n + n32 / 2 + 1] >> 4 & 0xF : nArray[n + n32 / 2 + 1] & 0xF;
                                cArray[n31 - n32 - 1] = (char)(n36 + 48);
                                ++n32;
                            }
                            String string = new String(cArray);
                            bStatusNumeric = new BStatusString(string, BStatus.ok);
                            break;
                        }
                        if (n31 == 248) {
                            long l = 0L;
                            long[] lArray = new long[8];
                            int n37 = 0;
                            while (n37 < 8) {
                                lArray[n37] = nArray[n37 + 1];
                                ++n37;
                            }
                            l = lArray[7] << 56 | lArray[6] << 48 | lArray[5] << 40 | lArray[4] << 32 | lArray[3] << 24 | lArray[2] << 16 | lArray[1] << 8 | lArray[0];
                            double d2 = Double.longBitsToDouble(l);
                            bStatusNumeric = new BStatusNumeric(d2, BStatus.ok);
                            break;
                        }
                        break block120;
                    }
                    case 14: {
                        long l = nArray[n] & 0xF;
                        long l16 = nArray[n] >> 4 & 0xF;
                        long l17 = nArray[n + 1] & 0xF;
                        long l18 = nArray[n + 1] >> 4 & 0xF;
                        long l19 = nArray[n + 2] & 0xF;
                        long l20 = nArray[n + 2] >> 4 & 0xF;
                        long l21 = nArray[n + 3] & 0xF;
                        long l22 = nArray[n + 3] >> 4 & 0xF;
                        long l23 = nArray[n + 4] & 0xF;
                        long l24 = nArray[n + 4] >> 4 & 0xF;
                        long l25 = nArray[n + 5] & 0xF;
                        long l26 = nArray[n + 5] >> 4 & 0xF;
                        if (l26 == 15L) {
                            d = -1.0;
                            l26 = 0L;
                        }
                        l = l + l16 * 10L + l17 * 100L + l18 * 1000L + l19 * 10000L + l20 * 100000L + l21 * 1000000L + l22 * 10000000L + l23 * 100000000L + l24 * 1000000000L + l25 * 10000000000L + l26 * 100000000000L;
                        bStatusNumeric = new BStatusNumeric((double)l * d, BStatus.ok);
                        break;
                    }
                    case 15: {
                        bStatusNumeric = new BStatusString("Special Functions Not Supported .", BStatus.fault);
                        break;
                    }
                    case 16: {
                        char[] cArray = new char[nArray[n]];
                        int n38 = 0;
                        while (n38 < nArray[n]) {
                            cArray[n - n38 - 1] = (char)nArray[n38 + n + 1];
                            ++n38;
                        }
                        String string = new String(cArray);
                        bStatusNumeric = new BStatusString(string, BStatus.ok);
                        break;
                    }
                    case 17: {
                        bStatusNumeric = new BStatusString("CP16 Units & Info Not Supported.", BStatus.fault);
                        break;
                    }
                    case 18: {
                        int n39;
                        int n40 = nArray[n] & 0x1F;
                        if (n40 == 0 && MbusToolkit.isTraceOn()) {
                            MbusLogInputOutput.log.trace("Every Day Detected");
                        }
                        if ((n39 = nArray[n + 1] & 0xF) < 1) {
                            n39 = 1;
                            if (MbusToolkit.isTraceOn()) {
                                MbusLogInputOutput.log.trace("Month Not Specified, Jan is output");
                            }
                        } else if (n39 > 12) {
                            n39 = 12;
                            if (MbusToolkit.isTraceOn()) {
                                MbusLogInputOutput.log.trace("Every Month Detected, Dec is output");
                            }
                        }
                        BMonth bMonth = BMonth.make((int)(n39 - 1));
                        int n41 = nArray[n] >> 5 & 7 | nArray[n + 1] >> 1 & 0x78;
                        if (n41 == 127) {
                            n41 = 0;
                            if (MbusToolkit.isTraceOn()) {
                                MbusLogInputOutput.log.trace("Every Year Detected");
                            }
                        }
                        if (n41 < 81) {
                            n41 += 2000;
                        }
                        if (n41 > 81 && n41 < 2000) {
                            n41 += 1900;
                        }
                        BAbsTime bAbsTime = BAbsTime.make((int)n41, (BMonth)bMonth, (int)n40);
                        bStatusNumeric = new BStatusNumeric((double)bAbsTime.getMillis(), BStatus.ok);
                        break;
                    }
                    case 20: {
                        int n42 = nArray[n] & 0x80;
                        if (n42 == 0) {
                            int n43 = nArray[n] & 0x3F;
                            int n44 = nArray[n + 1] & 0x3F;
                            int n45 = nArray[n + 2] & 0x1F;
                            int n46 = nArray[n + 3] & 0x1F;
                            int n47 = nArray[n + 4] & 0xF;
                            int n48 = (nArray[n + 3] & 0xE0) >> 5 & 0x7F | nArray[n + 4] << 3 & 0xF;
                            if (n43 == 63) {
                                n43 = 0;
                                if (MbusToolkit.isTraceOn()) {
                                    MbusLogInputOutput.log.trace("Every Second");
                                }
                            }
                            if (n44 == 63) {
                                n44 = 0;
                                if (MbusToolkit.isTraceOn()) {
                                    MbusLogInputOutput.log.trace("Every Minute");
                                }
                            }
                            if (n45 == 31) {
                                n45 = 0;
                                if (MbusToolkit.isTraceOn()) {
                                    MbusLogInputOutput.log.trace("Every Hour");
                                }
                            }
                            if (n46 == 0 && MbusToolkit.isTraceOn()) {
                                MbusLogInputOutput.log.trace("Every Day Detected");
                            }
                            if (n47 < 1) {
                                n47 = 1;
                                if (MbusToolkit.isTraceOn()) {
                                    MbusLogInputOutput.log.trace("Month Not Specified, Jan is output");
                                }
                            } else if (n47 > 12) {
                                n47 = 12;
                                if (MbusToolkit.isTraceOn()) {
                                    MbusLogInputOutput.log.trace("Every Month Detected, Dec is output");
                                }
                            }
                            BMonth bMonth = BMonth.make((int)(n47 - 1));
                            if (n48 == 127) {
                                n48 = 0;
                                if (MbusToolkit.isTraceOn()) {
                                    MbusLogInputOutput.log.trace("Every Year Detected");
                                }
                            }
                            if (n48 < 81) {
                                n48 += 2000;
                            }
                            if (n48 > 81 && n48 < 2000) {
                                n48 += 1900;
                            }
                            BAbsTime bAbsTime = BAbsTime.make((int)n48, (BMonth)bMonth, (int)n46, (int)n45, (int)n44, (int)n43, (int)0);
                            bStatusNumeric = new BStatusNumeric((double)bAbsTime.getMillis(), BStatus.ok);
                            break;
                        }
                        BAbsTime bAbsTime = BAbsTime.make((long)0L);
                        bStatusNumeric = new BStatusNumeric((double)bAbsTime.getMillis(), BStatus.fault);
                        break;
                    }
                    case 19: {
                        int n49 = nArray[n] & 0x80;
                        int n50 = nArray[n] & 0x3F;
                        int n51 = nArray[n + 1] & 0x1F;
                        int n52 = nArray[n + 2] & 0x1F;
                        int n53 = nArray[n + 3] & 0xF;
                        int n54 = (nArray[n + 2] & 0xE0) >> 5 & 7 | nArray[n + 3] >> 1 & 0x78;
                        int n55 = nArray[n + 1] >> 5 & 3;
                        n54 += 100 * n55;
                        if (n49 != 0) {
                            n50 = 0;
                            n51 = 0;
                        }
                        if (n50 == 63) {
                            n50 = 0;
                            if (MbusToolkit.isTraceOn()) {
                                MbusLogInputOutput.log.trace("Every Minute");
                            }
                        }
                        if (n51 == 31) {
                            n51 = 0;
                            if (MbusToolkit.isTraceOn()) {
                                MbusLogInputOutput.log.trace("Every Hour");
                            }
                        }
                        if (n52 == 0 && MbusToolkit.isTraceOn()) {
                            MbusLogInputOutput.log.trace("Every Day Detected");
                        }
                        if (n53 < 1) {
                            n53 = 1;
                            if (MbusToolkit.isTraceOn()) {
                                MbusLogInputOutput.log.trace("Month Not Specified, Jan is output");
                            }
                        } else if (n53 > 12) {
                            n53 = 12;
                            if (MbusToolkit.isTraceOn()) {
                                MbusLogInputOutput.log.trace("Every Month Detected, Dec is output");
                            }
                        }
                        BMonth bMonth = BMonth.make((int)(n53 - 1));
                        if (n54 == 127) {
                            n54 = 0;
                            if (MbusToolkit.isTraceOn()) {
                                MbusLogInputOutput.log.trace("Every Year Detected");
                            }
                        }
                        if (n54 < 81) {
                            n54 += 2000;
                        }
                        if (n54 > 81 && n54 < 2000) {
                            n54 += 1900;
                        }
                        BAbsTime bAbsTime = BAbsTime.make((int)n54, (BMonth)bMonth, (int)n52, (int)n51, (int)n50);
                        bStatusNumeric = new BStatusNumeric((double)bAbsTime.getMillis(), BStatus.ok);
                        break;
                    }
                    case 21: {
                        BAbsTime bAbsTime = BAbsTime.now();
                        int n56 = nArray[n] & 0x3F;
                        int n57 = nArray[n + 1] & 0x3F;
                        int n58 = nArray[n + 2] & 0x1F;
                        if (n56 == 63) {
                            n56 = 0;
                            if (MbusToolkit.isTraceOn()) {
                                MbusLogInputOutput.log.trace("Every Second");
                            }
                        }
                        if (n57 == 63) {
                            n57 = 0;
                            if (MbusToolkit.isTraceOn()) {
                                MbusLogInputOutput.log.trace("Every Minute");
                            }
                        }
                        if (n58 == 31) {
                            n58 = 0;
                            if (MbusToolkit.isTraceOn()) {
                                MbusLogInputOutput.log.trace("Every Hour");
                            }
                        }
                        BMonth bMonth = bAbsTime.getMonth().previous();
                        BAbsTime bAbsTime2 = BAbsTime.make((int)bAbsTime.getYear(), (BMonth)bMonth, (int)bAbsTime.getDay(), (int)n58, (int)n57, (int)n56, (int)0);
                        bStatusNumeric = new BStatusNumeric((double)bAbsTime2.getMillis(), BStatus.ok);
                        break;
                    }
                    case 22: {
                        bStatusNumeric = new BStatusString("Daylight Saving Not Supported .", BStatus.fault);
                        break;
                    }
                    case 23: {
                        bStatusNumeric = new BStatusString("Window Management Not Supported .", BStatus.fault);
                        break;
                    }
                }
                break block120;
            }
            switch (n2) {
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 14: 
                case 18: 
                case 19: 
                case 20: 
                case 21: {
                    bStatusNumeric = new BStatusNumeric(0.0, BStatus.ok);
                    break;
                }
                case 16: {
                    bStatusNumeric = new BStatusString("", BStatus.ok);
                    break;
                }
                case 13: {
                    int n59 = nArray[n] & 0xFF;
                    if (n59 == 248) {
                        bStatusNumeric = new BStatusNumeric(0.0, BStatus.ok);
                        break;
                    }
                    bStatusNumeric = new BStatusString("", BStatus.ok);
                    break;
                }
                case 15: {
                    bStatusNumeric = new BStatusString("Special Functions Not Supported .", BStatus.fault);
                    break;
                }
                case 17: {
                    bStatusNumeric = new BStatusString("CP16 Units & Info Not Supported.", BStatus.fault);
                    break;
                }
                case 22: {
                    bStatusNumeric = new BStatusString("Daylight Saving Not Supported .", BStatus.fault);
                    break;
                }
                case 23: {
                    bStatusNumeric = new BStatusString("Window Management Not Supported .", BStatus.fault);
                    break;
                }
            }
        }
        int n60 = n + n3;
        ValueData valueData = new ValueData(n60, (BStatusValue)bStatusNumeric);
        return valueData;
    }

    private static final void traceRawData(int n, String string, int[] nArray, int n2) {
        MbusToolkit.trace(string);
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("0x");
        int n3 = 0;
        while (n3 < n) {
            stringBuffer.append(TextUtil.byteToHexString((int)nArray[n2 + n3]));
            ++n3;
        }
        MbusToolkit.trace("[" + stringBuffer.toString() + ']');
    }

    public static final byte[] encode(BStatusValue bStatusValue, BMbusCommandCodes bMbusCommandCodes) {
        int n = bMbusCommandCodes.getOrdinal();
        byte[] byArray = null;
        long l = 0L;
        boolean bl = false;
        switch (n) {
            case 0: {
                break;
            }
            case 1: 
            case 16: {
                byArray = new byte[]{(byte)((BStatusNumeric)bStatusValue).getValue()};
                break;
            }
            case 2: 
            case 18: {
                byArray = new byte[2];
                l = (long)((BStatusNumeric)bStatusValue).getValue();
                byArray[0] = (byte)(l & 0xFFL);
                byArray[1] = (byte)(l >> 8 & 0xFFL);
                break;
            }
            case 3: 
            case 19: {
                byArray = new byte[3];
                l = (long)((BStatusNumeric)bStatusValue).getValue();
                byArray[0] = (byte)(l & 0xFFL);
                byArray[1] = (byte)(l >> 8 & 0xFFL);
                byArray[2] = (byte)(l >> 16 & 0xFFL);
                break;
            }
            case 4: 
            case 20: {
                byArray = new byte[4];
                l = (long)((BStatusNumeric)bStatusValue).getValue();
                byArray[0] = (byte)(l & 0xFFL);
                byArray[1] = (byte)(l >> 8 & 0xFFL);
                byArray[2] = (byte)(l >> 16 & 0xFFL);
                byArray[3] = (byte)(l >> 24 & 0xFFL);
                break;
            }
            case 6: 
            case 23: {
                byArray = new byte[6];
                l = (long)((BStatusNumeric)bStatusValue).getValue();
                byArray[0] = (byte)(l & 0xFFL);
                byArray[1] = (byte)(l >> 8 & 0xFFL);
                byArray[2] = (byte)(l >> 16 & 0xFFL);
                byArray[3] = (byte)(l >> 24 & 0xFFL);
                byArray[4] = (byte)(l >> 32 & 0xFFL);
                byArray[5] = (byte)(l >> 40 & 0xFFL);
                break;
            }
            case 7: 
            case 24: {
                byArray = new byte[8];
                l = (long)((BStatusNumeric)bStatusValue).getValue();
                byArray[0] = (byte)(l & 0xFFL);
                byArray[1] = (byte)(l >> 8 & 0xFFL);
                byArray[2] = (byte)(l >> 16 & 0xFFL);
                byArray[3] = (byte)(l >> 24 & 0xFFL);
                byArray[4] = (byte)(l >> 32 & 0xFFL);
                byArray[5] = (byte)(l >> 40 & 0xFFL);
                byArray[6] = (byte)(l >> 48 & 0xFFL);
                byArray[7] = (byte)(l >> 56 & 0xFFL);
                break;
            }
            case 5: 
            case 21: {
                int n2 = Float.floatToIntBits((float)((BStatusNumeric)bStatusValue).getValue());
                byArray = new byte[]{(byte)(n2 & 0xFF), (byte)(n2 >> 8 & 0xFF), (byte)(n2 >> 16 & 0xFF), (byte)(n2 >> 24 & 0xFF)};
                break;
            }
            case 22: {
                l = Double.doubleToLongBits(((BStatusNumeric)bStatusValue).getValue());
                byArray = new byte[]{(byte)(l & 0xFFL), (byte)(l >> 8 & 0xFFL), (byte)(l >> 16 & 0xFFL), (byte)(l >> 24 & 0xFFL)};
                byArray[4] = (byte)(l >> 32 & 0xFFL);
                byArray[5] = (byte)(l >> 40 & 0xFFL);
                byArray[6] = (byte)(l >> 48 & 0xFFL);
                byArray[7] = (byte)(l >> 56 & 0xFFL);
                break;
            }
            case 9: 
            case 25: {
                byArray = new byte[1];
                l = (long)((BStatusNumeric)bStatusValue).getValue();
                if (l < 0L) {
                    bl = true;
                    l = -l;
                }
                byArray[0] = (byte)(l & 0xFL | l / 10L << 4);
                if (!bl) break;
                byArray[0] = (byte)(byArray[0] | 0xF);
                break;
            }
            case 10: 
            case 26: {
                byArray = new byte[2];
                l = (long)((BStatusNumeric)bStatusValue).getValue();
                if (l < 0L) {
                    bl = true;
                    l = -l;
                }
                byArray[0] = (byte)(l & 0xFL | l / 10L << 4);
                byArray[1] = (byte)(l / 100L & 0xFL | l / 1000L << 4);
                if (!bl) break;
                byArray[1] = (byte)(byArray[1] | 0xF0);
                break;
            }
            case 11: 
            case 27: {
                byArray = new byte[3];
                l = (long)((BStatusNumeric)bStatusValue).getValue();
                if (l < 0L) {
                    bl = true;
                    l = -l;
                }
                byArray[0] = (byte)(l & 0xFL | l / 10L << 4);
                byArray[1] = (byte)(l / 100L & 0xFL | l / 1000L << 4);
                byArray[2] = (byte)(l / 10000L & 0xFL | l / 100000L << 4);
                if (!bl) break;
                byArray[2] = (byte)(byArray[2] | 0xF0);
                break;
            }
            case 12: 
            case 28: {
                byArray = new byte[4];
                l = (long)((BStatusNumeric)bStatusValue).getValue();
                if (l < 0L) {
                    bl = true;
                    l = -l;
                }
                byArray[0] = (byte)(l & 0xFL | l / 10L << 4);
                byArray[1] = (byte)(l / 100L & 0xFL | l / 1000L << 4);
                byArray[2] = (byte)(l / 10000L & 0xFL | l / 100000L << 4);
                byArray[3] = (byte)(l / 1000000L & 0xFL | l / 10000000L << 4);
                if (!bl) break;
                byArray[3] = (byte)(byArray[3] | 0xF0);
                break;
            }
            case 14: 
            case 30: {
                byArray = new byte[6];
                l = (long)((BStatusNumeric)bStatusValue).getValue();
                if (l < 0L) {
                    bl = true;
                    l = -l;
                }
                byArray[0] = (byte)(l & 0xFL | l / 10L << 4);
                byArray[1] = (byte)(l / 100L & 0xFL | l / 1000L << 4);
                byArray[2] = (byte)(l / 10000L & 0xFL | l / 100000L << 4);
                byArray[3] = (byte)(l / 1000000L & 0xFL | l / 10000000L << 4);
                byArray[4] = (byte)(l / 100000000L & 0xFL | l / 1000000000L << 4);
                byArray[5] = (byte)(l / 10000000000L & 0xFL | l / 100000000000L << 4);
                if (!bl) break;
                byArray[5] = (byte)(byArray[5] | 0xF0);
                break;
            }
            case 32: {
                String string = ((BStatusString)bStatusValue).getValue();
                byArray = new byte[string.length()];
                int n3 = 0;
                while (n3 < byArray.length) {
                    byArray[n3] = (byte)string.charAt(n3);
                    ++n3;
                }
                break;
            }
            case 33: 
            case 34: {
                BAbsTime bAbsTime = BAbsTime.make((long)((long)((BStatusNumeric)bStatusValue).getValue()));
                byArray = new byte[2];
                int n4 = bAbsTime.getYear() - 1900;
                int n5 = n4 / 100;
                int n6 = bAbsTime.getDay();
                int n7 = bAbsTime.getMonth().getOrdinal() + 1;
                byArray[0] = (byte)(n6 & 0x1F | ((n4 -= n5 * 100) & 7) << 5);
                byArray[1] = (byte)(n7 & 0xF | (n4 & 0x78) << 1);
                break;
            }
            case 36: {
                BAbsTime bAbsTime = BAbsTime.make((long)((long)((BStatusNumeric)bStatusValue).getValue()));
                byArray = new byte[3];
                int n8 = bAbsTime.getSecond();
                int n9 = bAbsTime.getMinute();
                int n10 = bAbsTime.getHour();
                byArray[0] = (byte)(n8 & 0x3F);
                byArray[1] = (byte)(n9 & 0x3F);
                byArray[2] = (byte)(n10 & 0x1F);
                break;
            }
            case 35: {
                BAbsTime bAbsTime = BAbsTime.make((long)((long)((BStatusNumeric)bStatusValue).getValue()));
                byArray = new byte[4];
                int n11 = bAbsTime.getMinute();
                int n12 = bAbsTime.getHour();
                int n13 = bAbsTime.getDay();
                int n14 = bAbsTime.getMonth().getOrdinal() + 1;
                int n15 = bAbsTime.getYear() - 1900;
                int n16 = n15 / 100;
                byArray[0] = (byte)(n11 & 0x3F);
                byArray[1] = (byte)(n12 & 0x1F | (n16 & 3) << 5);
                byArray[2] = (byte)(n13 & 0x1F | ((n15 -= n16 * 100) & 7) << 5);
                byArray[3] = (byte)(n14 & 0xF | (n15 & 0x78) << 1);
                break;
            }
        }
        return byArray;
    }

    private static final void mode2Swap(int[] nArray, int n, int n2) {
        int[] nArray2 = new int[n2];
        int n3 = 0;
        while (n3 < n2) {
            nArray2[n3] = nArray[n + n3];
            ++n3;
        }
        n3 = 0;
        while (n3 < n2) {
            nArray[n + n3] = nArray2[n2 - n3 - 1];
            ++n3;
        }
    }

    private MbusDataDecoderIEC870() {
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public static class ValueData {
        private int newIndex;
        private BStatusValue value;

        public int getIndex() {
            return this.newIndex;
        }

        public BStatusValue getValue() {
            return this.value;
        }

        private final /* synthetic */ void this() {
            this.newIndex = 0;
            this.value = null;
        }

        public ValueData(int n, BStatusValue bStatusValue) {
            this.this();
            this.newIndex = n;
            this.value = bStatusValue;
        }
    }
}

