/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.mbus.ui;

import com.tridium.mbus.actionArgSets.BLivePointSearchDiscoverOptions;
import com.tridium.mbus.ui.BPointDiscoveryModeSelectPane;
import com.tridium.mbus.ui.BPointLiveScanOptionsPane;
import com.tridium.mbus.utils.MbusToolkit;
import javax.baja.gx.BImage;
import javax.baja.naming.BOrd;
import javax.baja.ui.BDialog;
import javax.baja.ui.BNullWidget;
import javax.baja.ui.BWidget;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.pane.BEdgePane;
import javax.baja.ui.wizard.BWizardHeader;
import javax.baja.ui.wizard.WizardModel;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
class PointDiscoveryWizardModel
extends WizardModel
implements BPointDiscoveryModeSelectPane.DiscoveryModeListener {
    private static final BImage bannerImg = BImage.make((String)"module://icons/x32/wizard.png");
    private BWizardHeader banner;
    private BBorderPane bannerBorder;
    private BEdgePane bannerPane;
    private int currentStep;
    private boolean userCompleted;
    private BPointDiscoveryModeSelectPane pointDiscoveryModeSelectPane;
    private BPointLiveScanOptionsPane liveScanLimitsPane;
    protected BOrd currentDevice;

    public void setDevice(BOrd bOrd) {
        this.currentDevice = bOrd;
    }

    public String getTitle() {
        return MbusToolkit.getText("PointDiscoveryWizard.title");
    }

    public void init() {
        this.pointDiscoveryModeSelectPane = new BPointDiscoveryModeSelectPane(this);
        this.liveScanLimitsPane = new BPointLiveScanOptionsPane();
        this.liveScanLimitsPane.setDeviceRef(this.currentDevice);
        this.checkStep();
    }

    public void next() {
        ++this.currentStep;
        this.checkStep();
    }

    public void back() {
        --this.currentStep;
        this.checkStep();
    }

    public boolean finish() {
        if (this.isLivePointScan() && !this.liveScanLimitsPane.validate()) {
            BDialog.error((BWidget)this.getWizard(), (Object)MbusToolkit.getText("PointDiscoveryWizard.scanLimitCorrectionReq"));
            return false;
        }
        this.userCompleted = true;
        return true;
    }

    private final void checkStep() {
        switch (this.currentStep) {
            case 0: {
                int n = this.isDatabasePointScan() ? 4 : 6;
                this.setBannerWidget((BWidget)this.pointDiscoveryModeSelectPane, MbusToolkit.getText("PointDiscoveryWizard.discoveryMode"), MbusToolkit.getText("PointDiscoveryWizard.discoveryPointModeSelect"), n);
                break;
            }
            case 1: {
                this.setBannerWidget((BWidget)this.liveScanLimitsPane, MbusToolkit.getText("PointDiscoveryWizard.scanLimitSetup"), MbusToolkit.getText("PointDiscoveryWizard.scanLimitSetupDesc"), 5);
                break;
            }
        }
    }

    private final void setBannerWidget(BWidget bWidget, String string, String string2, int n) {
        this.bannerBorder.setContent(bWidget);
        this.banner.setTitle(string);
        this.banner.setDescription(string2);
        this.update((BWidget)this.bannerPane, n);
    }

    public boolean isUserFinished() {
        return this.userCompleted;
    }

    public boolean isDatabasePointScan() {
        return this.pointDiscoveryModeSelectPane.isScanDatabaseDiscover();
    }

    public boolean isLivePointScan() {
        return this.pointDiscoveryModeSelectPane.isScanLiveDeviceDiscover();
    }

    public BLivePointSearchDiscoverOptions getPointDiscoverOptions() {
        BLivePointSearchDiscoverOptions bLivePointSearchDiscoverOptions = new BLivePointSearchDiscoverOptions();
        bLivePointSearchDiscoverOptions.setMaxSequentialReads(this.liveScanLimitsPane.getMaximumReadsLimit());
        return bLivePointSearchDiscoverOptions;
    }

    public void modeChanged() {
        this.checkStep();
    }

    private final /* synthetic */ void this() {
        this.banner = new BWizardHeader(bannerImg, "", "");
        this.bannerBorder = new BBorderPane((BWidget)new BNullWidget(), 10.0, 10.0, 10.0, 10.0);
        this.bannerPane = new BEdgePane((BWidget)this.banner, null, null, null, (BWidget)this.bannerBorder);
        this.currentStep = 0;
        this.userCompleted = false;
        this.pointDiscoveryModeSelectPane = null;
        this.liveScanLimitsPane = null;
        this.currentDevice = null;
    }

    PointDiscoveryWizardModel() {
        this.this();
    }
}

