/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.mbus.ui;

import com.tridium.mbus.jobs.BMbusTxRxProfile;
import com.tridium.mbus.types.BMbusPrimaryAddressRange;
import com.tridium.mbus.types.BMbusSecondaryAddressFilters;
import com.tridium.mbus.ui.BAddressAndBaudRateRange;
import com.tridium.mbus.ui.BDiscoveryCommSpeedSelectPane;
import com.tridium.mbus.ui.BDiscoveryModeSelectPane;
import com.tridium.mbus.ui.BMbusPrimaryAddressRangeFE;
import com.tridium.mbus.ui.BMbusSecondaryAddressFE;
import com.tridium.mbus.ui.BMbusSecondaryKnownAddressFE;
import com.tridium.mbus.utils.MbusToolkit;
import javax.baja.gx.BImage;
import javax.baja.sys.BObject;
import javax.baja.sys.BVector;
import javax.baja.ui.BDialog;
import javax.baja.ui.BNullWidget;
import javax.baja.ui.BWidget;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.pane.BEdgePane;
import javax.baja.ui.pane.BGridPane;
import javax.baja.ui.wizard.BWizardHeader;
import javax.baja.ui.wizard.WizardModel;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
class DiscoveryWizardModel
extends WizardModel
implements BDiscoveryModeSelectPane.DiscoveryModeListener,
BDiscoveryCommSpeedSelectPane.DiscoveryCommSpeedListener {
    private static final BImage bannerImg = BImage.make((String)"module://icons/x32/wizard.png");
    private int step;
    private BWizardHeader banner;
    private BBorderPane bannerBorder;
    private BEdgePane bannerPane;
    private boolean finished;
    private boolean multipleRecords;
    private BGridPane primaryAddRangePane;
    private BMbusPrimaryAddressRange range;
    private BMbusPrimaryAddressRangeFE addressStep;
    private BAddressAndBaudRateRange scanBaudRate;
    private BDiscoveryModeSelectPane modeSelectPane;
    private BDiscoveryCommSpeedSelectPane commSpeedSelectPane;
    private BMbusSecondaryAddressFilters filters;
    private BMbusSecondaryAddressFE secondaryAddressInfo;
    private BMbusSecondaryKnownAddressFE secondaryDirectAddressInfo;
    boolean baudRateSelectable;

    public String getTitle() {
        return MbusToolkit.getText("DiscoveryWizard.title");
    }

    public void init() {
        this.modeSelectPane = new BDiscoveryModeSelectPane(this);
        this.commSpeedSelectPane = new BDiscoveryCommSpeedSelectPane(this);
        this.scanBaudRate = new BAddressAndBaudRateRange();
        this.addressStep.loadValue((BObject)this.range);
        this.secondaryAddressInfo.loadValue((BObject)this.filters);
        this.secondaryDirectAddressInfo.loadValue((BObject)this.filters);
        this.checkStep();
    }

    public void next() {
        this.step = this.baudRateSelectable ? (this.isSingleDeviceDiscover() && this.step == 2 ? 4 : ++this.step) : (this.step == 1 ? this.isSingleDeviceDiscover() + 3 : ++this.step);
        this.checkStep();
    }

    public void back() {
        this.step = this.baudRateSelectable ? (this.isSingleDeviceDiscover() && this.step == 4 ? 2 : --this.step) : (this.isSingleDeviceDiscover() && this.step == 4 ? 1 : (this.step == 3 ? 1 : --this.step));
        this.checkStep();
    }

    public boolean finish() {
        boolean bl;
        block22: {
            bl = false;
            if (this.modeSelectPane.isAddressDiscover()) {
                try {
                    this.addressStep.saveValue((BObject)this.range, null);
                    bl = true;
                }
                catch (Exception exception) {
                    try {
                        BDialog.error((BWidget)this.getWizard(), (String)"Error", (Object)exception.getMessage(), (Throwable)exception);
                        break block22;
                    }
                    catch (Exception exception2) {
                        if (MbusToolkit.isTraceOn()) {
                            MbusToolkit.trace("Error attempting to show exception dialog", exception);
                        }
                        break block22;
                    }
                }
            }
            if (this.modeSelectPane.isSecondaryDiscover()) {
                try {
                    this.secondaryAddressInfo.saveValue((BObject)this.filters, null);
                    bl = true;
                }
                catch (Exception exception) {
                    try {
                        BDialog.error((BWidget)this.getWizard(), (String)"Error", (Object)exception.getMessage(), (Throwable)exception);
                        break block22;
                    }
                    catch (Exception exception3) {
                        if (MbusToolkit.isTraceOn()) {
                            MbusToolkit.trace("Error attempting to show exception dialog", exception);
                        }
                        break block22;
                    }
                }
            }
            if (this.modeSelectPane.isSecondaryAddressSetupDiscover()) {
                try {
                    this.secondaryDirectAddressInfo.setModified();
                    this.secondaryDirectAddressInfo.saveValue((BObject)this.filters, null);
                    bl = true;
                }
                catch (Exception exception) {
                    try {
                        BDialog.error((BWidget)this.getWizard(), (String)"Error", (Object)exception.getMessage(), (Throwable)exception);
                        break block22;
                    }
                    catch (Exception exception4) {
                        if (MbusToolkit.isTraceOn()) {
                            MbusToolkit.trace("Error attempting to show exception dialog", exception);
                        }
                        break block22;
                    }
                }
            }
            if (this.modeSelectPane.isSingleDeviceDiscover()) {
                if (BDialog.open((BWidget)this.getWizard(), (String)MbusToolkit.getText("DiscoveryWizard.discovery"), (Object)MbusToolkit.getText("DiscoveryWizard.singleDisconnection"), (int)12) == 4) {
                    bl = true;
                }
            } else if (this.modeSelectPane.isScanDeviceDatabaseDiscover() || this.modeSelectPane.isSecondaryDiscover()) {
                bl = true;
            }
        }
        this.finished = bl;
        return bl;
    }

    private final void checkStep() {
        switch (this.step) {
            case 1: {
                int n = this.modeSelectPane.isScanDeviceDatabaseDiscover() ? 4 : 2;
                this.setBannerWidget((BWidget)this.modeSelectPane, MbusToolkit.getText("DiscoveryWizard.discoveryMode"), MbusToolkit.getText("DiscoveryWizard.discoveryModeSelect"), n);
                break;
            }
            case 2: {
                int n = this.modeSelectPane.isSingleDeviceDiscover() ? 6 : 2;
                this.setBannerWidget((BWidget)this.scanBaudRate, MbusToolkit.getText("DiscoveryWizard.baudRateTitle"), MbusToolkit.getText("DiscoveryWizard.baudRateSelect"), 1 | n);
                break;
            }
            case 3: {
                if (this.modeSelectPane.isSecondaryDiscover()) {
                    this.setBannerWidget((BWidget)this.secondaryAddressInfo, MbusToolkit.getText("DiscoveryWizard.addressFiltersTitle"), MbusToolkit.getText("DiscoveryWizard.AddressFilterRequest"), 7);
                    break;
                }
                if (this.modeSelectPane.isSecondaryAddressSetupDiscover()) {
                    this.setBannerWidget((BWidget)this.secondaryDirectAddressInfo, MbusToolkit.getText("DiscoveryWizard.secondaryAddressTitle"), MbusToolkit.getText("DiscoveryWizard.SecondaryAddressFilterRequest"), 7);
                    break;
                }
                this.setBannerWidget((BWidget)this.addressStep, MbusToolkit.getText("DiscoveryWizard.addressRange"), MbusToolkit.getText("DiscoveryWizard.deviceAddressRange"), 7);
                break;
            }
            case 4: {
                this.setBannerWidget((BWidget)this.commSpeedSelectPane, MbusToolkit.getText("DiscoveryWizard.commSpeedTitle"), MbusToolkit.getText("DiscoveryWizard.commSpeedSetup"), 5);
                break;
            }
        }
    }

    private final void setBannerWidget(BWidget bWidget, String string, String string2, int n) {
        this.bannerBorder.setContent(bWidget);
        this.banner.setTitle(string);
        this.banner.setDescription(string2);
        this.update((BWidget)this.bannerPane, n);
    }

    public void modeChanged() {
        this.checkStep();
    }

    public void speedChanged() {
        this.checkStep();
    }

    boolean isSingleDeviceDiscover() {
        return this.modeSelectPane.isSingleDeviceDiscover();
    }

    boolean isScanDeviceDatabaseDiscover() {
        return this.modeSelectPane.isScanDeviceDatabaseDiscover();
    }

    boolean isAddressDiscover() {
        return this.modeSelectPane.isAddressDiscover();
    }

    boolean isFinished() {
        return this.finished;
    }

    BMbusPrimaryAddressRange getRange() {
        return this.range;
    }

    BVector getSelectedBaudRatesVector() {
        return this.scanBaudRate.getSelectedBaudRates();
    }

    public BMbusTxRxProfile getTxRxProfile() {
        return this.commSpeedSelectPane.getTxRxProfile();
    }

    boolean getMultipleRecords() {
        return this.multipleRecords;
    }

    boolean isSecondaryDiscover() {
        return this.modeSelectPane.isSecondaryDiscover();
    }

    boolean isSpecificSecondaryAddressDiscover() {
        return this.modeSelectPane.isSecondaryAddressSetupDiscover();
    }

    BMbusSecondaryAddressFilters getFilters() {
        return this.filters;
    }

    public void setBaudSelectable(boolean bl) {
        this.baudRateSelectable = bl;
    }

    private final /* synthetic */ void this() {
        this.step = 1;
        this.banner = new BWizardHeader(bannerImg, "", "");
        this.bannerBorder = new BBorderPane((BWidget)new BNullWidget(), 10.0, 10.0, 10.0, 10.0);
        this.bannerPane = new BEdgePane((BWidget)this.banner, null, null, null, (BWidget)this.bannerBorder);
        this.finished = false;
        this.multipleRecords = false;
        this.primaryAddRangePane = new BGridPane();
        this.range = new BMbusPrimaryAddressRange();
        this.addressStep = new BMbusPrimaryAddressRangeFE();
        this.modeSelectPane = null;
        this.commSpeedSelectPane = null;
        this.filters = new BMbusSecondaryAddressFilters();
        this.secondaryAddressInfo = new BMbusSecondaryAddressFE();
        this.secondaryDirectAddressInfo = new BMbusSecondaryKnownAddressFE();
        this.baudRateSelectable = true;
    }

    DiscoveryWizardModel() {
        this.this();
    }
}

