/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.mbus.ui;

import com.tridium.mbus.enums.BMbusDeviceTypeId;
import com.tridium.mbus.types.BMbusSecondaryAddressFilters;
import com.tridium.mbus.ui.BMbusSecondaryAddressFE;
import com.tridium.mbus.utils.MbusToolkit;
import javax.baja.nre.util.TextUtil;
import javax.baja.sys.BComponent;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BCheckBox;
import javax.baja.ui.BLabel;
import javax.baja.ui.BTextField;
import javax.baja.ui.BWidget;
import javax.baja.ui.enums.BHalign;
import javax.baja.ui.pane.BGridPane;
import javax.baja.ui.text.BTextEditor;
import javax.baja.workbench.CannotSaveException;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public final class BMbusSecondaryKnownAddressFE
extends BMbusSecondaryAddressFE {
    public static final Type TYPE;
    private BTextField secondaryAddress;
    private BLabel addressText;
    private BLabel optimiseSpeeds;
    private BCheckBox optimiseSpeedsChkbox;
    private BLabel requiredLabel;
    static /* synthetic */ Class class$com$tridium$mbus$ui$BMbusSecondaryKnownAddressFE;

    public final Type getType() {
        return TYPE;
    }

    public final void doLoadValue(BObject bObject, Context context) throws Exception {
        this.secondaryAddress.setEditable(this.isReadonly() ^ true);
        BMbusSecondaryAddressFilters bMbusSecondaryAddressFilters = (BMbusSecondaryAddressFilters)bObject;
        this.secondaryAddress.setText(bMbusSecondaryAddressFilters.getSecondaryAddresses());
        this.optimiseSpeedsChkbox.setSelected(bMbusSecondaryAddressFilters.getOptimiseSpeeds());
        super.doLoadValue(bObject, context);
    }

    private final void validateAddressEntries() throws CannotSaveException {
        String string = this.secondaryAddress.getText();
        char c = ',';
        String[] stringArray = TextUtil.splitAndTrim((String)string, (char)c);
        boolean bl = false;
        int n = 0;
        while (n < stringArray.length) {
            String string2 = stringArray[n];
            int n2 = -1;
            n2 = string2.indexOf(45);
            if (n2 == -1) {
                this.validSecondaryAddress(string2, true);
            } else {
                String[] stringArray2 = TextUtil.splitAndTrim((String)string2, (char)'-');
                if (stringArray2.length != 2) {
                    throw new CannotSaveException(lex.getText("mbusSecondaryKnownAddressFE.RangeAddressInvalid", new Object[]{string2}));
                }
                this.validSecondaryAddress(stringArray2[0], false);
                this.validSecondaryAddress(stringArray2[1], false);
                long l = Long.parseLong(stringArray2[0]);
                long l2 = Long.parseLong(stringArray2[1]);
                if (l2 < l) {
                    throw new CannotSaveException(lex.getText("mbusSecondaryKnownAddressFE.StartAfterEndInRange", new Object[]{string2}));
                }
            }
            bl = true;
            ++n;
        }
        if (!bl) {
            throw new CannotSaveException(lex.getText("mbusSecondaryKnownAddressFE.NoValidAddressEntered"));
        }
    }

    private final void validSecondaryAddress(String string, boolean bl) throws CannotSaveException {
        if (string.length() < 8) {
            throw new CannotSaveException(lex.getText("mbusSecondaryKnownAddressFE.SecondaryAddressReqCharsWrong", new Object[]{String.valueOf(string.length()), string}));
        }
        int n = 0;
        while (n < string.length()) {
            char c = string.charAt(n);
            if (!(c >= '0' && c <= '9' || bl && c == 'F')) {
                throw new CannotSaveException(lex.getText("mbusSecondaryKnownAddressFE.InvalidCharacterForAddress", new Object[]{String.valueOf(c), string}));
            }
            ++n;
        }
    }

    public final BObject doSaveValue(BObject bObject, Context context) throws CannotSaveException, Exception {
        this.validateAddressEntries();
        BMbusSecondaryAddressFilters bMbusSecondaryAddressFilters = (BMbusSecondaryAddressFilters)super.doSaveValue(bObject, context);
        bMbusSecondaryAddressFilters.setSecondaryAddresses(this.secondaryAddress.getText());
        bMbusSecondaryAddressFilters.setOptimiseSpeeds(this.optimiseSpeedsChkbox.getSelected());
        return bMbusSecondaryAddressFilters;
    }

    protected final void doSetReadonly(boolean bl) {
        this.secondaryAddress.setEditable(bl ^ true);
        this.optimiseSpeedsChkbox.setEnabled(bl ^ true);
        super.doSetReadonly(bl);
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final /* synthetic */ void this() {
        this.secondaryAddress = new BTextField();
        this.addressText = new BLabel(MbusToolkit.lex.get("SecondaryAddressWizard.SecondaryAddressRequired", "Secondary Address (*): "), BHalign.left);
        this.optimiseSpeeds = new BLabel(MbusToolkit.lex.get("SecondaryAddressWizard.SecondaryOptimiseCommSpeed", "Optimise Comm Speed"), BHalign.left);
        this.optimiseSpeedsChkbox = new BCheckBox();
        this.requiredLabel = new BLabel(MbusToolkit.lex.get("SecondaryAddressWizard.RequiredField", "(*) REQUIRED FIELD"), BHalign.left);
    }

    public BMbusSecondaryKnownAddressFE() {
        super(false);
        this.this();
        this.deviceIdEditor.loadValue((BObject)BMbusDeviceTypeId.reserved);
        BGridPane bGridPane = new BGridPane();
        bGridPane.setColumnAlign(BHalign.left);
        bGridPane.setColumnGap((double)4);
        bGridPane.add(null, (BValue)this.addressText);
        bGridPane.add(null, (BValue)this.secondaryAddress);
        bGridPane.add(null, (BValue)this.manuText);
        bGridPane.add(null, (BValue)this.manuField);
        bGridPane.add(null, (BValue)this.devIdText);
        bGridPane.add(null, (BValue)this.deviceIdEditor);
        bGridPane.add(null, (BValue)this.versionText);
        bGridPane.add(null, (BValue)this.versionField);
        bGridPane.add(null, (BValue)this.optimiseSpeeds);
        bGridPane.add(null, (BValue)this.optimiseSpeedsChkbox);
        bGridPane.add(null, (BValue)this.requiredLabel);
        this.linkTo((BComponent)this.secondaryAddress, (Slot)BTextEditor.textModified, (Slot)setModified);
        this.linkTo((BComponent)this.manuField, (Slot)BTextEditor.textModified, (Slot)setModified);
        this.linkTo((BComponent)this.versionField, (Slot)BTextEditor.textModified, (Slot)setModified);
        if (this.deviceIdEditor.getTopic(BTextEditor.textModified.getName()) != null) {
            this.linkTo((BComponent)this.deviceIdEditor, (Slot)BTextEditor.textModified, (Slot)setModified);
        }
        this.setContent((BWidget)bGridPane);
    }

    static {
        Class clazz = class$com$tridium$mbus$ui$BMbusSecondaryKnownAddressFE;
        if (clazz == null) {
            clazz = class$com$tridium$mbus$ui$BMbusSecondaryKnownAddressFE = BMbusSecondaryKnownAddressFE.class("[Lcom.tridium.mbus.ui.BMbusSecondaryKnownAddressFE;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
    }
}

