/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.mbus.ui;

import com.tridium.mbus.BAbstractMbusNetwork;
import com.tridium.mbus.BMbusDevice;
import com.tridium.mbus.enums.BMbusFunction;
import com.tridium.mbus.enums.BMbusNumberType;
import com.tridium.mbus.enums.BMbusOrthogonalDescription;
import com.tridium.mbus.enums.BMbusUnit;
import com.tridium.mbus.jobs.BMbusLivePointSearchDiscoveryJob;
import com.tridium.mbus.learn.BMbusPointEntry;
import com.tridium.mbus.point.BMbusPointFolder;
import com.tridium.mbus.point.BMbusProxyExt;
import com.tridium.mbus.ui.PointDiscoveryWizardModel;
import com.tridium.mbus.utils.MbusToolkit;
import javax.baja.control.BControlPoint;
import javax.baja.control.ext.BAbstractProxyExt;
import javax.baja.driver.BDevice;
import javax.baja.driver.point.BDefaultProxyConversion;
import javax.baja.driver.point.BPointDeviceExt;
import javax.baja.driver.point.BProxyConversion;
import javax.baja.driver.point.BProxyExt;
import javax.baja.driver.ui.point.BPointManager;
import javax.baja.driver.ui.point.PointController;
import javax.baja.driver.ui.point.PointModel;
import javax.baja.gx.BImage;
import javax.baja.job.BJob;
import javax.baja.naming.BOrd;
import javax.baja.naming.BOrdList;
import javax.baja.registry.TypeInfo;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIcon;
import javax.baja.sys.BInteger;
import javax.baja.sys.BObject;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BWidget;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.wizard.BWizard;
import javax.baja.ui.wizard.WizardModel;
import javax.baja.units.BUnit;
import javax.baja.util.Array;
import javax.baja.util.Lexicon;
import javax.baja.workbench.mgr.BAbstractManager;
import javax.baja.workbench.mgr.MgrColumn;
import javax.baja.workbench.mgr.MgrController;
import javax.baja.workbench.mgr.MgrEditRow;
import javax.baja.workbench.mgr.MgrLearn;
import javax.baja.workbench.mgr.MgrModel;
import javax.baja.workbench.mgr.MgrTypeInfo;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public final class BMbusPointManager
extends BPointManager {
    public static final Type TYPE;
    static Lexicon lex;
    private static final BImage defaultIcon;
    String wholeName;
    MgrColumn colPath;
    MgrColumn colName;
    MgrColumn colType;
    MgrColumn colToString;
    MgrColumn colEnabled;
    MgrColumn colFacets;
    MgrColumn colTuning;
    MgrColumn colDeviceFacets;
    MgrColumn colConversion;
    MgrColumn colFaultCause;
    private MgrColumn colDescription;
    private MgrColumn colOrthoDescription;
    private MgrColumn colFunction;
    private MgrColumn colMbusUnit;
    private MgrColumn colExponent;
    private MgrColumn colNumberType;
    private MgrColumn colRecordNumber;
    private MgrColumn colMsgSlotNumber;
    private MgrColumn colStorageNumber;
    private MgrColumn colCycleNumber;
    private MgrColumn colMode;
    MgrColumn[] cols;
    BMbusPointEntry[] lastLearn;
    private BDevice device;
    private BAbstractMbusNetwork net;
    static /* synthetic */ Class class$com$tridium$mbus$ui$BMbusPointManager;
    static /* synthetic */ Class class$com$tridium$mbus$learn$BMbusPointEntry;
    static /* synthetic */ Class class$javax$baja$workbench$mgr$MgrTypeInfo;

    public final Type getType() {
        return TYPE;
    }

    protected final MgrModel makeModel() {
        return new Model(this);
    }

    protected final MgrLearn makeLearn() {
        return new Learn(this);
    }

    protected final MgrController makeController() {
        return new Controller(this);
    }

    public final void doLoadValue(BObject bObject, Context context) {
        super.doLoadValue(bObject, context);
        if (bObject instanceof BPointDeviceExt) {
            this.device = ((BPointDeviceExt)bObject).getDevice();
        } else if (bObject instanceof BMbusPointFolder) {
            this.device = ((BMbusPointFolder)bObject).getDevice();
        }
        this.device.lease();
    }

    private final void updateDiscoveryRows(BComponent bComponent) {
        Class clazz = class$com$tridium$mbus$learn$BMbusPointEntry;
        if (clazz == null) {
            clazz = class$com$tridium$mbus$learn$BMbusPointEntry = BMbusPointManager.class("[Lcom.tridium.mbus.learn.BMbusPointEntry;", false);
        }
        BMbusPointEntry[] bMbusPointEntryArray = (BMbusPointEntry[])bComponent.getChildren(clazz);
        int n = 0;
        while (n < bMbusPointEntryArray.length) {
            bMbusPointEntryArray[n].loadSlots();
            ++n;
        }
        this.getLearn().updateRoots((Object[])bMbusPointEntryArray);
    }

    public final BAbstractMbusNetwork getNetwork() {
        if (this.net == null) {
            this.net = this.findNetwork((BComponent)this.getCurrentValue());
        }
        return this.net;
    }

    public final BMbusDevice getDevice() {
        BComponent bComponent = (BComponent)this.getCurrentValue();
        while (!(bComponent instanceof BMbusDevice) && bComponent != null) {
            bComponent = (BComponent)bComponent.getParent();
        }
        return (BMbusDevice)bComponent;
    }

    private final BAbstractMbusNetwork findNetwork(BComponent bComponent) {
        if (bComponent == null) {
            return null;
        }
        if (bComponent instanceof BAbstractMbusNetwork) {
            return (BAbstractMbusNetwork)bComponent;
        }
        return this.findNetwork((BComponent)bComponent.getParent());
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final /* synthetic */ void this() {
        this.wholeName = "";
        this.colPath = new MgrColumn.Path(2);
        this.colName = new MgrColumn.Name();
        this.colType = new MgrColumn.Type(4);
        this.colToString = new MgrColumn.ToString("Out", 4);
        this.colEnabled = new MgrColumn.PropPath(new Property[]{BControlPoint.proxyExt, BProxyExt.enabled}, 3);
        this.colFacets = new MgrColumn.PropPath(new Property[]{BControlPoint.facets}, 1);
        this.colTuning = new MgrColumn.PropPath(new Property[]{BControlPoint.proxyExt, BProxyExt.tuningPolicyName}, 1);
        this.colDeviceFacets = new MgrColumn.PropPath(new Property[]{BControlPoint.proxyExt, BProxyExt.deviceFacets}, 3);
        this.colConversion = new MgrColumn.PropPath(new Property[]{BControlPoint.proxyExt, BProxyExt.conversion}, 3);
        this.colFaultCause = new MgrColumn.PropPath(new Property[]{BControlPoint.proxyExt, BProxyExt.faultCause}, 2);
        this.colDescription = new MgrColumn.PropPath(new Property[]{BControlPoint.proxyExt, BMbusProxyExt.description}, 5);
        this.colOrthoDescription = new MgrColumn.PropPath(new Property[]{BControlPoint.proxyExt, BMbusProxyExt.orthogonalDescription}, 5);
        this.colFunction = new MgrColumn.PropPath(new Property[]{BControlPoint.proxyExt, BMbusProxyExt.function}, 5);
        this.colMbusUnit = new MgrColumn.PropPath(new Property[]{BControlPoint.proxyExt, BMbusProxyExt.mbusUnit}, 5);
        this.colExponent = new MgrColumn.PropPath(new Property[]{BControlPoint.proxyExt, BMbusProxyExt.exponent}, 5);
        this.colNumberType = new MgrColumn.PropPath(new Property[]{BControlPoint.proxyExt, BMbusProxyExt.numberType}, 5);
        this.colRecordNumber = new MgrColumn.PropPath(new Property[]{BControlPoint.proxyExt, BMbusProxyExt.recordNumber}, 1);
        this.colMsgSlotNumber = new MgrColumn.PropPath(new Property[]{BControlPoint.proxyExt, BMbusProxyExt.messageSlotNumber}, 5);
        this.colStorageNumber = new MgrColumn.PropPath(new Property[]{BControlPoint.proxyExt, BMbusProxyExt.storageNumber}, 5);
        this.colCycleNumber = new MgrColumn.PropPath(new Property[]{BControlPoint.proxyExt, BMbusProxyExt.cycleNumber}, 5);
        this.colMode = new MgrColumn.PropPath(new Property[]{BControlPoint.proxyExt, BMbusProxyExt.deviceMode}, 5);
        this.cols = new MgrColumn[]{this.colName, this.colDescription, this.colOrthoDescription, this.colFunction, this.colMbusUnit, this.colExponent, this.colToString, this.colMode, this.colRecordNumber, this.colCycleNumber, this.colFacets, this.colStorageNumber, this.colTuning, this.colConversion, this.colFaultCause, this.colPath, this.colType, this.colEnabled, this.colNumberType, this.colMsgSlotNumber};
        this.lastLearn = null;
        this.device = null;
        this.net = null;
    }

    public BMbusPointManager() {
        this.this();
    }

    static {
        Class clazz = class$com$tridium$mbus$ui$BMbusPointManager;
        if (clazz == null) {
            clazz = class$com$tridium$mbus$ui$BMbusPointManager = BMbusPointManager.class("[Lcom.tridium.mbus.ui.BMbusPointManager;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
        Class clazz2 = class$com$tridium$mbus$ui$BMbusPointManager;
        if (clazz2 == null) {
            clazz2 = class$com$tridium$mbus$ui$BMbusPointManager = BMbusPointManager.class("[Lcom.tridium.mbus.ui.BMbusPointManager;", false);
        }
        lex = Lexicon.make((Class)clazz2);
        defaultIcon = BImage.make((String)"module://icons/x16/control/numericPoint.png");
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    class Model
    extends PointModel {
        protected MgrColumn[] makeColumns() {
            return BMbusPointManager.this.cols;
        }

        public BComponent newInstance(MgrTypeInfo mgrTypeInfo) throws Exception {
            BControlPoint bControlPoint = null;
            BMbusProxyExt bMbusProxyExt = new BMbusProxyExt();
            bMbusProxyExt.setMbusUnit(BMbusUnit.none);
            bMbusProxyExt.setDescription("None");
            bMbusProxyExt.setOrthogonalDescription(BMbusOrthogonalDescription.none);
            bMbusProxyExt.setMessageSlotNumber(0);
            bMbusProxyExt.setDeviceMode(0);
            bControlPoint = (BControlPoint)mgrTypeInfo.newInstance();
            BFacets bFacets = (BFacets)bControlPoint.getFacets().newCopy();
            bMbusProxyExt.setDeviceFacets(bFacets);
            bControlPoint.setProxyExt((BAbstractProxyExt)bMbusProxyExt);
            return bControlPoint;
        }

        Model(BPointManager bPointManager) {
            super(bPointManager);
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    private class Learn
    extends MgrLearn {
        protected MgrColumn[] makeColumns() {
            return new MgrColumn[]{new MgrColumn.Prop(BMbusPointEntry.description), new MgrColumn.Prop(BMbusPointEntry.orthogonalDescription), new MgrColumn.Prop(BMbusPointEntry.function), new MgrColumn.Prop(BMbusPointEntry.mbusUnit), new MgrColumn.Prop(BMbusPointEntry.exponent), new MgrColumn.Prop(BMbusPointEntry.numberType), new MgrColumn.Prop(BMbusPointEntry.deviceMode), new MgrColumn.Prop(BMbusPointEntry.recordNumber), new MgrColumn.Prop(BMbusPointEntry.cycleNumber), new MgrColumn.Prop(BMbusPointEntry.messageSlotNumber), new MgrColumn.Prop(BMbusPointEntry.storageNumber)};
        }

        public boolean isMatchable(Object object, BComponent bComponent) {
            return false;
        }

        public BImage getIcon(Object object) {
            MgrTypeInfo[] mgrTypeInfoArray = this.toTypes(object);
            if (mgrTypeInfoArray.length > 0) {
                BIcon bIcon = ((MbusMgrTypeInfo)mgrTypeInfoArray[0]).getPointTypeInfo().getInstance().getIcon();
                return BImage.make((BIcon)bIcon);
            }
            return defaultIcon;
        }

        public MgrTypeInfo[] toTypes(Object object) {
            BMbusPointEntry bMbusPointEntry = (BMbusPointEntry)((Object)object);
            Class clazz = class$javax$baja$workbench$mgr$MgrTypeInfo;
            if (clazz == null) {
                clazz = class$javax$baja$workbench$mgr$MgrTypeInfo = BMbusPointManager.class("[Ljavax.baja.workbench.mgr.MgrTypeInfo;", false);
            }
            Array array = new Array(clazz);
            if (bMbusPointEntry.getNumberType().equals((Object)BMbusNumberType.numericIp)) {
                array.add((Object)new MbusMgrTypeInfo(bMbusPointEntry.getMbusUnit(), bMbusPointEntry.getDescription(), Sys.getRegistry().getType("control:NumericPoint"), bMbusPointEntry.getOrthogonalDescription(), bMbusPointEntry.getMessageSlotNumber(), bMbusPointEntry.getStorageNumber(), bMbusPointEntry.getRecordNumber(), bMbusPointEntry.getCycleNumber(), bMbusPointEntry.getExponent(), bMbusPointEntry.getFunction(), bMbusPointEntry.getDeviceMode()));
            } else if (bMbusPointEntry.getNumberType().equals((Object)BMbusNumberType.booleanIp)) {
                array.add((Object)new MbusMgrTypeInfo(bMbusPointEntry.getMbusUnit(), bMbusPointEntry.getDescription(), Sys.getRegistry().getType("control:BooleanPoint"), bMbusPointEntry.getOrthogonalDescription(), bMbusPointEntry.getMessageSlotNumber(), bMbusPointEntry.getStorageNumber(), bMbusPointEntry.getRecordNumber(), bMbusPointEntry.getCycleNumber(), bMbusPointEntry.getExponent(), bMbusPointEntry.getFunction(), bMbusPointEntry.getDeviceMode()));
            } else if (bMbusPointEntry.getNumberType().equals((Object)BMbusNumberType.enumIp)) {
                array.add((Object)new MbusMgrTypeInfo(bMbusPointEntry.getMbusUnit(), bMbusPointEntry.getDescription(), Sys.getRegistry().getType("control:EnumPoint"), bMbusPointEntry.getOrthogonalDescription(), bMbusPointEntry.getMessageSlotNumber(), bMbusPointEntry.getStorageNumber(), bMbusPointEntry.getRecordNumber(), bMbusPointEntry.getCycleNumber(), bMbusPointEntry.getExponent(), bMbusPointEntry.getFunction(), bMbusPointEntry.getDeviceMode()));
            } else if (bMbusPointEntry.getNumberType().equals((Object)BMbusNumberType.dateIp) || bMbusPointEntry.getNumberType().equals((Object)BMbusNumberType.stringIp)) {
                array.add((Object)new MbusMgrTypeInfo(bMbusPointEntry.getMbusUnit(), bMbusPointEntry.getDescription(), Sys.getRegistry().getType("control:StringPoint"), bMbusPointEntry.getOrthogonalDescription(), bMbusPointEntry.getMessageSlotNumber(), bMbusPointEntry.getStorageNumber(), bMbusPointEntry.getRecordNumber(), bMbusPointEntry.getCycleNumber(), bMbusPointEntry.getExponent(), bMbusPointEntry.getFunction(), bMbusPointEntry.getDeviceMode()));
            }
            return (MgrTypeInfo[])array.trim();
        }

        public void toRow(Object object, MgrEditRow mgrEditRow) throws Exception {
            BMbusPointManager.this.wholeName = "";
            BMbusPointEntry bMbusPointEntry = (BMbusPointEntry)((Object)object);
            mgrEditRow.setCell(BMbusPointManager.this.colMbusUnit, (BValue)bMbusPointEntry.getMbusUnit());
            mgrEditRow.setCell(BMbusPointManager.this.colDescription, (BValue)BString.make((String)bMbusPointEntry.getDescription()));
            mgrEditRow.setCell(BMbusPointManager.this.colOrthoDescription, (BValue)bMbusPointEntry.getOrthogonalDescription());
            mgrEditRow.setCell(BMbusPointManager.this.colFunction, (BValue)bMbusPointEntry.getFunction());
            mgrEditRow.setCell(BMbusPointManager.this.colExponent, (BValue)BInteger.make((int)bMbusPointEntry.getExponent()));
            mgrEditRow.setCell(BMbusPointManager.this.colNumberType, (BValue)bMbusPointEntry.getNumberType());
            mgrEditRow.setCell(BMbusPointManager.this.colRecordNumber, (BValue)BInteger.make((int)bMbusPointEntry.getRecordNumber()));
            mgrEditRow.setCell(BMbusPointManager.this.colCycleNumber, (BValue)BInteger.make((int)bMbusPointEntry.getCycleNumber()));
            mgrEditRow.setCell(BMbusPointManager.this.colMsgSlotNumber, (BValue)BInteger.make((int)bMbusPointEntry.getMessageSlotNumber()));
            mgrEditRow.setCell(BMbusPointManager.this.colStorageNumber, (BValue)BInteger.make((int)bMbusPointEntry.getStorageNumber()));
            mgrEditRow.setCell(BMbusPointManager.this.colMode, (BValue)BInteger.make((int)bMbusPointEntry.getDeviceMode()));
            BMbusPointManager.this.wholeName = !bMbusPointEntry.getOrthogonalDescription().equals((Object)BMbusOrthogonalDescription.none) ? bMbusPointEntry.getDescription().toString() + ' ' + bMbusPointEntry.getOrthogonalDescription().toString() : bMbusPointEntry.getDescription();
            String string = "";
            if (bMbusPointEntry.getRecordNumber() > 1) {
                string = new Integer(bMbusPointEntry.getRecordNumber() - 1).toString();
                BMbusPointManager.this.wholeName = BMbusPointManager.this.wholeName + string + "_R";
            }
            String string2 = "";
            if (bMbusPointEntry.getCycleNumber() > 0) {
                string2 = new Integer(bMbusPointEntry.getCycleNumber()).toString();
                BMbusPointManager.this.wholeName = BMbusPointManager.this.wholeName + string2 + "_C";
            }
            if (bMbusPointEntry.getMessageSlotNumber() != 0 && bMbusPointEntry.getStorageNumber() < 1) {
                BMbusPointManager.this.wholeName = BMbusPointManager.this.wholeName + "SL" + new Integer(bMbusPointEntry.getMessageSlotNumber()).toString();
            } else if (bMbusPointEntry.getStorageNumber() != 0) {
                BMbusPointManager.this.wholeName = BMbusPointManager.this.wholeName + "ST" + new Integer(bMbusPointEntry.getStorageNumber()).toString();
            }
            BMbusPointManager.this.wholeName = BMbusPointManager.this.wholeName.replace(' ', '_');
            BMbusPointManager.this.wholeName = BMbusPointManager.this.wholeName.trim();
            mgrEditRow.setDefaultName(BMbusPointManager.this.wholeName);
        }

        public boolean isExisting(Object object, BComponent bComponent) {
            try {
                BMbusPointEntry bMbusPointEntry = (BMbusPointEntry)((Object)object);
                return bMbusPointEntry.is(bComponent);
            }
            catch (Throwable throwable) {
                MbusToolkit.error("Error asking is point existing");
                return false;
            }
        }

        public void jobComplete(final BJob bJob) {
            super.jobComplete(bJob);
            if (bJob instanceof BMbusLivePointSearchDiscoveryJob) {
                try {
                    new Thread(new Runnable(){

                        public final void run() {
                            try {
                                BMbusPointManager.this.getLearn().setJob(BMbusPointManager.this.getNetwork().submitPointDiscoveryJob(BOrdList.make((BOrd[])new BOrd[]{BMbusPointManager.this.device.getSlotPathOrd(), bJob.getSlotPathOrd()})));
                                BMbusPointManager.this.getController().updateCommands();
                            }
                            catch (Exception exception) {
                                MbusToolkit.error(MbusToolkit.getText("MbusDeviceManager.discoveryError"), exception);
                            }
                        }
                    }).start();
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                BMbusPointManager.this.getController().updateCommands();
            } else {
                BMbusPointManager.this.updateDiscoveryRows((BComponent)bJob);
            }
        }

        Learn(BMbusPointManager bMbusPointManager2) {
            super((BAbstractManager)bMbusPointManager2);
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    class Controller
    extends PointController {
        protected MgrController.IMgrCommand[] makeCommands() {
            return new MgrController.IMgrCommand[]{this.newCommand, this.newFolder, this.allDescendants, this.edit, this.learnMode, this.discover, this.add};
        }

        public CommandArtifact doDiscover(Context context) throws Exception {
            super.doDiscover(context);
            PointDiscoveryWizardModel pointDiscoveryWizardModel = new PointDiscoveryWizardModel();
            BMbusDevice bMbusDevice = BMbusPointManager.this.getDevice();
            if (bMbusDevice != null) {
                pointDiscoveryWizardModel.setDevice(bMbusDevice.getAbsoluteOrd());
            }
            BWizard.open((BWidget)this.getManager(), (WizardModel)pointDiscoveryWizardModel);
            if (!pointDiscoveryWizardModel.isUserFinished()) {
                return null;
            }
            if (pointDiscoveryWizardModel.isDatabasePointScan()) {
                BMbusPointManager.this.getLearn().setJob(BMbusPointManager.this.getNetwork().submitPointDiscoveryJob(BOrdList.make((BOrd[])new BOrd[]{bMbusDevice.getSlotPathOrd(), BOrd.NULL})));
            } else if (pointDiscoveryWizardModel.isLivePointScan()) {
                BMbusPointManager.this.getLearn().setJob(bMbusDevice.submitLivePointsDiscoveryJob(pointDiscoveryWizardModel.getPointDiscoverOptions()));
            }
            return null;
        }

        public void updateCommands() {
            super.updateCommands();
            if (BMbusPointManager.this.getLearn().getTable() != null) {
                boolean bl = false;
                if (BMbusPointManager.this.getLearn().getTable().getSelectedObject() != null) {
                    bl = true;
                }
                this.add.setEnabled(bl);
            }
        }

        Controller(BPointManager bPointManager) {
            super(bPointManager);
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public static class MbusMgrTypeInfo
    extends MgrTypeInfo {
        private static final BImage defaultIcon = BImage.make((String)"module://icons/x16/statusNumeric.png");
        private TypeInfo pntType;
        private BMbusUnit mbusUnit;
        private String description;
        private int msgSlotNumber;
        private BMbusFunction function;
        private int storageNumber;
        private int recordNumber;
        private int cycleNumber;
        private String displayName;
        private BMbusOrthogonalDescription orthoDesc;
        private int exponent;
        private int mode;

        public String getDisplayName() {
            return this.displayName;
        }

        public TypeInfo getPointTypeInfo() {
            return this.pntType;
        }

        public BProxyConversion getConverter() {
            return BDefaultProxyConversion.DEFAULT;
        }

        public BImage getIcon() {
            return defaultIcon;
        }

        public BComponent newInstance() {
            BControlPoint bControlPoint = null;
            bControlPoint = (BControlPoint)this.pntType.getInstance();
            BMbusProxyExt bMbusProxyExt = new BMbusProxyExt();
            bMbusProxyExt.setMbusUnit(this.mbusUnit);
            bMbusProxyExt.setDescription(this.description);
            bMbusProxyExt.setOrthogonalDescription(this.orthoDesc);
            bMbusProxyExt.setRecordNumber(this.recordNumber);
            bMbusProxyExt.setCycleNumber(this.cycleNumber);
            bMbusProxyExt.setMessageSlotNumber(this.msgSlotNumber);
            bMbusProxyExt.setStorageNumber(this.storageNumber);
            bMbusProxyExt.setFunction(this.function);
            bMbusProxyExt.setExponent(this.exponent);
            bMbusProxyExt.setDeviceMode(this.mode);
            int n = 0;
            if (this.exponent < 0) {
                n = -this.exponent;
            }
            BUnit bUnit = BMbusUnit.getNiagaraUnits(this.mbusUnit);
            BFacets bFacets = BFacets.makeNumeric((BUnit)bUnit, (int)n);
            bMbusProxyExt.setDeviceFacets(bFacets);
            bControlPoint.setProxyExt((BAbstractProxyExt)bMbusProxyExt);
            bControlPoint.setFacets(bFacets);
            return bControlPoint;
        }

        public boolean isMatchable(BComponent bComponent) {
            return false;
        }

        private final /* synthetic */ void this() {
            this.pntType = null;
            this.mbusUnit = null;
            this.description = null;
            this.msgSlotNumber = 0;
            this.function = BMbusFunction.instantaneous;
            this.storageNumber = 0;
            this.recordNumber = 0;
            this.cycleNumber = 0;
            this.displayName = "Invalid";
            this.orthoDesc = null;
            this.exponent = 0;
            this.mode = 0;
        }

        public MbusMgrTypeInfo(BMbusUnit bMbusUnit, String string, TypeInfo typeInfo, BMbusOrthogonalDescription bMbusOrthogonalDescription, int n, int n2, int n3, int n4, int n5, BMbusFunction bMbusFunction, int n6) {
            block7: {
                this.this();
                this.mbusUnit = bMbusUnit;
                this.description = string;
                this.orthoDesc = bMbusOrthogonalDescription;
                this.pntType = typeInfo;
                this.exponent = n5;
                this.msgSlotNumber = n;
                this.recordNumber = n3;
                this.cycleNumber = n4;
                this.storageNumber = n2;
                this.function = bMbusFunction;
                this.mode = n6;
                try {
                    this.displayName = !bMbusOrthogonalDescription.equals((Object)BMbusOrthogonalDescription.none) ? string.toString() + ' ' + bMbusOrthogonalDescription.toString() : string.toString();
                    boolean bl = false;
                    if (n != 0) {
                        bl = true;
                    }
                    boolean bl2 = false;
                    if (n2 < 1) {
                        bl2 = true;
                    }
                    if (bl & bl2) {
                        this.displayName = this.displayName + new Integer(n).toString();
                    } else if (n2 != 0) {
                        this.displayName = this.displayName + new Integer(n2).toString();
                    }
                }
                catch (Exception exception) {
                    if (MbusToolkit.getLog() == null) break block7;
                    MbusToolkit.error("Error Point Manager MbusMgrTypeInfo", exception);
                }
            }
        }
    }
}

