/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.mbus.ui;

import com.tridium.mbus.BAbstractMbusNetwork;
import com.tridium.mbus.BMbusDevice;
import com.tridium.mbus.BMbusTcpIpNetwork;
import com.tridium.mbus.actionArgSets.BPrimaryDiscoverOptions;
import com.tridium.mbus.actionArgSets.BSecondaryDiscoverOptions;
import com.tridium.mbus.enums.BMbusBaudRate;
import com.tridium.mbus.enums.BMbusDeviceTypeId;
import com.tridium.mbus.jobs.BMbusAssignBaudRateData;
import com.tridium.mbus.jobs.BMbusDeviceSearchJob;
import com.tridium.mbus.jobs.BMbusPrimaryDeviceSearchJob;
import com.tridium.mbus.jobs.BMbusSecondaryDeviceSearchJob;
import com.tridium.mbus.jobs.BMbusSecondarySearchJob;
import com.tridium.mbus.learn.BMbusDeviceDiscoveryJob;
import com.tridium.mbus.learn.BMbusDeviceEntry;
import com.tridium.mbus.types.BEncodableList;
import com.tridium.mbus.ui.DiscoveryWizardModel;
import com.tridium.mbus.utils.MbusToolkit;
import com.tridium.ui.theme.Theme;
import com.tridium.workbench.job.BJobBar;
import javax.baja.driver.BDevice;
import javax.baja.driver.ui.device.BDeviceManager;
import javax.baja.driver.ui.device.DeviceController;
import javax.baja.driver.ui.device.DeviceExtsColumn;
import javax.baja.driver.ui.device.DeviceModel;
import javax.baja.driver.ui.device.DeviceState;
import javax.baja.gx.BImage;
import javax.baja.gx.BInsets;
import javax.baja.job.BJob;
import javax.baja.job.BJobState;
import javax.baja.naming.BOrd;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComponent;
import javax.baja.sys.BComponentEvent;
import javax.baja.sys.BInteger;
import javax.baja.sys.BObject;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BBorder;
import javax.baja.ui.BDialog;
import javax.baja.ui.BNullWidget;
import javax.baja.ui.BWidget;
import javax.baja.ui.Command;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.pane.BEdgePane;
import javax.baja.ui.pane.BPane;
import javax.baja.ui.wizard.BWizard;
import javax.baja.ui.wizard.WizardModel;
import javax.baja.util.Array;
import javax.baja.workbench.fieldeditor.BWbFieldEditor;
import javax.baja.workbench.mgr.BAbstractManager;
import javax.baja.workbench.mgr.BMgrTable;
import javax.baja.workbench.mgr.MgrColumn;
import javax.baja.workbench.mgr.MgrController;
import javax.baja.workbench.mgr.MgrEditRow;
import javax.baja.workbench.mgr.MgrLearn;
import javax.baja.workbench.mgr.MgrModel;
import javax.baja.workbench.mgr.MgrState;
import javax.baja.workbench.mgr.MgrTypeInfo;
import javax.baja.workbench.view.BWbComponentView;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public final class BMbusDeviceManager
extends BDeviceManager {
    public static final Type TYPE;
    private static BImage deviceIcon;
    protected Object lastUpdateToggledByHandle;
    MgrColumn colName;
    MgrColumn colType;
    MgrColumn colDeviceExts;
    MgrColumn colStatus;
    MgrColumn colEnabled;
    MgrColumn colHealth;
    MgrColumn colPrimaryAddress;
    MgrColumn colSecondaryAddress;
    MgrColumn colAddressMode;
    MgrColumn colMBusConfig;
    MgrColumn colCycleQuantity;
    MgrColumn colResetRequired;
    MgrColumn colFcBitState;
    MgrColumn colFcBitInUse;
    MgrColumn colIdentNumber;
    MgrColumn colManufacturer;
    MgrColumn colVersionNumber;
    MgrColumn colDeviceTypeId;
    MgrColumn colModelName;
    MgrColumn colBaudRate;
    MgrColumn[] cols;
    BMbusDeviceEntry[] lastLearn;
    private BAbstractMbusNetwork net;
    static /* synthetic */ Class class$com$tridium$mbus$ui$BMbusDeviceManager;
    static /* synthetic */ Class class$com$tridium$mbus$learn$BMbusDeviceEntry;
    static /* synthetic */ Class class$javax$baja$workbench$mgr$MgrController$IMgrCommand;

    public final Type getType() {
        return TYPE;
    }

    protected final MgrModel makeModel() {
        return new Model(this);
    }

    protected final MgrLearn makeLearn() {
        return new Learn(this);
    }

    protected final MgrController makeController() {
        return new Controller(this);
    }

    protected final MgrState makeState() {
        return new MbusDeviceState();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void handleComponentEvent(BComponentEvent bComponentEvent) {
        final BComponent bComponent = bComponentEvent.getSourceComponent();
        if (!(bComponent instanceof BMbusDeviceSearchJob || bComponent instanceof BMbusSecondarySearchJob || bComponent instanceof BMbusPrimaryDeviceSearchJob || bComponent instanceof BMbusSecondaryDeviceSearchJob)) {
            super.handleComponentEvent(bComponentEvent);
            return;
        }
        try {
            if (!bComponentEvent.getSlotName().equals(BJob.jobState.getName())) {
                return;
            }
            if (this.getController().learnMode.isSelected() && ((BJob)bComponent).getJobState().equals((Object)BJobState.success)) {
                Object object = this.lastUpdateToggledByHandle;
                synchronized (object) {
                    if (this.lastUpdateToggledByHandle == bComponent.getHandle()) {
                        return;
                    }
                    this.lastUpdateToggledByHandle = bComponent.getHandle();
                }
                new Thread(new Runnable(){

                    public final void run() {
                        try {
                            BMbusDeviceManager.this.getLearn().setJob(BMbusDeviceManager.this.getNetwork().submitDeviceDiscoveryJob(((BJob)bComponent).getHandleOrd()));
                            BMbusDeviceManager.this.getController().updateCommands();
                        }
                        catch (Exception exception) {
                            MbusToolkit.error(MbusToolkit.getText("MbusDeviceManager.discoveryError"), exception);
                        }
                    }
                }).start();
                return;
            }
            if (!this.getController().learnMode.isSelected()) return;
            if (!((BJob)bComponent).getJobState().equals((Object)BJobState.canceled)) {
                if (!((BJob)bComponent).getJobState().equals((Object)BJobState.failed)) return;
            }
            this.getController().updateCommands();
            return;
        }
        catch (Exception exception) {
            MbusToolkit.error(MbusToolkit.getText("MbusDeviceManager.discoveryError"), exception);
            return;
        }
    }

    private final void updateDiscoveryRows(BComponent bComponent) {
        bComponent.loadSlots();
        Class clazz = class$com$tridium$mbus$learn$BMbusDeviceEntry;
        if (clazz == null) {
            clazz = class$com$tridium$mbus$learn$BMbusDeviceEntry = BMbusDeviceManager.class("[Lcom.tridium.mbus.learn.BMbusDeviceEntry;", false);
        }
        BMbusDeviceEntry[] bMbusDeviceEntryArray = (BMbusDeviceEntry[])bComponent.getChildren(clazz);
        this.lastLearn = bMbusDeviceEntryArray;
        int n = 0;
        while (n < bMbusDeviceEntryArray.length) {
            bMbusDeviceEntryArray[n].loadSlots();
            ++n;
        }
        this.getLearn().updateRoots((Object[])bMbusDeviceEntryArray);
    }

    public final BAbstractMbusNetwork getNetwork() {
        if (this.net == null) {
            this.net = this.findNetwork((BComponent)this.getCurrentValue());
        }
        return this.net;
    }

    private final BAbstractMbusNetwork findNetwork(BComponent bComponent) {
        if (bComponent == null) {
            return null;
        }
        if (bComponent instanceof BAbstractMbusNetwork) {
            return (BAbstractMbusNetwork)bComponent;
        }
        return this.findNetwork((BComponent)bComponent.getParent());
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final /* synthetic */ void this() {
        this.lastUpdateToggledByHandle = new Object();
        this.colName = new MgrColumn.Name();
        this.colType = new MgrColumn.Type();
        this.colDeviceExts = new DeviceExtsColumn((BDevice)new BMbusDevice());
        this.colStatus = new MgrColumn.Prop(BDevice.status);
        this.colEnabled = new MgrColumn.Prop(BDevice.enabled, 3);
        this.colHealth = new MgrColumn.Prop(BDevice.health, 0);
        this.colPrimaryAddress = new MgrColumn.Prop(BMbusDevice.primaryAddress, 1);
        this.colSecondaryAddress = new MgrColumn.Prop(BMbusDevice.secondaryAddress, 1);
        this.colAddressMode = new MgrColumn.Prop(BMbusDevice.addressMode, 1);
        this.colMBusConfig = new MgrColumn.Prop(BMbusDevice.mbusConfig, 1);
        this.colCycleQuantity = new MgrColumn.Prop(BMbusDevice.cycleQuantity, 1);
        this.colResetRequired = new MgrColumn.Prop(BMbusDevice.resetRequired, 1);
        this.colFcBitState = new MgrColumn.Prop(BMbusDevice.fcBitState, 5);
        this.colFcBitInUse = new MgrColumn.Prop(BMbusDevice.fcBitInUse, 1);
        this.colIdentNumber = new MgrColumn.Prop(BMbusDevice.identNumber, 1);
        this.colManufacturer = new MgrColumn.Prop(BMbusDevice.manufacturer, 1);
        this.colVersionNumber = new MgrColumn.Prop(BMbusDevice.versionNumber, 1);
        this.colDeviceTypeId = new MgrColumn.Prop(BMbusDevice.deviceTypeId, 1);
        this.colModelName = new MgrColumn.Prop(BMbusDevice.modelName, 1);
        this.colBaudRate = new MgrColumn.Prop(BMbusDevice.baudRate, 5);
        this.cols = new MgrColumn[]{this.colModelName, this.colName, this.colType, this.colDeviceExts, this.colPrimaryAddress, this.colSecondaryAddress, this.colAddressMode, this.colMBusConfig, this.colCycleQuantity, this.colResetRequired, this.colFcBitState, this.colFcBitInUse, this.colIdentNumber, this.colManufacturer, this.colVersionNumber, this.colDeviceTypeId, this.colStatus, this.colBaudRate, this.colEnabled, this.colHealth};
        this.lastLearn = null;
        this.net = null;
    }

    public BMbusDeviceManager() {
        this.this();
    }

    static {
        Class clazz = class$com$tridium$mbus$ui$BMbusDeviceManager;
        if (clazz == null) {
            clazz = class$com$tridium$mbus$ui$BMbusDeviceManager = BMbusDeviceManager.class("[Lcom.tridium.mbus.ui.BMbusDeviceManager;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
        deviceIcon = BImage.make((String)"module://icons/x16/device.png");
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    class Model
    extends DeviceModel {
        private BJob updateCmdJob;
        private BJob assignBaudRateCmdJob;
        private BEdgePane jobPane;

        protected MgrColumn[] makeColumns() {
            return BMbusDeviceManager.this.cols;
        }

        public BWidget makePane() {
            BEdgePane bEdgePane = new BEdgePane();
            bEdgePane.setTop((BWidget)this.jobPane);
            bEdgePane.setCenter(super.makePane());
            return bEdgePane;
        }

        void setUpdateJob(BJob bJob) {
            if (BMbusDeviceManager.this.getController().learnMode.isSelected()) {
                BMbusDeviceManager.this.getLearn().setJob(bJob);
                this.removeJobPane();
                return;
            }
            this.updateCmdJob = bJob;
            this.updateJobBars();
            ((Controller)BMbusDeviceManager.this.getController()).updateCommands();
        }

        BJob getUpdateJob() {
            return this.updateCmdJob;
        }

        void setAssignBaudRateJob(BJob bJob) {
            if (BMbusDeviceManager.this.getController().learnMode.isSelected()) {
                BMbusDeviceManager.this.getLearn().setJob(bJob);
                this.removeJobPane();
                return;
            }
            this.assignBaudRateCmdJob = bJob;
            this.updateJobBars();
            ((Controller)BMbusDeviceManager.this.getController()).updateCommands();
        }

        BJob getAssignBaudRateJob() {
            return this.assignBaudRateCmdJob;
        }

        private final void updateJobBars() {
            this.jobPane.removeAll();
            if (this.updateCmdJob != null) {
                this.jobPane.setTop((BWidget)this.createJobPane(this.updateCmdJob));
            }
            if (this.assignBaudRateCmdJob != null) {
                this.jobPane.setBottom((BWidget)this.createJobPane(this.assignBaudRateCmdJob));
            }
        }

        public void removeJobPane() {
            this.jobPane.setTop((BWidget)new BNullWidget());
            this.jobPane.setBottom((BWidget)new BNullWidget());
        }

        private final BPane createJobPane(BJob bJob) {
            BJobBar bJobBar = BJobBar.makeFor((BJob)bJob);
            bJobBar.load(bJob);
            BBorderPane bBorderPane = new BBorderPane((BWidget)bJobBar, BBorder.groove, BInsets.make((double)0.0, (double)5, (double)0.0, (double)5));
            bBorderPane.setFill(Theme.widget().getWindowBackground());
            bBorderPane = new BBorderPane((BWidget)bBorderPane, BInsets.make((double)0.0, (double)0.0, (double)5, (double)0.0));
            BMbusDeviceManager.this.attach((BWbComponentView.Attachable)bJobBar);
            BMbusDeviceManager.this.registerForComponentEvents((BComponent)bJob);
            return bBorderPane;
        }

        private final /* synthetic */ void this() {
            this.updateCmdJob = null;
            this.assignBaudRateCmdJob = null;
            this.jobPane = new BEdgePane();
        }

        Model(BDeviceManager bDeviceManager) {
            super(bDeviceManager);
            this.this();
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    private class Learn
    extends MgrLearn {
        protected MgrColumn[] makeColumns() {
            return new MgrColumn[]{new MgrColumn.Prop(BMbusDeviceEntry.primaryAddress), new MgrColumn.Prop(BMbusDeviceEntry.secondaryAddress), new MgrColumn.Prop(BMbusDeviceEntry.baudRate), new MgrColumn.Prop(BMbusDeviceEntry.addressMode)};
        }

        public boolean isMatchable(Object object, BComponent bComponent) {
            return false;
        }

        public BImage getIcon(Object object) {
            return deviceIcon;
        }

        public MgrTypeInfo[] toTypes(Object object) {
            return BMbusDeviceManager.this.getModel().getNewTypes();
        }

        public void toRow(Object object, MgrEditRow mgrEditRow) throws Exception {
            BMbusDeviceEntry bMbusDeviceEntry = (BMbusDeviceEntry)((Object)object);
            mgrEditRow.setCell(BMbusDeviceManager.this.colModelName, (BValue)BString.make((String)bMbusDeviceEntry.getModelName()));
            mgrEditRow.setCell(BMbusDeviceManager.this.colPrimaryAddress, (BValue)BInteger.make((int)bMbusDeviceEntry.getPrimaryAddress()));
            mgrEditRow.setCell(BMbusDeviceManager.this.colSecondaryAddress, (BValue)BString.make((String)bMbusDeviceEntry.getSecondaryAddress()));
            mgrEditRow.setCell(BMbusDeviceManager.this.colMBusConfig, bMbusDeviceEntry.getTxRxMbusConfig().newCopy(true));
            mgrEditRow.setCell(BMbusDeviceManager.this.colCycleQuantity, (BValue)BInteger.make((int)bMbusDeviceEntry.getCycleQuantity()));
            mgrEditRow.setCell(BMbusDeviceManager.this.colResetRequired, (BValue)BBoolean.make((boolean)bMbusDeviceEntry.getResetRequired()));
            mgrEditRow.setCell(BMbusDeviceManager.this.colFcBitState, (BValue)BBoolean.make((boolean)bMbusDeviceEntry.getFcBitState()));
            mgrEditRow.setCell(BMbusDeviceManager.this.colFcBitInUse, (BValue)BBoolean.make((boolean)bMbusDeviceEntry.getFcBitInUse()));
            mgrEditRow.setCell(BMbusDeviceManager.this.colIdentNumber, (BValue)BString.make((String)bMbusDeviceEntry.getIdentNumber()));
            mgrEditRow.setCell(BMbusDeviceManager.this.colManufacturer, (BValue)BString.make((String)bMbusDeviceEntry.getManufacturer()));
            mgrEditRow.setCell(BMbusDeviceManager.this.colVersionNumber, (BValue)BInteger.make((int)bMbusDeviceEntry.getVersionNumber()));
            mgrEditRow.setCell(BMbusDeviceManager.this.colDeviceTypeId, (BValue)BMbusDeviceTypeId.make(bMbusDeviceEntry.getDeviceTypeId().getOrdinal()));
            mgrEditRow.setCell(BMbusDeviceManager.this.colBaudRate, (BValue)BMbusBaudRate.make(bMbusDeviceEntry.getBaudRate().getOrdinal()));
            mgrEditRow.setCell(BMbusDeviceManager.this.colAddressMode, (BValue)bMbusDeviceEntry.getAddressMode());
        }

        public boolean isExisting(Object object, BComponent bComponent) {
            try {
                BMbusDeviceEntry bMbusDeviceEntry = (BMbusDeviceEntry)((Object)object);
                return bMbusDeviceEntry.is(bComponent);
            }
            catch (Throwable throwable) {
                MbusToolkit.error(MbusToolkit.getText("MbusDeviceManager.entryError"), throwable);
                return false;
            }
        }

        public void jobComplete(BJob bJob) {
            super.jobComplete(bJob);
            if (bJob instanceof BMbusDeviceDiscoveryJob) {
                BMbusDeviceManager.this.updateDiscoveryRows((BComponent)bJob);
            }
        }

        public void setJob(BJob bJob) {
            super.setJob(bJob);
            BMbusDeviceManager.this.updateDiscoveryRows((BComponent)bJob);
        }

        public void setJob(BOrd bOrd) throws Exception {
            super.setJob(bOrd);
        }

        Learn(BMbusDeviceManager bMbusDeviceManager2) {
            super((BAbstractManager)bMbusDeviceManager2);
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    class Controller
    extends DeviceController {
        private UpdateFromNetworkCmd updateCmd;
        private AssignBaudRateCmd assignCmd;

        protected MgrController.IMgrCommand[] makeCommands() {
            Class clazz = class$javax$baja$workbench$mgr$MgrController$IMgrCommand;
            if (clazz == null) {
                clazz = class$javax$baja$workbench$mgr$MgrController$IMgrCommand = BMbusDeviceManager.class("[Ljavax.baja.workbench.mgr.MgrController$IMgrCommand;", false);
            }
            Array array = new Array(clazz);
            array.addAll((Object[])new MgrController.IMgrCommand[]{this.newCommand, this.newFolder, this.updateCmd, this.allDescendants, this.edit, this.learnMode, this.discover, this.add});
            if (!(BMbusDeviceManager.this.getNetwork() instanceof BMbusTcpIpNetwork)) {
                array.add((Object)this.assignCmd);
            }
            return (MgrController.IMgrCommand[])array.trim();
        }

        public CommandArtifact doNew(Context context) throws Exception {
            super.doNew(context);
            return null;
        }

        public CommandArtifact doDiscover(Context context) throws Exception {
            super.doDiscover(context);
            ((Model)BMbusDeviceManager.this.getModel()).removeJobPane();
            DiscoveryWizardModel discoveryWizardModel = new DiscoveryWizardModel();
            discoveryWizardModel.setBaudSelectable(BMbusDeviceManager.this.net instanceof BMbusTcpIpNetwork ^ true);
            BWizard.open((BWidget)BMbusDeviceManager.this, (WizardModel)discoveryWizardModel);
            if (discoveryWizardModel.isFinished()) {
                if (discoveryWizardModel.isScanDeviceDatabaseDiscover()) {
                    BMbusDeviceManager.this.getNetwork().getNetworkDatabase().setJustDetected();
                    BMbusDeviceManager.this.getLearn().setJob(BMbusDeviceManager.this.getNetwork().submitDeviceDiscoveryJob(BOrd.NULL));
                } else if (discoveryWizardModel.isSingleDeviceDiscover()) {
                    BPrimaryDiscoverOptions bPrimaryDiscoverOptions = new BPrimaryDiscoverOptions();
                    bPrimaryDiscoverOptions.setBaudRates(discoveryWizardModel.getSelectedBaudRatesVector());
                    bPrimaryDiscoverOptions.setAddrRange(discoveryWizardModel.getRange());
                    bPrimaryDiscoverOptions.setTxRxProfile(discoveryWizardModel.getTxRxProfile());
                    BMbusDeviceManager.this.getLearn().setJob(BMbusDeviceManager.this.getNetwork().submitSingleDeviceDiscoveryJob(bPrimaryDiscoverOptions));
                } else if (discoveryWizardModel.isAddressDiscover()) {
                    BPrimaryDiscoverOptions bPrimaryDiscoverOptions = new BPrimaryDiscoverOptions();
                    bPrimaryDiscoverOptions.setBaudRates(discoveryWizardModel.getSelectedBaudRatesVector());
                    bPrimaryDiscoverOptions.setAddrRange(discoveryWizardModel.getRange());
                    bPrimaryDiscoverOptions.setTxRxProfile(discoveryWizardModel.getTxRxProfile());
                    BMbusDeviceManager.this.getLearn().setJob(BMbusDeviceManager.this.getNetwork().submitPrimaryDiscoverRangeJob(bPrimaryDiscoverOptions));
                } else if (discoveryWizardModel.isSecondaryDiscover()) {
                    BSecondaryDiscoverOptions bSecondaryDiscoverOptions = new BSecondaryDiscoverOptions();
                    bSecondaryDiscoverOptions.setBaudRates(discoveryWizardModel.getSelectedBaudRatesVector());
                    bSecondaryDiscoverOptions.setTxRxProfile(discoveryWizardModel.getTxRxProfile());
                    bSecondaryDiscoverOptions.setIdentScanOnly(false);
                    bSecondaryDiscoverOptions.setFilters(discoveryWizardModel.getFilters());
                    BMbusDeviceManager.this.getLearn().setJob(BMbusDeviceManager.this.getNetwork().submitFullSecondaryDiscoverJob(bSecondaryDiscoverOptions));
                } else if (discoveryWizardModel.isSpecificSecondaryAddressDiscover()) {
                    BSecondaryDiscoverOptions bSecondaryDiscoverOptions = new BSecondaryDiscoverOptions();
                    bSecondaryDiscoverOptions.setBaudRates(discoveryWizardModel.getSelectedBaudRatesVector());
                    bSecondaryDiscoverOptions.setTxRxProfile(discoveryWizardModel.getTxRxProfile());
                    bSecondaryDiscoverOptions.setFilters(discoveryWizardModel.getFilters());
                    BMbusDeviceManager.this.getLearn().setJob(BMbusDeviceManager.this.getNetwork().submitSecondaryAddressScanJob(bSecondaryDiscoverOptions));
                }
            }
            return null;
        }

        public void updateCommands() {
            boolean bl;
            BMgrTable bMgrTable = this.getManager().getModel().getTable();
            MgrLearn mgrLearn = BMbusDeviceManager.this.getLearn();
            boolean bl2 = false;
            if (bMgrTable != null && !bMgrTable.getSelection().isEmpty()) {
                bl2 = bl = true;
            }
            if (BMbusDeviceManager.this.getController().learnMode.isSelected()) {
                if (mgrLearn.getTable() != null) {
                    boolean bl3 = false;
                    if (mgrLearn.getTable().getSelectedObject() != null) {
                        bl3 = true;
                    }
                    this.add.setEnabled(bl3);
                }
                BJob bJob = mgrLearn.getJob();
                boolean bl4 = false;
                if (bJob != null) {
                    bl4 = bJob.getJobState().isComplete() ^ true;
                }
                boolean bl5 = bl4;
                boolean bl6 = false;
                if (bJob == null || !bl5) {
                    bl6 = true;
                }
                boolean bl7 = bl6;
                this.discover.setEnabled(bl7);
                boolean bl8 = false;
                if (bJob != null && bl5) {
                    bl8 = true;
                }
                this.cancel.setEnabled(bl8);
                this.edit.setEnabled(bl);
                boolean bl9 = false;
                if (bl7 && bl) {
                    bl9 = true;
                }
                this.updateCmd.setEnabled(bl9);
                boolean bl10 = false;
                if (bl7 && bl) {
                    bl10 = true;
                }
                this.assignCmd.setEnabled(bl10);
            } else {
                boolean bl11 = false;
                BJob bJob = ((Model)BMbusDeviceManager.this.getModel()).getAssignBaudRateJob();
                if (bJob != null && !bJob.getJobState().isComplete()) {
                    bl11 = true;
                } else {
                    bJob = ((Model)BMbusDeviceManager.this.getModel()).getUpdateJob();
                    if (bJob != null && !bJob.getJobState().isComplete()) {
                        bl11 = true;
                    }
                }
                this.cancel.setEnabled(false);
                this.discover.setEnabled(bl11 ^ true);
                this.edit.setEnabled(bl);
                boolean bl12 = false;
                if (bl && !bl11) {
                    bl12 = true;
                }
                this.updateCmd.setEnabled(bl12);
                boolean bl13 = false;
                if (bl && !bl11) {
                    bl13 = true;
                }
                this.assignCmd.setEnabled(bl13);
            }
        }

        private final /* synthetic */ void this() {
            this.updateCmd = null;
            this.assignCmd = null;
        }

        Controller(BDeviceManager bDeviceManager) {
            super(bDeviceManager);
            this.this();
            this.updateCmd = new UpdateFromNetworkCmd((BWidget)bDeviceManager);
            this.updateCmd.setFlags(7);
            this.assignCmd = new AssignBaudRateCmd((BWidget)bDeviceManager);
            this.assignCmd.setFlags(7);
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    class MbusDeviceState
    extends DeviceState {
        private BJob updateCmdJob;
        private BJob assignBaudRateCmdJob;

        protected void restoreForType(BAbstractManager bAbstractManager) {
            super.restoreForType(bAbstractManager);
            ((Model)bAbstractManager.getModel()).setUpdateJob(this.updateCmdJob);
            ((Model)bAbstractManager.getModel()).setAssignBaudRateJob(this.assignBaudRateCmdJob);
        }

        protected void saveForType(BAbstractManager bAbstractManager) {
            super.saveForType(bAbstractManager);
            this.updateCmdJob = ((Model)bAbstractManager.getModel()).updateCmdJob;
        }

        private final /* synthetic */ void this() {
            this.updateCmdJob = null;
            this.assignBaudRateCmdJob = null;
        }

        MbusDeviceState() {
            this.this();
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    class AssignBaudRateCmd
    extends MgrController.MgrCommand {
        public Command doMerge(Command command) {
            return this;
        }

        public CommandArtifact doInvoke() throws Exception {
            BAbstractMbusNetwork bAbstractMbusNetwork = BMbusDeviceManager.this.getNetwork();
            Model model = (Model)BMbusDeviceManager.this.getModel();
            BWbFieldEditor bWbFieldEditor = BWbFieldEditor.makeFor((BObject)BMbusBaudRate.baud300);
            bWbFieldEditor.loadValue((BObject)BMbusBaudRate.baud300);
            if (BDialog.open((BWidget)BMbusDeviceManager.this, (String)MbusToolkit.getText("MbusDeviceManager.chooseBaudRate"), (Object)bWbFieldEditor, (int)3) == 1) {
                BComponent[] bComponentArray = BMbusDeviceManager.this.getController().getSelectedComponents();
                BMbusDevice[] bMbusDeviceArray = new BMbusDevice[bComponentArray.length];
                System.arraycopy(bComponentArray, 0, bMbusDeviceArray, 0, bComponentArray.length);
                BOrd bOrd = bAbstractMbusNetwork.submitAssignBaudRateJob(new BMbusAssignBaudRateData((BMbusBaudRate)bWbFieldEditor.saveValue((BObject)BMbusBaudRate.baud300, null), bMbusDeviceArray));
                if (!bOrd.isNull()) {
                    bAbstractMbusNetwork.getComponentSpace().sync();
                    BJob bJob = (BJob)bOrd.get((BObject)bAbstractMbusNetwork);
                    bJob.lease();
                    model.setAssignBaudRateJob(bJob);
                }
            }
            return null;
        }

        AssignBaudRateCmd(BWidget bWidget) {
            super(bWidget, MbusToolkit.lex, "MbusDeviceManager.assignBaudRate");
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    class UpdateFromNetworkCmd
    extends MgrController.MgrCommand {
        public Command doMerge(Command command) {
            return this;
        }

        public CommandArtifact doInvoke() throws Exception {
            BAbstractMbusNetwork bAbstractMbusNetwork = BMbusDeviceManager.this.getNetwork();
            Model model = (Model)BMbusDeviceManager.this.getModel();
            BComponent[] bComponentArray = BMbusDeviceManager.this.getController().getSelectedComponents();
            String[] stringArray = new String[bComponentArray.length];
            int n = 0;
            while (n < bComponentArray.length) {
                stringArray[n] = ((BMbusDevice)bComponentArray[n]).getHandleOrd().toString();
                ++n;
            }
            BOrd bOrd = bAbstractMbusNetwork.submitPrimaryDiscoverJob(BEncodableList.make(stringArray));
            if (!bOrd.isNull()) {
                bAbstractMbusNetwork.getComponentSpace().sync();
                BJob bJob = (BJob)bOrd.get((BObject)bAbstractMbusNetwork);
                bJob.lease();
                model.setUpdateJob(bJob);
            }
            return null;
        }

        UpdateFromNetworkCmd(BWidget bWidget) {
            super(bWidget, MbusToolkit.lex, "MbusDeviceManager.updateFromNetwork");
        }
    }
}

