/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.mbus.types;

import com.tridium.mbus.BAbstractMbusNetwork;
import com.tridium.mbus.BMbusDevice;
import com.tridium.mbus.BMbusNetwork;
import com.tridium.mbus.comm.MBusTxTimings;
import com.tridium.mbus.enums.BMbusAddressing;
import com.tridium.mbus.enums.BMbusCommandCodes;
import com.tridium.mbus.enums.BMbusCommandTypes;
import com.tridium.mbus.enums.BMbusModeChange;
import com.tridium.mbus.enums.BMbusVifCodes;
import com.tridium.mbus.messages.MbusResponseMessage;
import com.tridium.mbus.messages.MbusSndUdMessage;
import com.tridium.mbus.utils.MbusDataDecoderIEC870;
import com.tridium.mbus.utils.MbusLogInputOutput;
import com.tridium.mbus.utils.MbusTextUtil;
import javax.baja.data.BIDataValue;
import javax.baja.serial.BBaudRate;
import javax.baja.status.BStatus;
import javax.baja.status.BStatusNumeric;
import javax.baja.status.BStatusValue;
import javax.baja.sys.Action;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BInteger;
import javax.baja.sys.BValue;
import javax.baja.sys.Clock;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.IFuture;
import javax.baja.util.Invocation;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public final class BMbusCommand
extends BComponent {
    public static final Property commandType = BMbusCommand.newProperty((int)0, (BValue)BMbusCommandTypes.none, null);
    public static final Property command = BMbusCommand.newProperty((int)0, (String)"", null);
    public static final Property readoutModeNumber = BMbusCommand.newProperty((int)16, (int)0, (BFacets)BFacets.make((String)"fieldWidth", (BIDataValue)BInteger.make((int)2)));
    public static final Property modeChange = BMbusCommand.newProperty((int)0, (BValue)BMbusModeChange.incapable, null);
    public static final Property presetDateAndTime = BMbusCommand.newProperty((int)0, (BValue)BAbsTime.now(), null);
    public static final Action execute = BMbusCommand.newAction((int)24, null);
    public static final Type TYPE;
    static /* synthetic */ Class class$com$tridium$mbus$types$BMbusCommand;

    public final BMbusCommandTypes getCommandType() {
        return (BMbusCommandTypes)this.get(commandType);
    }

    public final void setCommandType(BMbusCommandTypes bMbusCommandTypes) {
        this.set(commandType, (BValue)bMbusCommandTypes, null);
    }

    public final String getCommand() {
        return this.getString(command);
    }

    public final void setCommand(String string) {
        this.setString(command, string, null);
    }

    public final int getReadoutModeNumber() {
        return this.getInt(readoutModeNumber);
    }

    public final void setReadoutModeNumber(int n) {
        this.setInt(readoutModeNumber, n, null);
    }

    public final BMbusModeChange getModeChange() {
        return (BMbusModeChange)this.get(modeChange);
    }

    public final void setModeChange(BMbusModeChange bMbusModeChange) {
        this.set(modeChange, (BValue)bMbusModeChange, null);
    }

    public final BAbsTime getPresetDateAndTime() {
        return (BAbsTime)this.get(presetDateAndTime);
    }

    public final void setPresetDateAndTime(BAbsTime bAbsTime) {
        this.set(presetDateAndTime, (BValue)bAbsTime, null);
    }

    public final void execute() {
        this.invoke(execute, null, null);
    }

    public final Type getType() {
        return TYPE;
    }

    public final IFuture post(Action action, BValue bValue, Context context) {
        if (action == execute) {
            this.getNetwork().getWorker().post((Runnable)new Invocation((BComponent)this, action, bValue, context));
            return null;
        }
        return super.post(action, bValue, context);
    }

    public final boolean isParentLegal(BComponent bComponent) {
        boolean bl = false;
        if (bComponent instanceof BMbusCommand || bComponent instanceof BMbusDevice) {
            bl = true;
        }
        return bl;
    }

    public final void doExecute() {
        BMbusDevice bMbusDevice = (BMbusDevice)this.getParent();
        if (this.getCommandType().equals((Object)BMbusCommandTypes.none)) {
            return;
        }
        if (bMbusDevice.getReadoutModeNumber() == this.getReadoutModeNumber() || this.getModeChange().equals((Object)BMbusModeChange.capable)) {
            this.doOutputCommand();
            bMbusDevice.setReadoutModeNumber(this.getReadoutModeNumber());
        } else if (this.changeMode(this.getReadoutModeNumber())) {
            this.doOutputCommand();
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final void doOutputCommand() {
        BMbusDevice bMbusDevice = (BMbusDevice)this.getParent();
        BAbstractMbusNetwork bAbstractMbusNetwork = (BAbstractMbusNetwork)((BMbusDevice)this.getParent()).getNetwork();
        if (MbusLogInputOutput.log.isTraceOn()) {
            MbusLogInputOutput.log.trace("COMMAND: outputing message");
        }
        String string = "outCmd" + this.getHandle() + Clock.ticks();
        MBusTxTimings mBusTxTimings = bMbusDevice.getTxTimingsReference();
        try {
            try {
                long l;
                MbusSndUdMessage mbusSndUdMessage;
                if (bMbusDevice.getAddressMode() != BMbusAddressing.primary) {
                    mbusSndUdMessage = new MbusSndUdMessage(bMbusDevice, bAbstractMbusNetwork);
                    l = MBusTxTimings.calculateTxRxTime((long)2, (BBaudRate)bMbusDevice.getBaudRate());
                    MbusResponseMessage mbusResponseMessage = (MbusResponseMessage)bAbstractMbusNetwork.sendMBusSync(bMbusDevice.getTxTimingsReference(), string, mbusSndUdMessage, l += MBusTxTimings.calculateTxRxTime(mbusSndUdMessage, (BBaudRate)bMbusDevice.getBaudRate()));
                    if (mbusResponseMessage != null && mbusResponseMessage.getCollisionDetected()) {
                        bAbstractMbusNetwork.unlockSends(string);
                        throw new Exception("Secondary address selection collision");
                    }
                    bMbusDevice.setFcBitState(true);
                }
                mbusSndUdMessage = new MbusSndUdMessage(bMbusDevice, bAbstractMbusNetwork, this.getByteData());
                l = MBusTxTimings.calculateTxRxTime((long)2, (BBaudRate)bMbusDevice.getBaudRate());
                bAbstractMbusNetwork.sendMBusSync(mBusTxTimings, string, mbusSndUdMessage, l += MBusTxTimings.calculateTxRxTime(mbusSndUdMessage, (BBaudRate)bMbusDevice.getBaudRate()));
                bAbstractMbusNetwork.unlockSends(string);
            }
            catch (Throwable throwable) {
                bAbstractMbusNetwork.unlockSends(string);
            }
        }
        catch (Throwable throwable) {
            Object var6_10 = null;
            bAbstractMbusNetwork.unlockSends(string);
            throw throwable;
        }
        {
            Object var6_11 = null;
            bAbstractMbusNetwork.unlockSends(string);
            bMbusDevice.setReadoutModeNumber(this.getReadoutModeNumber());
            return;
        }
    }

    private final byte[] getByteData() {
        int n;
        String string = this.getCommand().trim();
        int n2 = string.length() / 2;
        int n3 = 0;
        String string2 = "";
        BStatusNumeric bStatusNumeric = new BStatusNumeric((double)this.getPresetDateAndTime().getMillis(), BStatus.ok);
        byte[] byArray = null;
        int n4 = 0;
        BMbusCommandCodes bMbusCommandCodes = BMbusCommandCodes.cp_32date;
        if (this.getCommandType().equals((Object)BMbusCommandTypes.commandWithPresetDateAndTime)) {
            if (n2 > 1) {
                char c = string.charAt(1);
                if (c == '2') {
                    n4 = 2;
                } else if (c == '3') {
                    n4 = 3;
                } else if (c == '4') {
                    n4 = 4;
                }
            }
        } else if (this.getCommandType().equals((Object)BMbusCommandTypes.currentDateAndTime)) {
            bMbusCommandCodes = BMbusCommandCodes.cp_32date;
            bStatusNumeric = new BStatusNumeric((double)BAbsTime.now().getMillis(), BStatus.ok);
            if (n2 == 0) {
                n2 = 2;
            }
            n4 = 4;
        } else if (this.getCommandType().equals((Object)BMbusCommandTypes.currentDate)) {
            bMbusCommandCodes = BMbusCommandCodes.cp_16date;
            bStatusNumeric = new BStatusNumeric((double)BAbsTime.now().getMillis(), BStatus.ok);
            if (n2 == 0) {
                n2 = 2;
            }
            n4 = 2;
        }
        n2 += n4;
        Class clazz = class$com$tridium$mbus$types$BMbusCommand;
        if (clazz == null) {
            clazz = class$com$tridium$mbus$types$BMbusCommand = BMbusCommand.class("[Lcom.tridium.mbus.types.BMbusCommand;", false);
        }
        BMbusCommand[] bMbusCommandArray = (BMbusCommand[])this.getChildren(clazz);
        int n5 = 0;
        while (n5 < bMbusCommandArray.length) {
            string2 = bMbusCommandArray[n5].getCommand().trim();
            n2 += string2.length() / 2;
            if (bMbusCommandArray[n5].getCommandType().equals((Object)BMbusCommandTypes.currentDateAndTime)) {
                n2 = n2 == 0 ? (n2 += 6) : (n2 += 4);
            } else if (bMbusCommandArray[n5].getCommandType().equals((Object)BMbusCommandTypes.currentDate)) {
                n2 = n2 == 0 ? (n2 += 4) : (n2 += 2);
            } else if (bMbusCommandArray[n5].getCommandType().equals((Object)BMbusCommandTypes.commandWithPresetDateAndTime) && string2.length() > 1) {
                n = string2.charAt(1);
                if (n == 50) {
                    n2 += 2;
                } else if (n == 51) {
                    n2 += 3;
                } else if (n == 52) {
                    n2 += 4;
                }
            }
            ++n5;
        }
        byArray = new byte[n2];
        n5 = 0;
        while (n5 < string.length() / 2) {
            byArray[n5] = (byte)(MbusTextUtil.hexCharToInt(string.charAt(n5 * 2)) * 16 + MbusTextUtil.hexCharToInt(string.charAt(n5 * 2 + 1)) & 0xFF);
            if (MbusLogInputOutput.log.isTraceOn()) {
                MbusLogInputOutput.log.trace("COMMAND: output hold= " + byArray[n5]);
            }
            ++n5;
        }
        if (byArray.length > 0) {
            if (byArray[0] == 2) {
                bMbusCommandCodes = BMbusCommandCodes.cp_16date;
            } else if (byArray[0] == 3) {
                bMbusCommandCodes = BMbusCommandCodes.timeOfDay;
            }
        }
        n3 = string.length() / 2;
        if (this.getCommandType().equals((Object)BMbusCommandTypes.currentDateAndTime) && string.length() < 2) {
            byArray[0] = (byte)BMbusCommandCodes.mbus_integer32bit.getOrdinal();
            byArray[1] = (byte)BMbusVifCodes.dateAndTime.getOrdinal();
            n3 += 2;
        }
        if (this.getCommandType().equals((Object)BMbusCommandTypes.currentDate) && string.length() < 2) {
            byArray[0] = (byte)BMbusCommandCodes.mbus_integer16bit.getOrdinal();
            byArray[1] = (byte)BMbusVifCodes.date.getOrdinal();
            n3 += 2;
        }
        if (this.getCommandType().equals((Object)BMbusCommandTypes.commandWithPresetDateAndTime) || this.getCommandType().equals((Object)BMbusCommandTypes.currentDate) || this.getCommandType().equals((Object)BMbusCommandTypes.currentDateAndTime)) {
            byte[] byArray2 = MbusDataDecoderIEC870.encode((BStatusValue)bStatusNumeric, bMbusCommandCodes);
            if (MbusLogInputOutput.log.isTraceOn()) {
                MbusLogInputOutput.log.trace("COMMAND: outputBytesLength= " + byArray2.length + " outputHold length = " + byArray.length + " outputHoldIndex = " + n3);
            }
            n = 0;
            while (n < byArray2.length) {
                if (n3 + n < byArray.length) {
                    byArray[n + n3] = byArray2[n];
                }
                ++n;
            }
            n3 += byArray2.length;
        }
        int n6 = 0;
        while (n6 < bMbusCommandArray.length) {
            String string3 = bMbusCommandArray[n6].getCommand().trim();
            int n7 = string3.length() / 2;
            bMbusCommandCodes = BMbusCommandCodes.mbus_integer32bit;
            bStatusNumeric = bMbusCommandArray[n6].getCommandType().equals((Object)BMbusCommandTypes.currentDateAndTime) || bMbusCommandArray[n6].getCommandType().equals((Object)BMbusCommandTypes.currentDate) ? new BStatusNumeric((double)BAbsTime.now().getMillis(), BStatus.ok) : new BStatusNumeric((double)bMbusCommandArray[n6].getPresetDateAndTime().getMillis(), BStatus.ok);
            int n8 = 0;
            while (n8 < n7) {
                byArray[n8 + n3] = (byte)(MbusTextUtil.hexCharToInt(string3.charAt(n8 * 2)) * 16 + MbusTextUtil.hexCharToInt(string3.charAt(n8 * 2 + 1)) & 0xFF);
                ++n8;
            }
            if (n7 > 1) {
                if (byArray[n3] == 2) {
                    bMbusCommandCodes = BMbusCommandCodes.cp_16date;
                } else if (byArray[n3] == 3) {
                    bMbusCommandCodes = BMbusCommandCodes.timeOfDay;
                }
                n3 += n7;
            } else if (bMbusCommandArray[n6].getCommandType().equals((Object)BMbusCommandTypes.currentDateAndTime)) {
                byArray[n3] = (byte)BMbusCommandCodes.mbus_integer32bit.getOrdinal();
                byArray[n3] = (byte)BMbusVifCodes.dateAndTime.getOrdinal();
                n3 += 2;
            } else if (bMbusCommandArray[n6].getCommandType().equals((Object)BMbusCommandTypes.currentDate)) {
                byArray[n3] = (byte)BMbusCommandCodes.mbus_integer16bit.getOrdinal();
                byArray[n3] = (byte)BMbusVifCodes.date.getOrdinal();
                n3 += 2;
            }
            if (bMbusCommandArray[n6].getCommandType().equals((Object)BMbusCommandTypes.currentDateAndTime) || bMbusCommandArray[n6].getCommandType().equals((Object)BMbusCommandTypes.currentDate) || bMbusCommandArray[n6].getCommandType().equals((Object)BMbusCommandTypes.commandWithPresetDateAndTime)) {
                byte[] byArray3 = MbusDataDecoderIEC870.encode((BStatusValue)bStatusNumeric, bMbusCommandCodes);
                int n9 = 0;
                while (n9 < byArray3.length) {
                    byArray[n9 + n3] = byArray3[n9];
                    ++n9;
                }
                n3 += byArray3.length;
            }
            ++n6;
        }
        return byArray;
    }

    public final boolean changeMode(int n) {
        BMbusDevice bMbusDevice = (BMbusDevice)this.getParent();
        boolean bl = true;
        if (bMbusDevice != null && bMbusDevice.getReadoutModeNumber() != n) {
            if (MbusLogInputOutput.log.isTraceOn()) {
                MbusLogInputOutput.log.trace("COMMAND: We are trying to Change Mode, input = " + n);
            }
            bl = false;
            Class clazz = class$com$tridium$mbus$types$BMbusCommand;
            if (clazz == null) {
                clazz = class$com$tridium$mbus$types$BMbusCommand = BMbusCommand.class("[Lcom.tridium.mbus.types.BMbusCommand;", false);
            }
            BMbusCommand[] bMbusCommandArray = (BMbusCommand[])bMbusDevice.getChildren(clazz);
            int n2 = 0;
            while (n2 < bMbusCommandArray.length) {
                if (bMbusCommandArray[n2].getReadoutModeNumber() == n && bMbusCommandArray[n2].getModeChange().equals((Object)BMbusModeChange.capable)) {
                    bMbusCommandArray[n2].doExecute();
                    bl = true;
                    break;
                }
                ++n2;
            }
        }
        return bl;
    }

    private final BMbusNetwork getNetwork() {
        return this.findNetwork((BComponent)this.getParent());
    }

    private final BMbusNetwork findNetwork(BComponent bComponent) {
        if (bComponent == null) {
            return null;
        }
        if (bComponent instanceof BMbusNetwork) {
            return (BMbusNetwork)bComponent;
        }
        return this.findNetwork((BComponent)bComponent.getParent());
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        Class clazz = class$com$tridium$mbus$types$BMbusCommand;
        if (clazz == null) {
            clazz = class$com$tridium$mbus$types$BMbusCommand = BMbusCommand.class("[Lcom.tridium.mbus.types.BMbusCommand;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
    }
}

