/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.mbus.point;

import com.tridium.basicdriver.message.Message;
import com.tridium.basicdriver.point.BBasicProxyExt;
import com.tridium.basicdriver.util.BBasicPollGroup;
import com.tridium.basicdriver.util.BIBasicPollable;
import com.tridium.mbus.BAbstractMbusNetwork;
import com.tridium.mbus.BMbusDevice;
import com.tridium.mbus.comm.MBusTxTimings;
import com.tridium.mbus.enums.BMbusAddressing;
import com.tridium.mbus.enums.BMbusNumberType;
import com.tridium.mbus.messages.MbusMessage;
import com.tridium.mbus.messages.MbusReceivedLongFrame;
import com.tridium.mbus.messages.MbusReqUd2Message;
import com.tridium.mbus.messages.MbusResponseMessage;
import com.tridium.mbus.messages.MbusSndUdMessage;
import com.tridium.mbus.mspec.BManuSpecDefElement;
import com.tridium.mbus.point.BMbusProxyExt;
import com.tridium.mbus.types.BMbusCommand;
import com.tridium.mbus.utils.MbusDataSort;
import com.tridium.mbus.utils.MbusLogInputOutput;
import com.tridium.mbus.utils.MbusSortedDataInformation;
import com.tridium.mbus.utils.MbusToolkit;
import javax.baja.driver.util.BPollFrequency;
import javax.baja.serial.BBaudRate;
import javax.baja.status.BStatus;
import javax.baja.status.BStatusBoolean;
import javax.baja.status.BStatusEnum;
import javax.baja.status.BStatusNumeric;
import javax.baja.status.BStatusString;
import javax.baja.status.BStatusValue;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BObject;
import javax.baja.sys.Clock;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.Lexicon;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BMbusPollGroup
extends BBasicPollGroup
implements BIBasicPollable {
    public static final Type TYPE;
    private static Lexicon lex;
    private static int[] manufacturersData;
    private boolean sucessfulRead;
    static /* synthetic */ Class class$com$tridium$mbus$point$BMbusPollGroup;
    static /* synthetic */ Class class$com$tridium$mbus$point$BMbusProxyExt;
    static /* synthetic */ Class class$com$tridium$mbus$types$BMbusCommand;

    public Type getType() {
        return TYPE;
    }

    public void poll() {
        String string = "pg" + Clock.ticks();
        BBasicProxyExt[] bBasicProxyExtArray = this.getSubscribedProxyExts();
        BAbstractMbusNetwork bAbstractMbusNetwork = (BAbstractMbusNetwork)bBasicProxyExtArray[0].getNetwork();
        try {
            this.commsProtectedPoll(bBasicProxyExtArray, bAbstractMbusNetwork, string);
            bAbstractMbusNetwork.unlockSends(string);
        }
        catch (Throwable throwable) {
            bAbstractMbusNetwork.unlockSends(string);
        }
    }

    public void commsProtectedPoll(BBasicProxyExt[] bBasicProxyExtArray, BAbstractMbusNetwork bAbstractMbusNetwork, Object object) {
        Class clazz;
        Object object2;
        long l;
        BMbusCommand[] bMbusCommandArray;
        boolean bl = false;
        if (bBasicProxyExtArray.length == 0) {
            return;
        }
        BMbusDevice bMbusDevice = (BMbusDevice)bBasicProxyExtArray[0].getDevice();
        MBusTxTimings mBusTxTimings = bMbusDevice.getTxTimingsReference();
        if (bMbusDevice.getResetRequired()) {
            if (MbusLogInputOutput.log.isTraceOn()) {
                MbusLogInputOutput.log.trace("Poll Reset to Meter:- " + bMbusDevice.getPrimaryAddress() + "Sec Add= " + bMbusDevice.getSecondaryAddress());
            }
            if (bMbusDevice.getAddressMode() != BMbusAddressing.primary) {
                bMbusCommandArray = new MbusSndUdMessage(bMbusDevice, bAbstractMbusNetwork);
                bMbusCommandArray.setMessageBaudRate(bMbusDevice.getBaudRate());
                l = MBusTxTimings.calculateTxRxTime((long)2, (BBaudRate)bMbusDevice.getBaudRate());
                object2 = (MbusResponseMessage)bAbstractMbusNetwork.sendMBusSync(mBusTxTimings, object, (Message)bMbusCommandArray, l += MBusTxTimings.calculateTxRxTime((MbusMessage)bMbusCommandArray, (BBaudRate)bMbusDevice.getBaudRate()));
                if (object2 == null || object2 != null && !object2.getSuccessfulResponse() || object2 != null && ((MbusResponseMessage)((Object)object2)).getCollisionDetected()) {
                    if (bMbusDevice.isMounted() && MbusLogInputOutput.log.isLoggable(2)) {
                        MbusLogInputOutput.log.trace(this.getDisplayName(null) + ": Failed to get response to initial secondary address selection " + (object2 != null && ((MbusResponseMessage)((Object)object2)).getCollisionDetected() ? "(COLLISION)" : ""));
                    }
                } else {
                    bMbusDevice.setFcBitState(true);
                }
            }
            bMbusDevice.doSendNkeAndInitDelay(mBusTxTimings, object);
        }
        if (MbusLogInputOutput.log.isTraceOn()) {
            MbusLogInputOutput.log.trace("Handling group poll for device : " + (bMbusDevice.isMounted() ? bMbusDevice.getDisplayName(null) : "unknown"));
        }
        if (bMbusDevice.getAddressMode() != BMbusAddressing.primary) {
            bMbusCommandArray = new MbusSndUdMessage(bMbusDevice, bAbstractMbusNetwork);
            bMbusCommandArray.setMessageBaudRate(bMbusDevice.getBaudRate());
            l = MBusTxTimings.calculateTxRxTime((long)2, (BBaudRate)bMbusDevice.getBaudRate());
            l += MBusTxTimings.calculateTxRxTime((MbusMessage)bMbusCommandArray, (BBaudRate)bMbusDevice.getBaudRate());
            if (MbusLogInputOutput.log.isTraceOn()) {
                MbusLogInputOutput.log.trace("Sending secondary address selector");
            }
            if ((object2 = (MbusResponseMessage)bAbstractMbusNetwork.sendMBusSync(mBusTxTimings, object, (Message)bMbusCommandArray, l)) == null || object2 != null && !object2.getSuccessfulResponse() || object2 != null && ((MbusResponseMessage)((Object)object2)).getCollisionDetected()) {
                if (MbusLogInputOutput.log.isLoggable(2) && bMbusDevice.isMounted()) {
                    if (object2 != null && ((MbusResponseMessage)((Object)object2)).getCollisionDetected()) {
                        MbusLogInputOutput.log.warning(bMbusDevice.getDisplayName(null) + " Bus collision detected - cannot select address for device - maybe secondary extended selection is required");
                    } else {
                        MbusLogInputOutput.log.warning(bMbusDevice.getDisplayName(null) + " Failed to select secondary addressing after reset - the device may require a longer reset time");
                    }
                }
                int n = 0;
                while (n < bBasicProxyExtArray.length) {
                    if (this.sucessfulRead) {
                        bBasicProxyExtArray[n].readReset();
                    } else if (object2 != null && ((MbusResponseMessage)((Object)object2)).getCollisionDetected()) {
                        bBasicProxyExtArray[n].readFail(lex.getText("BMbusGeneral.busSelectionFailure"));
                    } else {
                        bBasicProxyExtArray[n].readFail(lex.getText("BMbusPollGroup.readSecSelectFail"));
                    }
                    ++n;
                }
                if (object2 != null && ((MbusResponseMessage)((Object)object2)).getCollisionDetected()) {
                    return;
                }
            } else {
                bMbusDevice.setFcBitState(true);
            }
        }
        if ((clazz = class$com$tridium$mbus$types$BMbusCommand) == null) {
            clazz = class$com$tridium$mbus$types$BMbusCommand = BMbusPollGroup.class("[Lcom.tridium.mbus.types.BMbusCommand;", false);
        }
        bMbusCommandArray = (BMbusCommand[])bMbusDevice.getChildren(clazz);
        if (bBasicProxyExtArray.length > 0) {
            BMbusProxyExt bMbusProxyExt = (BMbusProxyExt)bBasicProxyExtArray[0];
            if (bMbusProxyExt.getDeviceMode() != bMbusDevice.getReadoutModeNumber()) {
                if (bMbusCommandArray.length > 0 && bMbusCommandArray[0].changeMode(bMbusProxyExt.getDeviceMode())) {
                    bl = true;
                }
            } else {
                bl = true;
            }
        }
        BBasicProxyExt[] bBasicProxyExtArray2 = new BBasicProxyExt[bBasicProxyExtArray.length];
        System.arraycopy(bBasicProxyExtArray, 0, bBasicProxyExtArray2, 0, bBasicProxyExtArray.length);
        int n = 0;
        while (n < bMbusDevice.getCycleQuantity()) {
            byte[] byArray;
            Object object3;
            object2 = new MbusReqUd2Message(bMbusDevice, bAbstractMbusNetwork);
            ((MbusMessage)((Object)object2)).setMessageBaudRate(bMbusDevice.getBaudRate());
            if (MbusLogInputOutput.log.isTraceOn()) {
                MbusLogInputOutput.log.trace("Poll to Meter:- " + bMbusDevice.getPrimaryAddress() + " ,Sec Add= " + bMbusDevice.getSecondaryAddress() + "  Cycle= " + n);
            }
            MbusResponseMessage mbusResponseMessage = null;
            long l2 = MBusTxTimings.calculateTxRxTime(261L, (BBaudRate)bMbusDevice.getBaudRate());
            l2 += MBusTxTimings.calculateTxRxTime((MbusMessage)((Object)object2), (BBaudRate)bMbusDevice.getBaudRate());
            if (MbusLogInputOutput.log.isTraceOn() && bMbusDevice.isMounted()) {
                MbusLogInputOutput.log.trace(bMbusDevice.getDisplayName(null) + " Sending data request");
            }
            if ((mbusResponseMessage = (MbusResponseMessage)bAbstractMbusNetwork.sendMBusSync(mBusTxTimings, object, (Message)object2, l2)) == null) {
                String string = lex.getText("BMbusPollGroup.readNull");
                int n2 = 0;
                while (n2 < bBasicProxyExtArray.length) {
                    bBasicProxyExtArray[n2].readFail(string);
                    ++n2;
                }
                if (bMbusDevice.getInhibitPing()) {
                    bMbusDevice.pingFail("timeout");
                }
                return;
            }
            if (!mbusResponseMessage.getSuccessfulResponse()) {
                int n3 = 0;
                while (n3 < bBasicProxyExtArray.length) {
                    object3 = lex.getText("BMbusPollGroup.pollError");
                    bBasicProxyExtArray[n3].readFail((String)object3);
                    ++n3;
                }
                if (MbusToolkit.isTraceOn()) {
                    MbusToolkit.trace("POLL_GRP: read fail");
                }
                return;
            }
            if (MbusLogInputOutput.log.isTraceOn()) {
                MbusLogInputOutput.log.trace("BMBUSPOLLGROUP: We have valid message");
            }
            if ((byArray = mbusResponseMessage.getBytes()).length > 8) {
                int n4;
                int n5;
                object3 = null;
                object3 = new MbusReceivedLongFrame(mbusResponseMessage, bAbstractMbusNetwork, bMbusDevice, bMbusDevice.getAllowMultipleRecords(), bMbusDevice.getMaxSpecialFunctionReads());
                boolean bl2 = false;
                if (bMbusDevice.getAddressMode().equals((Object)BMbusAddressing.primary)) {
                    if (bMbusDevice.getPrimaryAddress() != ((MbusReceivedLongFrame)((Object)object3)).getPrimaryAddress()) {
                        bl2 = true;
                    }
                } else if (bMbusDevice.getAddressMode().equals((Object)BMbusAddressing.secondary)) {
                    if (!bMbusDevice.getSecondaryAddress().equals(((MbusReceivedLongFrame)((Object)object3)).getSecondaryAddress())) {
                        bl2 = true;
                    }
                } else if (bMbusDevice.getAddressMode().equals((Object)BMbusAddressing.secondaryExtended) && !bMbusDevice.getSecondaryAddress().equals(((MbusReceivedLongFrame)((Object)object3)).getSecondaryAddress())) {
                    bl2 = true;
                }
                bMbusDevice.setMbusMeterStatusDescription(((MbusReceivedLongFrame)((Object)object3)).getStatus());
                bMbusDevice.setManufacturerStatusBit5(((MbusReceivedLongFrame)((Object)object3)).getStatusBit5());
                bMbusDevice.setManufacturerStatusBit6(((MbusReceivedLongFrame)((Object)object3)).getStatusBit6());
                bMbusDevice.setManufacturerStatusBit7(((MbusReceivedLongFrame)((Object)object3)).getStatusBit7());
                if (bl2) {
                    n5 = 0;
                    while (n5 < bBasicProxyExtArray.length) {
                        String string = lex.getText("BMbusPollGroup.AddressError");
                        bBasicProxyExtArray[n5].readFail(string);
                        ++n5;
                    }
                    if (MbusToolkit.isTraceOn()) {
                        MbusToolkit.trace("Response Message: Wrong Meter!");
                    }
                    return;
                }
                if (!bAbstractMbusNetwork.savesActive()) {
                    bAbstractMbusNetwork.getNetworkDatabase().addDeviceData(null, (MbusReceivedLongFrame)((Object)object3), n, bMbusDevice.getBaudRate(), bMbusDevice, bMbusDevice.getAddressMode(), null);
                } else if (MbusToolkit.isTraceOn()) {
                    MbusToolkit.trace("Not updating database this time, as station save is in progress");
                }
                if (!((MbusReceivedLongFrame)((Object)object3)).getFabricationNumber().equals("")) {
                    bMbusDevice.setFabricationNumber(((MbusReceivedLongFrame)((Object)object3)).getFabricationNumber());
                }
                if (((MbusReceivedLongFrame)((Object)object3)).getManufacturerIndex() != -1) {
                    try {
                        n5 = ((MbusReceivedLongFrame)((Object)object3)).getManufacturerIndex();
                        n4 = byArray.length - n5 - 2;
                        if (n4 > 0) {
                            manufacturersData = new int[n4];
                            int n6 = 0;
                            while (n6 < n4) {
                                BMbusPollGroup.manufacturersData[n6] = byArray[n5 + n6];
                                ++n6;
                            }
                        }
                    }
                    catch (Throwable throwable) {
                        if (MbusToolkit.isTraceOn()) {
                            MbusToolkit.trace("Unexpected condition hit: when extracting manufacturers data");
                            MbusToolkit.trace("manufacturerIndex : " + ((MbusReceivedLongFrame)((Object)object3)).getManufacturerIndex());
                            MbusToolkit.trace("lengthOfManufSpecData : " + byArray.length + " - " + ((MbusReceivedLongFrame)((Object)object3)).getManufacturerIndex() + " - 2");
                            MbusToolkit.trace("lengthOfManufSpecData = " + (byArray.length - ((MbusReceivedLongFrame)((Object)object3)).getManufacturerIndex() - 2));
                            MbusToolkit.trace("longFrameMessage : " + ((MbusResponseMessage)((Object)object3)).toDebugString());
                        }
                        return;
                    }
                }
                n5 = 0;
                while (n5 < bBasicProxyExtArray2.length) {
                    if (bBasicProxyExtArray2[n5] != null) {
                        BAbsTime bAbsTime;
                        n4 = 0;
                        BMbusProxyExt bMbusProxyExt = (BMbusProxyExt)bBasicProxyExtArray[n5];
                        BStatusValue bStatusValue = bMbusProxyExt.getReadValue();
                        if (bMbusProxyExt.getDeviceMode() != bMbusDevice.getReadoutModeNumber()) {
                            bl = false;
                        }
                        BStatusValue bStatusValue2 = null;
                        if (bMbusProxyExt.getManuSpecDefElementOrd().isNull()) {
                            bAbsTime = MbusDataSort.sort((MbusReceivedLongFrame)((Object)object3), bMbusProxyExt.getMbusUnit(), bMbusProxyExt.getDescription(), bMbusProxyExt.getOrthogonalDescription(), bMbusProxyExt.getMessageSlotNumber(), bMbusProxyExt.getRecordNumber(), bMbusProxyExt.getStorageNumber(), bMbusProxyExt.getFunction(), bMbusProxyExt.getExponent(), true);
                            if (bAbsTime != null && ((MbusSortedDataInformation[])bAbsTime).length > 0) {
                                bStatusValue2 = bAbsTime[((MbusSortedDataInformation[])bAbsTime).length - 1].value;
                            }
                        } else {
                            bStatusValue2 = ((BManuSpecDefElement)bMbusProxyExt.getManuSpecDefElementOrd().get((BObject)bAbstractMbusNetwork)).getValue(manufacturersData);
                        }
                        if (bStatusValue2 != null && bl) {
                            BStatusString bStatusString;
                            if (bStatusValue2 instanceof BStatusString) {
                                bMbusProxyExt.readOk(bStatusValue2);
                                n4 = 1;
                            } else if (bStatusValue instanceof BStatusString) {
                                if (bStatusValue2 instanceof BStatusNumeric) {
                                    if (bMbusProxyExt.getNumberType().equals((Object)BMbusNumberType.dateIp)) {
                                        bAbsTime = BAbsTime.make((long)((long)((BStatusNumeric)bStatusValue2).getValue()));
                                        bStatusString = new BStatusString(bAbsTime.encodeToString(), BStatus.ok);
                                        bMbusProxyExt.readOk((BStatusValue)bStatusString);
                                        n4 = 1;
                                    } else {
                                        bMbusProxyExt.readFail("Input was Numeric and expected a String");
                                        n4 = 1;
                                    }
                                } else {
                                    bMbusProxyExt.readFail("Input was Numeric and expected a String");
                                    n4 = 1;
                                }
                            } else if (bStatusValue instanceof BStatusNumeric && bStatusValue2 instanceof BStatusNumeric || bStatusValue instanceof BStatusEnum && bStatusValue2 instanceof BStatusEnum || bStatusValue instanceof BStatusBoolean && bStatusValue2 instanceof BStatusBoolean) {
                                if (bStatusValue2 instanceof BStatusNumeric) {
                                    if (bMbusProxyExt.getNumberType().equals((Object)BMbusNumberType.dateIp)) {
                                        bAbsTime = BAbsTime.make((long)((long)((BStatusNumeric)bStatusValue2).getValue()));
                                        bStatusString = new BStatusString(bAbsTime.encodeToString(), BStatus.ok);
                                        bMbusProxyExt.readOk((BStatusValue)bStatusString);
                                        n4 = 1;
                                    } else {
                                        bMbusProxyExt.readOk(bStatusValue2);
                                        n4 = 1;
                                    }
                                } else {
                                    bMbusProxyExt.readOk(bStatusValue2);
                                    n4 = 1;
                                }
                            } else {
                                bMbusProxyExt.readFail("Input was incorrect type");
                            }
                        }
                        if (n4 != 0) {
                            bBasicProxyExtArray2[n5] = null;
                        }
                    }
                    ++n5;
                }
            }
            ++n;
        }
        n = 0;
        while (n < bBasicProxyExtArray2.length) {
            if (bBasicProxyExtArray2[n] != null) {
                object2 = bBasicProxyExtArray2[n].getReadValue();
                object2.setStatus(16);
                bBasicProxyExtArray2[n].readOk((BStatusValue)object2);
            }
            ++n;
        }
    }

    public BPollFrequency getPollFrequency() {
        BBasicProxyExt[] bBasicProxyExtArray = this.getSubscribedProxyExts();
        if (bBasicProxyExtArray.length == 0) {
            return BPollFrequency.normal;
        }
        int n = 0;
        while (n < bBasicProxyExtArray.length) {
            if (bBasicProxyExtArray[n].isRunning()) {
                return ((BMbusDevice)bBasicProxyExtArray[0].getDevice()).getPollFrequency();
            }
            ++n;
        }
        return BPollFrequency.normal;
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final /* synthetic */ void this() {
        this.sucessfulRead = false;
    }

    public BMbusPollGroup() {
        this.this();
    }

    static {
        Class clazz = class$com$tridium$mbus$point$BMbusPollGroup;
        if (clazz == null) {
            clazz = class$com$tridium$mbus$point$BMbusPollGroup = BMbusPollGroup.class("[Lcom.tridium.mbus.point.BMbusPollGroup;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
        Class clazz2 = class$com$tridium$mbus$point$BMbusProxyExt;
        if (clazz2 == null) {
            clazz2 = class$com$tridium$mbus$point$BMbusProxyExt = BMbusPollGroup.class("[Lcom.tridium.mbus.point.BMbusProxyExt;", false);
        }
        lex = Lexicon.make((Class)clazz2);
        manufacturersData = null;
    }
}

