/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.mbus.messages;

import com.tridium.mbus.BAbstractMbusNetwork;
import com.tridium.mbus.BMbusDevice;
import com.tridium.mbus.enums.BMbusAddressing;
import com.tridium.mbus.messages.MbusMessage;
import com.tridium.mbus.utils.MbusTextUtil;

public final class MbusSndUdMessage
extends MbusMessage {
    public MbusSndUdMessage(BMbusDevice bMbusDevice, BAbstractMbusNetwork bAbstractMbusNetwork) {
        this.setCFieldNoFcb(67);
        this.setFcBitInUse(false);
        this.setFcBitState(false);
        if (bMbusDevice != null) {
            if (!bMbusDevice.getAddressMode().equals((Object)BMbusAddressing.primary)) {
                this.setStartCode(104);
                this.setFrame(2);
                this.setAField(253);
                this.setCiField(82);
                String string = bMbusDevice.getSecondaryAddress().trim();
                if (bMbusDevice.getAddressMode().equals((Object)BMbusAddressing.secondaryExtended)) {
                    string = string + "0C7800000000";
                }
                byte[] byArray = new byte[string.length() / 2];
                int n = 0;
                while (n < byArray.length) {
                    if (n > 3) {
                        byArray[n] = (byte)(MbusTextUtil.hexCharToInt(string.charAt(n * 2)) << 4 | MbusTextUtil.hexCharToInt(string.charAt(n * 2 + 1)));
                    } else {
                        byArray[3 - n] = (byte)(MbusTextUtil.hexCharToInt(string.charAt(n * 2)) << 4 | MbusTextUtil.hexCharToInt(string.charAt(n * 2 + 1)));
                    }
                    ++n;
                }
                if (bMbusDevice.getAddressMode().equals((Object)BMbusAddressing.secondaryExtended)) {
                    String string2 = bMbusDevice.getFabricationNumber();
                    int n2 = 0;
                    while (n2 < 4) {
                        byArray[byArray.length - n2 - 1] = (byte)(MbusTextUtil.hexCharToInt(string2.charAt(n2 * 2)) << 4 | MbusTextUtil.hexCharToInt(string2.charAt(n2 * 2 + 1)));
                        ++n2;
                    }
                }
                this.setBytes(byArray);
                if (bMbusDevice.getFcBitInUse()) {
                    this.setFcBitInUse(true);
                    this.setFcBitState(bMbusDevice.getFcBitState());
                    bAbstractMbusNetwork.setSearchFcBitState(bMbusDevice.getFcBitState() ^ true);
                }
            }
        } else if (bAbstractMbusNetwork != null) {
            this.setAField(bAbstractMbusNetwork.getPrimarySearchAddress());
            if (bAbstractMbusNetwork.getSearchFcBitInUse()) {
                this.setFcBitInUse(true);
                this.setFcBitState(bAbstractMbusNetwork.getSearchFcBitState());
                bAbstractMbusNetwork.setSearchFcBitState(bAbstractMbusNetwork.getSearchFcBitState() ^ true);
            }
        }
    }

    public MbusSndUdMessage(BMbusDevice bMbusDevice, BAbstractMbusNetwork bAbstractMbusNetwork, byte[] byArray) {
        this.setCFieldNoFcb(67);
        this.setFcBitInUse(false);
        this.setFcBitState(false);
        if (bMbusDevice != null) {
            if (bMbusDevice.getFcBitInUse()) {
                this.setFcBitInUse(true);
                this.setFcBitState(bMbusDevice.getFcBitState());
                bMbusDevice.setFcBitState(bMbusDevice.getFcBitState() ^ true);
            }
            if (bMbusDevice.getAddressMode().equals((Object)BMbusAddressing.primary)) {
                this.setAField(bMbusDevice.getPrimaryAddress());
            } else {
                this.setAField(253);
            }
            if (byArray != null) {
                this.setBytes(byArray);
                this.setFrame(2);
            }
        } else if (bAbstractMbusNetwork != null) {
            this.setAField(bAbstractMbusNetwork.getPrimarySearchAddress());
            if (bAbstractMbusNetwork.getSearchFcBitInUse()) {
                this.setFcBitInUse(true);
                this.setFcBitState(bAbstractMbusNetwork.getSearchFcBitState());
                bAbstractMbusNetwork.setSearchFcBitState(bAbstractMbusNetwork.getSearchFcBitState() ^ true);
            }
        }
    }

    public MbusSndUdMessage(byte[] byArray) {
        this.setCFieldNoFcb(83);
        this.setStartCode(104);
        this.setFrame(2);
        this.setAField(253);
        this.setCiField(82);
        this.setBytes(byArray);
    }
}

