/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.mbus.learn;

import com.tridium.mbus.BAbstractMbusNetwork;
import com.tridium.mbus.BMbusDevice;
import com.tridium.mbus.db.BMbusPointData;
import com.tridium.mbus.learn.BMbusPointEntry;
import com.tridium.mbus.utils.MbusToolkit;
import javax.baja.job.BJob;
import javax.baja.job.BSimpleJob;
import javax.baja.job.JobLogItem;
import javax.baja.naming.BOrd;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public final class BMbusPointDiscoveryJob
extends BSimpleJob {
    public static final Property networkOrd = BMbusPointDiscoveryJob.newProperty((int)0, (BValue)BOrd.NULL, null);
    public static final Property deviceOrd = BMbusPointDiscoveryJob.newProperty((int)0, (BValue)BOrd.NULL, null);
    public static final Property previousJobOrd = BMbusPointDiscoveryJob.newProperty((int)0, (BValue)BOrd.NULL, null);
    public static final Type TYPE;
    static /* synthetic */ Class class$com$tridium$mbus$learn$BMbusPointDiscoveryJob;

    public final BOrd getNetworkOrd() {
        return (BOrd)this.get(networkOrd);
    }

    public final void setNetworkOrd(BOrd bOrd) {
        this.set(networkOrd, (BValue)bOrd, null);
    }

    public final BOrd getDeviceOrd() {
        return (BOrd)this.get(deviceOrd);
    }

    public final void setDeviceOrd(BOrd bOrd) {
        this.set(deviceOrd, (BValue)bOrd, null);
    }

    public final BOrd getPreviousJobOrd() {
        return (BOrd)this.get(previousJobOrd);
    }

    public final void setPreviousJobOrd(BOrd bOrd) {
        this.set(previousJobOrd, (BValue)bOrd, null);
    }

    public final Type getType() {
        return TYPE;
    }

    public final void run(Context context) throws Exception {
        JobLogItem[] jobLogItemArray;
        BMbusDevice bMbusDevice;
        Object object;
        if (this.getPreviousJobOrd() != BOrd.NULL) {
            try {
                object = this.getPreviousJobOrd().get((BObject)this);
                if (object != null && object instanceof BJob) {
                    bMbusDevice = ((BJob)object).log();
                    jobLogItemArray = bMbusDevice.getItems();
                    this.log().message(MbusToolkit.lex.getText("MbusNetworkPointDiscovery.dataSourceOutputStart", new Object[]{String.valueOf(((BJob)object).getDisplayName(null))}));
                    int n = 0;
                    while (n < jobLogItemArray.length) {
                        String string;
                        if (jobLogItemArray[n] != null && (string = jobLogItemArray[n].getMessage()).trim().length() > 0) {
                            this.log().message("--> " + string);
                        }
                        ++n;
                    }
                    this.log().message(MbusToolkit.getText("MbusNetworkPointDiscovery.dataSourceOutputEnd"));
                }
            }
            catch (Throwable throwable) {}
        }
        object = (BAbstractMbusNetwork)this.getNetworkOrd().get((BObject)this);
        bMbusDevice = (BMbusDevice)this.getDeviceOrd().get((BObject)this);
        jobLogItemArray = ((BAbstractMbusNetwork)((Object)object)).getNetworkDatabase().getSpecificDeviceInformation(bMbusDevice);
        if (jobLogItemArray != null) {
            this.log().message(MbusToolkit.getText("MbusNetworkPointDsicovery.transferStart"));
            BMbusPointData[] bMbusPointDataArray = jobLogItemArray.getDynamicPointData();
            int n = bMbusPointDataArray.length;
            int n2 = 0;
            while (n2 < n) {
                BMbusPointEntry bMbusPointEntry = new BMbusPointEntry();
                bMbusPointEntry.setMbusUnit(bMbusPointDataArray[n2].getUnit());
                bMbusPointEntry.setDescription(bMbusPointDataArray[n2].getDescription());
                bMbusPointEntry.setOrthogonalDescription(bMbusPointDataArray[n2].getOrthogonalDescription());
                bMbusPointEntry.setNumberType(bMbusPointDataArray[n2].getNumberType());
                bMbusPointEntry.setMessageSlotNumber(bMbusPointDataArray[n2].getMessageSlotNumber());
                bMbusPointEntry.setRecordNumber(bMbusPointDataArray[n2].getRecordNumber());
                bMbusPointEntry.setCycleNumber(bMbusPointDataArray[n2].getCycleNumber());
                bMbusPointEntry.setStorageNumber(bMbusPointDataArray[n2].getStorageNumber());
                bMbusPointEntry.setExponent(bMbusPointDataArray[n2].getExponent());
                bMbusPointEntry.setFunction(bMbusPointDataArray[n2].getFunction());
                bMbusPointEntry.setDeviceMode(bMbusPointDataArray[n2].getDeviceMode());
                if (bMbusPointEntry.getCycleNumber() < bMbusDevice.getCycleQuantity()) {
                    this.add(null, (BValue)bMbusPointEntry);
                }
                ++n2;
            }
            this.log().message(MbusToolkit.getText("MbusNetworkPointDsicovery.transferEnd"));
        }
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public BMbusPointDiscoveryJob() {
    }

    public BMbusPointDiscoveryJob(BOrd bOrd, BOrd bOrd2, BOrd bOrd3) {
        this.setNetworkOrd(bOrd);
        this.setDeviceOrd(bOrd2);
        this.setPreviousJobOrd(bOrd3);
    }

    static {
        Class clazz = class$com$tridium$mbus$learn$BMbusPointDiscoveryJob;
        if (clazz == null) {
            clazz = class$com$tridium$mbus$learn$BMbusPointDiscoveryJob = BMbusPointDiscoveryJob.class("[Lcom.tridium.mbus.learn.BMbusPointDiscoveryJob;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
    }
}

