/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.mbus.jobs;

import com.tridium.mbus.BAbstractMbusNetwork;
import com.tridium.mbus.BMbusDevice;
import com.tridium.mbus.comm.MBusTxTimings;
import com.tridium.mbus.jobs.BMbusDeviceSearchJob;
import com.tridium.mbus.jobs.BMbusPrimaryDeviceSearchJob;
import com.tridium.mbus.utils.MbusToolkit;
import javax.baja.driver.BDevice;
import javax.baja.job.BJob;
import javax.baja.job.BJobState;
import javax.baja.job.JobCancelException;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BMbusUpdateDevicesJob
extends BMbusPrimaryDeviceSearchJob {
    public static final Type TYPE;
    protected BMbusDevice[] devicesToUpdate;
    static /* synthetic */ Class class$com$tridium$mbus$jobs$BMbusUpdateDevicesJob;

    public Type getType() {
        return TYPE;
    }

    public void setDevicesToUpdate(BMbusDevice[] bMbusDeviceArray) {
        if (Sys.getStation() == null) {
            throw new RuntimeException("Error: BMbusUpdateDevicesJob.setDevicesToUpdate called in non station based enviroment!");
        }
        this.devicesToUpdate = bMbusDeviceArray;
    }

    public void run(Context context) throws Exception {
        this.log().message(MbusToolkit.getText("BMbusUpdateDevicesJob.starting"));
        BDevice[] bDeviceArray = this.networkRef.getDevices();
        if (this.devicesToUpdate == null || this.devicesToUpdate.length == 0) {
            throw new Exception("No devices selected to be updated by primary address");
        }
        String string = new String("UpdateDevicesJob" + this.getHandle());
        this.networkRef.lockSends(string);
        this.networkRef.getNetworkDatabase().setActiveDiscovery((BJob)this);
        this.progressPerScan = 100.0 / (double)this.devicesToUpdate.length;
        int n = 0;
        while (n < this.devicesToUpdate.length) {
            if (!this.getJobState().equals((Object)BJobState.running)) break;
            this.networkRef.setSearchBaudRate(this.devicesToUpdate[n].getBaudRate());
            MBusTxTimings mBusTxTimings = this.devicesToUpdate[n].getTxTimingsReference();
            int n2 = this.devicesToUpdate[n].getPrimaryAddress();
            if (n2 < 0 || n2 > 250) {
                this.log().failed(MbusToolkit.lex.getText("BMbusUpdateDevicesJob.nonAllowedPrimaryAddress", new Object[]{String.valueOf(n2), String.valueOf(0), String.valueOf(250)}));
            } else {
                int n3 = 0;
                int n4 = 0;
                while (n4 < bDeviceArray.length) {
                    if (((BMbusDevice)bDeviceArray[n4]).getPrimaryAddress() == n2) {
                        ++n3;
                    }
                    ++n4;
                }
                if (n3 > 1) {
                    this.log().failed(MbusToolkit.lex.getText("BMbusNetworkSecondarySearchJob.multiplePrimaryWarning", new Object[]{String.valueOf(n2)}));
                }
                this.activeChildJob = new BMbusDeviceSearchJob(this.networkRef, new int[]{this.devicesToUpdate[n].getPrimaryAddress()}, this.log());
                ((BMbusDeviceSearchJob)this.activeChildJob).setOverrideTxTimings(mBusTxTimings);
                ((BMbusDeviceSearchJob)this.activeChildJob).overrideCommLock(string);
                this.log().message(MbusToolkit.lex.getText("BMbusUpdateDevicesJob.runningUpdateOfDevice", new Object[]{this.devicesToUpdate[n].getDisplayName(null)}));
                this.activeChildJob.submit(context);
                BJobState bJobState = this.waitForFinalState((BJob)this.activeChildJob);
                while (bJobState == BJobState.running) {
                    bJobState = this.waitForFinalState((BJob)this.activeChildJob);
                }
                switch (bJobState.getOrdinal()) {
                    case 4: {
                        this.log().message(MbusToolkit.getText("BMbusUpdateDevicesJob.completed"));
                        break;
                    }
                    case 5: {
                        this.log().message(MbusToolkit.getText("BMbusUpdateDevicesJob.failed"));
                        break;
                    }
                    case 3: {
                        this.log().message(MbusToolkit.getText("BMbusUpdateDevicesJob.cancelled"));
                        break;
                    }
                }
                this.baseProgress = this.progressPerScan * (double)(n + 1);
                this.progress((int)this.baseProgress);
            }
            ++n;
        }
        this.networkRef.getNetworkDatabase().cancelActiveDiscovery((BJob)this);
        this.networkRef.unlockSends(string);
        this.currentScanBaudRate = null;
        this.networkRef = null;
        this.addressesToScan = null;
        this.currentScanBaudRate = null;
        this.activeChildJob = null;
        if (this.getJobState().equals((Object)BJobState.canceling)) {
            throw new JobCancelException();
        }
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final /* synthetic */ void this() {
        this.devicesToUpdate = null;
    }

    public BMbusUpdateDevicesJob() {
        this.this();
    }

    public BMbusUpdateDevicesJob(BAbstractMbusNetwork bAbstractMbusNetwork) {
        this.this();
        this.networkRef = bAbstractMbusNetwork;
    }

    static {
        Class clazz = class$com$tridium$mbus$jobs$BMbusUpdateDevicesJob;
        if (clazz == null) {
            clazz = class$com$tridium$mbus$jobs$BMbusUpdateDevicesJob = BMbusUpdateDevicesJob.class("[Lcom.tridium.mbus.jobs.BMbusUpdateDevicesJob;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
    }
}

