/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.mbus.jobs;

import com.tridium.mbus.BAbstractMbusNetwork;
import com.tridium.mbus.BMbusConfig;
import com.tridium.mbus.comm.MBusTxTimings;
import com.tridium.mbus.db.BMbusDeviceData;
import com.tridium.mbus.db.BMbusNetworkDatabase;
import com.tridium.mbus.enums.BMbusAddressing;
import com.tridium.mbus.learn.BMbusDeviceEntry;
import com.tridium.mbus.messages.MbusReceivedLongFrame;
import com.tridium.mbus.messages.MbusReqUd2Message;
import com.tridium.mbus.messages.MbusResponseMessage;
import com.tridium.mbus.messages.MbusSndNkeMessage;
import com.tridium.mbus.messages.MbusSndUdMessage;
import com.tridium.mbus.types.BMbusSecondaryAddressFilters;
import com.tridium.mbus.utils.MbusLogInputOutput;
import com.tridium.mbus.utils.MbusToolkit;
import java.util.HashSet;
import javax.baja.job.BJobState;
import javax.baja.job.BSimpleJob;
import javax.baja.job.JobLog;
import javax.baja.job.JobLogItem;
import javax.baja.naming.BOrd;
import javax.baja.serial.BBaudRate;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BValue;
import javax.baja.sys.Clock;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BMbusSecondarySearchJob
extends BSimpleJob {
    public static final Property networkOrd = BMbusSecondarySearchJob.newProperty((int)0, (BValue)BOrd.NULL, null);
    public static final Property optimisticScan = BMbusSecondarySearchJob.newProperty((int)0, (boolean)true, null);
    public static final Type TYPE;
    static final byte WILDCARD_ADDRESS_MARK = 15;
    protected BAbstractMbusNetwork network;
    protected BMbusNetworkDatabase networkManager;
    protected BMbusSecondaryAddressFilters filters;
    protected boolean cancelInProgress;
    protected JobLog log;
    protected MBusTxTimings overrideTxTimings;
    protected HashSet detectedDevices;
    protected Object commLock;
    static /* synthetic */ Class class$com$tridium$mbus$jobs$BMbusSecondarySearchJob;

    public BOrd getNetworkOrd() {
        return (BOrd)this.get(networkOrd);
    }

    public void setNetworkOrd(BOrd bOrd) {
        this.set(networkOrd, (BValue)bOrd, null);
    }

    public boolean getOptimisticScan() {
        return this.getBoolean(optimisticScan);
    }

    public void setOptimisticScan(boolean bl) {
        this.setBoolean(optimisticScan, bl, null);
    }

    public Type getType() {
        return TYPE;
    }

    protected String getCommLockPrefix() {
        return "secSearch";
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run(Context context) throws Exception {
        boolean bl = false;
        if (this.commLock == null) {
            bl = true;
        }
        boolean bl2 = bl;
        if (this.networkManager == null) return;
        if (bl2) {
            this.commLock = this.getCommLockPrefix() + this.getHandle();
        }
        boolean bl3 = false;
        if (this.filters != null && (this.filters.getManufacturer().trim().length() != 0 || this.filters.getDeviceTypeId().getOrdinal() != new BMbusSecondaryAddressFilters().getDeviceTypeId().getOrdinal() || this.filters.getVersionNumber() != new BMbusSecondaryAddressFilters().getVersionNumber())) {
            bl3 = true;
        }
        boolean bl4 = bl3;
        try {
            try {
                this.doSecondarySearch(this.commLock, bl4 ? this.filters : null);
                if (bl2) {
                    this.network.unlockSends(this.commLock);
                }
                this.network = null;
                this.networkManager = null;
                this.filters = null;
                this.overrideTxTimings = null;
                this.commLock = null;
            }
            catch (Throwable throwable) {
                if (bl2) {
                    this.network.unlockSends(this.commLock);
                }
                throwable.printStackTrace();
                this.network = null;
                this.networkManager = null;
                this.filters = null;
                this.overrideTxTimings = null;
                this.commLock = null;
            }
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            if (bl2) {
                this.network.unlockSends(this.commLock);
            }
            this.network = null;
            this.networkManager = null;
            this.filters = null;
            this.overrideTxTimings = null;
            this.commLock = null;
            throw throwable;
        }
        {
            Object var5_7 = null;
            if (bl2) {
                this.network.unlockSends(this.commLock);
            }
            this.network = null;
            this.networkManager = null;
            this.filters = null;
            this.overrideTxTimings = null;
            this.commLock = null;
            return;
        }
    }

    protected void doSecondarySearch(Object object, BMbusSecondaryAddressFilters bMbusSecondaryAddressFilters) {
        Object object2;
        Object object3;
        Object object4;
        this.networkManager.setStatusMessage(MbusToolkit.getText("BMbusNetworkSecondarySearchJob.identSearchStarted"));
        MBusTxTimings mBusTxTimings = new MBusTxTimings();
        if (this.overrideTxTimings != null) {
            mBusTxTimings = this.overrideTxTimings;
        } else {
            mBusTxTimings.intermessageDelay = 1000L;
            mBusTxTimings.retryTransmission = 2;
            mBusTxTimings.responseTimeout = BRelTime.makeSeconds((int)1);
            mBusTxTimings.initalisationDelay = BRelTime.makeSeconds((int)2);
        }
        BMbusConfig bMbusConfig = new BMbusConfig();
        bMbusConfig.setInitialisationDelay(BRelTime.make((long)Math.max(mBusTxTimings.initalisationDelay.getMillis(), 2000L)));
        bMbusConfig.setRetryCount(Math.max(mBusTxTimings.retryTransmission, 2));
        bMbusConfig.setResponseTimeout(BRelTime.make((long)Math.max(mBusTxTimings.responseTimeout.getMillis(), 2000L)));
        bMbusConfig.setInterMessageDelay(BRelTime.make((long)Math.max(300L, mBusTxTimings.intermessageDelay)));
        int n = 0;
        int n2 = -1;
        int n3 = -1;
        byte[] byArray = new byte[]{-1, -1};
        if (bMbusSecondaryAddressFilters != null) {
            object4 = bMbusSecondaryAddressFilters.getManufacturer();
            if (((String)object4).length() == 3) {
                n = (((String)object4).charAt(0) - 64) * 32 * 32 + (((String)object4).charAt(1) - 64) * 32 + (((String)object4).charAt(2) - 64);
                byArray[0] = (byte)(n & 0xFF);
                byArray[1] = (byte)(n >> 8 & 0xFF);
            }
            n3 = (byte)bMbusSecondaryAddressFilters.getDeviceTypeId().getOrdinal();
            if (bMbusSecondaryAddressFilters.getVersionNumber() != 0) {
                n2 = (byte)bMbusSecondaryAddressFilters.getVersionNumber();
            }
        }
        object4 = new byte[]{-1, -1, -1, -1, -1, -1, -1, -1};
        object4[4] = byArray[0];
        object4[5] = byArray[1];
        object4[6] = n2;
        object4[7] = n3;
        long l = (byArray[0] & 0xFF) << 24 | (byArray[1] & 0xFF) << 16 | (n2 & 0xFF) << 8 | n3 & 0xFF;
        l &= 0xFFFFFFFFL;
        MbusSndNkeMessage mbusSndNkeMessage = new MbusSndNkeMessage(null, this.network, 255);
        mbusSndNkeMessage.handleCorruptBuffers();
        mbusSndNkeMessage.setResponseExpected(false);
        mbusSndNkeMessage.setMessageBaudRate(this.network.getSearchBaudRate());
        if (MbusLogInputOutput.log.isTraceOn()) {
            MbusLogInputOutput.log.trace(MbusToolkit.getText("BMbusNetworkSecondarySearchJob.initNoReply"));
        }
        long l2 = MBusTxTimings.calculateTxRxTime(mbusSndNkeMessage, (BBaudRate)this.network.getSearchBaudRate());
        int n4 = Math.max(3, mBusTxTimings.retryTransmission);
        this.logMessage(0, MbusToolkit.lex.getText("BMbusNetworkSecondarySearchJob.sendingSndNkes", new Object[]{String.valueOf(n4)}));
        int n5 = 0;
        while (n5 < n4) {
            this.network.sendMBusSync(mBusTxTimings, object, mbusSndNkeMessage, l2);
            ++n5;
        }
        this.logMessage(0, MbusToolkit.lex.getText("BMbusNetworkSecondarySearchJob.sentSndNkes", new Object[]{String.valueOf(n4)}));
        if (MbusLogInputOutput.log.isTraceOn()) {
            MbusLogInputOutput.log.trace(MbusToolkit.lex.getText("BMbusNetworkSecondarySearchJob.endInitNoReply"));
        }
        if (MbusLogInputOutput.log.isTraceOn()) {
            MbusLogInputOutput.log.trace(MbusToolkit.getText("BMbusNetworkSecondarySearchJob.initDelay"));
        }
        this.initialiseDelay(mBusTxTimings.initalisationDelay.getSeconds());
        this.logMessage(0, MbusToolkit.lex.getText("BMbusNetworkSecondarySearchJob.initSecondsDelayDone", new Object[]{String.valueOf(mBusTxTimings.initalisationDelay.getSeconds())}));
        if (MbusLogInputOutput.log.isTraceOn()) {
            MbusLogInputOutput.log.trace(MbusToolkit.getText("BMbusNetworkSecondarySearchJob.endInitDelay"));
        }
        this.network.setSearchFcBitState(true);
        if (!this.getOptimisticScan()) {
            this.logMessage(0, "Running slow & accurate scan");
        }
        this.progress(0);
        double d = 9.090909090909092;
        byte[] byArray2 = new byte[8];
        n5 = 0;
        while (n5 < byArray2.length) {
            byArray2[n5] = 15;
            ++n5;
        }
        n5 = 0;
        boolean bl = true;
        while (bl) {
            if (this.getCancelInProgress()) {
                return;
            }
            long l3 = this.getBytesAsAddress(byArray2) | l;
            object3 = null;
            if (byArray2[0] < 10) {
                int n6 = (int)((double)byArray2[0] * d);
                if (this.getProgress() < n6) {
                    this.progress(n6);
                }
            }
            object2 = Long.toHexString(l3).toUpperCase();
            while (((String)object2).length() < 16) {
                object2 = "0" + (String)object2;
            }
            this.logMessage(0, MbusToolkit.lex.getText("BMbusNetworkSecondarySearchJob.scanningWithSelector", new Object[]{object2}));
            MbusSndUdMessage mbusSndUdMessage = bMbusSecondaryAddressFilters == null ? new MbusSndUdMessage(this.getIntAsBytes((int)(l3 >> 32))) : new MbusSndUdMessage(this.getLongAsBytes(l3));
            mbusSndUdMessage.handleCorruptBuffers();
            mbusSndUdMessage.setMessageBaudRate(this.network.getSearchBaudRate());
            long l4 = MBusTxTimings.calculateTxRxTime((long)2, (BBaudRate)this.network.getSearchBaudRate());
            object3 = (MbusResponseMessage)this.network.sendMBusSync(mBusTxTimings, object, mbusSndUdMessage, l4 += MBusTxTimings.calculateTxRxTime(mbusSndUdMessage, (BBaudRate)this.network.getSearchBaudRate()));
            if (byArray2[0] < 10) {
                int n7 = (int)(((double)byArray2[0] + 0.5) * d);
                if (this.getProgress() < n7) {
                    this.progress(n7);
                }
            }
            if (this.getCancelInProgress()) {
                return;
            }
            if (byArray2[0] == 15) {
                if (object3 != null) {
                    this.logMessage(0, MbusToolkit.lex.getText("BMbusNetworkSecondarySearchJob.possibleDevicesFound", new Object[]{String.valueOf((Object)this.network.getSearchBaudRate())}));
                    byArray2[0] = 0;
                    this.progress((int)d);
                    continue;
                }
                this.logMessage(0, MbusToolkit.lex.getText("BMbusNetworkSecondarySearchJob.noPossibleDevicesFound", new Object[]{String.valueOf((Object)this.network.getSearchBaudRate())}));
                this.progress(100);
                return;
            }
            if (object3 != null && object3.getSuccessfulResponse()) {
                this.network.setSearchFcBitState(true);
                this.logMessage(0, MbusToolkit.getText("BMbusNetworkSecondarySearchJob.investigating"));
                if (MbusLogInputOutput.log.isTraceOn()) {
                    MbusLogInputOutput.log.trace("Selector \"0x" + Long.toHexString(l3) + "\" accepted by 1 or more devices");
                }
                int n8 = 0;
                if (this.getOptimisticScan() || n5 == byArray2.length - 1) {
                    int n9 = 0;
                    if (!((MbusResponseMessage)((Object)object3)).getCollisionDetected()) {
                        n9 = n8 = this.getAllTheData(object, bMbusConfig);
                    }
                }
                if (n8 > 0) {
                    if (MbusLogInputOutput.log.isTraceOn()) {
                        MbusLogInputOutput.log.trace("Device with selector \"0x" + Long.toHexString(l3) + "\" sucessfully learnt");
                    }
                    this.logMessage(3, MbusToolkit.lex.getText("BMbusNetworkSecondarySearchJob.deviceAcceptedSelector", new Object[]{Long.toHexString(l3).toUpperCase()}));
                    int n10 = n5;
                    byArray2[n10] = (byte)(byArray2[n10] + 1);
                    if (byArray2[n5] < 10) continue;
                    int n11 = n5;
                    while (n11 < byArray2.length) {
                        byArray2[n11] = 15;
                        ++n11;
                    }
                    if (--n5 == -1) {
                        return;
                    }
                    int n12 = n5;
                    byArray2[n12] = (byte)(byArray2[n12] + 1);
                    continue;
                }
                if (MbusLogInputOutput.log.isTraceOn()) {
                    MbusLogInputOutput.log.trace("Multiple devices clash with selector \"0x" + Long.toHexString(l3) + '\"');
                }
                if (++n5 - 1 == byArray2.length - 1) {
                    if (MbusLogInputOutput.log.isLoggable(3)) {
                        MbusLogInputOutput.log.error("MBUS NOT FULLY ADDRESSABLE: Multiple devices clash with maximum selector (same id) \"0x" + Long.toHexString(l3) + '\"');
                    }
                    this.logMessage(4, MbusToolkit.lex.getText("BMbusNetworkSecondarySearchJob.unaddressableSelector", new Object[]{Long.toHexString(l3).toUpperCase()}));
                    int n13 = n5 - 1;
                    while (n13 < byArray2.length) {
                        byArray2[n13] = 15;
                        ++n13;
                    }
                    int n14 = n5 -= 2;
                    byArray2[n14] = (byte)(byArray2[n14] + 1);
                    continue;
                }
                byArray2[n5] = 0;
                continue;
            }
            if (MbusLogInputOutput.log.isTraceOn()) {
                MbusLogInputOutput.log.trace("Device(s) with selector \"0x" + Long.toHexString(l3) + "\" did not reply");
            }
            int n15 = n5;
            byArray2[n15] = (byte)(byArray2[n15] + 1);
            if (byArray2[n5] < 10) continue;
            int n16 = n5;
            while (n16 < byArray2.length) {
                byArray2[n16] = 15;
                ++n16;
            }
            if (--n5 == -1) {
                bl = false;
                continue;
            }
            int n17 = n5;
            byArray2[n17] = (byte)(byArray2[n17] + 1);
        }
        this.progress(99);
        BMbusDeviceData[] bMbusDeviceDataArray = this.network.getNetworkDatabase().getDynamicDeviceData();
        int n18 = 0;
        while (n18 < bMbusDeviceDataArray.length) {
            object3 = bMbusDeviceDataArray[n18];
            if (object3.getJustDetected()) {
                object2 = new BMbusDeviceEntry();
                ((BMbusDeviceEntry)((Object)object2)).setPrimaryAddress(object3.getPrimaryAddress());
                ((BMbusDeviceEntry)((Object)object2)).setSecondaryAddress(object3.getSecondaryAddress());
                ((BMbusDeviceEntry)((Object)object2)).setTxRxMbusConfig((BMbusConfig)object3.getTxRxMbusConfig().newCopy(true));
                ((BMbusDeviceEntry)((Object)object2)).getTxRxMbusConfig().setOverrideNetwork(true);
                ((BMbusDeviceEntry)((Object)object2)).setIdentNumber(object3.getIdentNumber());
                ((BMbusDeviceEntry)((Object)object2)).setManufacturer(object3.getManufacturer());
                ((BMbusDeviceEntry)((Object)object2)).setVersionNumber(object3.getVersionNumber());
                ((BMbusDeviceEntry)((Object)object2)).setDeviceTypeId(object3.getDeviceTypeId());
                ((BMbusDeviceEntry)((Object)object2)).setBaudRate(object3.getBaudRate());
                ((BMbusDeviceEntry)((Object)object2)).setFcBitInUse(object3.getFcBitInUse());
                ((BMbusDeviceEntry)((Object)object2)).setFcBitState(object3.getFcBitState());
                ((BMbusDeviceEntry)((Object)object2)).setAddressMode(object3.getAddressMode());
                this.add(null, (BValue)object2);
            }
            ++n18;
        }
        this.progress(100);
        this.networkManager.setStatusMessage(MbusToolkit.getText("BMbusNetworkSecondarySearchJob.secondarySearchFinished"));
    }

    protected int getAllTheData(Object object, BMbusConfig bMbusConfig) {
        MbusReceivedLongFrame mbusReceivedLongFrame = null;
        MbusResponseMessage mbusResponseMessage = null;
        boolean bl = true;
        MbusReqUd2Message mbusReqUd2Message = new MbusReqUd2Message(253, this.network);
        mbusReqUd2Message.handleCorruptBuffers();
        mbusReqUd2Message.setMessageBaudRate(this.network.getSearchBaudRate());
        mbusReqUd2Message.setFcBitState(bl);
        int n = 0;
        if (!this.getCancelInProgress()) {
            if (bl) {
                this.networkManager.setStatusMessage(MbusToolkit.getText("BMbusNetworkSecondarySearchJob.RecvdDataTypeFCBS"));
            } else {
                this.networkManager.setStatusMessage(MbusToolkit.getText("BMbusNetworkSecondarySearchJob.RecvdDataTypeNoFCBS"));
            }
            long l = MBusTxTimings.calculateTxRxTime(261L, (BBaudRate)this.network.getSearchBaudRate());
            mbusResponseMessage = (MbusResponseMessage)this.network.sendMBusSync(this.network.getTxTimingsReference(), object, mbusReqUd2Message, l += MBusTxTimings.calculateTxRxTime(mbusReqUd2Message, (BBaudRate)this.network.getSearchBaudRate()));
            if (mbusResponseMessage != null && mbusResponseMessage.getSuccessfulResponse() && mbusResponseMessage.getLength() > 10) {
                mbusReceivedLongFrame = new MbusReceivedLongFrame(mbusResponseMessage, this.network, null, true, 0);
                this.networkManager.addDeviceData(this.detectedDevices, mbusReceivedLongFrame, 0, this.network.getSearchBaudRate(), null, BMbusAddressing.secondary, bMbusConfig);
                ++n;
            }
            bl ^= true;
            this.networkManager.setStatusMessage(MbusToolkit.getText("BMbusNetworkSecondarySearchJob.searchCompleted"));
        }
        return n;
    }

    public void success() {
        if (!this.cancelInProgress) {
            super.success();
        } else {
            this.setJobState(BJobState.canceled);
        }
    }

    public void doCancel(Context context) {
        try {
            this.cancelInProgress = true;
            super.doCancel(context);
        }
        catch (Exception exception) {
            this.networkManager.setStatusMessage(MbusToolkit.getText("BMbusNetworkSecondarySearchJob.Error Canceling"));
        }
    }

    public boolean getCancelInProgress() {
        return this.cancelInProgress;
    }

    public void initialiseDelay(int n) {
        long l = (long)(n * 1000) + Clock.ticks();
        try {
            long l2 = Math.min(l - Clock.ticks(), 1000L);
            while (l2 > 0L) {
                if (this.cancelInProgress) {
                    return;
                }
                Thread.sleep(l2);
                l2 = Math.min(l - Clock.ticks(), 1000L);
            }
        }
        catch (InterruptedException interruptedException) {}
    }

    public void setOverrideTxTimings(MBusTxTimings mBusTxTimings) {
        this.overrideTxTimings = mBusTxTimings;
    }

    public void logMessage(int n, String string) {
        this.log().add(new JobLogItem(n, string));
        if (this.log != null) {
            String string2 = "--> ";
            this.log.add(new JobLogItem(n, string2 + string));
        }
    }

    protected long getBytesAsAddress(byte[] byArray) {
        int n = byArray[0] << 28 | byArray[1] << 24 | byArray[2] << 20 | byArray[3] << 16 | byArray[4] << 12 | byArray[5] << 8 | byArray[6] << 4 | byArray[7];
        return (long)n << 32;
    }

    public byte[] getIntAsBytes(int n) {
        byte[] byArray = new byte[]{(byte)((n & 0xFF000000) >> 24 & 0xFF), (byte)((n & 0xFF0000) >> 16 & 0xFF), (byte)((n & 0xFF00) >> 8 & 0xFF), (byte)(n & 0xFF)};
        return byArray;
    }

    public byte[] getLongAsBytes(long l) {
        byte[] byArray = new byte[]{(byte)((l & 0xFF00000000000000L) >> 56 & 0xFFL), (byte)((l & 0xFF000000000000L) >> 48 & 0xFFL), (byte)((l & 0xFF0000000000L) >> 40 & 0xFFL), (byte)((l & 0xFF00000000L) >> 32 & 0xFFL), (byte)((l & 0xFFFFFFFFFF000000L) >> 24 & 0xFFL), (byte)((l & 0xFF0000L) >> 16 & 0xFFL), (byte)((l & 0xFF00L) >> 8 & 0xFFL), (byte)(l & 0xFFL)};
        return byArray;
    }

    public HashSet getDetectedDevicesHandleOrds() {
        HashSet hashSet = this.detectedDevices;
        this.detectedDevices = null;
        return hashSet;
    }

    public void overrideCommLock(Object object) {
        this.commLock = object;
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final /* synthetic */ void this() {
        this.network = null;
        this.networkManager = null;
        this.filters = null;
        this.cancelInProgress = true;
        this.log = null;
        this.overrideTxTimings = null;
        this.detectedDevices = new HashSet();
    }

    public BMbusSecondarySearchJob() {
        this.this();
    }

    public BMbusSecondarySearchJob(BAbstractMbusNetwork bAbstractMbusNetwork, BMbusSecondaryAddressFilters bMbusSecondaryAddressFilters, JobLog jobLog) {
        this.this();
        if (bMbusSecondaryAddressFilters != null) {
            this.filters = bMbusSecondaryAddressFilters;
        }
        this.network = bAbstractMbusNetwork;
        this.networkManager = this.network.getNetworkDatabase();
        this.cancelInProgress = false;
        this.log = jobLog;
    }

    static {
        Class clazz = class$com$tridium$mbus$jobs$BMbusSecondarySearchJob;
        if (clazz == null) {
            clazz = class$com$tridium$mbus$jobs$BMbusSecondarySearchJob = BMbusSecondarySearchJob.class("[Lcom.tridium.mbus.jobs.BMbusSecondarySearchJob;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
    }
}

