/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.mbus.jobs;

import com.tridium.mbus.BAbstractMbusNetwork;
import com.tridium.mbus.BMbusTcpIpNetwork;
import com.tridium.mbus.actionArgSets.BSecondaryDiscoverOptions;
import com.tridium.mbus.db.BMbusDeviceData;
import com.tridium.mbus.enums.BMbusBaudRate;
import com.tridium.mbus.jobs.BMbusSecondarySearchJob;
import com.tridium.mbus.utils.MbusToolkit;
import java.util.HashSet;
import javax.baja.job.BJob;
import javax.baja.job.BJobState;
import javax.baja.job.BSimpleJob;
import javax.baja.job.JobCancelException;
import javax.baja.naming.BOrd;
import javax.baja.serial.BBaudRate;
import javax.baja.sys.Action;
import javax.baja.sys.BComponent;
import javax.baja.sys.BComponentEvent;
import javax.baja.sys.BInteger;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.BVector;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Subscriber;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.Array;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BMbusSecondaryDeviceSearchJob
extends BSimpleJob {
    public static final Property discoveryOptions = BMbusSecondaryDeviceSearchJob.newProperty((int)0, (BValue)new BSecondaryDiscoverOptions(), null);
    public static final Action handleNewPrimaryAdddressFound = BMbusSecondaryDeviceSearchJob.newAction((int)0, (BValue)BInteger.make((int)-1), null);
    public static final Type TYPE;
    private BBaudRate currentScanBaudRate;
    private Object addressesToScanLock;
    private Array addressesToScan;
    private BSimpleJob activeChildJob;
    private BAbstractMbusNetwork networkRef;
    private double baseProgress;
    private double progressPerScan;
    static /* synthetic */ Class class$com$tridium$mbus$jobs$BMbusSecondaryDeviceSearchJob;
    static /* synthetic */ Class class$javax$baja$sys$BInteger;
    static /* synthetic */ Class class$javax$baja$serial$BBaudRate;

    public BSecondaryDiscoverOptions getDiscoveryOptions() {
        return (BSecondaryDiscoverOptions)this.get(discoveryOptions);
    }

    public void setDiscoveryOptions(BSecondaryDiscoverOptions bSecondaryDiscoverOptions) {
        this.set(discoveryOptions, (BValue)bSecondaryDiscoverOptions, null);
    }

    public void handleNewPrimaryAdddressFound(BInteger bInteger) {
        this.invoke(handleNewPrimaryAdddressFound, (BValue)bInteger, null);
    }

    public Type getType() {
        return TYPE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void doHandleNewPrimaryAdddressFound(BInteger bInteger) {
        if (bInteger.getInt() < 0 || bInteger.getInt() > 250) {
            return;
        }
        Object object = this.addressesToScanLock;
        synchronized (object) {
            this.addressesToScan.remove((Object)bInteger);
            return;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run(Context context) throws Exception {
        String string = new String("SecondaryDeviceSearch" + this.getHandle());
        try {
            try {
                this.doCommsLockedRun(context, string);
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
                this.networkRef.unlockSends(string);
                this.networkRef = null;
                this.activeChildJob = null;
                if (throwable instanceof JobCancelException) {
                    throw (JobCancelException)throwable;
                }
            }
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            this.networkRef.unlockSends(string);
            this.networkRef = null;
            this.activeChildJob = null;
            throw throwable;
        }
        {
            Object var4_6 = null;
            this.networkRef.unlockSends(string);
            this.networkRef = null;
            this.activeChildJob = null;
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public void doCommsLockedRun(Context context, Object object) throws Exception {
        this.log().message(MbusToolkit.getText("MbusNetworkDeviceSearch.startingScan"));
        BVector bVector = this.getDiscoveryOptions().getBaudRates();
        Class clazz = class$javax$baja$serial$BBaudRate;
        if (clazz == null) {
            clazz = class$javax$baja$serial$BBaudRate = BMbusSecondaryDeviceSearchJob.class("[Ljavax.baja.serial.BBaudRate;", false);
        }
        Object[] objectArray = bVector.getChildren(clazz);
        this.networkRef.getNetworkDatabase().clearJustDetected();
        this.networkRef.getNetworkDatabase().setActiveDiscovery((BJob)this);
        if (objectArray.length == 0) {
            if (!(this.networkRef instanceof BMbusTcpIpNetwork)) {
                this.log().message(MbusToolkit.getText("MbusNetworkDeviceSearch.noBaudRatesSpecified"));
                throw new Exception("Baud rates must be set");
            }
            this.log().message(MbusToolkit.lex.getText("MbusNetworkDeviceSearch.tcpipConverterSlowBaudSet", new Object[]{BMbusBaudRate.baud300.getTypeDisplayName(null)}));
            objectArray = new BBaudRate[]{BMbusBaudRate.baud300};
        } else {
            this.log().message(MbusToolkit.lex.getText("MbusNetworkDeviceSearch.baudRatesToScan", new Object[]{String.valueOf(objectArray.length)}));
            int n = 0;
            while (n < objectArray.length) {
                this.log().message("-> " + ((BBaudRate)objectArray[n]).getDisplayTag(context));
                ++n;
            }
        }
        this.networkRef.lockSends(object);
        HashSet hashSet = new HashSet();
        this.progressPerScan = 100.0 / (double)objectArray.length;
        int n = 0;
        while (n < objectArray.length) {
            if (!this.getJobState().equals((Object)BJobState.running)) break;
            this.currentScanBaudRate = (BBaudRate)objectArray[n];
            this.activeChildJob = this.getDiscoveryOptions().getIdentScanOnly() ? new BMbusSecondarySearchJob(this.networkRef, null, this.log()) : new BMbusSecondarySearchJob(this.networkRef, this.getDiscoveryOptions().getFilters(), this.log());
            ((BMbusSecondarySearchJob)this.activeChildJob).setOverrideTxTimings(this.getDiscoveryOptions().getTxRxProfile().getMBusTxTimings());
            ((BMbusSecondarySearchJob)this.activeChildJob).overrideCommLock(object);
            if (this.currentScanBaudRate instanceof BMbusBaudRate) {
                this.networkRef.setSearchBaudRate((BMbusBaudRate)this.currentScanBaudRate);
            }
            this.log().message(MbusToolkit.lex.getText("MbusNetworkDeviceSearch.startingBaudRateScan", new Object[]{this.currentScanBaudRate}));
            this.activeChildJob.submit(context);
            BJobState bJobState = this.waitForFinalState((BJob)this.activeChildJob);
            while (bJobState == BJobState.running) {
                bJobState = this.waitForFinalState((BJob)this.activeChildJob);
            }
            switch (bJobState.getOrdinal()) {
                case 4: {
                    this.log().message(MbusToolkit.lex.getText("MbusNetworkDeviceSearch.completedScanAtBaud", new Object[]{this.currentScanBaudRate}));
                    break;
                }
                case 5: {
                    this.log().message(MbusToolkit.lex.getText("MbusNetworkDeviceSearch.failedScanAtBaud", new Object[]{this.currentScanBaudRate}));
                    break;
                }
                case 3: {
                    this.log().message(MbusToolkit.lex.getText("MbusNetworkDeviceSearch.cancelledScanAtBaud", new Object[]{this.currentScanBaudRate}));
                    break;
                }
            }
            this.baseProgress = 100.0 / (double)objectArray.length * (double)(n + 1);
            this.progress((int)this.baseProgress);
            hashSet.addAll(((BMbusSecondarySearchJob)this.activeChildJob).getDetectedDevicesHandleOrds());
            ++n;
        }
        this.networkRef.getNetworkDatabase().clearJustDetected();
        Object[] objectArray2 = hashSet.toArray();
        int n2 = 0;
        while (n2 < objectArray2.length) {
            ((BMbusDeviceData)BOrd.make((String)((String)objectArray2[n2])).get((BObject)this)).setJustDetected(true);
            ++n2;
        }
        this.networkRef.getNetworkDatabase().cancelActiveDiscovery((BJob)this);
        this.currentScanBaudRate = null;
        this.addressesToScan = null;
        this.currentScanBaudRate = null;
        this.activeChildJob = null;
        if (this.getJobState().equals((Object)BJobState.canceling)) {
            throw new JobCancelException();
        }
    }

    public BJobState waitForFinalState(BJob bJob) {
        switch (bJob.getJobState().getOrdinal()) {
            case 3: {
                return BJobState.canceled;
            }
            case 4: {
                return BJobState.success;
            }
            case 5: {
                return BJobState.failed;
            }
            case 0: {
                return BJobState.unknown;
            }
        }
        jobMonitor jobMonitor2 = new jobMonitor(bJob, (BJob)this);
        jobMonitor2.subscribe((BComponent)bJob);
        jobMonitor2.waitForFinalState();
        jobMonitor2.unsubscribe((BComponent)bJob);
        return bJob.getJobState();
    }

    public void doCancel(Context context) {
        if (this.getJobState().isRunning()) {
            this.setJobState(BJobState.canceling);
        }
        if (this.activeChildJob != null) {
            this.activeChildJob.doCancel(context);
        }
        super.doCancel(context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected int[] getAddressesToScan() {
        if (this.addressesToScan == null) {
            return new int[0];
        }
        Object object = this.addressesToScanLock;
        synchronized (object) {
            int[] nArray = new int[this.addressesToScan.size()];
            Object[] objectArray = this.addressesToScan.array();
            int n = 0;
            while (n < this.addressesToScan.size()) {
                nArray[n] = ((BInteger)objectArray[n]).getInt();
                ++n;
            }
            return nArray;
        }
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final /* synthetic */ void this() {
        this.currentScanBaudRate = null;
        this.addressesToScanLock = new Object();
        Class clazz = class$javax$baja$sys$BInteger;
        if (clazz == null) {
            clazz = class$javax$baja$sys$BInteger = BMbusSecondaryDeviceSearchJob.class("[Ljavax.baja.sys.BInteger;", false);
        }
        this.addressesToScan = new Array(clazz);
        this.activeChildJob = null;
        this.baseProgress = 0.0;
        this.progressPerScan = 100.0;
    }

    public BMbusSecondaryDeviceSearchJob() {
        this.this();
    }

    public BMbusSecondaryDeviceSearchJob(BAbstractMbusNetwork bAbstractMbusNetwork) {
        this.this();
        this.networkRef = bAbstractMbusNetwork;
    }

    static {
        Class clazz = class$com$tridium$mbus$jobs$BMbusSecondaryDeviceSearchJob;
        if (clazz == null) {
            clazz = class$com$tridium$mbus$jobs$BMbusSecondaryDeviceSearchJob = BMbusSecondaryDeviceSearchJob.class("[Lcom.tridium.mbus.jobs.BMbusSecondaryDeviceSearchJob;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    protected class jobMonitor
    extends Subscriber {
        Object threadLock;
        BJob jobToMonitor;
        BJob blockedJob;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void event(BComponentEvent bComponentEvent) {
            if (bComponentEvent.getSlotName().equals(BJob.jobState.getName())) {
                Object object = this.threadLock;
                synchronized (object) {
                    this.threadLock.notifyAll();
                    return;
                }
            }
            if (!bComponentEvent.getSlotName().equals(BJob.progress.getName())) return;
            int n = (int)(BMbusSecondaryDeviceSearchJob.this.baseProgress + BMbusSecondaryDeviceSearchJob.this.progressPerScan / 100.0 * ((BInteger)bComponentEvent.getValue()).getDouble());
            if (((BInteger)bComponentEvent.getValue()).getDouble() > 100.0) {
                n = (int)(BMbusSecondaryDeviceSearchJob.this.baseProgress + 100.0 / BMbusSecondaryDeviceSearchJob.this.progressPerScan);
            }
            this.blockedJob.progress(n);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void waitForFinalState() {
            Object object = this.threadLock;
            synchronized (object) {
                while (this.jobToMonitor.getJobState() == BJobState.running) {
                    try {
                        this.threadLock.wait(10000L);
                        this.blockedJob.heartbeat();
                    }
                    catch (InterruptedException interruptedException) {}
                }
                return;
            }
        }

        private final /* synthetic */ void this() {
            this.threadLock = new Object();
        }

        public jobMonitor(BJob bJob, BJob bJob2) {
            this.this();
            this.jobToMonitor = bJob;
            this.blockedJob = bJob2;
        }
    }
}

