/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.mbus.jobs;

import com.tridium.mbus.BAbstractMbusNetwork;
import com.tridium.mbus.BMbusDevice;
import com.tridium.mbus.actionArgSets.BLivePointSearchDiscoverOptions;
import com.tridium.mbus.comm.MBusTxTimings;
import com.tridium.mbus.db.BMbusNetworkDatabase;
import com.tridium.mbus.enums.BMbusAddressing;
import com.tridium.mbus.messages.MbusMessage;
import com.tridium.mbus.messages.MbusReceivedLongFrame;
import com.tridium.mbus.messages.MbusReqUd2Message;
import com.tridium.mbus.messages.MbusResponseMessage;
import com.tridium.mbus.messages.MbusSndUdMessage;
import com.tridium.mbus.utils.MbusDecodeVariableFrame;
import com.tridium.mbus.utils.MbusLogInputOutput;
import com.tridium.mbus.utils.MbusToolkit;
import javax.baja.job.BJob;
import javax.baja.job.BJobState;
import javax.baja.job.BSimpleJob;
import javax.baja.job.JobCancelException;
import javax.baja.serial.BBaudRate;
import javax.baja.sys.BComponent;
import javax.baja.sys.BComponentEvent;
import javax.baja.sys.BInteger;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Subscriber;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BMbusLivePointSearchDiscoveryJob
extends BSimpleJob {
    public static final Property discoveryOptions = BMbusLivePointSearchDiscoveryJob.newProperty((int)0, (BValue)new BLivePointSearchDiscoverOptions(), null);
    public static final Type TYPE;
    protected BMbusDevice deviceRef;
    protected BAbstractMbusNetwork networkRef;
    protected double baseProgress;
    protected double progressPerScan;
    static /* synthetic */ Class class$com$tridium$mbus$jobs$BMbusLivePointSearchDiscoveryJob;

    public BLivePointSearchDiscoverOptions getDiscoveryOptions() {
        return (BLivePointSearchDiscoverOptions)this.get(discoveryOptions);
    }

    public void setDiscoveryOptions(BLivePointSearchDiscoverOptions bLivePointSearchDiscoverOptions) {
        this.set(discoveryOptions, (BValue)bLivePointSearchDiscoverOptions, null);
    }

    public Type getType() {
        return TYPE;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run(Context context) throws Exception {
        String string = new String("LivePointSearch" + this.getHandle());
        try {
            try {
                this.doCommsLockedRun(context, string);
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
                this.networkRef.unlockSends(string);
                this.networkRef = null;
                this.deviceRef = null;
                if (throwable instanceof JobCancelException) {
                    throw (JobCancelException)throwable;
                }
            }
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            this.networkRef.unlockSends(string);
            this.networkRef = null;
            this.deviceRef = null;
            throw throwable;
        }
        {
            Object var4_6 = null;
            this.networkRef.unlockSends(string);
            this.networkRef = null;
            this.deviceRef = null;
            return;
        }
    }

    public void doCommsLockedRun(Context context, Object object) throws Exception {
        MbusMessage mbusMessage;
        this.log().message(MbusToolkit.getText("MbusNetworkPointSearch.startingScan"));
        this.networkRef.getNetworkDatabase().setActiveDiscovery((BJob)this);
        this.log().message(MbusToolkit.getText("MbusNetworkPointSearch.awaitingComms"));
        MBusTxTimings mBusTxTimings = this.deviceRef.getTxTimingsReference();
        this.heartbeat();
        BMbusNetworkDatabase bMbusNetworkDatabase = this.networkRef.getNetworkDatabase();
        this.networkRef.lockSends(object);
        if (this.getJobState().equals((Object)BJobState.canceling)) {
            throw new JobCancelException();
        }
        this.heartbeat();
        this.progress(1);
        if (this.deviceRef.getResetRequired()) {
            this.log().message(MbusToolkit.getText("MbusNetworkPointSearch.resettingAndInitStart"));
            this.deviceRef.doSendNkeAndInitDelay(mBusTxTimings, object);
            this.log().message(MbusToolkit.getText("MbusNetworkPointSearch.resettingAndInitEnd"));
        }
        if (this.getJobState().equals((Object)BJobState.canceling)) {
            throw new JobCancelException();
        }
        this.progress(3);
        if (this.deviceRef.getAddressMode() != BMbusAddressing.primary) {
            MbusResponseMessage mbusResponseMessage;
            this.log().message(MbusToolkit.getText("MbusNetworkPointSearch.selectingSecondaryAddress"));
            mbusMessage = new MbusSndUdMessage(this.deviceRef, this.networkRef);
            mbusMessage.setMessageBaudRate(this.deviceRef.getBaudRate());
            long l = MBusTxTimings.calculateTxRxTime((long)2, (BBaudRate)this.deviceRef.getBaudRate());
            l += MBusTxTimings.calculateTxRxTime(mbusMessage, (BBaudRate)this.deviceRef.getBaudRate());
            if (MbusLogInputOutput.log.isTraceOn()) {
                MbusLogInputOutput.log.trace("Sending secondary address selector");
            }
            if ((mbusResponseMessage = (MbusResponseMessage)this.networkRef.sendMBusSync(mBusTxTimings, object, mbusMessage, l)) == null || mbusResponseMessage != null && !mbusResponseMessage.getSuccessfulResponse() || mbusResponseMessage != null && mbusResponseMessage.getCollisionDetected()) {
                if (MbusLogInputOutput.log.isLoggable(2) && this.deviceRef.isMounted()) {
                    if (mbusResponseMessage != null && mbusResponseMessage.getCollisionDetected()) {
                        MbusLogInputOutput.log.warning(this.deviceRef.getDisplayName(null) + " Failed to select secondary addressing - collision detected - try extended secondary addressing");
                    } else {
                        MbusLogInputOutput.log.warning(this.deviceRef.getDisplayName(null) + " Failed to select secondary addressing after reset - the device may require a longer reset time");
                    }
                }
                if (mbusResponseMessage != null && mbusResponseMessage.getCollisionDetected()) {
                    this.log().message(MbusToolkit.getText("BMbusGeneral.busSelectionFailure"));
                } else {
                    this.log().message(MbusToolkit.getText("MbusNetworkPointSearch.failedSecondaryAddressSelection"));
                }
                throw new Exception(MbusToolkit.getText("MbusNetworkPointSearch.failedSecondaryAddressSelection"));
            }
            this.log().message(MbusToolkit.getText("MbusNetworkPointSearch.selectedSecondaryAddress"));
            this.networkRef.setSearchFcBitState(true);
        }
        if (this.getJobState().equals((Object)BJobState.canceling)) {
            throw new JobCancelException();
        }
        this.progress(5);
        mbusMessage = null;
        MbusResponseMessage mbusResponseMessage = null;
        int n = this.getDiscoveryOptions().getMaxSequentialReads();
        this.log().message(MbusToolkit.lex.getText("MbusNetworkPointSearch.scanningUpToResp", new Object[]{String.valueOf(n)}));
        double d = 95.0 / (double)n;
        long l = -1;
        MbusDecodeVariableFrame.DecoderOverrides decoderOverrides = new MbusDecodeVariableFrame.DecoderOverrides();
        int n2 = 0;
        while (n2 < n) {
            block23: {
                mbusMessage = new MbusReqUd2Message(this.deviceRef, this.networkRef);
                if (l == (long)-1) {
                    l = MBusTxTimings.calculateTxRxTime(261L, (BBaudRate)this.deviceRef.getBaudRate());
                    l += MBusTxTimings.calculateTxRxTime(mbusMessage, (BBaudRate)this.deviceRef.getBaudRate());
                }
                if (this.getJobState().equals((Object)BJobState.canceling)) {
                    throw new JobCancelException();
                }
                mbusResponseMessage = (MbusResponseMessage)this.networkRef.sendMBusSync(this.deviceRef.getTxTimingsReference(), object, mbusMessage, l);
                if (this.getJobState().equals((Object)BJobState.canceling)) {
                    throw new JobCancelException();
                }
                if (mbusResponseMessage == null || !mbusResponseMessage.getSuccessfulResponse() || mbusResponseMessage.getLength() <= 10) break block23;
                decoderOverrides.recordNumber = n2 + 1;
                MbusReceivedLongFrame mbusReceivedLongFrame = new MbusReceivedLongFrame(mbusResponseMessage, this.networkRef, this.deviceRef, false, 0, decoderOverrides);
                switch (mbusReceivedLongFrame.getCIField()) {
                    case 118: {
                        break;
                    }
                    case 114: {
                        break;
                    }
                    default: {
                        this.log().message(MbusToolkit.getText("MbusNetworkPointSearch.endOfVDS"));
                        n2 = n;
                        break block23;
                    }
                }
                this.log().message(MbusToolkit.lex.getText("MbusNetworkPointSearch.processingResponse", new Object[]{String.valueOf(n2 + 1)}));
                this.progress((int)((double)(n2 + 1) * d + (double)5));
                boolean bl = mbusReceivedLongFrame.getFurtherDataIndicated();
                int n3 = bMbusNetworkDatabase.addDeviceData(null, mbusReceivedLongFrame, 0, this.deviceRef.getBaudRate(), this.deviceRef, this.deviceRef.getAddressMode(), this.deviceRef.getMbusConfig());
                if (n3 > 0) {
                    this.log().message(MbusToolkit.lex.getText("MbusNetworkPointSearch.addedNewPointDefs", new Object[]{String.valueOf(n3)}));
                }
                if (!bl) {
                    this.log().message(MbusToolkit.getText("MbusNetworkPointSearch.noMoreDataToBeRead"));
                    break;
                }
            }
            ++n2;
        }
        this.progress(100);
        this.networkRef.getNetworkDatabase().cancelActiveDiscovery((BJob)this);
        if (this.getJobState().equals((Object)BJobState.canceling)) {
            throw new JobCancelException();
        }
    }

    public BJobState waitForFinalState(BJob bJob) {
        switch (bJob.getJobState().getOrdinal()) {
            case 3: {
                return BJobState.canceled;
            }
            case 4: {
                return BJobState.success;
            }
            case 5: {
                return BJobState.failed;
            }
            case 0: {
                return BJobState.unknown;
            }
        }
        jobMonitor jobMonitor2 = new jobMonitor(bJob, (BJob)this);
        jobMonitor2.subscribe((BComponent)bJob);
        jobMonitor2.waitForFinalState();
        jobMonitor2.unsubscribe((BComponent)bJob);
        return bJob.getJobState();
    }

    public void doCancel(Context context) {
        if (this.getJobState().isRunning()) {
            this.setJobState(BJobState.canceling);
        }
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final /* synthetic */ void this() {
        this.baseProgress = 0.0;
        this.progressPerScan = 100.0;
    }

    public BMbusLivePointSearchDiscoveryJob() {
        this.this();
    }

    public BMbusLivePointSearchDiscoveryJob(BMbusDevice bMbusDevice) {
        this.this();
        this.deviceRef = bMbusDevice;
        this.networkRef = bMbusDevice.getMbusNetwork();
    }

    static {
        Class clazz = class$com$tridium$mbus$jobs$BMbusLivePointSearchDiscoveryJob;
        if (clazz == null) {
            clazz = class$com$tridium$mbus$jobs$BMbusLivePointSearchDiscoveryJob = BMbusLivePointSearchDiscoveryJob.class("[Lcom.tridium.mbus.jobs.BMbusLivePointSearchDiscoveryJob;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    protected class jobMonitor
    extends Subscriber {
        Object threadLock;
        BJob jobToMonitor;
        BJob blockedJob;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void event(BComponentEvent bComponentEvent) {
            if (bComponentEvent.getSlotName().equals(BJob.jobState.getName())) {
                Object object = this.threadLock;
                synchronized (object) {
                    this.threadLock.notifyAll();
                    return;
                }
            }
            if (!bComponentEvent.getSlotName().equals(BJob.progress.getName())) return;
            int n = (int)(BMbusLivePointSearchDiscoveryJob.this.baseProgress + BMbusLivePointSearchDiscoveryJob.this.progressPerScan / 100.0 * ((BInteger)bComponentEvent.getValue()).getDouble());
            if (((BInteger)bComponentEvent.getValue()).getDouble() > 100.0) {
                n = (int)(BMbusLivePointSearchDiscoveryJob.this.baseProgress + 100.0 / BMbusLivePointSearchDiscoveryJob.this.progressPerScan);
            }
            this.blockedJob.progress(n);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void waitForFinalState() {
            Object object = this.threadLock;
            synchronized (object) {
                while (this.jobToMonitor.getJobState() == BJobState.running) {
                    try {
                        this.threadLock.wait(10000L);
                        this.blockedJob.heartbeat();
                    }
                    catch (InterruptedException interruptedException) {}
                }
                return;
            }
        }

        private final /* synthetic */ void this() {
            this.threadLock = new Object();
        }

        public jobMonitor(BJob bJob, BJob bJob2) {
            this.this();
            this.jobToMonitor = bJob;
            this.blockedJob = bJob2;
        }
    }
}

