/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.mbus.jobs;

import com.tridium.basicdriver.message.Message;
import com.tridium.mbus.BAbstractMbusNetwork;
import com.tridium.mbus.BMbusDevice;
import com.tridium.mbus.comm.MBusTxTimings;
import com.tridium.mbus.enums.BMbusAddressing;
import com.tridium.mbus.enums.BMbusBaudRate;
import com.tridium.mbus.jobs.BMbusAssignBaudRateData;
import com.tridium.mbus.messages.MbusControlFrameMessage;
import com.tridium.mbus.messages.MbusResponseMessage;
import com.tridium.mbus.messages.MbusSndUdMessage;
import com.tridium.mbus.utils.MbusToolkit;
import java.io.IOException;
import javax.baja.job.BJobState;
import javax.baja.job.BSimpleJob;
import javax.baja.naming.BatchResolve;
import javax.baja.serial.BBaudRate;
import javax.baja.sys.BComponent;
import javax.baja.sys.BObject;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public final class BMbusAssignBaudRateJob
extends BSimpleJob {
    public static final Type TYPE;
    private BAbstractMbusNetwork network;
    private BMbusDevice[] devices;
    private BMbusBaudRate demanded;
    static /* synthetic */ Class class$com$tridium$mbus$jobs$BMbusAssignBaudRateJob;

    public final Type getType() {
        return TYPE;
    }

    public final void run(Context context) throws Exception {
        String string = "assignBaudRate" + this.getHandle();
        try {
            this.commProtectedRun(string, context);
            this.network.unlockSends(string);
        }
        catch (Exception exception) {
            this.network.unlockSends(string);
            throw exception;
        }
        catch (Throwable throwable) {
            this.network.unlockSends(string);
            throw new Exception(throwable.getMessage());
        }
    }

    public final void commProtectedRun(Object object, Context context) throws Exception {
        double d = 5;
        double d2 = 95.0;
        if (this.devices.length > 1) {
            d2 = 95.0 / (double)this.devices.length;
        }
        IOException iOException = null;
        boolean bl = false;
        int n = 0;
        while (n < this.devices.length) {
            block11: {
                if (this.getJobState().equals((Object)BJobState.canceling)) {
                    return;
                }
                this.log().message(MbusToolkit.lex.getText("MbusAssignBaudRateJob.assigningToDevice", (Object[])new String[]{this.demanded.getDisplayTag(context), this.devices[n].getDisplayName(null)}));
                try {
                    Object object2;
                    this.progress((int)d);
                    MbusControlFrameMessage mbusControlFrameMessage = new MbusControlFrameMessage();
                    mbusControlFrameMessage.setMessageBaudRate(this.devices[n].getBaudRate());
                    mbusControlFrameMessage.setCiField(this.demanded.getMbusCommsBaudRate());
                    mbusControlFrameMessage.setCFieldNoFcb(67);
                    mbusControlFrameMessage.setAField(this.devices[n].getPrimaryAddress());
                    if (this.devices[n].getAddressMode() != BMbusAddressing.primary) {
                        object2 = new MbusSndUdMessage(this.devices[n], this.network);
                        object2.setMessageBaudRate(this.devices[n].getBaudRate());
                        long l = MBusTxTimings.calculateTxRxTime((long)2, (BBaudRate)this.devices[n].getBaudRate());
                        MbusResponseMessage mbusResponseMessage = (MbusResponseMessage)this.network.sendMBusSync(this.devices[n].getTxTimingsReference(), object, (Message)object2, l += MBusTxTimings.calculateTxRxTime(object2, (BBaudRate)this.devices[n].getBaudRate()));
                        if (mbusResponseMessage != null && mbusResponseMessage.getCollisionDetected()) {
                            this.log().failed(MbusToolkit.getText("BMbusGeneral.busSelectionFailure"));
                            throw new Exception("Bus collision detected on secondary address selection");
                        }
                        this.devices[n].setFcBitState(true);
                        mbusControlFrameMessage.setAField(253);
                    } else {
                        mbusControlFrameMessage.setAField(this.devices[n].getPrimaryAddress());
                    }
                    mbusControlFrameMessage.setFcBitInUse(this.devices[n].getFcBitInUse());
                    mbusControlFrameMessage.setFcBitState(this.devices[n].getFcBitState());
                    this.devices[n].setFcBitState(this.devices[n].getFcBitState() ^ true);
                    object2 = this.devices[n].getBaudRate();
                    long l = MBusTxTimings.calculateTxRxTime((long)2, (BBaudRate)this.devices[n].getBaudRate());
                    MbusResponseMessage mbusResponseMessage = (MbusResponseMessage)this.network.sendMBusSync(this.devices[n].getTxTimingsReference(), object, mbusControlFrameMessage, l += MBusTxTimings.calculateTxRxTime(mbusControlFrameMessage, (BBaudRate)this.devices[n].getBaudRate()));
                    this.progress((int)(d += 0.5 * d2));
                    if (mbusResponseMessage != null && mbusResponseMessage.getSuccessfulResponse()) {
                        mbusControlFrameMessage.setMessageBaudRate(this.demanded);
                        l = MBusTxTimings.calculateTxRxTime(261L, (BBaudRate)this.demanded);
                        mbusResponseMessage = (MbusResponseMessage)this.network.sendMBusSync(this.devices[n].getTxTimingsReference(), object, mbusControlFrameMessage, l += MBusTxTimings.calculateTxRxTime(mbusControlFrameMessage, (BBaudRate)this.demanded));
                        this.progress((int)(d += 0.5 * d2));
                        if (mbusResponseMessage != null && mbusResponseMessage.getSuccessfulResponse()) {
                            this.log().success(MbusToolkit.getText("MbusAssignBaudRateJob.success"));
                            this.devices[n].setBaudRate(this.demanded);
                            break block11;
                        }
                        this.log().failed(MbusToolkit.getText("MbusAssignBaudRateJob.failed"));
                        bl = true;
                        throw new IOException(MbusToolkit.getText("MbusAssignBaudRateJob.failed"));
                    }
                    this.progress((int)(d += 0.5 * d2));
                    this.devices[n].setBaudRate((BMbusBaudRate)((Object)object2));
                    bl = true;
                    this.log().failed(MbusToolkit.getText("MbusAssignBaudRateJob.failedBackToOriginalValue"));
                    throw new IOException(MbusToolkit.getText("MbusAssignBaudRateJob.failedBackToOriginalValue"));
                }
                catch (IOException iOException2) {
                    iOException = iOException2;
                }
            }
            ++n;
        }
        if (iOException != null) {
            throw iOException;
        }
        this.setJobState(bl ? BJobState.failed : BJobState.success);
    }

    public final void success() {
        if (this.getJobState() == BJobState.success) {
            this.log().success("Job Success");
            this.complete(BJobState.success);
        } else if (this.getJobState() == BJobState.canceling) {
            this.canceled();
        } else {
            this.complete(BJobState.failed);
        }
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final /* synthetic */ void this() {
        this.network = null;
        this.devices = null;
        this.demanded = BMbusBaudRate.baud300;
    }

    public BMbusAssignBaudRateJob() {
        this.this();
    }

    public BMbusAssignBaudRateJob(BAbstractMbusNetwork bAbstractMbusNetwork, BMbusAssignBaudRateData bMbusAssignBaudRateData) {
        this.this();
        this.network = bAbstractMbusNetwork;
        this.demanded = bMbusAssignBaudRateData.getDemanded();
        try {
            BatchResolve batchResolve = new BatchResolve(bMbusAssignBaudRateData.getDeviceOrds().toArray());
            batchResolve.resolve((BObject)bAbstractMbusNetwork);
            BComponent[] bComponentArray = batchResolve.getTargetComponents();
            this.devices = new BMbusDevice[bComponentArray.length];
            int n = 0;
            while (n < bComponentArray.length) {
                this.devices[n] = (BMbusDevice)bComponentArray[n];
                ++n;
            }
        }
        catch (Exception exception) {
            MbusToolkit.error("Error resolving device ords for job", exception);
        }
    }

    static {
        Class clazz = class$com$tridium$mbus$jobs$BMbusAssignBaudRateJob;
        if (clazz == null) {
            clazz = class$com$tridium$mbus$jobs$BMbusAssignBaudRateJob = BMbusAssignBaudRateJob.class("[Lcom.tridium.mbus.jobs.BMbusAssignBaudRateJob;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
    }
}

