/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.mbus.jobs;

import com.tridium.basicdriver.message.Message;
import com.tridium.mbus.BAbstractMbusNetwork;
import com.tridium.mbus.BMbusDevice;
import com.tridium.mbus.comm.MBusTxTimings;
import com.tridium.mbus.enums.BMbusAddressing;
import com.tridium.mbus.messages.MbusLongFrameMessage;
import com.tridium.mbus.messages.MbusReqUd2Message;
import com.tridium.mbus.messages.MbusResponseMessage;
import com.tridium.mbus.messages.MbusSndUdMessage;
import com.tridium.mbus.utils.MbusToolkit;
import javax.baja.job.BJobState;
import javax.baja.job.BSimpleJob;
import javax.baja.serial.BBaudRate;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public final class BMbusAssignAddressJob
extends BSimpleJob {
    public static final Type TYPE;
    private BAbstractMbusNetwork network;
    private BMbusDevice device;
    private int address;
    static /* synthetic */ Class class$com$tridium$mbus$jobs$BMbusAssignAddressJob;

    public final Type getType() {
        return TYPE;
    }

    public final void run(Context context) throws Exception {
        String string = "assignAddr" + this.getHandle();
        try {
            this.commProtectedRun(string, context);
            this.network.unlockSends(string);
        }
        catch (Exception exception) {
            this.network.unlockSends(string);
            throw exception;
        }
        catch (Throwable throwable) {
            this.network.unlockSends(string);
            throw new Exception(throwable.getMessage());
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final void commProtectedRun(Object object, Context context) throws Exception {
        if (this.address < 0 || this.address >= 250) throw new Exception("Invalid address information!");
        MbusLongFrameMessage mbusLongFrameMessage = new MbusLongFrameMessage();
        mbusLongFrameMessage.setMessageBaudRate(this.device.getBaudRate());
        mbusLongFrameMessage.setCFieldNoFcb(67);
        if (this.device == null) {
            mbusLongFrameMessage.setAField(254);
        } else {
            if (this.device.getAddressMode() != BMbusAddressing.primary) {
                MbusSndUdMessage mbusSndUdMessage = new MbusSndUdMessage(this.device, this.network);
                mbusSndUdMessage.setMessageBaudRate(this.device.getBaudRate());
                long l = MBusTxTimings.calculateTxRxTime((long)2, (BBaudRate)this.device.getBaudRate());
                MbusResponseMessage mbusResponseMessage = (MbusResponseMessage)this.network.sendMBusSync(this.device.getTxTimingsReference(), object, mbusSndUdMessage, l += MBusTxTimings.calculateTxRxTime(mbusSndUdMessage, (BBaudRate)this.device.getBaudRate()));
                if (mbusResponseMessage != null && mbusResponseMessage.getCollisionDetected()) {
                    this.log().failed(MbusToolkit.getText("BMbusGeneral.busSelectionFailure") + ' ' + this.address);
                    this.setJobState(BJobState.failed);
                    throw new Exception("Bus collision detected on secondary address selection");
                }
                this.device.setFcBitState(true);
                mbusLongFrameMessage.setAField(253);
            } else {
                mbusLongFrameMessage.setAField(this.device.getPrimaryAddress());
            }
            if (this.device.getFcBitInUse()) {
                mbusLongFrameMessage.setCFieldNoFcb(83);
            }
        }
        mbusLongFrameMessage.setCiField(81);
        byte[] byArray = new byte[]{1, 122, (byte)this.address};
        mbusLongFrameMessage.setBytes(byArray);
        Message message = null;
        long l = MBusTxTimings.calculateTxRxTime((long)2, (BBaudRate)this.device.getBaudRate());
        message = this.network.sendMBusSync(this.device.getTxTimingsReference(), object, mbusLongFrameMessage, l += MBusTxTimings.calculateTxRxTime(mbusLongFrameMessage, (BBaudRate)this.device.getBaudRate()));
        if (message != null && message.getSuccessfulResponse()) {
            this.log().success(MbusToolkit.getText("MbusAssignAddressJob.initialSuccess"));
        } else {
            this.log().message(MbusToolkit.getText("MbusAssignAddressJob.noConfirmationOfSuccess"));
        }
        MbusReqUd2Message mbusReqUd2Message = new MbusReqUd2Message(this.address);
        mbusReqUd2Message.setMessageBaudRate(this.device.getBaudRate());
        long l2 = MBusTxTimings.calculateTxRxTime(261L, (BBaudRate)this.device.getBaudRate());
        message = this.network.sendMBusSync(this.device.getTxTimingsReference(), object, mbusReqUd2Message, l2 += MBusTxTimings.calculateTxRxTime(mbusLongFrameMessage, (BBaudRate)this.device.getBaudRate()));
        if (message != null) {
            this.log().success(MbusToolkit.getText("MbusAssignAddressJob.success") + ' ' + this.address);
            if (this.device != null) {
                this.device.setPrimaryAddress(this.address);
            }
        } else {
            this.log().failed(MbusToolkit.getText("MbusAssignAddressJob.failed") + ' ' + this.address);
            this.setJobState(BJobState.failed);
            return;
        }
        this.setJobState(BJobState.success);
    }

    public final void success() {
        if (this.getJobState() == BJobState.success) {
            this.log().success("Job Success");
            this.complete(BJobState.success);
        } else {
            this.complete(BJobState.failed);
        }
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final /* synthetic */ void this() {
        this.network = null;
        this.device = null;
        this.address = 0;
    }

    public BMbusAssignAddressJob() {
        this.this();
    }

    public BMbusAssignAddressJob(BAbstractMbusNetwork bAbstractMbusNetwork, int n, BMbusDevice bMbusDevice) {
        this.this();
        this.network = bAbstractMbusNetwork;
        this.address = n;
        this.device = bMbusDevice;
    }

    static {
        Class clazz = class$com$tridium$mbus$jobs$BMbusAssignAddressJob;
        if (clazz == null) {
            clazz = class$com$tridium$mbus$jobs$BMbusAssignAddressJob = BMbusAssignAddressJob.class("[Lcom.tridium.mbus.jobs.BMbusAssignAddressJob;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
    }
}

