/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.mbus.comm;

import com.tridium.basicdriver.BBasicNetwork;
import com.tridium.basicdriver.comm.Comm;
import com.tridium.basicdriver.comm.CommReceiver;
import com.tridium.basicdriver.comm.CommTransmitter;
import com.tridium.basicdriver.message.Message;
import com.tridium.basicdriver.message.ReceivedMessage;
import com.tridium.basicdriver.util.BasicException;
import com.tridium.mbus.BAbstractMbusNetwork;
import com.tridium.mbus.BMbusTcpIpNetwork;
import com.tridium.mbus.comm.IMbusComm;
import com.tridium.mbus.comm.MbusCommUtil;
import com.tridium.platform.BOperatingSystemEnum;
import com.tridium.platform.tcpip.BPingArgs;
import com.tridium.platform.tcpip.BTcpIpPlatformService;
import java.net.Socket;
import java.net.SocketException;
import javax.baja.net.BInternetAddress;
import javax.baja.sys.BInteger;
import javax.baja.sys.BRelTime;
import javax.baja.sys.Clock;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class MbusSocketComm
extends Comm
implements IMbusComm {
    private Object socketRestartLock;
    private long ticksOfLastSocketRestart;
    private Socket socket;
    private Thread rxThread;
    private ISocketAddressHolder socketAddressHolder;
    private long lastSentMessageTicks;
    private long lastRecvMessageTicks;

    protected boolean started() throws Exception {
        try {
            this.reopenSocket();
            if (this.rxThread != null) {
                this.rxThread.interrupt();
            }
            this.rxThread = new Thread((Runnable)this.getCommReceiver(), "MbusTcpIpSocketRcv:" + this.getNetwork().getName());
            this.getCommReceiver().setAlive(true);
            this.rxThread.start();
            this.rxThread.setPriority(5);
        }
        catch (Exception exception) {
            String string = "Error opening and configuring the socket";
            this.getNetwork().getLog().error(string, (Throwable)exception);
            if (this.socket != null) {
                try {
                    this.socket.close();
                }
                catch (Exception exception2) {
                    this.getNetwork().getLog().error("Unable to close socket", (Throwable)exception2);
                }
            }
            throw exception;
        }
        return true;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void stopped() throws Exception {
        this.getCommReceiver().setAlive(false);
        if (this.getCommReceiver() != null && this.rxThread != null) {
            this.rxThread.interrupt();
        }
        if (this.socket == null) return;
        try {
            try {
                this.socket.close();
            }
            catch (Exception exception) {
                this.getNetwork().getLog().error("Unable to close socket", (Throwable)exception);
            }
        }
        catch (Throwable throwable) {
            Object var2_3 = null;
            this.socket = null;
            throw throwable;
        }
        {
            Object var2_4 = null;
            this.socket = null;
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void reopenSocket() throws BasicException {
        Object object = this.socketRestartLock;
        synchronized (object) {
            this.ticksOfLastSocketRestart = Clock.ticks();
            try {
                BInternetAddress bInternetAddress = this.socketAddressHolder.getInternetAddress();
                BAbstractMbusNetwork bAbstractMbusNetwork = (BAbstractMbusNetwork)this.getNetwork();
                if (bAbstractMbusNetwork != null && bAbstractMbusNetwork instanceof BMbusTcpIpNetwork && this.attemptDeviceIcmpPingAllowed()) {
                    if (((BMbusTcpIpNetwork)bAbstractMbusNetwork).getPingPreConnect() && !this.icmpPing(bInternetAddress.getHost().toString())) {
                        throw new BasicException("Could not ping TCP/IP gateway @ " + bInternetAddress.getHost().toString());
                    }
                    if (((BMbusTcpIpNetwork)this.getNetwork()).getFaultCause().startsWith("Could not ping TCP/IP gateway")) {
                        this.getNetwork().setFaultCause("");
                    }
                }
                if (this.socket != null) {
                    this.socket.close();
                }
                this.socket = new Socket(bInternetAddress.getAddress(), bInternetAddress.getPort());
                this.socket.setKeepAlive(true);
                this.getCommReceiver().setInputStream(this.socket.getInputStream());
                this.getCommTransmitter().setOutputStream(this.socket.getOutputStream());
                this.getNetwork().pingOk();
            }
            catch (Exception exception) {
                this.getNetwork().pingFail("Error reopening/reconfiguring the socket " + exception.getMessage());
                this.getNetwork().getLog().error("Error reopening/reconfiguring the socket", (Throwable)exception);
                if (this.socket != null) {
                    try {
                        this.socket.close();
                    }
                    catch (Exception exception2) {
                        this.getNetwork().getLog().error("Unable to close socket after reopen", (Throwable)exception2);
                    }
                }
                this.getNetwork().pingFail("Could not establish TCP/IP communications");
                throw new BasicException(exception.getMessage(), (Throwable)exception);
            }
            return;
        }
    }

    public void onReceiveError(Exception exception) {
        this.reopenSocket();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Message transmit(Message message, BRelTime bRelTime, int n) throws BasicException {
        try {
            return MbusCommUtil.transmit(this, message, bRelTime, n);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            if (exception instanceof SocketException) {
                Object object = this.socketRestartLock;
                synchronized (object) {
                    if (Clock.ticks() - 1000L > this.ticksOfLastSocketRestart) {
                        try {
                            if (this.socket != null) {
                                this.socket.close();
                            }
                        }
                        catch (Throwable throwable) {}
                    }
                }
            }
            if (exception instanceof BasicException) {
                throw (BasicException)((Object)exception);
            }
            return null;
        }
    }

    public void receive(ReceivedMessage receivedMessage) {
        this.lastRecvMessageTicks = Clock.ticks();
        super.receive(receivedMessage);
    }

    public long getLastMessageTicks() {
        return Math.max(this.lastRecvMessageTicks, this.lastSentMessageTicks);
    }

    public void messageSent() {
        this.lastSentMessageTicks = Clock.ticks();
    }

    public void performNetworkInterMessageDelay() {
        MbusCommUtil.performNetworkInterMessageDelay(this);
    }

    public Message processNetworkTransmit(Message message, BRelTime bRelTime) throws BasicException {
        return this.processTransmit(message, bRelTime);
    }

    public boolean attemptDeviceIcmpPingAllowed() {
        return BOperatingSystemEnum.isOS((BOperatingSystemEnum)BOperatingSystemEnum.qnx) || BOperatingSystemEnum.isOS((BOperatingSystemEnum)BOperatingSystemEnum.windows);
    }

    public boolean icmpPing() {
        BInternetAddress bInternetAddress = this.socketAddressHolder.getInternetAddress();
        return this.icmpPing(bInternetAddress.getHost().toString());
    }

    public boolean icmpPing(String string) {
        BTcpIpPlatformService bTcpIpPlatformService = (BTcpIpPlatformService)Sys.getService((Type)BTcpIpPlatformService.TYPE);
        bTcpIpPlatformService.lease();
        try {
            BInteger bInteger = bTcpIpPlatformService.ping(new BPingArgs(string, 1));
            boolean bl = false;
            if (bInteger.getInt() >= 0) {
                bl = true;
            }
            return bl;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return false;
        }
    }

    private final /* synthetic */ void this() {
        this.socketRestartLock = new Object();
        this.ticksOfLastSocketRestart = Long.MIN_VALUE;
        this.socket = null;
        this.rxThread = null;
        this.socketAddressHolder = null;
        this.lastSentMessageTicks = 0L;
        this.lastRecvMessageTicks = 0L;
    }

    public MbusSocketComm(BBasicNetwork bBasicNetwork, CommReceiver commReceiver, CommTransmitter commTransmitter, ISocketAddressHolder iSocketAddressHolder) {
        super(bBasicNetwork, commReceiver, commTransmitter);
        this.this();
        this.socketAddressHolder = iSocketAddressHolder;
    }

    public static interface ISocketAddressHolder {
        public BInternetAddress getInternetAddress();
    }
}

