/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.mbus.comm;

import com.tridium.basicdriver.comm.Comm;
import com.tridium.basicdriver.comm.CommReceiver;
import com.tridium.basicdriver.comm.CommTransmitter;
import com.tridium.basicdriver.message.Message;
import com.tridium.basicdriver.message.ReceivedMessage;
import com.tridium.basicdriver.serial.BSerialNetwork;
import com.tridium.basicdriver.serial.SerialComm;
import com.tridium.basicdriver.util.BasicException;
import com.tridium.mbus.BAbstractMbusNetwork;
import com.tridium.mbus.comm.IMbusComm;
import com.tridium.mbus.comm.MbusCommReceiver;
import com.tridium.mbus.comm.MbusCommTransmitter;
import com.tridium.mbus.comm.MbusCommUtil;
import javax.baja.sys.BRelTime;
import javax.baja.sys.Clock;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public final class MbusSerialComm
extends SerialComm
implements IMbusComm {
    private BAbstractMbusNetwork mbusNetwork;
    private long lastSentMessageTicks;
    private long lastRecvTicks;

    public final Message transmit(Message message, BRelTime bRelTime, int n) throws BasicException {
        return MbusCommUtil.transmit((Comm)this, message, bRelTime, n);
    }

    public final void receive(ReceivedMessage receivedMessage) {
        this.setReceivedMessageTicks(Clock.ticks());
        this.lastRecvTicks = Clock.ticks();
        super.receive(receivedMessage);
    }

    public final BAbstractMbusNetwork getCommsNetwork() {
        return this.mbusNetwork;
    }

    public final void messageSent() {
        this.lastSentMessageTicks = Clock.ticks();
    }

    public final void performNetworkInterMessageDelay() {
        MbusCommUtil.performNetworkInterMessageDelay((Comm)this);
    }

    public final Message processNetworkTransmit(Message message, BRelTime bRelTime) throws BasicException {
        return this.processTransmit(message, bRelTime);
    }

    public final long getLastMessageTicks() {
        return Math.max(this.lastRecvTicks, this.lastSentMessageTicks);
    }

    private final /* synthetic */ void this() {
        this.mbusNetwork = null;
        this.lastSentMessageTicks = 0L;
        this.lastRecvTicks = 0L;
    }

    public MbusSerialComm(BAbstractMbusNetwork bAbstractMbusNetwork, MbusCommReceiver mbusCommReceiver, MbusCommTransmitter mbusCommTransmitter) {
        super((BSerialNetwork)bAbstractMbusNetwork, (CommReceiver)mbusCommReceiver, (CommTransmitter)mbusCommTransmitter);
        this.this();
        this.mbusNetwork = bAbstractMbusNetwork;
    }
}

