/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.mbus.comm;

import com.tridium.basicdriver.comm.Comm;
import com.tridium.basicdriver.message.Message;
import com.tridium.basicdriver.serial.BSerialNetwork;
import com.tridium.basicdriver.util.BasicException;
import com.tridium.mbus.BAbstractMbusNetwork;
import com.tridium.mbus.comm.IMbusComm;
import com.tridium.mbus.comm.MbusSocketComm;
import com.tridium.mbus.enums.BMbusBaudRate;
import com.tridium.mbus.messages.MbusMessage;
import javax.baja.serial.BBaudRate;
import javax.baja.serial.BSerialHelper;
import javax.baja.sys.BRelTime;
import javax.baja.sys.Clock;

public final class MbusCommUtil {
    public static final long MIN_SLEEP_TIME = 20L;

    public static final Message transmit(Comm comm, Message message, BRelTime bRelTime, int n) throws BasicException {
        MbusMessage mbusMessage;
        if (message == null) {
            return null;
        }
        if (message instanceof MbusMessage && !(comm instanceof MbusSocketComm)) {
            mbusMessage = (MbusMessage)message;
            if (comm.isCommStarted()) {
                BSerialHelper bSerialHelper = ((BSerialNetwork)comm.getNetwork()).getSerialPortConfig();
                BMbusBaudRate bMbusBaudRate = (BMbusBaudRate)bSerialHelper.getBaudRate();
                BMbusBaudRate bMbusBaudRate2 = mbusMessage.getMessageBaudRate();
                if (!bMbusBaudRate2.equals((Object)bMbusBaudRate)) {
                    bSerialHelper.setBaudRate((BBaudRate)bMbusBaudRate2);
                }
            }
        }
        ((IMbusComm)comm).performNetworkInterMessageDelay();
        mbusMessage = MbusCommUtil.performTransmit(comm, message, bRelTime, n);
        return mbusMessage;
    }

    public static final void performNetworkInterMessageDelay(Comm comm) {
        MbusCommUtil.performNetworkInterMessageDelay(comm, 20L);
    }

    public static final void performNetworkInterMessageDelay(Comm comm, long l) {
        long l2 = ((BAbstractMbusNetwork)comm.getNetwork()).getActiveTxTimings().intermessageDelay;
        long l3 = ((IMbusComm)comm).getLastMessageTicks();
        if (l3 <= 0L) {
            return;
        }
        long l4 = Clock.ticks() - l3;
        long l5 = Math.max(l - l4, l2 - l4);
        if (l5 > 0L) {
            try {
                Thread.sleep(l5);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    private static final Message performTransmit(Comm comm, Message message, BRelTime bRelTime, int n) throws BasicException {
        if (!message.getResponseExpected()) {
            comm.transmitNoResponse(message);
            return null;
        }
        BasicException basicException = null;
        Message message2 = null;
        try {
            int n2 = 0;
            while (n2 < n + 1) {
                message2 = ((IMbusComm)comm).processNetworkTransmit(message, bRelTime);
                if (message2 != null && message2.getSuccessfulResponse()) break;
                ++n2;
            }
            if (message2 != null && !message2.getSuccessfulResponse()) {
                String string = "Unsuccessful response for request message sent.";
                basicException = new BasicException(string);
            }
        }
        catch (BasicException basicException2) {
            basicException = basicException2;
        }
        if (basicException != null) {
            if (basicException instanceof BasicException) {
                if (comm.getNetwork().getLog().isTraceOn()) {
                    comm.getNetwork().getLog().trace("Comm sendRequest exception: ", (Throwable)basicException);
                }
            } else {
                throw basicException;
            }
        }
        return message2;
    }
}

