/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.mbus.comm;

import com.tridium.basicdriver.comm.CommReceiver;
import com.tridium.basicdriver.message.Message;
import com.tridium.basicdriver.message.ReceivedMessage;
import com.tridium.mbus.comm.MbusSocketComm;
import com.tridium.mbus.messages.MbusMessage;
import com.tridium.mbus.messages.MbusReceivedMessage;
import com.tridium.mbus.messages.MbusReqUd1Message;
import com.tridium.mbus.messages.MbusReqUd2Message;
import com.tridium.mbus.utils.MbusCrcGenerator;
import com.tridium.mbus.utils.MbusToolkit;
import java.net.SocketException;
import javax.baja.log.Log;
import javax.baja.sys.BRelTime;
import javax.baja.sys.Clock;
import javax.baja.util.ByteArrayUtil;
import javax.baja.util.TextUtil;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public final class MbusCommReceiver
extends CommReceiver {
    private byte[] collisionDetectionCharacters;
    private boolean rcv_done;
    private MbusReceivedMessage rcv_msg;
    private byte[] rcv_messageInput;
    private boolean rcv_responseOk;
    private boolean smi_done;
    private boolean smi_firstChar;
    private int smi_length;
    private boolean smi_lengthNextChar;
    private int smi_charIn;
    private boolean smi_newChar;
    private byte[] smi_inputBuffer;
    private int smi_numberOfBytesInput;
    private byte[] smi_byteMessage;
    private boolean streamPositionRecovery;
    private long lastCharReadTicks;
    private Object resetRequestLock;
    private boolean resetRequested;
    private long resetRequestedTicks;
    private long lastEOFMarkerTicks;
    private Object messageSentLock;
    private long maxDataReceivedGapTimeMs;
    MbusMessage sentMessage;
    private Log rawLog;

    public final void setCollisionHexBytes(String string) {
        block17: {
            if (this.rawLog.isTraceOn()) {
                this.rawLog.trace("Loading collision detection data from \"" + string + '\"');
            }
            if (string == null || string.trim().length() == 0) {
                return;
            }
            try {
                try {
                    this.collisionDetectionCharacters = this.getHexToBytes(string, ',');
                }
                catch (Exception exception) {}
                if (this.collisionDetectionCharacters.length == 0) {
                    try {
                        this.collisionDetectionCharacters = this.getHexToBytes(string, ';');
                    }
                    catch (Exception exception) {}
                }
                if (this.collisionDetectionCharacters.length == 0) {
                    try {
                        this.collisionDetectionCharacters = this.getHexToBytes(string, '\t');
                    }
                    catch (Exception exception) {}
                }
                if (this.collisionDetectionCharacters.length == 0) {
                    try {
                        this.collisionDetectionCharacters = this.getHexToBytes(string, ' ');
                    }
                    catch (Exception exception) {}
                }
                if (this.rawLog.isTraceOn()) {
                    int n = 0;
                    while (n < this.collisionDetectionCharacters.length) {
                        this.rawLog.trace("Collision detection character loaded - [" + n + "] = 0x" + TextUtil.byteToHexString((int)this.collisionDetectionCharacters[n]));
                        ++n;
                    }
                }
            }
            catch (Throwable throwable) {
                if (!this.rawLog.isLoggable(3)) break block17;
                this.rawLog.error("Issue when loading collisionHexBytes for receiver with value \"\"", throwable);
            }
        }
    }

    private final byte[] getHexToBytes(String string, char c) throws Exception {
        byte[] byArray = null;
        String[] stringArray = TextUtil.split((String)string, (char)c);
        byArray = new byte[stringArray.length];
        int n = 0;
        while (n < stringArray.length) {
            stringArray[n] = stringArray[n].trim();
            if (stringArray[n].startsWith("0x")) {
                stringArray[n] = stringArray[n].substring(2);
            }
            if (stringArray[n].length() > 2) {
                throw new Exception("Value is longer than 1 byte in hex - invalid entry");
            }
            stringArray[n] = stringArray[n].toUpperCase();
            int n2 = 0;
            while (n2 < stringArray[n].length()) {
                if (!(stringArray[n].charAt(n2) >= '0' && stringArray[n].charAt(n2) <= '9' || stringArray[n].charAt(n2) >= 'A' && stringArray[n].charAt(n2) <= 'F')) {
                    throw new Exception("Outside valid ASCII Range - \"" + stringArray[n] + '\"');
                }
                ++n2;
            }
            byArray[n] = (byte)(Integer.parseInt(stringArray[n], 16) & 0xFF);
            ++n;
        }
        return byArray;
    }

    public final void initReceiveState(byte[] byArray) {
    }

    public final void initReceiveState(Message message) {
    }

    protected final ReceivedMessage receive() throws Exception {
        int n;
        Object object;
        if (this.rawLog.isTraceOn()) {
            this.rawLog.trace("receive()");
        }
        this.rcv_responseOk = false;
        this.rcv_done = false;
        this.rcv_msg = null;
        this.rcv_messageInput = null;
        if (MbusToolkit.isTraceOn()) {
            MbusToolkit.trace("MessageSent In Receive = " + (this.sentMessage != null ? ByteArrayUtil.toHexString((byte[])this.sentMessage.getBytes()) : "null"));
        }
        boolean bl = false;
        while (!this.rcv_done) {
            this.rcv_responseOk = false;
            this.rcv_messageInput = this.getSingleMessageInput();
            if (this.rcv_messageInput == null) {
                if (MbusToolkit.isTraceOn()) {
                    MbusToolkit.trace("Comm receiver shutdown");
                }
                return null;
            }
            if (MbusToolkit.isTraceOn()) {
                MbusToolkit.trace("Single Message Input = " + (this.sentMessage != null ? ByteArrayUtil.toHexString((byte[])this.sentMessage.getBytes()) : "null"));
            }
            if (this.sentMessage != null && (this.sentMessage instanceof MbusReqUd1Message || this.sentMessage instanceof MbusReqUd2Message) && this.rcv_messageInput[0] == 104) {
                this.rcv_done = true;
                if (!MbusToolkit.isTraceOn()) continue;
                MbusToolkit.trace("UD1 or UD2, with input beginning 0x68 found");
                continue;
            }
            if (this.sentMessage != null && !(this.sentMessage instanceof MbusReqUd1Message) && !(this.sentMessage instanceof MbusReqUd2Message)) {
                if (MbusToolkit.isTraceOn()) {
                    MbusToolkit.trace("Sent message not UD1 or UD2");
                }
                object = new String(this.rcv_messageInput);
                String string = new String(this.sentMessage.getBytes());
                if (string.equals(object)) {
                    if (MbusToolkit.isTraceOn()) {
                        MbusToolkit.trace("Echo response received");
                    }
                    this.rcv_messageInput = new byte[1];
                    this.rcv_messageInput[0] = -27;
                    this.rcv_done = true;
                    this.rcv_responseOk = true;
                    continue;
                }
                if (this.rcv_messageInput[0] == -27) {
                    if (MbusToolkit.isTraceOn()) {
                        MbusToolkit.trace("0xE5 received, NOT from a UD1 or UD2");
                    }
                    this.rcv_done = true;
                    this.rcv_responseOk = true;
                    continue;
                }
                n = 0;
                while (n < this.collisionDetectionCharacters.length) {
                    if (this.rcv_messageInput[0] == this.collisionDetectionCharacters[n]) {
                        if (MbusToolkit.isTraceOn()) {
                            MbusToolkit.trace("Received collision detection marker 0x" + TextUtil.byteToHexString((int)this.rcv_messageInput[0]));
                        }
                        bl = true;
                        this.rcv_done = true;
                        this.rcv_responseOk = true;
                    }
                    ++n;
                }
                continue;
            }
            if (this.rcv_messageInput[0] != -27) continue;
            if (MbusToolkit.isTraceOn()) {
                MbusToolkit.trace("0xE5 received");
            }
            this.rcv_done = true;
            this.rcv_responseOk = true;
        }
        if (this.rcv_messageInput != null && this.rcv_messageInput.length > 0 && this.rcv_messageInput[0] == -27 && MbusToolkit.isTraceOn()) {
            MbusToolkit.trace("0xE5 received");
        }
        this.rcv_msg = new MbusReceivedMessage(this.rcv_messageInput);
        this.rcv_msg.setSuccessfulResponse(this.rcv_responseOk);
        if (bl) {
            this.rcv_msg.setCollisionFlag(true);
        }
        if (this.rcv_messageInput.length > 4) {
            object = this.rcv_msg.getBytes();
            byte by = object[((byte[])object).length - 2];
            if (by != (n = MbusCrcGenerator.mBus(this.rcv_msg.getBytes()))) {
                this.rcv_msg.setSuccessfulResponse(false);
                if (MbusToolkit.isTraceOn()) {
                    MbusToolkit.trace("Input Chksum= " + by + " Should be= " + n);
                    int n2 = 0;
                    while (n2 < this.rcv_msg.getLength()) {
                        MbusToolkit.trace("index = " + n2 + " value = " + object[n2] + " raw value = " + object[n2] + " char = '" + (char)object[n2] + '\'');
                        ++n2;
                    }
                }
            } else {
                this.rcv_msg.setSuccessfulResponse(true);
                this.messageSent(null);
            }
        }
        return this.rcv_msg;
    }

    private final void resetSingleMessageInputVariables() {
        this.smi_done = false;
        this.smi_firstChar = true;
        this.smi_length = 4;
        this.smi_lengthNextChar = false;
        this.smi_charIn = -1;
        this.smi_newChar = false;
        this.smi_numberOfBytesInput = 0;
        this.smi_byteMessage = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final byte[] getSingleMessageInput() throws Exception {
        this.resetSingleMessageInputVariables();
        int n = -1;
        try {
            while (true) {
                block39: {
                    block36: {
                        block35: {
                            block38: {
                                block37: {
                                    if (this.smi_done) {
                                        if (this.smi_numberOfBytesInput <= 0) return this.smi_byteMessage;
                                        this.smi_byteMessage = new byte[this.smi_numberOfBytesInput];
                                        System.arraycopy(this.smi_inputBuffer, 0, this.smi_byteMessage, 0, this.smi_numberOfBytesInput);
                                        return this.smi_byteMessage;
                                    }
                                    if (this.getInputStream() == null) {
                                        if (!this.isAlive()) {
                                            return null;
                                        }
                                        Thread.sleep(1000L);
                                        continue;
                                    }
                                    this.smi_charIn = this.getInputStream().read();
                                    boolean bl = false;
                                    if (this.smi_charIn != -1) {
                                        bl = true;
                                    }
                                    this.smi_newChar = bl;
                                    this.smi_charIn &= 0xFF;
                                    if (!this.smi_newChar) break block36;
                                    Object object = this.resetRequestLock;
                                    synchronized (object) {
                                        if (this.resetRequested) {
                                            if (this.lastCharReadTicks + this.maxDataReceivedGapTimeMs < this.resetRequestedTicks && !this.smi_firstChar) {
                                                this.smi_done = false;
                                                this.smi_firstChar = true;
                                                this.smi_length = 4;
                                                this.smi_lengthNextChar = false;
                                                this.smi_numberOfBytesInput = 0;
                                                this.smi_byteMessage = null;
                                                n = -1;
                                                if (this.rawLog.isLoggable(2)) {
                                                    this.rawLog.warning("Reception system reset - mid-frame reading - last byte read outside of expected time tollerance");
                                                }
                                            }
                                            this.resetRequested = false;
                                        }
                                    }
                                    this.lastCharReadTicks = Clock.ticks();
                                    if (this.rawLog.isTraceOn()) {
                                        this.rawLog.trace("RX : 0x" + TextUtil.byteToHexString((int)this.smi_charIn) + " [" + this.lastCharReadTicks + ']');
                                    }
                                    if (!this.smi_firstChar) break block37;
                                    if (this.rawLog.isTraceOn()) {
                                        this.rawLog.trace("Reading first character of response");
                                    }
                                    this.smi_firstChar = false;
                                    if (this.smi_charIn == 229) {
                                        this.smi_length = 1;
                                        this.smi_done = true;
                                        this.smi_numberOfBytesInput = 1;
                                        this.smi_inputBuffer[0] = (byte)this.smi_charIn;
                                        break block35;
                                    } else if (!this.streamPositionRecovery) {
                                        switch (this.smi_charIn) {
                                            case 16: {
                                                this.smi_length = 5;
                                                break;
                                            }
                                            case 104: {
                                                this.smi_lengthNextChar = true;
                                                break;
                                            }
                                            default: {
                                                this.smi_length = 1;
                                                this.smi_done = true;
                                                this.smi_numberOfBytesInput = 1;
                                                this.smi_inputBuffer[0] = (byte)this.smi_charIn;
                                                break;
                                            }
                                        }
                                        break block35;
                                    } else {
                                        switch (this.smi_charIn) {
                                            case 104: {
                                                this.smi_lengthNextChar = true;
                                                break;
                                            }
                                            default: {
                                                this.smi_length = 1;
                                                this.smi_done = true;
                                                this.smi_numberOfBytesInput = 1;
                                                this.smi_inputBuffer[0] = (byte)this.smi_charIn;
                                                break;
                                            }
                                        }
                                    }
                                    break block35;
                                }
                                if (!this.smi_lengthNextChar) break block35;
                                if (n == -1) break block38;
                                if ((n & 0xFF) == this.smi_charIn) {
                                    this.smi_lengthNextChar = false;
                                    this.smi_length = this.smi_charIn + 6;
                                    this.streamPositionRecovery = false;
                                    if (this.rawLog.isTraceOn()) {
                                        this.rawLog.trace("First / Second length check matched: 0x" + TextUtil.byteToHexString((int)this.smi_charIn));
                                    }
                                    break block35;
                                } else {
                                    if (this.rawLog.isLoggable(2)) {
                                        this.rawLog.warning("First / Second length check failed: 0x" + TextUtil.byteToHexString((int)this.smi_charIn) + " != " + TextUtil.byteToHexString((int)(n & 0xFF)));
                                    }
                                    this.streamPositionRecovery = true;
                                    this.resetSingleMessageInputVariables();
                                    n = -1;
                                    continue;
                                }
                            }
                            n = this.smi_charIn;
                        }
                        this.smi_inputBuffer[this.smi_numberOfBytesInput] = (byte)this.smi_charIn;
                        ++this.smi_numberOfBytesInput;
                        if (this.smi_numberOfBytesInput < this.smi_length) continue;
                        break block39;
                    }
                    if (!this.isAlive()) {
                        return null;
                    }
                    if (this.lastEOFMarkerTicks > Clock.ticks() - 100L) {
                        Thread.sleep(1000L);
                        if (!this.rawLog.isTraceOn()) continue;
                        this.rawLog.trace("Reception EOF Protection Complete");
                        continue;
                    }
                    this.lastEOFMarkerTicks = Clock.ticks();
                    continue;
                }
                this.smi_done = true;
                if (!this.rawLog.isTraceOn()) continue;
                this.rawLog.trace("Read required number of bytes " + this.smi_length);
            }
        }
        catch (SocketException socketException) {
            try {
                Thread.sleep(5000L);
                if (MbusToolkit.isTraceOn()) {
                    MbusToolkit.trace("Comm receiver Socket Exception " + socketException);
                }
                if (!this.isAlive()) return this.smi_byteMessage;
                ((MbusSocketComm)this.getComm()).onReceiveError(socketException);
                return this.smi_byteMessage;
            }
            catch (InterruptedException interruptedException) {
                if (!MbusToolkit.isTraceOn()) return null;
                MbusToolkit.trace("Comm receiver interrupted during msg read");
                return null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected final void messagePendingTx() {
        Object object = this.resetRequestLock;
        synchronized (object) {
            this.resetRequested = true;
            this.resetRequestedTicks = Clock.ticks();
        }
        if (this.rawLog.isTraceOn()) {
            this.rawLog.trace("Pre-Dispatch Message Rcvr Notification [" + this.resetRequestedTicks + ']');
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void setReceiveBufferTimeout(BRelTime bRelTime) {
        Object object = this.resetRequestLock;
        synchronized (object) {
            this.maxDataReceivedGapTimeMs = bRelTime.getMillis();
        }
        if (this.rawLog.isTraceOn()) {
            this.rawLog.trace("Maximum time gap since last byte received for buffer reset = " + bRelTime.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected final void messageSent(MbusMessage mbusMessage) {
        Object object = this.messageSentLock;
        synchronized (object) {
            this.sentMessage = mbusMessage;
        }
        if (this.rawLog.isTraceOn()) {
            this.rawLog.trace("MessageSent Output = " + (this.sentMessage != null ? ByteArrayUtil.toHexString((byte[])this.sentMessage.getBytes()) : "null"));
        }
    }

    private final /* synthetic */ void this() {
        this.collisionDetectionCharacters = new byte[0];
        this.rcv_done = false;
        this.rcv_msg = null;
        this.rcv_messageInput = null;
        this.rcv_responseOk = false;
        this.smi_done = false;
        this.smi_firstChar = true;
        this.smi_length = 4;
        this.smi_lengthNextChar = false;
        this.smi_charIn = -1;
        this.smi_newChar = false;
        this.smi_inputBuffer = new byte[300];
        this.smi_numberOfBytesInput = 0;
        this.smi_byteMessage = null;
        this.streamPositionRecovery = false;
        this.lastCharReadTicks = 0L;
        this.resetRequestLock = new Object();
        this.resetRequested = false;
        this.resetRequestedTicks = 0L;
        this.lastEOFMarkerTicks = Long.MIN_VALUE;
        this.messageSentLock = new Object();
        this.maxDataReceivedGapTimeMs = 1000L;
        this.sentMessage = null;
        this.rawLog = Log.getLog((String)"MBusNetwork_RAW_INPUT");
    }

    public MbusCommReceiver() {
        this.this();
    }
}

