/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.mbus.comm;

import com.tridium.mbus.messages.MbusMessage;
import javax.baja.serial.BBaudRate;
import javax.baja.sys.BRelTime;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class MBusTxTimings {
    public long intermessageDelay;
    public BRelTime responseTimeout;
    public BRelTime initalisationDelay;
    public int retryTransmission;

    public boolean timingsMatch(MBusTxTimings mBusTxTimings) {
        boolean bl = false;
        if (mBusTxTimings.intermessageDelay == this.intermessageDelay && mBusTxTimings.initalisationDelay == this.initalisationDelay && mBusTxTimings.responseTimeout == this.responseTimeout && mBusTxTimings.retryTransmission == this.retryTransmission) {
            bl = true;
        }
        return bl;
    }

    public static long calculateTxRxTime(long l, BBaudRate bBaudRate) {
        return MBusTxTimings.calculateTxRxTime(l, bBaudRate.getOrdinal());
    }

    public static long calculateTxRxTime(MbusMessage mbusMessage, BBaudRate bBaudRate) {
        return MBusTxTimings.calculateTxRxTime((long)mbusMessage.getWriteBytesLength(), bBaudRate.getOrdinal());
    }

    public static long calculateTxRxTime(long l, long l2) {
        long l3 = (l *= 11L) / l2 * 1000L;
        l3 = (long)((double)l3 + (double)(l % l2) / (double)l2 * 1000.0);
        return l3;
    }

    public void applyInitialisationDelay() throws InterruptedException {
        long l = this.initalisationDelay.getMillis();
        if (l < 1L) {
            return;
        }
        Thread.sleep(l);
    }

    private final /* synthetic */ void this() {
        this.intermessageDelay = 12000L;
        this.responseTimeout = BRelTime.makeSeconds((int)12);
        this.initalisationDelay = BRelTime.makeSeconds((int)1);
        this.retryTransmission = 0;
    }

    public MBusTxTimings() {
        this.this();
    }

    public MBusTxTimings(MBusTxTimings mBusTxTimings) {
        this.this();
        this.intermessageDelay = mBusTxTimings.intermessageDelay;
        this.initalisationDelay = BRelTime.make((long)mBusTxTimings.initalisationDelay.getMillis());
        this.responseTimeout = BRelTime.make((long)mBusTxTimings.responseTimeout.getMillis());
        this.retryTransmission = mBusTxTimings.retryTransmission;
    }
}

