/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.mbus;

import com.tridium.basicdriver.BBasicNetwork;
import com.tridium.basicdriver.comm.Comm;
import com.tridium.basicdriver.util.BasicException;
import com.tridium.mbus.BAbstractMbusNetwork;
import com.tridium.mbus.comm.MbusCommReceiver;
import com.tridium.mbus.comm.MbusCommTransmitter;
import com.tridium.mbus.comm.MbusSocketComm;
import com.tridium.mbus.utils.MbusToolkit;
import javax.baja.net.BInternetAddress;
import javax.baja.status.BStatus;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.Array;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public final class BMbusTcpIpNetwork
extends BAbstractMbusNetwork
implements MbusSocketComm.ISocketAddressHolder {
    public static final Property ipAddress = BMbusTcpIpNetwork.newProperty((int)0, (BValue)new BInternetAddress("192.168.1.10:6021"), null);
    public static final Property pingPreConnect = BMbusTcpIpNetwork.newProperty((int)8, (boolean)true, null);
    public static final Type TYPE;
    private Object startCommsLock;
    private volatile boolean commsStartAllowed;
    private volatile String startingUpForIp;
    static /* synthetic */ Class class$com$tridium$mbus$BMbusTcpIpNetwork;
    static /* synthetic */ Class class$javax$baja$sys$Type;

    public final BInternetAddress getIpAddress() {
        return (BInternetAddress)this.get(ipAddress);
    }

    public final void setIpAddress(BInternetAddress bInternetAddress) {
        this.set(ipAddress, (BValue)bInternetAddress, null);
    }

    public final boolean getPingPreConnect() {
        return this.getBoolean(pingPreConnect);
    }

    public final void setPingPreConnect(boolean bl) {
        this.setBoolean(pingPreConnect, bl, null);
    }

    public final Type getType() {
        return TYPE;
    }

    public final Type[] getServiceTypes() {
        Class clazz = class$javax$baja$sys$Type;
        if (clazz == null) {
            clazz = class$javax$baja$sys$Type = BMbusTcpIpNetwork.class("[Ljavax.baja.sys.Type;", false);
        }
        Array array = new Array(clazz);
        array.add((Object)this.getType());
        array.addAll((Object[])super.getServiceTypes());
        return (Type[])array.trim();
    }

    public final void started() throws Exception {
        this.startStationMonitorSaving();
        this.setFlags((Slot)ping, 8);
        this.setFlags((Slot)upload, 4);
        this.setFlags((Slot)download, 4);
    }

    public final void stopped() throws Exception {
        this.stopStationMonitorSaving();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void changed(Property var1_1, Context var2_2) {
        block18: {
            if (!this.isRunning()) break block18;
            if (BMbusTcpIpNetwork.ipAddress == var1_1) {
                if (this.getLog().isTraceOn()) {
                    this.getLog().trace(this.getName() + " *** Comm's restart in progress due to IP change ***");
                }
                try {
                    this.stopComm();
                }
                catch (Exception var3_3) {
                    this.getLog().error("Error attempting to change the IP address on this device", (Throwable)var3_3);
                }
            }
            if (BMbusTcpIpNetwork.status != var1_1 && BMbusTcpIpNetwork.ipAddress != var1_1) break block18;
            var3_4 = this.startCommsLock;
            synchronized (var3_4) {
                block17: {
                    if (!this.isDisabled()) break block17;
                    try {
                        this.stopComm();
                        this.startingUpForIp = null;
                    }
                    catch (Exception var5_5) {
                        if (this.getLog().isTraceOn()) {
                            var5_5.printStackTrace();
                        }
                    }
                    return;
                }
                if (this.startingUpForIp != null) {
                    return;
                }
                if (this.isFatalFault() || this.isCommActive() || this.getComm().isCommStarted()) ** GOTO lbl48
                this.startingUpForIp = this.getIpAddress().encodeToString();
                try {
                    try {
                        this.startCommunicationSystem();
                        this.startingUpForIp = null;
                    }
                    catch (Exception var7_7) {
                        if (this.getLog().isTraceOn()) {
                            this.getLog().error("Error start comms system", (Throwable)var7_7);
                        }
                        this.startingUpForIp = null;
                    }
                }
                catch (Throwable var5_6) {
                    var6_8 = null;
                    this.startingUpForIp = null;
                    throw var5_6;
                }
                {
                    var6_9 = null;
                    this.startingUpForIp = null;
lbl48:
                    // 2 sources

                    return;
                }
            }
        }
        super.changed(var1_1, var2_2);
    }

    public final void descendantsStarted() throws Exception {
        this.commsStartAllowed = true;
        if (this.getLog().isTraceOn()) {
            this.getLog().trace(this.getName() + " *** Comm's start allowed ***");
        }
        new Thread(new Runnable(){

            public final void run() {
                block2: {
                    try {
                        BMbusTcpIpNetwork.this.startComm();
                    }
                    catch (Throwable throwable) {
                        if (!BMbusTcpIpNetwork.this.getLog().isTraceOn()) break block2;
                        BMbusTcpIpNetwork.this.getLog().trace(BMbusTcpIpNetwork.this.getName() + " *** Comm's start fail at decendants started *** " + throwable.getMessage());
                    }
                }
            }
        }).start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void startComm() throws Exception {
        Object object = this.startCommsLock;
        synchronized (object) {
            block5: {
                if (this.isDisabled() || this.isFatalFault() || this.getComm() == null) break block5;
                try {
                    this.startCommunicationSystem();
                }
                catch (Exception exception) {
                    this.setFaultCause(exception.getMessage());
                    this.setStatus(BStatus.make((BStatus)this.getStatus(), (int)4, (boolean)true));
                    throw exception;
                }
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void stopComm() throws Exception {
        Object object = this.startCommsLock;
        synchronized (object) {
            Comm comm = this.getComm();
            if (comm != null && comm instanceof MbusSocketComm) {
                MbusSocketComm mbusSocketComm = (MbusSocketComm)comm;
                mbusSocketComm.stop();
            }
            return;
        }
    }

    public final void doPing() {
        if (!Sys.isStationStarted()) {
            return;
        }
        if (this.startingUpForIp != null) {
            return;
        }
        if (this.isDown()) {
            this.startingUpForIp = this.getIpAddress().encodeToString();
            try {
                this.stopComm();
                this.startCommunicationSystem();
                this.setFaultCause("");
                this.startingUpForIp = null;
            }
            catch (BasicException basicException) {
                this.pingFail(basicException.getMessage());
                this.startingUpForIp = null;
                return;
            }
            catch (Exception exception) {
                this.pingFail(exception.getMessage());
                this.startingUpForIp = null;
                return;
            }
        } else {
            MbusSocketComm mbusSocketComm = (MbusSocketComm)this.getComm();
            if (mbusSocketComm.attemptDeviceIcmpPingAllowed()) {
                if (this.getPingPreConnect() && !mbusSocketComm.icmpPing()) {
                    this.setFaultCause("Could not ping TCP/IP gateway");
                    this.pingFail("Could not ping TCP/IP gateway");
                    return;
                }
                if (((BMbusTcpIpNetwork)this.getNetwork()).getFaultCause().startsWith("Could not ping TCP/IP gateway")) {
                    this.getNetwork().setFaultCause("");
                }
            }
        }
        try {
            if (MbusToolkit.getLog().getLogName() != this.getNetwork().getLog().getLogName()) {
                MbusToolkit.setLog(this.getNetwork().getLog());
            }
        }
        catch (Throwable throwable) {}
        this.pingOk();
    }

    private final void startCommunicationSystem() throws Exception {
        if (this.getComm() == null) {
            if (this.getLog().isTraceOn()) {
                this.getLog().trace(this.getName() + " *** Comm's request ignored - currently null comm's link layer ***");
            }
            return;
        }
        if (!this.commsStartAllowed) {
            if (this.getLog().isTraceOn()) {
                this.getLog().trace(this.getName() + " *** Comm's start delayed until full network boot ***");
            }
            return;
        }
        if (this.getComm().isCommStarted()) {
            return;
        }
        if (this.getLog().isTraceOn()) {
            this.getLog().trace(this.getName() + " *** Starting Communication Handler - Socket Comm ***");
        }
        this.getComm().start();
        if (this.getLog().isTraceOn()) {
            this.getLog().trace(this.getName() + " *** Started Communication Handler - Socket Comm ***");
        }
    }

    protected final String checkSerialConfig() {
        return null;
    }

    protected final String getLicenseConnectTypeName() {
        return "tcpip";
    }

    protected final Comm makeComm() {
        MbusCommReceiver mbusCommReceiver = new MbusCommReceiver();
        mbusCommReceiver.setCollisionHexBytes(super.getCollisionCsvBytes());
        return new MbusSocketComm((BBasicNetwork)this, mbusCommReceiver, new MbusCommTransmitter(), this);
    }

    public final BInternetAddress getInternetAddress() {
        return this.getIpAddress();
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final /* synthetic */ void this() {
        this.startCommsLock = new Object();
        this.commsStartAllowed = false;
        this.startingUpForIp = null;
    }

    public BMbusTcpIpNetwork() {
        this.this();
        this.setFlags((Slot)serialPortConfig, 4);
        this.setFlags((Slot)searchBaudRate, 4);
    }

    static {
        Class clazz = class$com$tridium$mbus$BMbusTcpIpNetwork;
        if (clazz == null) {
            clazz = class$com$tridium$mbus$BMbusTcpIpNetwork = BMbusTcpIpNetwork.class("[Lcom.tridium.mbus.BMbusTcpIpNetwork;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
    }
}

