/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.mbus;

import com.tridium.basicdriver.BBasicDevice;
import com.tridium.basicdriver.message.Message;
import com.tridium.mbus.BAbstractMbusNetwork;
import com.tridium.mbus.BMbusConfig;
import com.tridium.mbus.BMbusDeviceFolder;
import com.tridium.mbus.BMbusNetwork;
import com.tridium.mbus.BMbusTcpIpNetwork;
import com.tridium.mbus.actionArgSets.BLivePointSearchDiscoverOptions;
import com.tridium.mbus.comm.MBusTxTimings;
import com.tridium.mbus.db.BMbusNetworkDatabase;
import com.tridium.mbus.enums.BMbusAddressing;
import com.tridium.mbus.enums.BMbusAppReset;
import com.tridium.mbus.enums.BMbusBaudRate;
import com.tridium.mbus.enums.BMbusDeviceTypeId;
import com.tridium.mbus.enums.BMbusHeaderTypes;
import com.tridium.mbus.enums.BMbusTestControl;
import com.tridium.mbus.history.BMbusHistoryDeviceExt;
import com.tridium.mbus.jobs.BMbusAssignAddressJob;
import com.tridium.mbus.jobs.BMbusLivePointSearchDiscoveryJob;
import com.tridium.mbus.messages.MbusLongFrameMessage;
import com.tridium.mbus.messages.MbusMessage;
import com.tridium.mbus.messages.MbusReceivedLongFrame;
import com.tridium.mbus.messages.MbusReqSkeMessage;
import com.tridium.mbus.messages.MbusReqUd1Message;
import com.tridium.mbus.messages.MbusReqUd2Message;
import com.tridium.mbus.messages.MbusResponseMessage;
import com.tridium.mbus.messages.MbusSndNkeMessage;
import com.tridium.mbus.messages.MbusSndUdMessage;
import com.tridium.mbus.point.BMbusPointDeviceExt;
import com.tridium.mbus.types.BMbusCommand;
import com.tridium.mbus.utils.MbusLogInputOutput;
import com.tridium.mbus.utils.MbusToolkit;
import javax.baja.data.BIDataValue;
import javax.baja.driver.util.BPollFrequency;
import javax.baja.naming.BOrd;
import javax.baja.serial.BBaudRate;
import javax.baja.spy.SpyWriter;
import javax.baja.sys.Action;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BInteger;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.IFuture;
import javax.baja.util.Invocation;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public final class BMbusDevice
extends BBasicDevice {
    public static final Property mbusConfig = BMbusDevice.newProperty((int)264, (BValue)new BMbusConfig(), null);
    public static final Property modelName = BMbusDevice.newProperty((int)0, (String)"", null);
    public static final Property pollFrequency = BMbusDevice.newProperty((int)0, (BValue)BPollFrequency.normal, null);
    public static final Property baudRate = BMbusDevice.newProperty((int)0, (BValue)BMbusBaudRate.baud300, null);
    public static final Property primaryAddress = BMbusDevice.newProperty((int)0, (int)0, (BFacets)BFacets.make((String)"min", (BIDataValue)BInteger.make((int)0), (String)"max", (BIDataValue)BInteger.make((int)250), (String)"fieldWidth", (BIDataValue)BInteger.make((int)3)));
    public static final Property secondaryAddress = BMbusDevice.newProperty((int)0, (String)"", (BFacets)BFacets.make((String)"fieldWidth", (BIDataValue)BInteger.make((int)16)));
    public static final Property addressMode = BMbusDevice.newProperty((int)0, (BValue)BMbusAddressing.primary, null);
    public static final Property cycleQuantity = BMbusDevice.newProperty((int)5, (int)1, null);
    public static final Property resetRequired = BMbusDevice.newProperty((int)4, (boolean)true, null);
    public static final Property resetRequiredForPing = BMbusDevice.newProperty((int)4, (boolean)true, null);
    public static final Property inhibitPing = BMbusDevice.newProperty((int)4, (boolean)false, null);
    public static final Property fcBitState = BMbusDevice.newProperty((int)1, (boolean)false, null);
    public static final Property fcBitInUse = BMbusDevice.newProperty((int)0, (boolean)true, null);
    public static final Property reqSkeCapable = BMbusDevice.newProperty((int)0, (boolean)false, null);
    public static final Property identNumber = BMbusDevice.newProperty((int)1, (String)"", (BFacets)BFacets.make((String)"fieldWidth", (BIDataValue)BInteger.make((int)8)));
    public static final Property manufacturer = BMbusDevice.newProperty((int)1, (String)"", (BFacets)BFacets.make((String)"fieldWidth", (BIDataValue)BInteger.make((int)3)));
    public static final Property manufString = BMbusDevice.newProperty((int)4, (String)"", null);
    public static final Property versionNumber = BMbusDevice.newProperty((int)4, (int)0, null);
    public static final Property deviceTypeId = BMbusDevice.newProperty((int)0, (BValue)BMbusDeviceTypeId.other, null);
    public static final Property applicationResetType = BMbusDevice.newProperty((int)4, (BValue)BMbusAppReset.all, null);
    public static final Property subTelegramNumber = BMbusDevice.newProperty((int)4, (int)0, null);
    public static final Property history = BMbusDevice.newProperty((int)0, (BValue)new BMbusHistoryDeviceExt(), null);
    public static final Property points = BMbusDevice.newProperty((int)0, (BValue)new BMbusPointDeviceExt(), null);
    public static final Property headerType = BMbusDevice.newProperty((int)0, (BValue)BMbusHeaderTypes.asMessage, null);
    public static final Property maxInputsPerCycleCount = BMbusDevice.newProperty((int)4, (int)0, null);
    public static final Property allowMultipleRecords = BMbusDevice.newProperty((int)5, (boolean)true, null);
    public static final Property maxSpecialFunctionReads = BMbusDevice.newProperty((int)5, (int)1000, null);
    public static final Property commandHidden = BMbusDevice.newProperty((int)4, (BValue)new BMbusCommand(), null);
    public static final Property fabricationNumber = BMbusDevice.newProperty((int)1, (String)"", (BFacets)BFacets.make((String)"fieldWidth", (BIDataValue)BInteger.make((int)8)));
    public static final Property readoutModeNumber = BMbusDevice.newProperty((int)1, (int)0, (BFacets)BFacets.make((String)"fieldWidth", (BIDataValue)BInteger.make((int)2)));
    public static final Property mbusMeterStatusDescription = BMbusDevice.newProperty((int)1, (String)"No status Input", null);
    public static final Property manufacturerStatusBit5 = BMbusDevice.newProperty((int)5, (boolean)false, null);
    public static final Property manufacturerStatusBit6 = BMbusDevice.newProperty((int)5, (boolean)false, null);
    public static final Property manufacturerStatusBit7 = BMbusDevice.newProperty((int)5, (boolean)false, null);
    public static final Action resetDatalink = BMbusDevice.newAction((int)16, null);
    public static final Action resetApplication = BMbusDevice.newAction((int)16, null);
    public static final Action removeFromDatabase = BMbusDevice.newAction((int)16, null);
    public static final Action alarmProtocol = BMbusDevice.newAction((int)16, null);
    public static final Action assignAddress = BMbusDevice.newAction((int)128, (BValue)BInteger.DEFAULT, (BFacets)BFacets.make((String)"min", (BIDataValue)BInteger.make((int)0), (String)"max", (BIDataValue)BInteger.make((int)250)));
    public static final Action calculateTimeForConcurrentReads = BMbusDevice.newAction((int)2052, (BValue)BInteger.make((int)0), null);
    public static final Action submitLivePointsDiscoveryJob = BMbusDevice.newAction((int)4, (BValue)new BLivePointSearchDiscoverOptions(), null);
    public static final Action optimiseReads = BMbusDevice.newAction((int)280, null);
    public static final Type TYPE;
    protected MBusTxTimings networkTxTimings;
    private int optimisesQueued;
    private Object optimisedVarsSyncLock;
    static /* synthetic */ Class class$com$tridium$mbus$BMbusDevice;

    public final BMbusConfig getMbusConfig() {
        return (BMbusConfig)this.get(mbusConfig);
    }

    public final void setMbusConfig(BMbusConfig bMbusConfig) {
        this.set(mbusConfig, (BValue)bMbusConfig, null);
    }

    public final String getModelName() {
        return this.getString(modelName);
    }

    public final void setModelName(String string) {
        this.setString(modelName, string, null);
    }

    public final BPollFrequency getPollFrequency() {
        return (BPollFrequency)this.get(pollFrequency);
    }

    public final void setPollFrequency(BPollFrequency bPollFrequency) {
        this.set(pollFrequency, (BValue)bPollFrequency, null);
    }

    public final BMbusBaudRate getBaudRate() {
        return (BMbusBaudRate)this.get(baudRate);
    }

    public final void setBaudRate(BMbusBaudRate bMbusBaudRate) {
        this.set(baudRate, (BValue)bMbusBaudRate, null);
    }

    public final int getPrimaryAddress() {
        return this.getInt(primaryAddress);
    }

    public final void setPrimaryAddress(int n) {
        this.setInt(primaryAddress, n, null);
    }

    public final String getSecondaryAddress() {
        return this.getString(secondaryAddress);
    }

    public final void setSecondaryAddress(String string) {
        this.setString(secondaryAddress, string, null);
    }

    public final BMbusAddressing getAddressMode() {
        return (BMbusAddressing)this.get(addressMode);
    }

    public final void setAddressMode(BMbusAddressing bMbusAddressing) {
        this.set(addressMode, (BValue)bMbusAddressing, null);
    }

    public final int getCycleQuantity() {
        return this.getInt(cycleQuantity);
    }

    public final void setCycleQuantity(int n) {
        this.setInt(cycleQuantity, n, null);
    }

    public final boolean getResetRequired() {
        return this.getBoolean(resetRequired);
    }

    public final void setResetRequired(boolean bl) {
        this.setBoolean(resetRequired, bl, null);
    }

    public final boolean getResetRequiredForPing() {
        return this.getBoolean(resetRequiredForPing);
    }

    public final void setResetRequiredForPing(boolean bl) {
        this.setBoolean(resetRequiredForPing, bl, null);
    }

    public final boolean getInhibitPing() {
        return this.getBoolean(inhibitPing);
    }

    public final void setInhibitPing(boolean bl) {
        this.setBoolean(inhibitPing, bl, null);
    }

    public final boolean getFcBitState() {
        return this.getBoolean(fcBitState);
    }

    public final void setFcBitState(boolean bl) {
        this.setBoolean(fcBitState, bl, null);
    }

    public final boolean getFcBitInUse() {
        return this.getBoolean(fcBitInUse);
    }

    public final void setFcBitInUse(boolean bl) {
        this.setBoolean(fcBitInUse, bl, null);
    }

    public final boolean getReqSkeCapable() {
        return this.getBoolean(reqSkeCapable);
    }

    public final void setReqSkeCapable(boolean bl) {
        this.setBoolean(reqSkeCapable, bl, null);
    }

    public final String getIdentNumber() {
        return this.getString(identNumber);
    }

    public final void setIdentNumber(String string) {
        this.setString(identNumber, string, null);
    }

    public final String getManufacturer() {
        return this.getString(manufacturer);
    }

    public final void setManufacturer(String string) {
        this.setString(manufacturer, string, null);
    }

    public final String getManufString() {
        return this.getString(manufString);
    }

    public final void setManufString(String string) {
        this.setString(manufString, string, null);
    }

    public final int getVersionNumber() {
        return this.getInt(versionNumber);
    }

    public final void setVersionNumber(int n) {
        this.setInt(versionNumber, n, null);
    }

    public final BMbusDeviceTypeId getDeviceTypeId() {
        return (BMbusDeviceTypeId)this.get(deviceTypeId);
    }

    public final void setDeviceTypeId(BMbusDeviceTypeId bMbusDeviceTypeId) {
        this.set(deviceTypeId, (BValue)bMbusDeviceTypeId, null);
    }

    public final BMbusAppReset getApplicationResetType() {
        return (BMbusAppReset)this.get(applicationResetType);
    }

    public final void setApplicationResetType(BMbusAppReset bMbusAppReset) {
        this.set(applicationResetType, (BValue)bMbusAppReset, null);
    }

    public final int getSubTelegramNumber() {
        return this.getInt(subTelegramNumber);
    }

    public final void setSubTelegramNumber(int n) {
        this.setInt(subTelegramNumber, n, null);
    }

    public final BMbusHistoryDeviceExt getHistory() {
        return (BMbusHistoryDeviceExt)this.get(history);
    }

    public final void setHistory(BMbusHistoryDeviceExt bMbusHistoryDeviceExt) {
        this.set(history, (BValue)bMbusHistoryDeviceExt, null);
    }

    public final BMbusPointDeviceExt getPoints() {
        return (BMbusPointDeviceExt)this.get(points);
    }

    public final void setPoints(BMbusPointDeviceExt bMbusPointDeviceExt) {
        this.set(points, (BValue)bMbusPointDeviceExt, null);
    }

    public final BMbusHeaderTypes getHeaderType() {
        return (BMbusHeaderTypes)this.get(headerType);
    }

    public final void setHeaderType(BMbusHeaderTypes bMbusHeaderTypes) {
        this.set(headerType, (BValue)bMbusHeaderTypes, null);
    }

    public final int getMaxInputsPerCycleCount() {
        return this.getInt(maxInputsPerCycleCount);
    }

    public final void setMaxInputsPerCycleCount(int n) {
        this.setInt(maxInputsPerCycleCount, n, null);
    }

    public final boolean getAllowMultipleRecords() {
        return this.getBoolean(allowMultipleRecords);
    }

    public final void setAllowMultipleRecords(boolean bl) {
        this.setBoolean(allowMultipleRecords, bl, null);
    }

    public final int getMaxSpecialFunctionReads() {
        return this.getInt(maxSpecialFunctionReads);
    }

    public final void setMaxSpecialFunctionReads(int n) {
        this.setInt(maxSpecialFunctionReads, n, null);
    }

    public final BMbusCommand getCommandHidden() {
        return (BMbusCommand)this.get(commandHidden);
    }

    public final void setCommandHidden(BMbusCommand bMbusCommand) {
        this.set(commandHidden, (BValue)bMbusCommand, null);
    }

    public final String getFabricationNumber() {
        return this.getString(fabricationNumber);
    }

    public final void setFabricationNumber(String string) {
        this.setString(fabricationNumber, string, null);
    }

    public final int getReadoutModeNumber() {
        return this.getInt(readoutModeNumber);
    }

    public final void setReadoutModeNumber(int n) {
        this.setInt(readoutModeNumber, n, null);
    }

    public final String getMbusMeterStatusDescription() {
        return this.getString(mbusMeterStatusDescription);
    }

    public final void setMbusMeterStatusDescription(String string) {
        this.setString(mbusMeterStatusDescription, string, null);
    }

    public final boolean getManufacturerStatusBit5() {
        return this.getBoolean(manufacturerStatusBit5);
    }

    public final void setManufacturerStatusBit5(boolean bl) {
        this.setBoolean(manufacturerStatusBit5, bl, null);
    }

    public final boolean getManufacturerStatusBit6() {
        return this.getBoolean(manufacturerStatusBit6);
    }

    public final void setManufacturerStatusBit6(boolean bl) {
        this.setBoolean(manufacturerStatusBit6, bl, null);
    }

    public final boolean getManufacturerStatusBit7() {
        return this.getBoolean(manufacturerStatusBit7);
    }

    public final void setManufacturerStatusBit7(boolean bl) {
        this.setBoolean(manufacturerStatusBit7, bl, null);
    }

    public final void resetDatalink() {
        this.invoke(resetDatalink, null, null);
    }

    public final void resetApplication() {
        this.invoke(resetApplication, null, null);
    }

    public final void removeFromDatabase() {
        this.invoke(removeFromDatabase, null, null);
    }

    public final void alarmProtocol() {
        this.invoke(alarmProtocol, null, null);
    }

    public final void assignAddress(BInteger bInteger) {
        this.invoke(assignAddress, (BValue)bInteger, null);
    }

    public final BRelTime calculateTimeForConcurrentReads(BInteger bInteger) {
        return (BRelTime)this.invoke(calculateTimeForConcurrentReads, (BValue)bInteger, null);
    }

    public final BOrd submitLivePointsDiscoveryJob(BLivePointSearchDiscoverOptions bLivePointSearchDiscoverOptions) {
        return (BOrd)this.invoke(submitLivePointsDiscoveryJob, (BValue)bLivePointSearchDiscoverOptions, null);
    }

    public final void optimiseReads() {
        this.invoke(optimiseReads, null, null);
    }

    public final Type getType() {
        return TYPE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final IFuture post(Action action, BValue bValue, Context context) {
        if (action == ping || action == optimiseReads || action == resetDatalink || action == resetApplication || action == removeFromDatabase || action == alarmProtocol) {
            this.getMbusNetwork().getWorker().post((Runnable)new Invocation((BComponent)this, action, bValue, context));
            return null;
        }
        if (action != assignAddress) {
            return super.post(action, bValue, context);
        }
        Object object = this.optimisedVarsSyncLock;
        synchronized (object) {
            block7: {
                String string;
                if (this.optimisesQueued <= 1) {
                    ++this.optimisesQueued;
                    return null;
                }
                if (MbusToolkit.isTraceOn()) {
                    string = this.isRunning() ? this.getSlotPath().toString() : "UNKNOWN DEVICE";
                }
                break block7;
                String string2 = string;
                MbusToolkit.trace("Maximium optimises already queued for " + string2 + " cancelling additional request");
            }
            return null;
        }
    }

    public final boolean isParentLegal(BComponent bComponent) {
        boolean bl = false;
        if (bComponent instanceof BMbusCommand || bComponent instanceof BMbusDeviceFolder || bComponent instanceof BMbusDevice || bComponent instanceof BMbusTcpIpNetwork || bComponent instanceof BMbusNetwork) {
            bl = true;
        }
        return bl;
    }

    public final BAbstractMbusNetwork getMbusNetwork() {
        return (BAbstractMbusNetwork)this.getNetwork();
    }

    public final Type getNetworkType() {
        return BAbstractMbusNetwork.TYPE;
    }

    public final void started() throws Exception {
        super.started();
        this.setFlags((Slot)upload, 4);
        this.setFlags((Slot)download, 4);
        this.getMbusNetwork().getNetworkDatabase().rationalise(this);
        this.optimiseReads();
    }

    public final void changed(Property property, Context context) {
        super.changed(property, context);
        if (!this.isRunning()) {
            return;
        }
        BAbstractMbusNetwork bAbstractMbusNetwork = this.getMbusNetwork();
        if (property == headerType) {
            BMbusNetworkDatabase bMbusNetworkDatabase = bAbstractMbusNetwork.getNetworkDatabase();
            bMbusNetworkDatabase.removeDevicePointInformation(this.getPrimaryAddress(), this.getSecondaryAddress(), this.getModelName());
            this.setIdentNumber("");
            this.setManufacturer("");
            this.setVersionNumber(0);
            this.setDeviceTypeId(BMbusDeviceTypeId.other);
            if (this.getPrimaryAddress() != 253) {
                this.setSecondaryAddress("");
            }
        }
        if (property == addressMode) {
            this.ping();
        } else if (property == modelName) {
            this.getMbusNetwork().getNetworkDatabase().rationalise(this);
        }
    }

    public final IFuture postPing() {
        this.doPing();
        return null;
    }

    public final void doPing() {
        BAbstractMbusNetwork bAbstractMbusNetwork = this.getMbusNetwork();
        String string = "ping" + this.getHandle();
        try {
            this.doCommsLockedPing(bAbstractMbusNetwork, string);
            bAbstractMbusNetwork.unlockSends(string);
        }
        catch (Throwable throwable) {
            bAbstractMbusNetwork.unlockSends(string);
            throwable.printStackTrace();
        }
    }

    public final void doCommsLockedPing(BAbstractMbusNetwork bAbstractMbusNetwork, Object object) {
        block21: {
            long l;
            Object object2;
            if (!this.isRunning()) {
                return;
            }
            if (bAbstractMbusNetwork.getTestMode() != BMbusTestControl.inactive) {
                this.pingOk();
                return;
            }
            if (this.getInhibitPing()) {
                this.pingOk();
                return;
            }
            MbusResponseMessage mbusResponseMessage = null;
            MBusTxTimings mBusTxTimings = this.getTxTimingsReference();
            if (this.getAddressMode() != BMbusAddressing.primary) {
                object2 = new MbusSndUdMessage(this, bAbstractMbusNetwork);
                ((MbusMessage)((Object)object2)).setMessageBaudRate(this.getBaudRate());
                l = MBusTxTimings.calculateTxRxTime((long)2, (BBaudRate)this.getBaudRate());
                mbusResponseMessage = (MbusResponseMessage)bAbstractMbusNetwork.sendMBusSync(mBusTxTimings, object, (Message)object2, l += MBusTxTimings.calculateTxRxTime((MbusMessage)((Object)object2), (BBaudRate)this.getBaudRate()));
                if ((mbusResponseMessage == null || mbusResponseMessage != null && !mbusResponseMessage.getSuccessfulResponse() || mbusResponseMessage != null && mbusResponseMessage.getCollisionDetected()) && this.isMounted() && MbusLogInputOutput.log.isLoggable(2)) {
                    MbusLogInputOutput.log.trace(this.getDisplayName(null) + ": Failed to get response to initial secondary address selection " + (mbusResponseMessage != null && mbusResponseMessage.getCollisionDetected() ? "(COLLISION)" : ""));
                }
            }
            if (this.getResetRequiredForPing()) {
                if (MbusLogInputOutput.log.isTraceOn()) {
                    MbusLogInputOutput.log.trace("Ping Reset to Meter:- " + this.getPrimaryAddress() + "Sec Add= " + this.getSecondaryAddress());
                }
                this.doSendNkeAndInitDelay(mBusTxTimings, object);
                if (this.getAddressMode() != BMbusAddressing.primary) {
                    object2 = new MbusSndUdMessage(this, bAbstractMbusNetwork);
                    ((MbusMessage)((Object)object2)).setMessageBaudRate(this.getBaudRate());
                    l = MBusTxTimings.calculateTxRxTime((long)2, (BBaudRate)this.getBaudRate());
                    mbusResponseMessage = (MbusResponseMessage)bAbstractMbusNetwork.sendMBusSync(mBusTxTimings, object, (Message)object2, l += MBusTxTimings.calculateTxRxTime((MbusMessage)((Object)object2), (BBaudRate)this.getBaudRate()));
                    if (mbusResponseMessage == null || mbusResponseMessage != null && !mbusResponseMessage.getSuccessfulResponse() || mbusResponseMessage != null && mbusResponseMessage.getCollisionDetected()) {
                        if (this.isMounted() && MbusLogInputOutput.log.isLoggable(2)) {
                            if (mbusResponseMessage != null && mbusResponseMessage.getCollisionDetected()) {
                                MbusLogInputOutput.log.trace(this.getDisplayName(null) + ": Secondary address selection collision detected");
                            } else {
                                MbusLogInputOutput.log.trace(this.getDisplayName(null) + ": Secondary address selection failure");
                            }
                        }
                        String string = mbusResponseMessage != null && mbusResponseMessage.getCollisionDetected() ? "collision - secondary address selection" : "timeout - secondary address selection";
                        this.pingFail(string);
                        bAbstractMbusNetwork.unlockSends(object);
                        return;
                    }
                    this.setFcBitState(true);
                }
            }
            try {
                if (MbusLogInputOutput.log.isTraceOn()) {
                    MbusLogInputOutput.log.trace("Ping to Meter:- " + this.getPrimaryAddress() + "Sec Add= " + this.getSecondaryAddress());
                }
                if (this.getReqSkeCapable()) {
                    object2 = new MbusReqSkeMessage(this, this.getMbusNetwork());
                    ((MbusMessage)((Object)object2)).setMessageBaudRate(this.getBaudRate());
                    l = MBusTxTimings.calculateTxRxTime((long)2, (BBaudRate)this.getBaudRate());
                    mbusResponseMessage = (MbusResponseMessage)bAbstractMbusNetwork.sendMBusSync(mBusTxTimings, object, (Message)object2, l += MBusTxTimings.calculateTxRxTime((MbusMessage)((Object)object2), (BBaudRate)this.getBaudRate()));
                } else {
                    object2 = new MbusReqUd2Message(this, this.getMbusNetwork());
                    ((MbusMessage)((Object)object2)).setMessageBaudRate(this.getBaudRate());
                    l = MBusTxTimings.calculateTxRxTime(261L, (BBaudRate)this.getBaudRate());
                    mbusResponseMessage = (MbusResponseMessage)bAbstractMbusNetwork.sendMBusSync(mBusTxTimings, object, (Message)object2, l += MBusTxTimings.calculateTxRxTime((MbusMessage)((Object)object2), (BBaudRate)this.getBaudRate()));
                }
                bAbstractMbusNetwork.unlockSends(object);
                if (mbusResponseMessage != null) {
                    if (MbusLogInputOutput.log.isTraceOn()) {
                        MbusLogInputOutput.log.trace("Input(Ping):- " + mbusResponseMessage.toDebugString());
                    }
                    this.pingOk();
                    if (mbusResponseMessage.getBytes().length > 8) {
                        object2 = null;
                        object2 = new MbusReceivedLongFrame(mbusResponseMessage, this.getMbusNetwork(), this, false, 0);
                        this.setMbusMeterStatusDescription(((MbusReceivedLongFrame)((Object)object2)).getStatus());
                        this.setManufacturerStatusBit5(((MbusReceivedLongFrame)((Object)object2)).getStatusBit5());
                        this.setManufacturerStatusBit6(((MbusReceivedLongFrame)((Object)object2)).getStatusBit6());
                        this.setManufacturerStatusBit7(((MbusReceivedLongFrame)((Object)object2)).getStatusBit7());
                    }
                } else {
                    this.pingFail("timeout");
                }
            }
            catch (Exception exception) {
                this.pingFail("caught exception");
                if (!MbusToolkit.isTraceOn()) break block21;
                MbusToolkit.trace("Error pinging device", exception);
            }
        }
    }

    public final BRelTime doCalculateTimeForConcurrentReads(BInteger bInteger) {
        int n = bInteger.getInt();
        long l = 0L;
        MBusTxTimings mBusTxTimings = this.getTxTimingsReference();
        if (this.getAddressMode().equals((Object)BMbusAddressing.secondary)) {
            l += MBusTxTimings.calculateTxRxTime(17L, (BBaudRate)this.getBaudRate());
            l += mBusTxTimings.intermessageDelay;
        }
        if (this.getResetRequired()) {
            l += MBusTxTimings.calculateTxRxTime((long)5, (BBaudRate)this.getBaudRate());
            l += mBusTxTimings.intermessageDelay;
        }
        l += MBusTxTimings.calculateTxRxTime((long)5, (BBaudRate)this.getBaudRate()) * (long)n;
        l += MBusTxTimings.calculateTxRxTime(256L, (BBaudRate)this.getBaudRate()) * (long)n;
        if (n > 1) {
            l += mBusTxTimings.intermessageDelay * (long)(n - 1);
        }
        return BRelTime.make((long)l);
    }

    public final void doSendNkeAndInitDelay(MBusTxTimings mBusTxTimings, Object object) {
        BAbstractMbusNetwork bAbstractMbusNetwork = this.getMbusNetwork();
        if (bAbstractMbusNetwork == null) {
            return;
        }
        MbusSndNkeMessage mbusSndNkeMessage = new MbusSndNkeMessage(this, bAbstractMbusNetwork, 253);
        mbusSndNkeMessage.setMessageBaudRate(this.getBaudRate());
        long l = MBusTxTimings.calculateTxRxTime((long)2, (BBaudRate)this.getBaudRate());
        l += MBusTxTimings.calculateTxRxTime(mbusSndNkeMessage, (BBaudRate)this.getBaudRate());
        if (this.getAddressMode() != BMbusAddressing.primary) {
            MbusResponseMessage mbusResponseMessage = (MbusResponseMessage)bAbstractMbusNetwork.sendMBusSync(mBusTxTimings, object, mbusSndNkeMessage, l);
            if (mbusResponseMessage == null || mbusResponseMessage != null && !mbusResponseMessage.getSuccessfulResponse()) {
                if (this.isMounted() && MbusLogInputOutput.log.isLoggable(2)) {
                    MbusLogInputOutput.log.trace(this.getDisplayName(null) + ": SND_NKE unconfirmed - continuing assumming data loss");
                }
                this.setFcBitState(true);
            }
        } else {
            int n;
            mbusSndNkeMessage.setResponseExpected(false);
            MBusTxTimings mBusTxTimings2 = new MBusTxTimings();
            mBusTxTimings2.intermessageDelay = 300L;
            mBusTxTimings2.responseTimeout = BRelTime.make((long)100L);
            int n2 = 0;
            if (this.getAddressMode() == BMbusAddressing.primary) {
                n2 = 1;
            }
            mBusTxTimings2.retryTransmission = n = Math.max(3 - n2, mBusTxTimings.retryTransmission);
            MbusResponseMessage mbusResponseMessage = null;
            int n3 = 0;
            while (n3 < n) {
                if (this.isMounted() && MbusLogInputOutput.log.isLoggable(2)) {
                    MbusLogInputOutput.log.trace(this.getDisplayName(null) + ": Sending SND_NKE");
                }
                if (n3 == n - 1) {
                    mbusSndNkeMessage.setResponseExpected(true);
                }
                mBusTxTimings2.responseTimeout = mBusTxTimings.responseTimeout;
                mbusResponseMessage = (MbusResponseMessage)bAbstractMbusNetwork.sendMBusSync(mBusTxTimings2, object, mbusSndNkeMessage, l);
                if (this.isMounted() && MbusLogInputOutput.log.isLoggable(2)) {
                    MbusLogInputOutput.log.trace(this.getDisplayName(null) + ": Sent SND_NKE");
                }
                ++n3;
            }
            if ((mbusResponseMessage == null || mbusResponseMessage != null && !mbusResponseMessage.getSuccessfulResponse()) && this.isMounted() && MbusLogInputOutput.log.isLoggable(2)) {
                MbusLogInputOutput.log.trace(this.getDisplayName(null) + ": SND_NKE unconfirmed - continuing assumming data loss");
            }
        }
        try {
            if (MbusLogInputOutput.log.isTraceOn() && this.isMounted()) {
                MbusLogInputOutput.log.trace(this.getDisplayName(null) + " Initalisation delay");
            }
            mBusTxTimings.applyInitialisationDelay();
            if (MbusLogInputOutput.log.isTraceOn() && this.isMounted()) {
                MbusLogInputOutput.log.trace(this.getDisplayName(null) + " Initalisation delay complete");
            }
        }
        catch (InterruptedException interruptedException) {}
        this.setFcBitState(true);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void doResetDatalink() {
        BAbstractMbusNetwork bAbstractMbusNetwork = this.getMbusNetwork();
        String string = "resetDl" + this.getHandle();
        MBusTxTimings mBusTxTimings = this.getTxTimingsReference();
        try {
            try {
                long l;
                MbusMessage mbusMessage;
                if (this.getAddressMode() != BMbusAddressing.primary) {
                    mbusMessage = new MbusSndUdMessage(this, bAbstractMbusNetwork);
                    mbusMessage.setMessageBaudRate(this.getBaudRate());
                    l = MBusTxTimings.calculateTxRxTime((long)2, (BBaudRate)this.getBaudRate());
                    MbusResponseMessage mbusResponseMessage = (MbusResponseMessage)bAbstractMbusNetwork.sendMBusSync(mBusTxTimings, string, mbusMessage, l += MBusTxTimings.calculateTxRxTime(mbusMessage, (BBaudRate)this.getBaudRate()));
                    if (mbusResponseMessage != null && mbusResponseMessage.getCollisionDetected()) {
                        bAbstractMbusNetwork.unlockSends(string);
                        throw new Exception("Secondary address selection collision detected");
                    }
                }
                mbusMessage = new MbusSndNkeMessage(this, bAbstractMbusNetwork, 0);
                mbusMessage.setMessageBaudRate(this.getBaudRate());
                l = MBusTxTimings.calculateTxRxTime((long)2, (BBaudRate)this.getBaudRate());
                bAbstractMbusNetwork.sendMBusSync(mBusTxTimings, string, mbusMessage, l += MBusTxTimings.calculateTxRxTime(mbusMessage, (BBaudRate)this.getBaudRate()));
                this.setFcBitState(true);
                bAbstractMbusNetwork.unlockSends(string);
                bAbstractMbusNetwork.getNetworkDatabase().initialiseDelay(bAbstractMbusNetwork.getActiveTxTimings().initalisationDelay.getSeconds());
            }
            catch (Exception exception) {
                if (MbusToolkit.isTraceOn()) {
                    MbusToolkit.trace("Error resetting data link", exception);
                }
            }
            catch (Throwable throwable) {
                if (MbusToolkit.isTraceOn()) {
                    MbusToolkit.trace("Error resetting data link " + throwable.getMessage());
                }
            }
        }
        catch (Throwable throwable) {
            Object var5_10 = null;
            bAbstractMbusNetwork.unlockSends(string);
            throw throwable;
        }
        {
            Object var5_11 = null;
            bAbstractMbusNetwork.unlockSends(string);
            return;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void doAlarmProtocol() {
        String string = "alarmProtocol" + this.getHandle();
        BAbstractMbusNetwork bAbstractMbusNetwork = this.getMbusNetwork();
        MBusTxTimings mBusTxTimings = this.getTxTimingsReference();
        try {
            try {
                long l;
                MbusMessage mbusMessage;
                if (this.getAddressMode() != BMbusAddressing.primary) {
                    mbusMessage = new MbusSndUdMessage(this, bAbstractMbusNetwork);
                    mbusMessage.setMessageBaudRate(this.getBaudRate());
                    l = MBusTxTimings.calculateTxRxTime((long)2, (BBaudRate)this.getBaudRate());
                    MbusResponseMessage mbusResponseMessage = (MbusResponseMessage)bAbstractMbusNetwork.sendMBusSync(mBusTxTimings, string, mbusMessage, l += MBusTxTimings.calculateTxRxTime(mbusMessage, (BBaudRate)this.getBaudRate()));
                    if (mbusResponseMessage != null && mbusResponseMessage.getCollisionDetected()) {
                        bAbstractMbusNetwork.unlockSends(string);
                        throw new Exception("Secondary address selection collision detected");
                    }
                }
                mbusMessage = new MbusReqUd1Message(this, bAbstractMbusNetwork);
                mbusMessage.setMessageBaudRate(this.getBaudRate());
                l = MBusTxTimings.calculateTxRxTime(261L, (BBaudRate)this.getBaudRate());
                bAbstractMbusNetwork.sendMBusSync(mBusTxTimings, string, mbusMessage, l += MBusTxTimings.calculateTxRxTime(mbusMessage, (BBaudRate)this.getBaudRate()));
                bAbstractMbusNetwork.unlockSends(string);
            }
            catch (Exception exception) {
                if (MbusToolkit.isTraceOn()) {
                    MbusToolkit.trace("Error alarm protocol", exception);
                }
            }
            catch (Throwable throwable) {
                if (MbusToolkit.isTraceOn()) {
                    MbusToolkit.trace("Error alarm protocol " + throwable.getMessage());
                }
            }
        }
        catch (Throwable throwable) {
            Object var5_10 = null;
            bAbstractMbusNetwork.unlockSends(string);
            throw throwable;
        }
        {
            Object var5_11 = null;
            bAbstractMbusNetwork.unlockSends(string);
            return;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void doResetApplication() {
        String string = "resetApp" + this.getHandle();
        MBusTxTimings mBusTxTimings = this.getTxTimingsReference();
        BAbstractMbusNetwork bAbstractMbusNetwork = this.getMbusNetwork();
        try {
            try {
                MbusMessage mbusMessage;
                if (this.getAddressMode() != BMbusAddressing.primary) {
                    mbusMessage = new MbusSndUdMessage(this, bAbstractMbusNetwork);
                    mbusMessage.setMessageBaudRate(this.getBaudRate());
                    long l = MBusTxTimings.calculateTxRxTime(261L, (BBaudRate)this.getBaudRate());
                    MbusResponseMessage mbusResponseMessage = (MbusResponseMessage)bAbstractMbusNetwork.sendMBusSync(mBusTxTimings, string, mbusMessage, l += MBusTxTimings.calculateTxRxTime(mbusMessage, (BBaudRate)this.getBaudRate()));
                    if (mbusResponseMessage != null && mbusResponseMessage.getCollisionDetected()) {
                        bAbstractMbusNetwork.unlockSends(string);
                        throw new Exception("Secondary address selection collision detected");
                    }
                }
                mbusMessage = new MbusLongFrameMessage();
                mbusMessage.setMessageBaudRate(this.getBaudRate());
                if (this.getAddressMode() == BMbusAddressing.primary) {
                    mbusMessage.setAField(this.getPrimaryAddress());
                } else {
                    mbusMessage.setAField(253);
                }
                mbusMessage.setCFieldNoFcb(67);
                mbusMessage.setCiField(80);
                byte[] byArray = new byte[]{(byte)(this.getApplicationResetType().getOrdinal() | this.getSubTelegramNumber() & 0xF)};
                mbusMessage.setBytes(byArray);
                long l = MBusTxTimings.calculateTxRxTime((long)2, (BBaudRate)this.getBaudRate());
                bAbstractMbusNetwork.sendMBusSync(mBusTxTimings, string, mbusMessage, l += MBusTxTimings.calculateTxRxTime(mbusMessage, (BBaudRate)this.getBaudRate()));
                bAbstractMbusNetwork.unlockSends(string);
            }
            catch (Exception exception) {
                if (MbusToolkit.isTraceOn()) {
                    MbusToolkit.trace("Error resetting appliance", exception);
                }
            }
            catch (Throwable throwable) {
                if (MbusToolkit.isTraceOn()) {
                    MbusToolkit.trace("Error resetting appliance " + throwable.getMessage());
                }
            }
        }
        catch (Throwable throwable) {
            Object var5_12 = null;
            bAbstractMbusNetwork.unlockSends(string);
            throw throwable;
        }
        {
            Object var5_13 = null;
            bAbstractMbusNetwork.unlockSends(string);
            return;
        }
    }

    public final BOrd doSubmitLivePointsDiscoveryJob(BLivePointSearchDiscoverOptions bLivePointSearchDiscoverOptions) {
        BMbusLivePointSearchDiscoveryJob bMbusLivePointSearchDiscoveryJob = new BMbusLivePointSearchDiscoveryJob(this);
        bMbusLivePointSearchDiscoveryJob.setDiscoveryOptions(bLivePointSearchDiscoverOptions);
        return bMbusLivePointSearchDiscoveryJob.submit(null);
    }

    public final void doRemoveFromDatabase() {
        BAbstractMbusNetwork bAbstractMbusNetwork = this.getMbusNetwork();
        BMbusNetworkDatabase bMbusNetworkDatabase = bAbstractMbusNetwork.getNetworkDatabase();
        bMbusNetworkDatabase.removeDevice(this.getPrimaryAddress(), this.getSecondaryAddress());
    }

    public final void doAssignAddress(BInteger bInteger) {
        BAbstractMbusNetwork bAbstractMbusNetwork = this.getMbusNetwork();
        new BMbusAssignAddressJob(bAbstractMbusNetwork, bInteger.getInt(), this).submit(null);
    }

    public final MBusTxTimings getTxTimingsReference() {
        if (this.networkTxTimings == null) {
            return this.getMbusNetwork().getTxTimingsReference();
        }
        return this.networkTxTimings;
    }

    public final void spy(SpyWriter spyWriter) throws Exception {
        super.spy(spyWriter);
        MBusTxTimings mBusTxTimings = this.getTxTimingsReference();
        spyWriter.startProps("Expected TX Timings");
        spyWriter.prop((Object)"IMD", (Object)BRelTime.make((long)mBusTxTimings.intermessageDelay));
        spyWriter.prop((Object)"Retry TX", mBusTxTimings.retryTransmission);
        spyWriter.prop((Object)"Response Timeout", (Object)mBusTxTimings.responseTimeout);
        spyWriter.prop((Object)"Initalisation Delay", (Object)mBusTxTimings.initalisationDelay);
        spyWriter.endProps();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void doOptimiseReads() {
        int n;
        Object object = this.optimisedVarsSyncLock;
        synchronized (object) {
            --this.optimisesQueued;
            // MONITOREXIT @DISABLED, blocks:[0, 1] lbl5 : MonitorExitStatement: MONITOREXIT : var1_1
            n = this.getPoints().getMaxMessageRequired();
        }
        if (MbusToolkit.isTraceOn()) {
            String string = this.isRunning() ? this.getSlotPath().toString() : "UNKNOWN DEVICE";
            MbusToolkit.trace("Maximum messages under device " + string + " required for currently setup points: " + n);
        }
        if (n > 0) {
            if (!this.getAllowMultipleRecords()) {
                this.setAllowMultipleRecords(true);
            }
        } else if (this.getAllowMultipleRecords()) {
            this.setAllowMultipleRecords(false);
        }
        if (this.getMaxSpecialFunctionReads() != n) {
            this.setMaxSpecialFunctionReads(n);
        }
        if (this.getCycleQuantity() != 1) {
            this.setCycleQuantity(1);
        }
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final /* synthetic */ void this() {
        this.networkTxTimings = null;
        this.optimisesQueued = 0;
        this.optimisedVarsSyncLock = new Object();
    }

    public BMbusDevice() {
        this.this();
    }

    static {
        Class clazz = class$com$tridium$mbus$BMbusDevice;
        if (clazz == null) {
            clazz = class$com$tridium$mbus$BMbusDevice = BMbusDevice.class("[Lcom.tridium.mbus.BMbusDevice;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
    }
}

