/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.mbus;

import com.tridium.basicdriver.comm.Comm;
import com.tridium.basicdriver.comm.CommReceiver;
import com.tridium.basicdriver.message.Message;
import com.tridium.basicdriver.serial.BSerialNetwork;
import com.tridium.basicdriver.util.BBasicPollScheduler;
import com.tridium.mbus.BMbusDevice;
import com.tridium.mbus.BMbusDeviceFolder;
import com.tridium.mbus.actionArgSets.BPrimaryDiscoverOptions;
import com.tridium.mbus.actionArgSets.BSecondaryDiscoverOptions;
import com.tridium.mbus.comm.MBusTxTimings;
import com.tridium.mbus.comm.MbusCommReceiver;
import com.tridium.mbus.comm.MbusCommTransmitter;
import com.tridium.mbus.comm.MbusSerialComm;
import com.tridium.mbus.db.BMbusNetworkDatabase;
import com.tridium.mbus.enums.BMbusBaudRate;
import com.tridium.mbus.enums.BMbusTestControl;
import com.tridium.mbus.jobs.BMbusAssignAddressJob;
import com.tridium.mbus.jobs.BMbusAssignBaudRateData;
import com.tridium.mbus.jobs.BMbusAssignBaudRateJob;
import com.tridium.mbus.jobs.BMbusPrimaryDeviceSearchJob;
import com.tridium.mbus.jobs.BMbusSecondaryAddressScanJob;
import com.tridium.mbus.jobs.BMbusSecondaryDeviceSearchJob;
import com.tridium.mbus.jobs.BMbusUpdateDevicesJob;
import com.tridium.mbus.learn.BMbusDeviceDiscoveryJob;
import com.tridium.mbus.learn.BMbusHistoryImportDiscoveryJob;
import com.tridium.mbus.learn.BMbusPointDiscoveryJob;
import com.tridium.mbus.types.BEncodableList;
import com.tridium.mbus.utils.MbusToolkit;
import com.tridium.sys.station.BStationSaveJob;
import javax.baja.data.BIDataValue;
import javax.baja.driver.ping.BPingMonitor;
import javax.baja.driver.util.BPollScheduler;
import javax.baja.job.BJobService;
import javax.baja.job.BJobState;
import javax.baja.license.Feature;
import javax.baja.license.FeatureNotLicensedException;
import javax.baja.log.Log;
import javax.baja.naming.BOrd;
import javax.baja.naming.BOrdList;
import javax.baja.serial.BBaudRate;
import javax.baja.serial.BSerialHelper;
import javax.baja.serial.BSerialParity;
import javax.baja.sys.Action;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComponent;
import javax.baja.sys.BComponentEvent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BInteger;
import javax.baja.sys.BObject;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BValue;
import javax.baja.sys.Clock;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Subscriber;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public abstract class BAbstractMbusNetwork
extends BSerialNetwork {
    public static final Property initialisationDelay = BAbstractMbusNetwork.newProperty((int)0, (BValue)BRelTime.makeSeconds((int)3), (BFacets)BFacets.make((String)"showMilliseconds", (BIDataValue)BBoolean.TRUE, (String)"min", (BIDataValue)BRelTime.make((long)0L), (String)"max", (BIDataValue)BRelTime.make((long)100000L)));
    public static final Property networkDatabase = BAbstractMbusNetwork.newProperty((int)0, (BValue)new BMbusNetworkDatabase(), null);
    public static final Property searchBaudRate = BAbstractMbusNetwork.newProperty((int)261, (BValue)BMbusBaudRate.baud300, null);
    public static final Property searchFcBitState = BAbstractMbusNetwork.newProperty((int)0, (boolean)false, null);
    public static final Property searchFcBitInUse = BAbstractMbusNetwork.newProperty((int)0, (boolean)true, null);
    public static final Property primarySearchAddress = BAbstractMbusNetwork.newProperty((int)4, (int)0, (BFacets)BFacets.make((String)"min", (BIDataValue)BInteger.make((int)0), (String)"max", (BIDataValue)BInteger.make((int)250)));
    public static final Property testMode = BAbstractMbusNetwork.newProperty((int)4, (BValue)BMbusTestControl.inactive, null);
    public static final Property testString = BAbstractMbusNetwork.newProperty((int)4, (String)"", null);
    public static final Property inhibitDatabaseUpdate = BAbstractMbusNetwork.newProperty((int)8, (boolean)true, null);
    public static final Property retryCount = BAbstractMbusNetwork.newProperty((int)0, (int)2, null);
    public static final Property responseTimeout = BAbstractMbusNetwork.newProperty((int)0, (BValue)BRelTime.make((long)(BRelTime.SECOND.getMillis() * (long)3)), (BFacets)BFacets.make((String)"showMilliseconds", (BIDataValue)BBoolean.TRUE));
    public static final Property interMessageDelay = BAbstractMbusNetwork.newProperty((int)0, (BValue)BRelTime.make((long)300L), (BFacets)BFacets.make((String)"showMilliseconds", (BIDataValue)BBoolean.TRUE, (String)"min", (BIDataValue)BRelTime.make((long)0L), (String)"max", (BIDataValue)BRelTime.SECOND));
    public static final Property pollScheduler = BAbstractMbusNetwork.newProperty((int)0, (BValue)BAbstractMbusNetwork.makeDefaultPollScheduler(), null);
    public static final Property serialPortConfig = BAbstractMbusNetwork.newProperty((int)0, (BValue)BAbstractMbusNetwork.makeDefaultSerialHelper(), null);
    public static final Property monitor = BAbstractMbusNetwork.newProperty((int)0, (BValue)BAbstractMbusNetwork.makeDefaultPingMonitor(), null);
    public static final Property collisionCsvBytes = BAbstractMbusNetwork.newProperty((int)260, (String)"A2", null);
    public static final Property receiverBufferResetTimeout = BAbstractMbusNetwork.newProperty((int)260, (BValue)BRelTime.SECOND, (BFacets)BFacets.make((String)"showMilliseconds", (BIDataValue)BBoolean.FALSE, (String)"min", (BIDataValue)BRelTime.make((long)0L), (String)"max", (BIDataValue)BRelTime.makeSeconds((int)10)));
    public static final Action submitDeviceDiscoveryJob = BAbstractMbusNetwork.newAction((int)4, (BValue)BOrd.NULL, null);
    public static final Action submitHistoryImportDiscoveryJob = BAbstractMbusNetwork.newAction((int)4, (BValue)BOrd.NULL, null);
    public static final Action submitPointDiscoveryJob = BAbstractMbusNetwork.newAction((int)4, (BValue)BOrdList.make((BOrd[])new BOrd[]{BOrd.NULL, BOrd.NULL}), null);
    public static final Action submitSingleDeviceDiscoveryJob = BAbstractMbusNetwork.newAction((int)4, (BValue)new BPrimaryDiscoverOptions(), null);
    public static final Action submitPrimaryDiscoverJob = BAbstractMbusNetwork.newAction((int)4, (BValue)BEncodableList.DEFAULT, null);
    public static final Action submitPrimaryDiscoverRangeJob = BAbstractMbusNetwork.newAction((int)4, (BValue)new BPrimaryDiscoverOptions(), null);
    public static final Action submitAssignBaudRateJob = BAbstractMbusNetwork.newAction((int)4, (BValue)new BMbusAssignBaudRateData(), null);
    public static final Action submitFullSecondaryDiscoverJob = BAbstractMbusNetwork.newAction((int)4, (BValue)new BSecondaryDiscoverOptions(), null);
    public static final Action submitSecondaryAddressScanJob = BAbstractMbusNetwork.newAction((int)4, (BValue)new BSecondaryDiscoverOptions(), null);
    public static final Action assignAddress = BAbstractMbusNetwork.newAction((int)128, (BValue)BInteger.DEFAULT, (BFacets)BFacets.make((String)"min", (BIDataValue)BInteger.make((int)0), (String)"max", (BIDataValue)BInteger.make((int)250)));
    public static final Action clearNetworkDatabase = BAbstractMbusNetwork.newAction((int)0, null);
    public static final Action updateReceiverResetTimeout = BAbstractMbusNetwork.newAction((int)276, null);
    public static final Type TYPE;
    static int currentTestMeterNumber;
    private volatile boolean savesActive;
    private Object savesActiveLock;
    protected final StationSaveSubscriber jobServiceMonitor;
    private volatile Object sendLock;
    private volatile Object sendActiveLock;
    private MBusTxTimings activeTxTimings;
    protected MBusTxTimings networkTxTimings;
    static /* synthetic */ Class class$com$tridium$mbus$BAbstractMbusNetwork;
    static /* synthetic */ Class class$com$tridium$sys$station$BStationSaveJob;

    public BRelTime getInitialisationDelay() {
        return (BRelTime)this.get(initialisationDelay);
    }

    public void setInitialisationDelay(BRelTime bRelTime) {
        this.set(initialisationDelay, (BValue)bRelTime, null);
    }

    public BMbusNetworkDatabase getNetworkDatabase() {
        return (BMbusNetworkDatabase)this.get(networkDatabase);
    }

    public void setNetworkDatabase(BMbusNetworkDatabase bMbusNetworkDatabase) {
        this.set(networkDatabase, (BValue)bMbusNetworkDatabase, null);
    }

    public BMbusBaudRate getSearchBaudRate() {
        return (BMbusBaudRate)this.get(searchBaudRate);
    }

    public void setSearchBaudRate(BMbusBaudRate bMbusBaudRate) {
        this.set(searchBaudRate, (BValue)bMbusBaudRate, null);
    }

    public boolean getSearchFcBitState() {
        return this.getBoolean(searchFcBitState);
    }

    public void setSearchFcBitState(boolean bl) {
        this.setBoolean(searchFcBitState, bl, null);
    }

    public boolean getSearchFcBitInUse() {
        return this.getBoolean(searchFcBitInUse);
    }

    public void setSearchFcBitInUse(boolean bl) {
        this.setBoolean(searchFcBitInUse, bl, null);
    }

    public int getPrimarySearchAddress() {
        return this.getInt(primarySearchAddress);
    }

    public void setPrimarySearchAddress(int n) {
        this.setInt(primarySearchAddress, n, null);
    }

    public BMbusTestControl getTestMode() {
        return (BMbusTestControl)this.get(testMode);
    }

    public void setTestMode(BMbusTestControl bMbusTestControl) {
        this.set(testMode, (BValue)bMbusTestControl, null);
    }

    public String getTestString() {
        return this.getString(testString);
    }

    public void setTestString(String string) {
        this.setString(testString, string, null);
    }

    public boolean getInhibitDatabaseUpdate() {
        return this.getBoolean(inhibitDatabaseUpdate);
    }

    public void setInhibitDatabaseUpdate(boolean bl) {
        this.setBoolean(inhibitDatabaseUpdate, bl, null);
    }

    public int getRetryCount() {
        return this.getInt(retryCount);
    }

    public void setRetryCount(int n) {
        this.setInt(retryCount, n, null);
    }

    public BRelTime getResponseTimeout() {
        return (BRelTime)this.get(responseTimeout);
    }

    public void setResponseTimeout(BRelTime bRelTime) {
        this.set(responseTimeout, (BValue)bRelTime, null);
    }

    public BRelTime getInterMessageDelay() {
        return (BRelTime)this.get(interMessageDelay);
    }

    public void setInterMessageDelay(BRelTime bRelTime) {
        this.set(interMessageDelay, (BValue)bRelTime, null);
    }

    public BPollScheduler getPollScheduler() {
        return (BPollScheduler)this.get(pollScheduler);
    }

    public void setPollScheduler(BPollScheduler bPollScheduler) {
        this.set(pollScheduler, (BValue)bPollScheduler, null);
    }

    public BSerialHelper getSerialPortConfig() {
        return (BSerialHelper)this.get(serialPortConfig);
    }

    public void setSerialPortConfig(BSerialHelper bSerialHelper) {
        this.set(serialPortConfig, (BValue)bSerialHelper, null);
    }

    public BPingMonitor getMonitor() {
        return (BPingMonitor)this.get(monitor);
    }

    public void setMonitor(BPingMonitor bPingMonitor) {
        this.set(monitor, (BValue)bPingMonitor, null);
    }

    public String getCollisionCsvBytes() {
        return this.getString(collisionCsvBytes);
    }

    public void setCollisionCsvBytes(String string) {
        this.setString(collisionCsvBytes, string, null);
    }

    public BRelTime getReceiverBufferResetTimeout() {
        return (BRelTime)this.get(receiverBufferResetTimeout);
    }

    public void setReceiverBufferResetTimeout(BRelTime bRelTime) {
        this.set(receiverBufferResetTimeout, (BValue)bRelTime, null);
    }

    public BOrd submitDeviceDiscoveryJob(BOrd bOrd) {
        return (BOrd)this.invoke(submitDeviceDiscoveryJob, (BValue)bOrd, null);
    }

    public BOrd submitHistoryImportDiscoveryJob(BOrd bOrd) {
        return (BOrd)this.invoke(submitHistoryImportDiscoveryJob, (BValue)bOrd, null);
    }

    public BOrd submitPointDiscoveryJob(BOrdList bOrdList) {
        return (BOrd)this.invoke(submitPointDiscoveryJob, (BValue)bOrdList, null);
    }

    public BOrd submitSingleDeviceDiscoveryJob(BPrimaryDiscoverOptions bPrimaryDiscoverOptions) {
        return (BOrd)this.invoke(submitSingleDeviceDiscoveryJob, (BValue)bPrimaryDiscoverOptions, null);
    }

    public BOrd submitPrimaryDiscoverJob(BEncodableList bEncodableList) {
        return (BOrd)this.invoke(submitPrimaryDiscoverJob, (BValue)bEncodableList, null);
    }

    public BOrd submitPrimaryDiscoverRangeJob(BPrimaryDiscoverOptions bPrimaryDiscoverOptions) {
        return (BOrd)this.invoke(submitPrimaryDiscoverRangeJob, (BValue)bPrimaryDiscoverOptions, null);
    }

    public BOrd submitAssignBaudRateJob(BMbusAssignBaudRateData bMbusAssignBaudRateData) {
        return (BOrd)this.invoke(submitAssignBaudRateJob, (BValue)bMbusAssignBaudRateData, null);
    }

    public BOrd submitFullSecondaryDiscoverJob(BSecondaryDiscoverOptions bSecondaryDiscoverOptions) {
        return (BOrd)this.invoke(submitFullSecondaryDiscoverJob, (BValue)bSecondaryDiscoverOptions, null);
    }

    public BOrd submitSecondaryAddressScanJob(BSecondaryDiscoverOptions bSecondaryDiscoverOptions) {
        return (BOrd)this.invoke(submitSecondaryAddressScanJob, (BValue)bSecondaryDiscoverOptions, null);
    }

    public void assignAddress(BInteger bInteger) {
        this.invoke(assignAddress, (BValue)bInteger, null);
    }

    public void clearNetworkDatabase() {
        this.invoke(clearNetworkDatabase, null, null);
    }

    public void updateReceiverResetTimeout() {
        this.invoke(updateReceiverResetTimeout, null, null);
    }

    public Type getType() {
        return TYPE;
    }

    public void doUpdateReceiverResetTimeout() {
        BAbstractMbusNetwork bAbstractMbusNetwork = this;
        this.getWriteWorker().post(new Runnable((BComponent)bAbstractMbusNetwork){
            final /* synthetic */ BComponent val$srcComp;

            public final void run() {
                try {
                    BRelTime bRelTime = BAbstractMbusNetwork.this.getReceiverBufferResetTimeout();
                    CommReceiver commReceiver = BAbstractMbusNetwork.this.getComm().getCommReceiver();
                    if (commReceiver instanceof MbusCommReceiver) {
                        ((MbusCommReceiver)commReceiver).setReceiveBufferTimeout(bRelTime);
                    }
                }
                catch (Throwable throwable) {
                    if (MbusToolkit.isTraceOn()) {
                        MbusToolkit.trace("Re-attempting receiver timeout setup in 5 seconds due to " + throwable.getMessage());
                    }
                    Clock.schedule((BComponent)this.val$srcComp, (BRelTime)BRelTime.makeSeconds((int)5), (Action)updateReceiverResetTimeout, null);
                }
            }
            {
                this.val$srcComp = bComponent;
            }
        });
    }

    public void descendantsStarted() throws Exception {
        super.descendantsStarted();
        this.doUpdateReceiverResetTimeout();
    }

    public static BBasicPollScheduler makeDefaultPollScheduler() {
        BBasicPollScheduler bBasicPollScheduler = new BBasicPollScheduler();
        bBasicPollScheduler.setFastRate(BRelTime.make((long)30000L));
        bBasicPollScheduler.setNormalRate(BRelTime.make((long)45000L));
        bBasicPollScheduler.setSlowRate(BRelTime.make((long)90000L));
        return bBasicPollScheduler;
    }

    public static BSerialHelper makeDefaultSerialHelper() {
        BSerialHelper bSerialHelper = new BSerialHelper();
        bSerialHelper.setParity(BSerialParity.even);
        bSerialHelper.setBaudRate((BBaudRate)BMbusBaudRate.baud300);
        return bSerialHelper;
    }

    public static BPingMonitor makeDefaultPingMonitor() {
        BPingMonitor bPingMonitor = new BPingMonitor();
        bPingMonitor.setPingFrequency(BRelTime.makeMinutes((int)30));
        return bPingMonitor;
    }

    public BFacets getSlotFacets(Slot slot) {
        if (slot == interMessageDelay) {
            String[] stringArray = new String[]{"showSeconds", "showMilliseconds", "min", "max"};
            BIDataValue[] bIDataValueArray = new BIDataValue[]{BBoolean.TRUE, BBoolean.TRUE, BRelTime.make((long)0L), BRelTime.MINUTE};
            return BFacets.make((String[])stringArray, (BIDataValue[])bIDataValueArray);
        }
        return super.getSlotFacets(slot);
    }

    public Type getDeviceType() {
        return BMbusDevice.TYPE;
    }

    public Type getDeviceFolderType() {
        return BMbusDeviceFolder.TYPE;
    }

    public void started() throws Exception {
        super.started();
        MbusToolkit.setLog(this.getLog());
        this.startStationMonitorSaving();
        this.setFlags((Slot)ping, 4);
        this.setFlags((Slot)upload, 4);
        this.setFlags((Slot)download, 4);
        this.setSearchFcBitInUse(true);
        this.setSearchFcBitState(false);
        this.setTestMode(BMbusTestControl.inactive);
        if (this.getLog().isTraceOn()) {
            this.getLog().trace("*** Mbus Driver Started ***");
        }
    }

    public void stopped() throws Exception {
        super.stopped();
        this.stopStationMonitorSaving();
    }

    protected Comm makeComm() {
        MbusCommReceiver mbusCommReceiver = new MbusCommReceiver();
        mbusCommReceiver.setCollisionHexBytes(this.getCollisionCsvBytes());
        return new MbusSerialComm(this, mbusCommReceiver, new MbusCommTransmitter());
    }

    public BOrd doSubmitDeviceDiscoveryJob(BOrd bOrd) {
        BMbusDeviceDiscoveryJob bMbusDeviceDiscoveryJob = new BMbusDeviceDiscoveryJob(this);
        bMbusDeviceDiscoveryJob.setPrevJob(bOrd);
        return bMbusDeviceDiscoveryJob.submit(null);
    }

    public BOrd doSubmitHistoryImportDiscoveryJob(BOrd bOrd) {
        return new BMbusHistoryImportDiscoveryJob(this.getSlotPathOrd(), bOrd).submit(null);
    }

    public BOrd doSubmitPointDiscoveryJob(BOrdList bOrdList) {
        if (bOrdList.size() == 0) {
            throw new RuntimeException("Expected 1 or 2 ords to submitPointDiscoveryJob - [0] = Device BOrd, [1] = Previous job BOrd");
        }
        BOrd bOrd = bOrdList.get(0);
        BOrd bOrd2 = bOrdList.get(1);
        return new BMbusPointDiscoveryJob(this.getSlotPathOrd(), bOrd, bOrd2).submit(null);
    }

    public final Feature getLicenseFeature() {
        Feature feature = Sys.getLicenseManager().checkFeature("tridium", "mbus");
        String[] stringArray = feature.list();
        int n = 0;
        while (n < stringArray.length) {
            if (stringArray[n].equals(this.getLicenseConnectTypeName()) && !feature.getb(stringArray[n], true)) {
                throw new FeatureNotLicensedException("Not licensed for " + this.getLicenseConnectTypeName());
            }
            ++n;
        }
        return feature;
    }

    protected abstract String getLicenseConnectTypeName();

    public BOrd doSubmitSingleDeviceDiscoveryJob(BPrimaryDiscoverOptions bPrimaryDiscoverOptions) {
        bPrimaryDiscoverOptions.getAddrRange().setStart(254);
        bPrimaryDiscoverOptions.getAddrRange().setEnd(254);
        BMbusPrimaryDeviceSearchJob bMbusPrimaryDeviceSearchJob = new BMbusPrimaryDeviceSearchJob(this);
        bMbusPrimaryDeviceSearchJob.setDiscoveryOptions(bPrimaryDiscoverOptions);
        bMbusPrimaryDeviceSearchJob.setSingleDeviceScan(true);
        return bMbusPrimaryDeviceSearchJob.submit(null);
    }

    public BOrd doSubmitPrimaryDiscoverRangeJob(BPrimaryDiscoverOptions bPrimaryDiscoverOptions) {
        BMbusPrimaryDeviceSearchJob bMbusPrimaryDeviceSearchJob = new BMbusPrimaryDeviceSearchJob(this);
        bMbusPrimaryDeviceSearchJob.setDiscoveryOptions(bPrimaryDiscoverOptions);
        return bMbusPrimaryDeviceSearchJob.submit(null);
    }

    public BOrd doSubmitFullSecondaryDiscoverJob(BSecondaryDiscoverOptions bSecondaryDiscoverOptions) {
        BMbusSecondaryDeviceSearchJob bMbusSecondaryDeviceSearchJob = new BMbusSecondaryDeviceSearchJob(this);
        bMbusSecondaryDeviceSearchJob.setDiscoveryOptions(bSecondaryDiscoverOptions);
        return bMbusSecondaryDeviceSearchJob.submit(null);
    }

    public BOrd doSubmitSecondaryAddressScanJob(BSecondaryDiscoverOptions bSecondaryDiscoverOptions) {
        BMbusSecondaryAddressScanJob bMbusSecondaryAddressScanJob = new BMbusSecondaryAddressScanJob(this);
        bMbusSecondaryAddressScanJob.setDiscoveryOptions(bSecondaryDiscoverOptions);
        return bMbusSecondaryAddressScanJob.submit(null);
    }

    public BOrd doSubmitPrimaryDiscoverJob(BEncodableList bEncodableList) {
        BOrd bOrd = BOrd.NULL;
        try {
            String[] stringArray = bEncodableList.toStringArray();
            BMbusDevice[] bMbusDeviceArray = new BMbusDevice[stringArray.length];
            int n = 0;
            while (n < stringArray.length) {
                bMbusDeviceArray[n] = (BMbusDevice)BOrd.make((String)stringArray[n]).get((BObject)this);
                ++n;
            }
            BMbusUpdateDevicesJob bMbusUpdateDevicesJob = new BMbusUpdateDevicesJob(this);
            bMbusUpdateDevicesJob.setDevicesToUpdate(bMbusDeviceArray);
            bOrd = bMbusUpdateDevicesJob.submit(null);
        }
        catch (Exception exception) {
            MbusToolkit.error("Error in Device discovery Job, String part ", exception);
        }
        return bOrd;
    }

    public BOrd doSubmitAssignBaudRateJob(BMbusAssignBaudRateData bMbusAssignBaudRateData) {
        return new BMbusAssignBaudRateJob(this, bMbusAssignBaudRateData).submit(null);
    }

    public void doAssignAddress(BInteger bInteger) {
        new BMbusAssignAddressJob(this, bInteger.getInt(), null).submit(null);
    }

    public void doClearNetworkDatabase() {
        this.getNetworkDatabase().clearAllDetectedDevices();
    }

    public void changed(Property property, Context context) {
        if (property.equals((Object)retryCount) || property.equals((Object)interMessageDelay) || property.equals((Object)responseTimeout) || property.equals((Object)initialisationDelay)) {
            MBusTxTimings mBusTxTimings = new MBusTxTimings();
            mBusTxTimings.initalisationDelay = (BRelTime)this.getInitialisationDelay().newCopy();
            mBusTxTimings.retryTransmission = this.getRetryCount();
            mBusTxTimings.responseTimeout = (BRelTime)this.getResponseTimeout().newCopy();
            mBusTxTimings.intermessageDelay = this.getInterMessageDelay().getMillis();
            this.networkTxTimings = mBusTxTimings;
        } else if (property.equals((Object)receiverBufferResetTimeout) && Sys.isStationStarted()) {
            this.doUpdateReceiverResetTimeout();
        }
    }

    protected void startStationMonitorSaving() {
        BJobService bJobService = (BJobService)Sys.getService((Type)BJobService.TYPE);
        if (bJobService != null && !this.jobServiceMonitor.isSubscribed((BComponent)bJobService)) {
            if (this.getLog().isTraceOn()) {
                this.getLog().trace("*** MBus Driver -> Station Save Monitoring Started against " + bJobService.getHandleOrd() + " ***");
            }
            this.jobServiceMonitor.setLog(this.getLog());
            this.jobServiceMonitor.subscribe((BComponent)bJobService);
        }
    }

    protected void stopStationMonitorSaving() {
        this.jobServiceMonitor.unsubscribeAll();
        this.noStationSaves();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void stationSavesActive() {
        Object object = this.savesActiveLock;
        synchronized (object) {
            this.savesActive = true;
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void noStationSaves() {
        Object object = this.savesActiveLock;
        synchronized (object) {
            this.savesActive = false;
            // MONITOREXIT @DISABLED, blocks:[0, 1] lbl5 : MonitorExitStatement: MONITOREXIT : var1_1
            this.getNetworkDatabase().startRestoration();
            return;
        }
    }

    public final boolean savesActive() {
        return this.savesActive;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void lockSends(Object object) {
        Object object2 = this.sendLock;
        synchronized (object2) {
            if (this.sendActiveLock == object) {
                return;
            }
            do {
                if (this.sendActiveLock == object) {
                    return;
                }
                if (this.getLog().isTraceOn()) {
                    this.getLog().trace(BAbsTime.now().encodeToString() + ":Waiting for exclusive comms lock against " + object);
                }
                if (this.sendActiveLock == null) continue;
                try {
                    this.sendLock.wait();
                }
                catch (InterruptedException interruptedException) {}
            } while (this.sendActiveLock != null);
            this.sendActiveLock = object;
            if (this.getLog().isTraceOn()) {
                this.getLog().trace(BAbsTime.now().encodeToString() + ":Exclusive comms locked against " + object);
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void unlockSends(Object object) {
        Object object2 = this.sendLock;
        synchronized (object2) {
            if (this.sendActiveLock == object) {
                if (this.getLog().isTraceOn()) {
                    this.getLog().trace(BAbsTime.now().encodeToString() + ":Exclusive comms released against " + object);
                }
                this.sendActiveLock = null;
                this.sendLock.notifyAll();
            }
            return;
        }
    }

    public final Message sendMBusSyncActiveParams(Message message, long l) {
        return this.sendMBusSync(this.activeTxTimings, this.sendActiveLock, message, l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final Message sendMBusSync(MBusTxTimings mBusTxTimings, Object object, Message message, long l) {
        this.lockSends(object);
        long l2 = l;
        l2 += mBusTxTimings.responseTimeout.getMillis();
        if (this.getLog().isTraceOn()) {
            this.getLog().trace(BAbsTime.now().encodeToString() + ":DynamicResponseTimeout " + l2 + "ms");
        }
        Object object2 = this.sendLock;
        synchronized (object2) {
            if (this.sendActiveLock == object) {
                if (this.getLog().isTraceOn()) {
                    this.getLog().trace(BAbsTime.now().encodeToString() + ":Exclusive comms sending against " + object);
                }
                this.activeTxTimings = mBusTxTimings;
                return this.sendSync(message, BRelTime.make((long)l2), this.activeTxTimings.retryTransmission);
            }
            if (this.getLog().isLoggable(2)) {
                this.getLog().warning(BAbsTime.now().encodeToString() + ":Exclusive comms sending (locking failed against " + object + ')');
            }
            this.activeTxTimings = mBusTxTimings;
            return this.sendSync(message, BRelTime.make((long)l2), this.activeTxTimings.retryTransmission);
        }
    }

    public MBusTxTimings getActiveTxTimings() {
        return this.activeTxTimings;
    }

    public Object getSendLockActive() {
        return this.sendActiveLock;
    }

    public MBusTxTimings getTxTimingsReference() {
        return this.networkTxTimings;
    }

    public static int getCurrentTestMeterNumber() {
        return currentTestMeterNumber;
    }

    public static void setCurrentTestMeterNumber(int n) {
        currentTestMeterNumber = n;
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final /* synthetic */ void this() {
        this.savesActive = false;
        this.savesActiveLock = new Object();
        this.jobServiceMonitor = new StationSaveSubscriber();
        this.sendLock = new Object();
        this.sendActiveLock = null;
        this.activeTxTimings = this.getTxTimingsReference();
        this.networkTxTimings = new MBusTxTimings();
    }

    public BAbstractMbusNetwork() {
        this.this();
        MbusToolkit.setLog(this.getLog());
    }

    static {
        Class clazz = class$com$tridium$mbus$BAbstractMbusNetwork;
        if (clazz == null) {
            clazz = class$com$tridium$mbus$BAbstractMbusNetwork = BAbstractMbusNetwork.class("[Lcom.tridium.mbus.BAbstractMbusNetwork;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
        currentTestMeterNumber = 0;
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    protected final class StationSaveSubscriber
    extends Subscriber {
        protected Log log;

        public final void setLog(Log log) {
            this.log = log;
        }

        public final void event(BComponentEvent bComponentEvent) {
            if (bComponentEvent.getValue().getType().is(BJobState.TYPE)) {
                switch (((BJobState)bComponentEvent.getValue()).getOrdinal()) {
                    case 1: {
                        break;
                    }
                    case 3: 
                    case 4: 
                    case 5: {
                        this.checkOutstandingSaveJobs(bComponentEvent.getSourceComponent());
                    }
                    case 2: {
                        break;
                    }
                    default: {
                        if (!this.log.isLoggable(3)) break;
                        this.log.error("StationSaveSubscriber - unknown event id state : " + ((BJobState)bComponentEvent.getValue()).getOrdinal());
                    }
                }
                return;
            }
            if (bComponentEvent.getValue().getType().is(BStationSaveJob.TYPE)) {
                switch (bComponentEvent.getId()) {
                    case 1: {
                        BAbstractMbusNetwork.this.jobServiceMonitor.subscribe((BComponent)bComponentEvent.getValue(), 2);
                        BAbstractMbusNetwork.this.stationSavesActive();
                        if (this.log == null || !this.log.isTraceOn()) break;
                        this.log.trace("Awaiting station save state updates");
                        break;
                    }
                    case 0: 
                    case 2: {
                        this.checkOutstandingSaveJobs(bComponentEvent.getSourceComponent());
                        break;
                    }
                }
            }
        }

        public final void checkOutstandingSaveJobs(BComponent bComponent) {
            if (this.log.isTraceOn()) {
                this.log.trace("Checking for save station job completions");
            }
            int n = 0;
            Class clazz = class$com$tridium$sys$station$BStationSaveJob;
            if (clazz == null) {
                clazz = class$com$tridium$sys$station$BStationSaveJob = BAbstractMbusNetwork.class("[Lcom.tridium.sys.station.BStationSaveJob;", false);
            }
            Object[] objectArray = bComponent.getChildren(clazz);
            int n2 = 0;
            while (n2 < objectArray.length) {
                BStationSaveJob bStationSaveJob = (BStationSaveJob)objectArray[n2];
                switch (bStationSaveJob.getJobState().getOrdinal()) {
                    case 1: 
                    case 2: {
                        ++n;
                        break;
                    }
                }
                ++n2;
            }
            if (n == 0) {
                if (this.log.isTraceOn()) {
                    this.log.trace("No station saves are active");
                }
                BAbstractMbusNetwork.this.noStationSaves();
            } else {
                if (this.log.isTraceOn()) {
                    this.log.trace(n + " station saves are active");
                }
                BAbstractMbusNetwork.this.stationSavesActive();
            }
        }

        private final /* synthetic */ void this() {
            this.log = Log.getLog((String)"MBusStationSaveMonitor");
        }

        protected StationSaveSubscriber() {
            this.this();
        }
    }
}

