/*
 * Decompiled with CFR 0.152.
 */
package com.wunderground.weather;

import java.io.InputStream;
import java.net.URI;
import javax.baja.data.BIDataValue;
import javax.baja.naming.BHost;
import javax.baja.naming.BIpHost;
import javax.baja.net.HttpConnection;
import javax.baja.status.BStatus;
import javax.baja.status.BStatusEnum;
import javax.baja.status.BStatusNumeric;
import javax.baja.status.BStatusString;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BEnum;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIcon;
import javax.baja.sys.BInteger;
import javax.baja.sys.BMonth;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BajaException;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.units.BUnit;
import javax.baja.util.Array;
import javax.baja.weather.BForecast;
import javax.baja.weather.BWeatherProvider;
import javax.baja.weather.BWeatherReport;
import javax.baja.weather.BWeatherService;
import javax.baja.weather.BWeatherState;
import javax.baja.weather.BWindDirection;
import javax.baja.xml.XElem;
import javax.baja.xml.XParser;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BWundergroundWeatherProvider
extends BWeatherProvider {
    public static final Property latitude = BWundergroundWeatherProvider.newProperty((int)8, (double)37.55, (BFacets)BFacets.make((String)"units", (BIDataValue)BUnit.getUnit((String)"degrees angular"), (String)"precision", (BIDataValue)BInteger.make((int)2)));
    public static final Property longitude = BWundergroundWeatherProvider.newProperty((int)8, (double)-77.46, (BFacets)BFacets.make((String)"units", (BIDataValue)BUnit.getUnit((String)"degrees angular"), (String)"precision", (BIDataValue)BInteger.make((int)2)));
    public static final Property location = BWundergroundWeatherProvider.newProperty((int)1, (String)"", null);
    public static final Property key = BWundergroundWeatherProvider.newProperty((int)0, (String)"", null);
    public static final Type TYPE;
    private static final BIcon icon;
    static /* synthetic */ Class class$com$wunderground$weather$BWundergroundWeatherProvider;
    static /* synthetic */ Class class$javax$baja$weather$BForecast;

    public double getLatitude() {
        return this.getDouble(latitude);
    }

    public void setLatitude(double d) {
        this.setDouble(latitude, d, null);
    }

    public double getLongitude() {
        return this.getDouble(longitude);
    }

    public void setLongitude(double d) {
        this.setDouble(longitude, d, null);
    }

    public String getLocation() {
        return this.getString(location);
    }

    public void setLocation(String string) {
        this.setString(location, string, null);
    }

    public String getKey() {
        return this.getString(key);
    }

    public void setKey(String string) {
        this.setString(key, string, null);
    }

    public Type getType() {
        return TYPE;
    }

    public String toString(Context context) {
        return "wunderground.com (" + this.getLocation() + ')';
    }

    public BIcon getIcon() {
        return icon;
    }

    public void changed(Property property, Context context) {
        super.changed(property, context);
        if (this.isRunning() && (property.equals((Object)longitude) || property.equals((Object)latitude) || property.equals((Object)key))) {
            this.updateReport();
            this.updateSunStatus();
        }
    }

    private final XElem getFeed() throws Exception {
        return this.getFeed(new URI("http", null, "api.wunderground.com", 80, "/api/" + this.getKey() + "/forecast/alerts/conditions/lang:EN/q/" + this.getLatitude() + ',' + this.getLongitude() + ".xml", "", null));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final XElem getFeed(URI uRI) throws Exception {
        HttpConnection httpConnection;
        block4: {
            XElem xElem;
            httpConnection = new HttpConnection((BHost)new BIpHost(uRI.getHost()), uRI.getPort(), uRI.getPath());
            try {
                httpConnection.setUserAgent("Niagara/" + Sys.getRegistry().getModule("baja").getVendorVersion());
                httpConnection.setTimeout((int)BRelTime.makeSeconds((int)30).getMillis());
                httpConnection.connect();
                if (httpConnection.getStatusCode() != 301 && httpConnection.getStatusCode() != 302) break block4;
                BWeatherService.log.trace("Redirect to " + httpConnection.getResponseHeader("Location"));
                xElem = this.getFeed(new URI(httpConnection.getResponseHeader("Location")));
                Object var4_5 = null;
            }
            catch (Throwable throwable) {
                Object var4_7 = null;
                httpConnection.close();
                throw throwable;
            }
            httpConnection.close();
            return xElem;
        }
        if (httpConnection.getStatusCode() / 100 != 2) {
            throw new BajaException("" + httpConnection.getStatusCode() + ' ' + httpConnection.getStatusMessage(), (Throwable)new Exception(uRI.toString()));
        }
        XElem xElem = XParser.make((InputStream)httpConnection.getInputStream()).parse();
        Object var4_6 = null;
        httpConnection.close();
        return xElem;
    }

    /*
     * Unable to fully structure code
     */
    public void updateReport() {
        block19: {
            if (this.getKey().length() == 0) {
                return;
            }
            var1_1 = (BWeatherReport)this.getParent();
            try {
                var2_2 = this.getFeed();
                if (var2_2.elem("error") != null) {
                    var1_1.setStatus(BStatus.fault);
                    throw new Exception("Error encountered: " + var2_2.elem("error").elem("description").text().toString());
                }
                var1_1.setStatus(BStatus.ok);
                this.setLocation(var2_2.elem("current_observation").elem("display_location").elem("full").text().toString());
                var3_4 = var1_1.getCurrent();
                this.setStatusString(var3_4.getWeatherSummary(), var2_2.elem("current_observation").elem("weather").text().toString());
                this.setStatusEnum(var3_4.getState(), (BEnum)BWeatherState.make((String)var3_4.getWeatherSummary().getValue()));
                this.setStatusNumeric(var3_4.getTemp(), var2_2.elem("current_observation").elem("temp_f").text().toString());
                this.setStatusNumeric(var3_4.getHeatIndex(), var2_2.elem("current_observation").elem("heat_index_f").text().toString());
                this.setStatusNumeric(var3_4.getDewPoint(), var2_2.elem("current_observation").elem("dewpoint_f").text().toString());
                this.setStatusNumeric(var3_4.getVisibility(), var2_2.elem("current_observation").elem("visibility_mi").text().toString());
                this.setStatusNumeric(var3_4.getPressure(), var2_2.elem("current_observation").elem("pressure_in").text().toString());
                this.setStatusNumeric(var3_4.getWindGust(), var2_2.elem("current_observation").elem("wind_gust_mph").text().toString());
                this.setStatusNumeric(var3_4.getWindChill(), var2_2.elem("current_observation").elem("windchill_f").text().toString());
                this.setStatusNumeric(var3_4.getWindChill(), var2_2.elem("current_observation").elem("windchill_f").text().toString());
                var4_6 = var2_2.elem("current_observation").elem("relative_humidity").text().toString();
                this.setStatusNumeric(var3_4.getHumidity(), var4_6.substring(0, var4_6.length() - 1));
                this.setStatusNumeric(var3_4.getWindSpeed(), var2_2.elem("current_observation").elem("wind_mph").text().toString());
                switch (var2_2.elem("current_observation").elem("wind_dir").text().toString().charAt(0)) {
                    case 'N': {
                        this.setStatusEnum(var3_4.getWindDirection(), (BEnum)BWindDirection.north);
                        break;
                    }
                    case 'S': {
                        this.setStatusEnum(var3_4.getWindDirection(), (BEnum)BWindDirection.south);
                        break;
                    }
                    case 'W': {
                        this.setStatusEnum(var3_4.getWindDirection(), (BEnum)BWindDirection.west);
                        break;
                    }
                    case 'E': {
                        this.setStatusEnum(var3_4.getWindDirection(), (BEnum)BWindDirection.east);
                        break;
                    }
                }
                var3_4.setSun(this.getLongitude(), this.getLatitude());
                var5_8 = var2_2.elem("forecast").elem("simpleforecast").elem("forecastdays").elems("forecastday");
                v0 = BWundergroundWeatherProvider.class$javax$baja$weather$BForecast;
                if (v0 == null) {
                    v0 = BWundergroundWeatherProvider.class$javax$baja$weather$BForecast = BWundergroundWeatherProvider.class("[Ljavax.baja.weather.BForecast;", false);
                }
                var6_9 = new Array(v0);
                var7_10 = 0;
                while (var7_10 < var5_8.length) {
                    var8_12 = new BForecast();
                    this.setStatusNumeric(var8_12.getHigh(), var5_8[var7_10].elem("high").elem("fahrenheit").text().toString());
                    this.setStatusNumeric(var8_12.getLow(), var5_8[var7_10].elem("low").elem("fahrenheit").text().toString());
                    this.setStatusString(var8_12.getWeatherSummary(), var5_8[var7_10].elem("conditions").text().toString());
                    this.setStatusEnum(var8_12.getState(), (BEnum)BWeatherState.make((String)var8_12.getWeatherSummary().getValue()));
                    this.setStatusNumeric(var8_12.getPrecipChance(), var5_8[var7_10].elem("pop").text().toString());
                    try {
                        var9_14 = Integer.parseInt(var5_8[var7_10].elem("date").elem("year").text().toString());
                        var10_16 = BMonth.make((int)(Integer.parseInt(var5_8[var7_10].elem("date").elem("month").text().toString()) - 1));
                        var11_17 = Integer.parseInt(var5_8[var7_10].elem("date").elem("day").text().toString());
                        var8_12.setDate(BAbsTime.make((int)var9_14, (BMonth)var10_16, (int)var11_17));
                    }
                    catch (NumberFormatException var9_15) {
                        var8_12.setDate(BAbsTime.NULL);
                    }
                    var8_12.setLastUpdate(BAbsTime.now());
                    var8_12.setSun(var8_12.getDate(), this.getLatitude(), this.getLongitude());
                    var6_9.add((Object)var8_12);
                    ++var7_10;
                }
                var1_1.setForecast((BForecast[])var6_9.trim());
                if (BWeatherService.log.isTraceOn()) {
                    BWeatherService.log.trace("Updated weather for " + this.toString());
                }
                var3_4.setLastUpdate(BAbsTime.now());
                var1_1.getCurrent().setStatus(BStatus.ok);
                v1 = BWundergroundWeatherProvider.class$javax$baja$weather$BForecast;
                if (v1 == null) {
                    v1 = BWundergroundWeatherProvider.class$javax$baja$weather$BForecast = BWundergroundWeatherProvider.class("[Ljavax.baja.weather.BForecast;", false);
                }
                var7_11 = (BForecast[])var1_1.getChildren(v1);
                var8_13 = 0;
                while (var8_13 < var7_11.length) {
                    var7_11[var8_13].setStatus(BStatus.ok);
                    ++var8_13;
                }
                break block19;
            }
            catch (Exception var2_3) {
                var1_1.getCurrent().setStatus(BStatus.stale);
                v2 = BWundergroundWeatherProvider.class$javax$baja$weather$BForecast;
                if (v2 == null) {
                    v2 = BWundergroundWeatherProvider.class$javax$baja$weather$BForecast = BWundergroundWeatherProvider.class("[Ljavax.baja.weather.BForecast;", false);
                }
                var3_5 = (BForecast[])var1_1.getChildren(v2);
                var4_7 = 0;
                ** while (var4_7 < var3_5.length)
            }
lbl-1000:
            // 1 sources

            {
                var3_5[var4_7].setStatus(BStatus.stale);
                ++var4_7;
                continue;
            }
lbl92:
            // 1 sources

            BWeatherService.log.error("Updating weather failed for " + this.toString(), (Throwable)var2_3);
        }
    }

    private final void setStatusString(BStatusString bStatusString, String string) throws Exception {
        try {
            if (string != null) {
                bStatusString.setStatus(BStatus.ok);
                bStatusString.setValue(string);
            } else {
                bStatusString.setStatus(64);
            }
        }
        catch (Exception exception) {
            bStatusString.setStatus(64);
        }
    }

    private final void setStatusNumeric(BStatusNumeric bStatusNumeric, String string) throws Exception {
        try {
            if (string != null && !string.equals("NA") && !string.startsWith("-999")) {
                bStatusNumeric.setStatus(BStatus.ok);
                bStatusNumeric.setValue(Double.parseDouble(string));
            } else {
                bStatusNumeric.setStatus(64);
            }
        }
        catch (Exception exception) {
            bStatusNumeric.setStatus(64);
        }
    }

    private final void setStatusEnum(BStatusEnum bStatusEnum, BEnum bEnum) throws Exception {
        try {
            if (bEnum != null) {
                bStatusEnum.setStatus(BStatus.ok);
                bStatusEnum.setValue(bEnum);
            } else {
                bStatusEnum.setStatus(64);
            }
        }
        catch (Exception exception) {
            bStatusEnum.setStatus(64);
        }
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        Class clazz = class$com$wunderground$weather$BWundergroundWeatherProvider;
        if (clazz == null) {
            clazz = class$com$wunderground$weather$BWundergroundWeatherProvider = BWundergroundWeatherProvider.class("[Lcom.wunderground.weather.BWundergroundWeatherProvider;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
        icon = BIcon.make((String)"module://weatherUnderground/icons/wunderground.png");
    }
}

