/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.wiresheet.states;

import com.tridium.ui.theme.Theme;
import com.tridium.wiresheet.BThumbnail;
import com.tridium.wiresheet.BWireSheetPane;
import com.tridium.wiresheet.WsState;
import com.tridium.wiresheet.states.NormalState;
import javax.baja.gx.Point;
import javax.baja.gx.RectGeom;
import javax.baja.ui.event.BMouseEvent;

public class ViewportDragState
extends WsState {
    private Point anchor;
    private double pOrig;
    private double qOrig;

    public void mouseReleased(BMouseEvent bMouseEvent) {
        this.transition(new NormalState(this.ws));
        Point point = this.translateToCanvasPane(bMouseEvent);
        double d = point.x;
        double d2 = point.y;
        this.updateViewport(d, d2);
    }

    public void mouseDragged(BMouseEvent bMouseEvent) {
        Point point = this.translateToCanvasPane(bMouseEvent);
        double d = point.x;
        double d2 = point.y;
        this.updateViewport(d, d2);
    }

    private final void updateViewport(double d, double d2) {
        double d3 = Theme.scrollBar().getFixedWidth();
        double d4 = this.ws.getWidth() - d3;
        double d5 = this.ws.getHeight() - d3;
        BThumbnail bThumbnail = this.ws.getThumbnail();
        double d6 = (d -= bThumbnail.getX()) - (this.anchor.x - this.pOrig);
        double d7 = (d2 -= bThumbnail.getY()) - (this.anchor.y - this.qOrig);
        RectGeom rectGeom = new RectGeom(d6 * (double)this.ws.grid.wixel, d7 * (double)this.ws.grid.wixel, d4, d5);
        this.ws.getScrollPane().scrollToVisible(rectGeom);
    }

    public ViewportDragState(BWireSheetPane bWireSheetPane, Point point, double d, double d2) {
        super(bWireSheetPane);
        BThumbnail bThumbnail = bWireSheetPane.getThumbnail();
        point.translate(-bThumbnail.getX(), -bThumbnail.getY());
        this.anchor = point;
        RectGeom rectGeom = bWireSheetPane.getScrollPane().getViewport();
        this.pOrig = rectGeom.x / (double)bWireSheetPane.grid.wixel;
        this.qOrig = rectGeom.y / (double)bWireSheetPane.grid.wixel;
        this.updateViewport(d, d2);
    }
}

