/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.wiresheet.states;

import com.tridium.wiresheet.BThumbnail;
import com.tridium.wiresheet.BWireSheetPane;
import com.tridium.wiresheet.WsState;
import com.tridium.wiresheet.states.NormalState;
import com.tridium.wiresheet.states.ThumbnailDragState;
import com.tridium.wiresheet.states.ViewportDragState;
import javax.baja.gx.Point;
import javax.baja.gx.RectGeom;
import javax.baja.ui.event.BKeyEvent;
import javax.baja.ui.event.BMouseEvent;
import javax.baja.ui.event.BMouseWheelEvent;

public class ThumbnailOverState
extends WsState {
    private Point dragCheckPoint;

    public void keyPressed(BKeyEvent bKeyEvent) {
        if (bKeyEvent.isControlDown()) {
            switch (bKeyEvent.getKeyCode()) {
                case 38: {
                    this.ws.commands.zoomIn.invoke();
                    break;
                }
                case 40: {
                    this.ws.commands.zoomOut.invoke();
                    break;
                }
            }
        }
    }

    public void mousePressed(BMouseEvent bMouseEvent) {
        this.dragCheckPoint = this.translateToCanvasPane(bMouseEvent);
    }

    public void mouseReleased(BMouseEvent bMouseEvent) {
        double d;
        double d2;
        this.dragCheckPoint = null;
        Point point = this.translateToCanvasPane(bMouseEvent);
        BThumbnail bThumbnail = this.ws.getThumbnail();
        if (bThumbnail.contains(d2 = point.x - bThumbnail.getX(), d = point.y - bThumbnail.getY())) {
            this.centerViewport((int)d2, (int)d);
        }
    }

    public void mouseMoved(BMouseEvent bMouseEvent) {
        Point point = this.translateToCanvasPane(bMouseEvent);
        double d = point.x;
        double d2 = point.y;
        BThumbnail bThumbnail = this.ws.getThumbnail();
        if (!bThumbnail.contains(d - bThumbnail.getX(), d2 - bThumbnail.getY())) {
            this.transition(new NormalState(this.ws));
            return;
        }
    }

    public void mouseDragged(BMouseEvent bMouseEvent) {
        Point point = this.translateToCanvasPane(bMouseEvent);
        double d = point.x;
        double d2 = point.y;
        if (this.dragCheckPoint == null) {
            return;
        }
        if (Math.abs(this.dragCheckPoint.x - d) < 8.0 && Math.abs(this.dragCheckPoint.y - d2) < 8.0) {
            return;
        }
        if (bMouseEvent.isControlDown()) {
            this.transition(new ThumbnailDragState(this.ws, this.dragCheckPoint, d, d2));
        } else {
            this.transition(new ViewportDragState(this.ws, this.dragCheckPoint, d, d2));
        }
    }

    public void mouseWheel(BMouseWheelEvent bMouseWheelEvent) {
        if (bMouseWheelEvent.isControlDown()) {
            this.ws.controller.zoom(bMouseWheelEvent.getWheelRotation() * -1);
            bMouseWheelEvent.consume();
            this.ws.relayout();
        }
    }

    private final void centerViewport(int n, int n2) {
        RectGeom rectGeom = this.ws.getScrollPane().getViewport();
        double d = rectGeom.width / (double)this.ws.grid.wixel;
        double d2 = rectGeom.height / (double)this.ws.grid.wixel;
        double d3 = (double)(n - 1) - d / (double)2;
        double d4 = (double)(n2 - 1) - d2 / (double)2;
        RectGeom rectGeom2 = new RectGeom(d3 * (double)this.ws.grid.wixel, d4 * (double)this.ws.grid.wixel, rectGeom.width, rectGeom.height);
        this.ws.getScrollPane().scrollToVisible(rectGeom2);
    }

    public ThumbnailOverState(BWireSheetPane bWireSheetPane) {
        super(bWireSheetPane);
    }
}

