/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.wiresheet.states;

import com.tridium.ui.theme.Theme;
import com.tridium.wiresheet.BThumbnail;
import com.tridium.wiresheet.BWireSheetPane;
import com.tridium.wiresheet.BWsOptions;
import com.tridium.wiresheet.WsConst;
import com.tridium.wiresheet.WsState;
import com.tridium.wiresheet.states.NormalState;
import javax.baja.gx.Point;
import javax.baja.ui.event.BMouseEvent;

public class ThumbnailDragState
extends WsState {
    private Point anchor;

    public void mouseReleased(BMouseEvent bMouseEvent) {
        this.transition(new NormalState(this.ws));
        Point point = this.translateToCanvasPane(bMouseEvent);
        double d = point.x;
        double d2 = point.y;
        this.updateOptions(d, d2);
        BWsOptions.make().save();
    }

    public void mouseDragged(BMouseEvent bMouseEvent) {
        Point point = this.translateToCanvasPane(bMouseEvent);
        double d = point.x;
        double d2 = point.y;
        this.updateOptions(d, d2);
    }

    private final void updateOptions(double d, double d2) {
        double d3 = Theme.scrollBar().getFixedWidth();
        double d4 = this.ws.getWidth() - d3;
        double d5 = this.ws.getHeight() - d3;
        BThumbnail bThumbnail = this.ws.getThumbnail();
        double d6 = bThumbnail.getWidth();
        double d7 = bThumbnail.getHeight();
        d -= this.anchor.x;
        d2 -= this.anchor.y;
        if (d > d4) {
            d = d4;
        }
        if (d2 > d5) {
            d2 = d5;
        }
        if (d < 0.0) {
            d = 0.0;
        }
        if (d2 < 0.0) {
            d2 = 0.0;
        }
        double d8 = d + d6 / (double)2 < d4 / (double)2 ? d : Math.min(-1.0, -(d4 - d - d6));
        double d9 = d2 + d7 / (double)2 < d5 / (double)2 ? d2 : Math.min(-1.0, -(d5 - d2 - d7));
        BWsOptions.make().setThumbnailX((int)d8);
        BWsOptions.make().setThumbnailY((int)d9);
        this.ws.relayout();
    }

    public ThumbnailDragState(BWireSheetPane bWireSheetPane, Point point, double d, double d2) {
        super(bWireSheetPane);
        BThumbnail bThumbnail = bWireSheetPane.getThumbnail();
        point.translate(-bThumbnail.getX(), -bThumbnail.getY());
        this.anchor = point;
        bWireSheetPane.getScrollPane().setMouseCursor(WsConst.moveCursor);
        this.updateOptions(d, d2);
    }
}

