/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.wiresheet.states;

import com.tridium.wiresheet.BWireSheetPane;
import com.tridium.wiresheet.BWsCanvas;
import com.tridium.wiresheet.WsConst;
import com.tridium.wiresheet.WsState;
import com.tridium.wiresheet.states.NormalState;
import javax.baja.gx.BColor;
import javax.baja.gx.Graphics;
import javax.baja.gx.Point;
import javax.baja.gx.RectGeom;
import javax.baja.ui.event.BMouseEvent;

public class RubberBandState
extends WsState {
    private double x;
    private double y;
    private double w;
    private double h;
    private Point lock;

    public void mouseReleased(BMouseEvent bMouseEvent) {
        this.transition(new NormalState(this.ws));
        double d = bMouseEvent.getX();
        double d2 = bMouseEvent.getY();
        this.computePoints(d, d2);
        this.selection.unselectAll();
        BWsCanvas bWsCanvas = this.ws.getCanvas();
        bWsCanvas.getRootGlyph().selectAllInPixelRect(new RectGeom(this.x, this.y, this.w, this.h));
        bWsCanvas.repaint();
    }

    public void mouseDragged(BMouseEvent bMouseEvent) {
        double d = this.x;
        double d2 = this.y;
        double d3 = this.w;
        double d4 = this.h;
        double d5 = bMouseEvent.getX();
        double d6 = bMouseEvent.getY();
        this.computePoints(d5, d6);
        double d7 = Math.min(this.x, d);
        double d8 = Math.min(this.y, d2);
        double d9 = Math.max(this.x + this.w, d + d3) - d7;
        double d10 = Math.max(this.y + this.h, d2 + d4) - d8;
        this.ws.getCanvas().repaint(d7 - 1.0, d8 - 1.0, d9 + (double)2, d10 + (double)2);
    }

    public void mousePulsed(BMouseEvent bMouseEvent) {
        if (this.pulseViewport(bMouseEvent)) {
            this.mouseDragged(bMouseEvent);
        }
    }

    public void paintFx(Graphics graphics) {
        graphics.setBrush(BColor.black);
        graphics.strokeRect(this.x, this.y, this.w, this.h);
    }

    private final void computePoints(double d, double d2) {
        this.x = Math.min(this.lock.x, d);
        this.y = Math.min(this.lock.y, d2);
        this.w = Math.abs(this.lock.x - d);
        this.h = Math.abs(this.lock.y - d2);
    }

    public RubberBandState(BWireSheetPane bWireSheetPane, Point point, double d, double d2) {
        super(bWireSheetPane);
        this.lock = point;
        this.computePoints(d, d2);
        bWireSheetPane.getScrollPane().setMouseCursor(WsConst.rubberBandCursor);
    }
}

