/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.wiresheet.states;

import com.tridium.util.ArrayUtil;
import com.tridium.wiresheet.BWireSheetPane;
import com.tridium.wiresheet.ComponentGlyph;
import com.tridium.wiresheet.ResizeZone;
import com.tridium.wiresheet.WsState;
import com.tridium.wiresheet.commands.ResizeCommand;
import com.tridium.wiresheet.states.NormalState;
import javax.baja.gx.BColor;
import javax.baja.gx.Graphics;
import javax.baja.gx.IGeom;
import javax.baja.gx.RectGeom;
import javax.baja.ui.event.BMouseEvent;
import javax.baja.util.BWsAnnotation;

public class ResizeState
extends WsState {
    private double x;
    private double y;
    private double w;
    private double h;
    private ResizeZone zone;
    private ComponentGlyph[] otherGlyphs;
    private RectGeom[] otherRects;

    public void mouseReleased(BMouseEvent bMouseEvent) {
        this.transition(new NormalState(this.ws));
        double d = bMouseEvent.getX();
        double d2 = bMouseEvent.getY();
        this.computeResizeBox(d, d2);
        ComponentGlyph[] componentGlyphArray = new ComponentGlyph[this.otherGlyphs.length + 1];
        BWsAnnotation[] bWsAnnotationArray = new BWsAnnotation[componentGlyphArray.length];
        componentGlyphArray[0] = this.zone.glyph;
        bWsAnnotationArray[0] = BWsAnnotation.make((int)((int)this.x / this.ws.grid.wixel), (int)((int)this.y / this.ws.grid.wixel), (int)((int)this.w / this.ws.grid.wixel), (int)((int)this.h / this.ws.grid.wixel));
        int n = 0;
        while (n < this.otherGlyphs.length) {
            RectGeom rectGeom = this.otherRects[n];
            componentGlyphArray[n + 1] = this.otherGlyphs[n];
            bWsAnnotationArray[n + 1] = BWsAnnotation.make((int)((int)rectGeom.x / this.ws.grid.wixel), (int)((int)rectGeom.y / this.ws.grid.wixel), (int)((int)rectGeom.width / this.ws.grid.wixel), (int)((int)rectGeom.height / this.ws.grid.wixel));
            ++n;
        }
        new ResizeCommand(this.ws, componentGlyphArray, bWsAnnotationArray).invoke();
    }

    public void mouseDragged(BMouseEvent bMouseEvent) {
        double d = bMouseEvent.getX();
        double d2 = bMouseEvent.getY();
        this.computeResizeBox(d, d2);
        this.ws.getCanvas().repaint();
    }

    public void mousePulsed(BMouseEvent bMouseEvent) {
        if (this.pulseViewport(bMouseEvent)) {
            this.mouseDragged(bMouseEvent);
        }
    }

    private final void computeResizeBox(double d, double d2) {
        d = this.snapToGrid(d);
        d2 = this.snapToGrid(d2);
        ComponentGlyph componentGlyph = this.zone.glyph;
        if (this.zone.onRight()) {
            if (d < (double)(componentGlyph.x + 2 * this.ws.grid.wixel)) {
                d = componentGlyph.x + 2 * this.ws.grid.wixel;
            }
            if (d > (double)(this.ws.grid.getWixelWidth() * this.ws.grid.wixel)) {
                d = this.ws.grid.getWixelWidth() * this.ws.grid.wixel;
            }
            this.w = d - (double)componentGlyph.x;
        }
        if (this.zone.onLeft()) {
            if (d > (double)(componentGlyph.x + componentGlyph.pw - 2 * this.ws.grid.wixel)) {
                d = componentGlyph.x + componentGlyph.pw - 2 * this.ws.grid.wixel;
            }
            if (d < 0.0) {
                d = 0.0;
            }
            this.x = d;
            this.w = (double)(componentGlyph.x + componentGlyph.pw) - d;
        }
        if (this.zone.onBottom()) {
            if (d2 < (double)(componentGlyph.y + 2 * this.ws.grid.wixel)) {
                d2 = componentGlyph.y + 2 * this.ws.grid.wixel;
            }
            if (d2 > (double)(this.ws.grid.getWixelHeight() * this.ws.grid.wixel)) {
                d2 = this.ws.grid.getWixelHeight() * this.ws.grid.wixel;
            }
            this.h = d2 - (double)componentGlyph.y;
        }
        if (this.zone.onTop()) {
            if (d2 > (double)(componentGlyph.y + componentGlyph.ph - 2 * this.ws.grid.wixel)) {
                d2 = componentGlyph.y + componentGlyph.ph - 2 * this.ws.grid.wixel;
            }
            if (d2 < 0.0) {
                d2 = 0.0;
            }
            this.y = d2;
            this.h = (double)(componentGlyph.y + componentGlyph.ph) - d2;
        }
        double d3 = this.x - (double)componentGlyph.x;
        double d4 = this.y - (double)componentGlyph.y;
        double d5 = this.w - (double)componentGlyph.pw;
        double d6 = this.h - (double)componentGlyph.ph;
        int n = 0;
        while (n < this.otherGlyphs.length) {
            ComponentGlyph componentGlyph2 = this.otherGlyphs[n];
            RectGeom rectGeom = this.otherRects[n];
            rectGeom.x = (double)componentGlyph2.x + d3;
            rectGeom.y = (double)componentGlyph2.y + d4;
            rectGeom.width = (double)componentGlyph2.pw + d5;
            rectGeom.height = (double)componentGlyph2.ph + d6;
            ++n;
        }
    }

    public void paintFx(Graphics graphics) {
        graphics.setBrush(BColor.black);
        graphics.strokeRect(this.x, this.y, this.w, this.h);
        int n = 0;
        while (n < this.otherRects.length) {
            graphics.stroke((IGeom)this.otherRects[n]);
            ++n;
        }
    }

    public ResizeState(BWireSheetPane bWireSheetPane, ResizeZone resizeZone, double d, double d2) {
        super(bWireSheetPane);
        this.zone = resizeZone;
        this.x = resizeZone.glyph.x;
        this.y = resizeZone.glyph.y;
        this.w = resizeZone.glyph.pw;
        this.h = resizeZone.glyph.ph;
        Object[] objectArray = this.selection.getComponentGlyphs();
        this.otherGlyphs = (ComponentGlyph[])ArrayUtil.removeOne((Object[])objectArray, (Object)resizeZone.glyph);
        this.otherRects = new RectGeom[this.otherGlyphs.length];
        int n = 0;
        while (n < this.otherRects.length) {
            ComponentGlyph componentGlyph = this.otherGlyphs[n];
            this.otherRects[n] = new RectGeom((double)(componentGlyph.x - 5), (double)(componentGlyph.y - 5), (double)(componentGlyph.pw + 10), (double)(componentGlyph.ph + 10));
            ++n;
        }
        this.computeResizeBox(d, d2);
        bWireSheetPane.getCanvas().repaint();
    }
}

