/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.wiresheet.states;

import com.tridium.wiresheet.BThumbnail;
import com.tridium.wiresheet.BWireSheetPane;
import com.tridium.wiresheet.BWsCanvas;
import com.tridium.wiresheet.ComponentGlyph;
import com.tridium.wiresheet.Glyph;
import com.tridium.wiresheet.ResizeZone;
import com.tridium.wiresheet.WsConst;
import com.tridium.wiresheet.WsController;
import com.tridium.wiresheet.WsState;
import com.tridium.wiresheet.commands.MoveGlyphsCommand;
import com.tridium.wiresheet.states.LinkState;
import com.tridium.wiresheet.states.MoveState;
import com.tridium.wiresheet.states.ResizeState;
import com.tridium.wiresheet.states.RubberBandState;
import com.tridium.wiresheet.states.ThumbnailOverState;
import javax.baja.gx.Point;
import javax.baja.gx.RectGeom;
import javax.baja.ui.event.BKeyEvent;
import javax.baja.ui.event.BMouseEvent;
import javax.baja.ui.event.BMouseWheelEvent;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class NormalState
extends WsState {
    private int cursorType;
    private Point dragCheckPoint;
    private Glyph pressedGlyph;
    private Glyph mouseOverGlyph;
    private ResizeZone resizeZone;
    private Glyph linkOver;
    private int linkOverZone;

    public void keyPressed(BKeyEvent bKeyEvent) {
        if (!bKeyEvent.isControlDown()) {
            switch (bKeyEvent.getKeyCode()) {
                case 38: {
                    this.move(0, -1);
                    break;
                }
                case 40: {
                    this.move(0, 1);
                    break;
                }
                case 37: {
                    this.move(-1, 0);
                    break;
                }
                case 39: {
                    this.move(1, 0);
                    break;
                }
            }
        } else {
            switch (bKeyEvent.getKeyCode()) {
                case 38: {
                    this.ws.commands.zoomIn.invoke();
                    break;
                }
                case 40: {
                    this.ws.commands.zoomOut.invoke();
                    break;
                }
            }
        }
    }

    void move(int n, int n2) {
        ComponentGlyph[] componentGlyphArray = this.selection.getComponentGlyphs();
        if (componentGlyphArray != null && componentGlyphArray.length > 0) {
            new MoveGlyphsCommand(this.ws, componentGlyphArray, n, n2).invoke();
        }
    }

    public void transition(WsState wsState) {
        this.setMouseOver(null);
        super.transition(wsState);
    }

    public void mouseWheel(BMouseWheelEvent bMouseWheelEvent) {
        if (bMouseWheelEvent.isControlDown()) {
            this.ws.controller.zoom(bMouseWheelEvent.getWheelRotation() * -1);
            bMouseWheelEvent.consume();
            this.ws.relayout();
        }
    }

    public void mousePressed(BMouseEvent bMouseEvent) {
        double d = bMouseEvent.getX();
        double d2 = bMouseEvent.getY();
        int n = (int)(d / (double)this.ws.grid.wixel);
        int n2 = (int)(d2 / (double)this.ws.grid.wixel);
        if (bMouseEvent.isPopupTrigger()) {
            this.popup(bMouseEvent, d, d2);
            return;
        }
        if (this.isButton1(bMouseEvent)) {
            if (bMouseEvent.isShiftDown() && this.linkOver != null) {
                this.transition(new LinkState(this.ws, this.linkOver, this.linkOverZone, d, d2));
                return;
            }
            this.dragCheckPoint = new Point(d, d2);
        } else {
            this.dragCheckPoint = null;
        }
        this.pressedGlyph = this.selection.getSelectableGlyphAt(n, n2);
        if (this.isButton1(bMouseEvent) && bMouseEvent.getClickCount() > 1 && this.pressedGlyph != null) {
            this.pressedGlyph.doubleClicked(bMouseEvent);
        }
    }

    public void mouseReleased(BMouseEvent bMouseEvent) {
        double d = bMouseEvent.getX();
        double d2 = bMouseEvent.getY();
        int n = (int)(d / (double)this.ws.grid.wixel);
        int n2 = (int)(d2 / (double)this.ws.grid.wixel);
        if (bMouseEvent.isPopupTrigger()) {
            this.popup(bMouseEvent, d, d2);
            return;
        }
        Glyph glyph = this.selection.getSelectableGlyphAt(n, n2);
        if (glyph != null && glyph == this.pressedGlyph) {
            if (this.isMultiple(bMouseEvent)) {
                if (glyph.isSelected()) {
                    this.selection.unselect(glyph);
                } else {
                    this.selection.select(glyph);
                }
            } else {
                this.selection.unselectAll();
                this.selection.select(glyph);
            }
        } else {
            this.selection.unselectAll();
        }
        this.pressedGlyph = null;
        this.ws.getCanvas().setMouseCursor(WsConst.normalCursor);
    }

    public void mouseMoved(BMouseEvent bMouseEvent) {
        this.checkMouseOver(bMouseEvent);
    }

    public void mouseEntered(BMouseEvent bMouseEvent) {
        this.checkMouseOver(bMouseEvent);
    }

    public void mouseExited(BMouseEvent bMouseEvent) {
        this.checkMouseOver(bMouseEvent);
    }

    public void mouseDragged(BMouseEvent bMouseEvent) {
        double d = bMouseEvent.getX();
        double d2 = bMouseEvent.getY();
        int n = (int)(d / (double)this.ws.grid.wixel);
        int n2 = (int)(d2 / (double)this.ws.grid.wixel);
        if (this.dragCheckPoint == null) {
            return;
        }
        if (Math.abs(this.dragCheckPoint.x - d) < 8.0 && Math.abs(this.dragCheckPoint.y - d2) < 8.0) {
            return;
        }
        if (this.resizeZone != null) {
            this.transition(new ResizeState(this.ws, this.resizeZone, d, d2));
            return;
        }
        if (this.linkOver != null) {
            this.transition(new LinkState(this.ws, this.linkOver, this.linkOverZone, d, d2));
            return;
        }
        int n3 = (int)this.dragCheckPoint.x / this.ws.grid.wixel;
        int n4 = (int)this.dragCheckPoint.y / this.ws.grid.wixel;
        Glyph glyph = this.selection.getSelectableGlyphAt(n3, n4);
        if (glyph != null) {
            RectGeom rectGeom;
            if (!glyph.isSelected()) {
                this.selection.unselectAll();
                this.selection.select(glyph);
            }
            if ((rectGeom = this.selection.getSelectionPixelBounds()) != null) {
                int n5 = (int)this.dragCheckPoint.x;
                int n6 = (int)this.dragCheckPoint.y;
                this.transition(new MoveState(this.ws, rectGeom, n5, n6));
            }
            return;
        }
        this.transition(new RubberBandState(this.ws, this.dragCheckPoint, d, d2));
    }

    private final boolean isMultiple(BMouseEvent bMouseEvent) {
        boolean bl = false;
        if (bMouseEvent.isShiftDown() || bMouseEvent.isControlDown()) {
            bl = true;
        }
        return bl;
    }

    private final boolean isButton1(BMouseEvent bMouseEvent) {
        boolean bl;
        int n = bMouseEvent.getModifiers();
        boolean bl2 = false;
        if ((n & 0x10) != 0) {
            bl2 = true;
        }
        boolean bl3 = bl2;
        boolean bl4 = false;
        if ((n & 8) != 0) {
            bl4 = true;
        }
        boolean bl5 = bl4;
        boolean bl6 = false;
        if ((n & 4) != 0) {
            bl6 = bl = true;
        }
        if (bl3) {
            return true;
        }
        return !bl3 && !bl5 && !bl;
    }

    private final void popup(BMouseEvent bMouseEvent, double d, double d2) {
        int n = (int)(d / (double)this.ws.grid.wixel);
        int n2 = (int)(d2 / (double)this.ws.grid.wixel);
        Glyph glyph = this.selection.getSelectableGlyphAt(n, n2);
        if (glyph != null) {
            if (!glyph.isSelected()) {
                if (!this.isMultiple(bMouseEvent)) {
                    this.selection.unselectAll();
                }
                this.selection.select(glyph);
            }
            glyph.popup(d, d2);
        } else {
            this.controller.doBackgroundPopup(d, d2);
        }
    }

    private final void checkMouseOver(BMouseEvent bMouseEvent) {
        double d = bMouseEvent.getX();
        double d2 = bMouseEvent.getY();
        BThumbnail bThumbnail = this.ws.getThumbnail();
        Point point = this.translateToCanvasPane(bMouseEvent);
        if (this.ws.commands.showThumbnail.isSelected() && bThumbnail.contains(point.x - bThumbnail.getX(), point.y - bThumbnail.getY())) {
            this.transition(new ThumbnailOverState(this.ws));
            return;
        }
        int n = (int)(d / (double)this.ws.grid.wixel);
        int n2 = (int)(d2 / (double)this.ws.grid.wixel);
        this.setResizeZone(this.selection.getResizeAt(d, d2));
        this.setMouseOver(this.ws.getCanvas().getRootGlyph().descendentAt(n, n2));
        this.checkLinkOver(this.mouseOverGlyph, n, n2);
    }

    private final void setResizeZone(ResizeZone resizeZone) {
        if (resizeZone != this.resizeZone) {
            this.resizeZone = resizeZone;
            if (resizeZone == null) {
                this.ws.getCanvas().setMouseCursor(WsConst.normalCursor);
            } else {
                this.ws.getCanvas().setMouseCursor(resizeZone.mouseCursor);
            }
        }
    }

    private final void setMouseOver(Glyph glyph) {
        if (glyph != this.mouseOverGlyph) {
            this.ws.getShell().showStatus(null);
            if (this.mouseOverGlyph != null) {
                this.mouseOverGlyph.setMouseOver(false);
            }
            if (glyph != null) {
                glyph.setMouseOver(true);
            }
            this.mouseOverGlyph = glyph;
        }
    }

    private final void checkLinkOver(Glyph glyph, int n, int n2) {
        int n3 = 0;
        if (glyph != null && (n3 = glyph.getLinkHotSpot(n - glyph.absP(), n2 - glyph.absQ())) == 0) {
            glyph = null;
        }
        if (glyph != this.linkOver) {
            if (this.linkOver != null) {
                this.linkOver.setLinkOver(0);
            }
            this.linkOver = glyph;
            this.linkOverZone = n3;
            if (glyph != null) {
                glyph.setLinkOver(n3);
            }
            BWsCanvas bWsCanvas = this.ws.getCanvas();
            switch (n3) {
                case 0: {
                    bWsCanvas.setMouseCursor(WsConst.normalCursor);
                    break;
                }
                case 1: {
                    bWsCanvas.setMouseCursor(WsConst.linkSourceCursor);
                    break;
                }
                case 2: {
                    bWsCanvas.setMouseCursor(WsConst.linkTargetCursor);
                    break;
                }
            }
        }
    }

    private final /* synthetic */ void this() {
        this.cursorType = -1;
        this.dragCheckPoint = null;
    }

    public NormalState(BWireSheetPane bWireSheetPane) {
        super(bWireSheetPane);
        this.this();
        BWsCanvas bWsCanvas = bWireSheetPane.getCanvas();
        bWsCanvas.setMouseCursor(WsConst.normalCursor);
        bWsCanvas.repaint();
    }

    public NormalState(BWireSheetPane bWireSheetPane, WsController wsController) {
        super(bWireSheetPane, wsController);
        this.this();
        BWsCanvas bWsCanvas = bWireSheetPane.getCanvas();
        bWsCanvas.setMouseCursor(WsConst.normalCursor);
        bWsCanvas.repaint();
    }
}

