/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.wiresheet.states;

import com.tridium.wiresheet.BWireSheetPane;
import com.tridium.wiresheet.BWsCanvas;
import com.tridium.wiresheet.Glyph;
import com.tridium.wiresheet.Woint;
import com.tridium.wiresheet.WsConst;
import com.tridium.wiresheet.WsState;
import com.tridium.wiresheet.states.NormalState;
import javax.baja.gx.BColor;
import javax.baja.gx.Graphics;
import javax.baja.sys.BComponent;
import javax.baja.sys.BasicContext;
import javax.baja.sys.Context;
import javax.baja.sys.LinkCheck;
import javax.baja.sys.Slot;
import javax.baja.ui.event.BKeyEvent;
import javax.baja.ui.event.BMouseEvent;
import javax.baja.workbench.commands.LinkCommand;

public class LinkState
extends WsState {
    static Context context = new BasicContext();
    private Glyph anchorGlyph;
    private int anchorZone;
    private Woint anchor;
    private double ax;
    private double ay;
    private double cx;
    private double cy;
    private Glyph linkOver;
    private boolean linkValid;
    private BComponent anchorComponent;
    private Slot anchorSlot;

    public void mouseReleased(BMouseEvent bMouseEvent) {
        this.anchorGlyph.setLinkOver(0);
        if (this.linkOver != null) {
            this.linkOver.setLinkOver(0);
        }
        if (!bMouseEvent.isShiftDown()) {
            this.transition(new NormalState(this.ws));
        }
        if (this.linkOver != null && this.linkValid) {
            Slot slot;
            BComponent bComponent;
            Slot slot2;
            BComponent bComponent2;
            if (this.anchorZone == 1) {
                bComponent2 = this.anchorComponent;
                slot2 = this.anchorSlot;
                bComponent = this.linkOver.getLinkComponent();
                slot = this.linkOver.getLinkSlot();
            } else {
                bComponent = this.anchorComponent;
                slot = this.anchorSlot;
                bComponent2 = this.linkOver.getLinkComponent();
                slot2 = this.linkOver.getLinkSlot();
            }
            if (slot2 == null || slot == null) {
                this.transition(new NormalState(this.ws));
            }
            new LinkCommand(this.ws.getShell(), bComponent2, slot2, bComponent, slot).invoke();
        }
    }

    public void mouseDragged(BMouseEvent bMouseEvent) {
        this.mouseMoveOp(bMouseEvent);
    }

    public void mouseMoved(BMouseEvent bMouseEvent) {
        this.mouseMoveOp(bMouseEvent);
    }

    private final void mouseMoveOp(BMouseEvent bMouseEvent) {
        double d = bMouseEvent.getX();
        double d2 = bMouseEvent.getY();
        int n = (int)(d / (double)this.ws.grid.wixel);
        int n2 = (int)(d2 / (double)this.ws.grid.wixel);
        BWsCanvas bWsCanvas = this.ws.getCanvas();
        Glyph glyph = bWsCanvas.getRootGlyph().descendentAt(n, n2);
        this.linkValid = false;
        int n3 = 0;
        String string = null;
        if (glyph != null) {
            n3 = glyph.getLinkHotSpot(n - glyph.absP(), n2 - glyph.absQ());
            if (n3 == 0) {
                glyph = null;
            } else if (n3 == this.anchorZone) {
                string = n3 == 1 ? this.getInvalidStatus(glyph, "Source to source") : this.getInvalidStatus(glyph, "Target to target");
            } else {
                LinkCheck linkCheck = this.checkLink(glyph.getLinkComponent(), glyph.getLinkSlot());
                if (linkCheck.isValid()) {
                    string = this.getValidStatus(glyph.getLinkComponent(), glyph.getLinkSlot());
                    this.linkValid = true;
                } else {
                    string = this.getInvalidStatus(glyph, linkCheck.getInvalidReason());
                }
            }
        }
        this.ws.getShell().showStatus(string);
        if (glyph != this.linkOver) {
            if (this.linkOver != null && this.linkOver != this.anchorGlyph) {
                this.linkOver.setLinkOver(0);
            }
            this.linkOver = glyph;
            if (glyph != null && this.linkOver != this.anchorGlyph) {
                glyph.setLinkOver(n3);
            }
        }
        if (this.linkValid) {
            if (n3 == 1) {
                bWsCanvas.setMouseCursor(WsConst.linkTargetCursor);
            } else {
                bWsCanvas.setMouseCursor(WsConst.linkSourceCursor);
            }
        } else if (n3 == 0) {
            bWsCanvas.setMouseCursor(WsConst.grabCursor);
        } else {
            bWsCanvas.setMouseCursor(WsConst.linkInvalidCursor);
        }
        this.cx = d;
        this.cy = d2;
        bWsCanvas.repaint();
    }

    public void mousePulsed(BMouseEvent bMouseEvent) {
        if (this.pulseViewport(bMouseEvent)) {
            this.mouseDragged(bMouseEvent);
        }
    }

    public void keyReleased(BKeyEvent bKeyEvent) {
        if (bKeyEvent.getKeyCode() != 16) {
            this.transition(new NormalState(this.ws));
        }
    }

    public LinkCheck checkLink(BComponent bComponent, Slot slot) {
        Slot slot2;
        BComponent bComponent2;
        Slot slot3;
        BComponent bComponent3;
        if (this.anchorZone == 1) {
            bComponent3 = this.anchorComponent;
            slot3 = this.anchorSlot;
            bComponent2 = bComponent;
            slot2 = slot;
        } else {
            bComponent2 = this.anchorComponent;
            slot2 = this.anchorSlot;
            bComponent3 = bComponent;
            slot3 = slot;
        }
        if (slot3 == null || slot2 == null) {
            return LinkCheck.makeValid();
        }
        return bComponent2.checkLink(bComponent3, slot3, slot2, context);
    }

    public String getInvalidStatus(Glyph glyph, String string) {
        Slot slot = glyph.getLinkSlot();
        String string2 = slot == null ? "*" : slot.getName();
        return "Link to \"" + string2 + "\" invalid: " + string;
    }

    public String getValidStatus(BComponent bComponent, Slot slot) {
        Slot slot2;
        BComponent bComponent2;
        Slot slot3;
        BComponent bComponent3;
        if (this.anchorZone == 1) {
            bComponent3 = this.anchorComponent;
            slot3 = this.anchorSlot;
            bComponent2 = bComponent;
            slot2 = slot;
        } else {
            bComponent2 = this.anchorComponent;
            slot2 = this.anchorSlot;
            bComponent3 = bComponent;
            slot3 = slot;
        }
        String string = slot3 == null ? "*" : slot3.getName();
        String string2 = slot2 == null ? "*" : slot2.getName();
        return "Link: \"" + bComponent3.getName() + '.' + string + "\" -> \"" + bComponent2.getName() + '.' + string2 + '\"';
    }

    public void paintFx(Graphics graphics) {
        graphics.setBrush(BColor.black);
        graphics.strokeLine(this.ax, this.ay, this.cx, this.cy);
    }

    public LinkState(BWireSheetPane bWireSheetPane, Glyph glyph, int n, double d, double d2) {
        super(bWireSheetPane);
        this.anchorGlyph = glyph;
        this.anchorZone = n;
        this.ax = n == 2 ? glyph.absX() + 2 : glyph.absX() + glyph.pw - 2;
        this.ay = glyph.absY() + glyph.ph / 2;
        this.anchorComponent = glyph.getLinkComponent();
        this.anchorSlot = glyph.getLinkSlot();
        this.cx = d;
        this.cy = d2;
        BWsCanvas bWsCanvas = bWireSheetPane.getCanvas();
        bWsCanvas.setMouseCursor(WsConst.grabCursor);
        bWsCanvas.repaint();
    }
}

