/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.wiresheet;

import com.tridium.wiresheet.BWireSheetPane;
import com.tridium.wiresheet.WsConst;
import com.tridium.wiresheet.WsController;
import com.tridium.wiresheet.WsSelection;
import javax.baja.gx.Graphics;
import javax.baja.gx.Point;
import javax.baja.ui.BWidget;
import javax.baja.ui.event.BKeyEvent;
import javax.baja.ui.event.BMouseEvent;
import javax.baja.ui.event.BMouseWheelEvent;

public abstract class WsState
implements WsConst {
    protected final BWireSheetPane ws;
    protected final WsController controller;
    protected final WsSelection selection;

    public void transition(WsState wsState) {
        this.ws.controller.transition(wsState);
    }

    public void keyPressed(BKeyEvent bKeyEvent) {
    }

    public void keyReleased(BKeyEvent bKeyEvent) {
    }

    public void keyTyped(BKeyEvent bKeyEvent) {
    }

    public void mousePressed(BMouseEvent bMouseEvent) {
    }

    public void mouseReleased(BMouseEvent bMouseEvent) {
    }

    public void mouseEntered(BMouseEvent bMouseEvent) {
    }

    public void mouseExited(BMouseEvent bMouseEvent) {
    }

    public void mouseMoved(BMouseEvent bMouseEvent) {
    }

    public void mouseDragged(BMouseEvent bMouseEvent) {
    }

    public void mousePulsed(BMouseEvent bMouseEvent) {
    }

    public void mouseWheel(BMouseWheelEvent bMouseWheelEvent) {
    }

    public void paintFx(Graphics graphics) {
    }

    public Point translateToCanvasPane(BMouseEvent bMouseEvent) {
        return this.translateToCanvasPane(new Point(bMouseEvent.getX(), bMouseEvent.getY()));
    }

    public Point translateToCanvasPane(Point point) {
        return this.ws.getScrollPane().translateFromChild((BWidget)this.ws.getCanvas(), point);
    }

    public boolean pulseViewport(BMouseEvent bMouseEvent) {
        return this.ws.controller.pulseViewport(bMouseEvent.getX(), bMouseEvent.getY());
    }

    public double snapToGrid(double d) {
        double d2 = Math.IEEEremainder(d, this.ws.grid.wixel);
        if (d2 > (double)(this.ws.grid.wixel / 2)) {
            return d - d2 + (double)this.ws.grid.wixel;
        }
        return d - d2;
    }

    protected WsState(BWireSheetPane bWireSheetPane) {
        this.ws = bWireSheetPane;
        this.controller = bWireSheetPane.controller;
        this.selection = bWireSheetPane.selection;
    }

    protected WsState(BWireSheetPane bWireSheetPane, WsController wsController) {
        this.ws = bWireSheetPane;
        this.controller = wsController;
        this.selection = bWireSheetPane.selection;
    }
}

