/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.wiresheet;

import com.tridium.ui.UiEnv;
import com.tridium.wiresheet.BWireSheetPane;
import com.tridium.wiresheet.BWsCanvas;
import com.tridium.wiresheet.BWsOptions;
import com.tridium.wiresheet.ComponentGlyph;
import com.tridium.wiresheet.Glyph;
import com.tridium.wiresheet.LinkGlyph;
import com.tridium.wiresheet.LinkKnobGlyph;
import com.tridium.wiresheet.LinkLinkGlyph;
import com.tridium.wiresheet.LinkSnakeGlyph;
import com.tridium.wiresheet.LinkStubGlyph;
import com.tridium.wiresheet.StdComponentGlyph;
import com.tridium.wiresheet.TextBlockGlyph;
import com.tridium.wiresheet.WsConst;
import com.tridium.wiresheet.WsSelectedState;
import com.tridium.wiresheet.WsSelection;
import com.tridium.wiresheet.WsState;
import com.tridium.wiresheet.commands.EditLinkCommand;
import com.tridium.wiresheet.states.NormalState;
import com.tridium.workbench.commands.PasteSpecialCommand;
import com.tridium.workbench.nav.BComponentMenuAgent;
import com.tridium.workbench.transfer.NTransferContext;
import com.tridium.workbench.transfer.TransferArtifact;
import com.tridium.workbench.transfer.TransferUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import javax.baja.gx.BFont;
import javax.baja.gx.Point;
import javax.baja.gx.RectGeom;
import javax.baja.naming.BOrd;
import javax.baja.nre.util.Array;
import javax.baja.space.Mark;
import javax.baja.sync.Transaction;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BComponentEvent;
import javax.baja.sys.BLink;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.BVector;
import javax.baja.sys.Context;
import javax.baja.sys.Flags;
import javax.baja.sys.Knob;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.SlotCursor;
import javax.baja.ui.BMenu;
import javax.baja.ui.BSeparator;
import javax.baja.ui.BSubMenuItem;
import javax.baja.ui.BWidget;
import javax.baja.ui.Command;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.CommandEvent;
import javax.baja.ui.ToggleCommand;
import javax.baja.ui.commands.CopyCommand;
import javax.baja.ui.commands.CutCommand;
import javax.baja.ui.commands.DeleteCommand;
import javax.baja.ui.commands.DuplicateCommand;
import javax.baja.ui.commands.PasteCommand;
import javax.baja.ui.commands.RenameCommand;
import javax.baja.ui.event.BKeyEvent;
import javax.baja.ui.event.BMouseEvent;
import javax.baja.ui.event.BMouseWheelEvent;
import javax.baja.ui.transfer.BTransferWidget;
import javax.baja.ui.transfer.TransferContext;
import javax.baja.ui.transfer.TransferEnvelope;
import javax.baja.util.BWsAnnotation;
import javax.baja.util.BWsTextBlock;
import javax.baja.workbench.commands.ComponentCompositeCommand;
import javax.baja.workbench.commands.ComponentReorderCommand;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class WsController
implements WsConst {
    static int nextId;
    public final BWireSheetPane ws;
    public final WsSelection selection;
    public BComponent container;
    public Point dropPoint;
    private WsState state;
    private HashMap byName;
    private HashMap byHandle;
    private int auto;
    private boolean reload;
    int id;
    static /* synthetic */ Class class$javax$baja$sys$BComponent;

    public WsState getState() {
        return this.state;
    }

    public void transition(WsState wsState) {
        this.state = wsState;
    }

    public ComponentGlyph[] getAllComponentGlyphs() {
        Glyph[] glyphArray = this.ws.getCanvas().getRootGlyph().componentLayer.getChildGlyphs();
        ComponentGlyph[] componentGlyphArray = new ComponentGlyph[glyphArray.length];
        System.arraycopy(glyphArray, 0, componentGlyphArray, 0, glyphArray.length);
        return componentGlyphArray;
    }

    public void load(BComponent bComponent) {
        ComponentGlyph componentGlyph;
        BComponent bComponent2;
        this.container = bComponent;
        WsSelectedState[] wsSelectedStateArray = this.selection.preLoad();
        this.ws.getCanvas().preLoad();
        this.byName.clear();
        this.byHandle.clear();
        this.auto = -2;
        this.dropPoint = null;
        ArrayList<ComponentGlyph> arrayList = new ArrayList<ComponentGlyph>();
        SlotCursor slotCursor = bComponent.getProperties();
        while (slotCursor.nextComponent()) {
            bComponent2 = slotCursor.get().asComponent();
            if (Flags.isHidden((BComplex)bComponent, (Slot)slotCursor.property()) || bComponent2 instanceof BVector) continue;
            arrayList.add(this.addComponentGlyph(bComponent2));
        }
        Class clazz = class$javax$baja$sys$BComponent;
        if (clazz == null) {
            clazz = class$javax$baja$sys$BComponent = WsController.class("[Ljavax.baja.sys.BComponent;", false);
        }
        bComponent2 = new Array(clazz);
        int n = 0;
        while (n < arrayList.size()) {
            componentGlyph = (ComponentGlyph)arrayList.get(n);
            componentGlyph.checkForSubscribe(this.ws.getView(), (Array)bComponent2);
            ++n;
        }
        if (bComponent2.size() > 0) {
            this.ws.getView().registerForComponentEvents((BComponent[])bComponent2.trim(), 0);
        }
        n = 0;
        while (n < arrayList.size()) {
            componentGlyph = (ComponentGlyph)arrayList.get(n);
            componentGlyph.loadLinks();
            ++n;
        }
        n = 0;
        while (n < arrayList.size()) {
            componentGlyph = (ComponentGlyph)arrayList.get(n);
            componentGlyph.loadKnobs();
            ++n;
        }
        n = 0;
        while (n < arrayList.size()) {
            componentGlyph = (ComponentGlyph)arrayList.get(n);
            componentGlyph.postSubscribe();
            ++n;
        }
        this.ws.getCanvas().postLoad();
        this.selection.postLoad(wsSelectedStateArray);
        this.ws.getThumbnail().postLoad();
    }

    public void reload() {
        this.reload = true;
        this.ws.getCanvas().relayout();
    }

    public void doLayout() {
        int n = 0;
        while (this.reload) {
            this.reload = false;
            if (n++ > 10) {
                System.out.println("ERROR: WsController recursive reload!");
                break;
            }
            this.load(this.container);
        }
    }

    public void saveAnnotations(ComponentGlyph[] componentGlyphArray) throws Exception {
        HashMap<BComponent, ComponentGlyph> hashMap = new HashMap<BComponent, ComponentGlyph>();
        int n = 0;
        while (n < componentGlyphArray.length) {
            hashMap.put(componentGlyphArray[n].component, componentGlyphArray[n]);
            ++n;
        }
        ComponentGlyph[] componentGlyphArray2 = this.getAllComponentGlyphs();
        int n2 = 0;
        while (n2 < componentGlyphArray2.length) {
            if (componentGlyphArray2[n2].component.getProperty("wsAnnotation") == null) {
                hashMap.put(componentGlyphArray2[n2].component, componentGlyphArray2[n2]);
            }
            ++n2;
        }
        Context context = Transaction.start((BComponent)this.container, null);
        Iterator iterator = hashMap.values().iterator();
        while (iterator.hasNext()) {
            this.saveAnnotation((ComponentGlyph)iterator.next(), context);
        }
        Transaction.end((BComponent)this.container, (Context)context);
    }

    private final void saveAnnotation(ComponentGlyph componentGlyph, Context context) throws Exception {
        BComponent bComponent = componentGlyph.component;
        BWsAnnotation bWsAnnotation = componentGlyph.toAnnotation();
        Property property = bComponent.getProperty("wsAnnotation");
        if (property == null) {
            bComponent.add("wsAnnotation", (BValue)bWsAnnotation, 1, context);
        } else {
            BWsAnnotation bWsAnnotation2 = (BWsAnnotation)bComponent.get(property);
            if (!bWsAnnotation2.equals((Object)bWsAnnotation)) {
                bComponent.set(property, (BValue)bWsAnnotation, context);
            }
        }
    }

    public void zoom(int n) {
        RectGeom rectGeom = this.ws.getScrollPane().getViewport();
        double d = (rectGeom.width / (double)2 + rectGeom.x) / (double)this.ws.grid.wixel;
        double d2 = (rectGeom.height / (double)2 + rectGeom.y) / (double)this.ws.grid.wixel;
        int n2 = this.ws.grid.wixel + n;
        if (n2 < 2) {
            n2 = 2;
        }
        if (n2 > 20) {
            n2 = 20;
        }
        if (this.ws.grid.wixel != n2) {
            this.ws.grid.wixel = n2;
            this.ws.doLayout(this.ws.getChildWidgets());
            this.ws.getScrollPane().getContent().repaint();
            this.ws.getThumbnail().repaintBuffer();
        }
        RectGeom rectGeom2 = this.ws.getScrollPane().getViewport();
        if (rectGeom2.width > 0.0) {
            double d3 = rectGeom2.width / (double)this.ws.grid.wixel;
            double d4 = rectGeom2.height / (double)this.ws.grid.wixel;
            double d5 = d - d3 / (double)2;
            double d6 = d2 - d4 / (double)2;
            rectGeom = new RectGeom(d5 * (double)this.ws.grid.wixel, d6 * (double)this.ws.grid.wixel, rectGeom2.width, rectGeom2.height);
            this.ws.getScrollPane().scrollToVisible(rectGeom);
        }
    }

    public void zoomReset() {
        this.zoom(12 - this.ws.grid.wixel);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ComponentGlyph addComponentGlyph(BComponent bComponent) {
        if (bComponent instanceof BVector) {
            throw new IllegalStateException();
        }
        HashMap hashMap = this.byName;
        synchronized (hashMap) {
            ComponentGlyph componentGlyph = (ComponentGlyph)this.byName.get(bComponent.getName());
            if (componentGlyph != null) {
                return componentGlyph;
            }
            BWsAnnotation bWsAnnotation = null;
            BValue bValue = bComponent.get("wsAnnotation");
            bWsAnnotation = bValue instanceof BWsAnnotation ? (BWsAnnotation)bValue : this.nextAutoAnnotation();
            int n = bWsAnnotation.p;
            int n2 = bWsAnnotation.q;
            int n3 = bWsAnnotation.wixelWidth;
            int n4 = bWsAnnotation.wixelHeight;
            if (n3 < 2) {
                n3 = 2;
            }
            if (n + n3 > BWsOptions.make().getMaxWidth()) {
                n = BWsOptions.make().getMaxWidth() - n3;
            }
            if (n2 + n4 > BWsOptions.make().getMaxHeight()) {
                n2 = BWsOptions.make().getMaxHeight() - n4;
            }
            if (n < 0) {
                n = 0;
            }
            if (n2 < 0) {
                n2 = 0;
            }
            bWsAnnotation = BWsAnnotation.make((int)n, (int)n2, (int)n3, (int)n4);
            componentGlyph = bComponent instanceof BWsTextBlock ? new TextBlockGlyph(this.ws, bComponent, bWsAnnotation) : new StdComponentGlyph(this.ws, bComponent, bWsAnnotation);
            this.byName.put(bComponent.getName(), componentGlyph);
            this.byHandle.put(componentGlyph.handle, componentGlyph);
            this.ws.getCanvas().getRootGlyph().componentLayer.addToTop(componentGlyph);
            return componentGlyph;
        }
    }

    public LinkGlyph addLinkGlyph(StdComponentGlyph stdComponentGlyph, BLink bLink) {
        StdComponentGlyph stdComponentGlyph2 = this.toStdComponentGlyph(bLink.getSourceOrd());
        LinkLinkGlyph linkLinkGlyph = stdComponentGlyph2 == null ? new LinkStubGlyph(this.ws, bLink, stdComponentGlyph) : new LinkSnakeGlyph(this.ws, bLink, stdComponentGlyph, stdComponentGlyph2);
        this.ws.getCanvas().getRootGlyph().linkLayer.add(linkLinkGlyph);
        return linkLinkGlyph;
    }

    public LinkGlyph addKnobGlyph(ComponentGlyph componentGlyph, Knob knob) {
        if (!(componentGlyph instanceof StdComponentGlyph)) {
            return null;
        }
        StdComponentGlyph stdComponentGlyph = this.toStdComponentGlyph(knob.getTargetOrd());
        if (stdComponentGlyph != null) {
            return null;
        }
        LinkKnobGlyph linkKnobGlyph = new LinkKnobGlyph(this.ws, knob, (StdComponentGlyph)componentGlyph);
        this.ws.getCanvas().getRootGlyph().linkLayer.add(linkKnobGlyph);
        return linkKnobGlyph;
    }

    public ComponentGlyph toComponentGlyph(BOrd bOrd) {
        String string = String.valueOf(bOrd);
        if (string.startsWith("h:")) {
            String string2 = string.substring(2).trim();
            return (ComponentGlyph)this.byHandle.get(string2);
        }
        if (string.startsWith("station:") || string.startsWith("slot:")) {
            try {
                BObject bObject = bOrd.get((BObject)this.ws.controller.container);
                if (bObject.isComponent()) {
                    return (ComponentGlyph)this.byHandle.get(bObject.asComponent().getHandle());
                }
            }
            catch (Exception exception) {}
        }
        return null;
    }

    public StdComponentGlyph toStdComponentGlyph(BOrd bOrd) {
        ComponentGlyph componentGlyph = this.toComponentGlyph(bOrd);
        if (componentGlyph instanceof StdComponentGlyph) {
            return (StdComponentGlyph)componentGlyph;
        }
        return null;
    }

    private final BWsAnnotation nextAutoAnnotation() {
        this.auto += 4;
        if (this.auto > this.ws.grid.getWixelWidth() - 8 || this.auto > this.ws.grid.getWixelWidth() - 8) {
            this.auto = 2;
        }
        return BWsAnnotation.make((int)this.auto, (int)this.auto, (int)8);
    }

    public void doBackgroundPopup(double d, double d2) {
        this.dropPoint = new Point(d, d2);
        BMenu bMenu = new BMenu();
        int n = (int)(d / (double)this.ws.grid.wixel);
        int n2 = (int)(d2 / (double)this.ws.grid.wixel);
        BWsAnnotation bWsAnnotation = BWsAnnotation.make((int)n, (int)n2);
        BWsCanvas bWsCanvas = this.ws.getCanvas();
        BMenu bMenu2 = BComponentMenuAgent.makeNewMenu((BWidget)this.ws, (BComponent)this.container, (BWsAnnotation)bWsAnnotation);
        if (bMenu2 != null) {
            bMenu.add("new", (BValue)new BSubMenuItem(bMenu2));
            bMenu.add("sep0", (BValue)new BSeparator());
        }
        bMenu.add("cut", (Command)new CutCommand((BTransferWidget)bWsCanvas));
        bMenu.add("copy", (Command)new CopyCommand((BTransferWidget)bWsCanvas));
        bMenu.add("paste", (Command)new PasteCommand((BTransferWidget)bWsCanvas));
        bMenu.add("pasteSpecial", (Command)new PasteSpecialCommand((BTransferWidget)bWsCanvas, this.container));
        bMenu.add("duplicate", (Command)new DuplicateCommand((BTransferWidget)bWsCanvas));
        bMenu.add("sep1", (BValue)new BSeparator());
        bMenu.add("delete", (Command)new DeleteCommand((BTransferWidget)bWsCanvas));
        bMenu.add("deleteLinks", (Command)this.ws.commands.deleteLinks);
        bMenu.add("properties", (Command)this.ws.commands.editLink);
        bMenu.add("rename", (Command)new RenameCommand((BTransferWidget)bWsCanvas));
        bMenu.add("sep2", (BValue)new BSeparator());
        if (this.addLinkSelection(bMenu, n, n2)) {
            bMenu.add("sepLinkSep1", (BValue)new BSeparator());
        }
        bMenu.add("arrange", (Command)this.ws.commands.arrange);
        bMenu.add("selectAll", (Command)this.ws.commands.selectAll);
        bMenu.add("sep3", (BValue)new BSeparator());
        bMenu.add("reorder", (Command)new ComponentReorderCommand((BWidget)this.ws, this.container));
        bMenu.add("composite", (Command)new ComponentCompositeCommand((BWidget)this.ws, this.container));
        bMenu = this.ws.getView().makeBackgroundPopup(bMenu);
        if (bMenu != null) {
            bMenu.removeConsecutiveSeparators();
            bMenu.open((BWidget)bWsCanvas, d, d2);
        }
    }

    public boolean addLinkSelection(BMenu bMenu, int n, int n2) {
        LinkGlyph[] linkGlyphArray = this.ws.getCanvas().rootGlyph.linkLayer.getLinkGlyphsAt(n, n2);
        if (linkGlyphArray.length > 1) {
            bMenu.add("sepLinkSep0", (BValue)new BSeparator());
            BMenu bMenu2 = new BMenu();
            int n3 = 0;
            while (n3 < linkGlyphArray.length) {
                bMenu2.add("linkSel?", (Command)new LinkSelectCommand(linkGlyphArray[n3]));
                ++n3;
            }
            bMenu.add("linkMenu", (BValue)new BSubMenuItem(WsConst.lex.get("linkSelection"), bMenu2));
            return true;
        }
        return false;
    }

    public void keyPressed(BKeyEvent bKeyEvent) {
        if (this.processInput()) {
            this.state.keyPressed(bKeyEvent);
        }
    }

    public void keyReleased(BKeyEvent bKeyEvent) {
        if (this.processInput()) {
            this.state.keyReleased(bKeyEvent);
        }
    }

    public void keyTyped(BKeyEvent bKeyEvent) {
        if (this.processInput()) {
            this.state.keyTyped(bKeyEvent);
        }
    }

    public void mousePressed(BMouseEvent bMouseEvent) {
        if (this.processInput()) {
            this.state.mousePressed(bMouseEvent);
        }
    }

    public void mouseReleased(BMouseEvent bMouseEvent) {
        if (this.processInput()) {
            this.state.mouseReleased(bMouseEvent);
        }
    }

    public void mouseEntered(BMouseEvent bMouseEvent) {
        if (this.processInput()) {
            this.state.mouseEntered(bMouseEvent);
        }
    }

    public void mouseExited(BMouseEvent bMouseEvent) {
        if (this.processInput()) {
            this.state.mouseExited(bMouseEvent);
        }
    }

    public void mouseMoved(BMouseEvent bMouseEvent) {
        if (this.processInput()) {
            this.state.mouseMoved(bMouseEvent);
        }
    }

    public void mouseDragged(BMouseEvent bMouseEvent) {
        if (this.processInput()) {
            this.state.mouseDragged(bMouseEvent);
        }
    }

    public void mousePulsed(BMouseEvent bMouseEvent) {
        if (this.processInput()) {
            this.state.mousePulsed(bMouseEvent);
        }
    }

    public void mouseWheel(BMouseWheelEvent bMouseWheelEvent) {
        if (this.processInput()) {
            this.state.mouseWheel(bMouseWheelEvent);
        }
    }

    boolean processInput() {
        boolean bl = false;
        if (this.ws.getShell() != null && this.ws.initialized) {
            bl = true;
        }
        return bl;
    }

    public boolean pulseViewport(double d, double d2) {
        return this.ws.getScrollPane().pulseViewport(new Point(d, d2), (double)(this.ws.grid.wixel * 2));
    }

    public void handleComponentEvent(BComponentEvent bComponentEvent) {
        if (this.container == null) {
            return;
        }
        int n = bComponentEvent.getId();
        BComponent bComponent = bComponentEvent.getSourceComponent();
        Object object = bComponent.getHandle();
        String string = bComponentEvent.getSlotName();
        if (this.container.getHandle().equals(object)) {
            switch (n) {
                case 1: 
                case 3: {
                    this.reload();
                    break;
                }
                case 2: {
                    ComponentGlyph componentGlyph = (ComponentGlyph)this.byName.get(string);
                    if (componentGlyph != null) {
                        this.ws.grid.set(componentGlyph.p, componentGlyph.q, componentGlyph.ww, componentGlyph.wh, 0);
                        this.ws.grid.clearLinks();
                    }
                    this.reload();
                    break;
                }
            }
            return;
        }
        ComponentGlyph componentGlyph = (ComponentGlyph)this.byHandle.get(object);
        if (componentGlyph != null) {
            switch (n) {
                case 0: {
                    if (string.equals("wsAnnotation")) {
                        this.reload();
                        break;
                    }
                    componentGlyph.changed(string);
                    break;
                }
                case 1: 
                case 3: 
                case 4: 
                case 8: 
                case 9: {
                    this.reload();
                    break;
                }
                case 2: 
                case 6: {
                    this.ws.grid.set(componentGlyph.p, componentGlyph.q, componentGlyph.ww, componentGlyph.wh, 0);
                    this.ws.grid.clearLinks();
                    this.reload();
                    break;
                }
            }
            return;
        }
        BComponent bComponent2 = (BComponent)bComponent.getParent();
        if (bComponent2 != null) {
            componentGlyph = (ComponentGlyph)this.byHandle.get(bComponent2.getHandle());
        }
        if (componentGlyph != null) {
            if (n == 0) {
                componentGlyph.changed(bComponent.getPropertyInParent().getName());
            }
            return;
        }
    }

    public void updateTransferStates() {
        boolean bl = false;
        boolean bl2 = false;
        Glyph[] glyphArray = this.selection.get();
        int n = 0;
        while (n < glyphArray.length) {
            Glyph glyph = glyphArray[n];
            if (glyph instanceof ComponentGlyph) {
                bl = true;
            }
            if (glyph instanceof LinkGlyph) {
                bl2 = true;
            }
            ++n;
        }
        BWsCanvas bWsCanvas = this.ws.getCanvas();
        bWsCanvas.setCutEnabled(bl);
        bWsCanvas.setCopyEnabled(bl);
        bWsCanvas.setPasteEnabled(true);
        bWsCanvas.setPasteSpecialEnabled(true);
        bWsCanvas.setDuplicateEnabled(bl);
        bWsCanvas.setDeleteEnabled(bl);
        bWsCanvas.setRenameEnabled(bl);
        if (this.ws.commands != null) {
            if (this.ws.commands.deleteLinks != null) {
                this.ws.commands.deleteLinks.setEnabled(bl2);
            }
            if (this.ws.commands.editLink != null) {
                EditLinkCommand editLinkCommand = this.ws.commands.editLink;
                boolean bl3 = false;
                if (this.ws.selection.getLinks().length == 1) {
                    bl3 = true;
                }
                editLinkCommand.setEnabled(bl3);
            }
        }
    }

    public TransferContext makeTransferContext(Context context, int n, TransferEnvelope transferEnvelope) {
        NTransferContext nTransferContext = new NTransferContext(context, n, transferEnvelope);
        nTransferContext.params = this.getTransferParameters(false);
        return nTransferContext;
    }

    public CommandArtifact insertTransferData(TransferContext transferContext) throws Exception {
        CommandArtifact commandArtifact = null;
        commandArtifact = TransferUtil.insert((BWidget)this.ws.getCanvas(), (TransferContext)transferContext, (BObject)this.container, (BComponent)this.getTransferParameters(true));
        if (commandArtifact instanceof TransferArtifact) {
            this.completeTransfer((TransferArtifact)commandArtifact);
        }
        return commandArtifact;
    }

    /*
     * Exception decompiling
     */
    public void completeTransfer(TransferArtifact var1_1) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 2[TRYBLOCK] [1 : 57->138)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public BComponent getTransferParameters(boolean bl) {
        BComponent bComponent = new BComponent();
        if (this.dropPoint != null) {
            bComponent.add("origin", (BValue)BWsAnnotation.make((int)((int)this.dropPoint.x / this.ws.grid.wixel), (int)((int)this.dropPoint.y / this.ws.grid.wixel), (int)2));
            if (bl) {
                this.dropPoint = null;
            }
        }
        return bComponent;
    }

    public Mark getSelectionAsMark() {
        ComponentGlyph[] componentGlyphArray = this.selection.getComponentGlyphs();
        if (componentGlyphArray.length == 0) {
            return null;
        }
        BComponent[] bComponentArray = new BComponent[componentGlyphArray.length];
        int n = 0;
        while (n < bComponentArray.length) {
            bComponentArray[n] = componentGlyphArray[n].component;
            ++n;
        }
        Arrays.sort(bComponentArray, new SlotOrder(this.container));
        return new Mark((BObject[])bComponentArray);
    }

    public static BFont getFont(BFont bFont, int n) {
        if (UiEnv.get().isMicroEdition()) {
            return BFont.make((String)bFont.getName(), (double)Math.max(10, n), (int)bFont.getStyle());
        }
        return BFont.make((String)bFont.getName(), (double)n, (int)bFont.getStyle());
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final /* synthetic */ void this() {
        this.byName = new HashMap();
        this.byHandle = new HashMap();
        this.auto = -2;
        this.id = nextId++;
    }

    public WsController(BWireSheetPane bWireSheetPane) {
        this.this();
        this.ws = bWireSheetPane;
        this.selection = bWireSheetPane.selection;
        this.state = new NormalState(bWireSheetPane, this);
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    private class LinkSelectCommand
    extends ToggleCommand {
        private LinkGlyph linkGlyph;

        public CommandArtifact doInvoke(CommandEvent commandEvent) throws Exception {
            if (commandEvent != null && commandEvent.isControlDown()) {
                if (this.linkGlyph.isSelected()) {
                    WsController.this.ws.selection.unselect(this.linkGlyph);
                } else {
                    WsController.this.ws.selection.select(this.linkGlyph);
                }
            } else {
                WsController.this.ws.selection.unselectAll();
                WsController.this.ws.selection.select(this.linkGlyph);
            }
            return null;
        }

        public synchronized boolean isSelected() {
            return this.linkGlyph.isSelected();
        }

        private LinkSelectCommand(LinkGlyph linkGlyph) {
            super((BWidget)WsController.this.ws.getCanvas(), linkGlyph.getStatusMessage());
            this.linkGlyph = linkGlyph;
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    static class SlotOrder
    implements Comparator {
        HashMap lookup;

        public int compare(Object object, Object object2) {
            int n;
            String string = ((BComponent)object).getName();
            String string2 = ((BComponent)object2).getName();
            int n2 = (Integer)this.lookup.get(string);
            if (n2 < (n = ((Integer)this.lookup.get(string2)).intValue())) {
                return -1;
            }
            if (n2 == n) {
                return 0;
            }
            return 1;
        }

        private final /* synthetic */ void this() {
            this.lookup = new HashMap();
        }

        public SlotOrder(BComponent bComponent) {
            this.this();
            Property[] propertyArray = bComponent.getPropertiesArray();
            int n = 0;
            while (n < propertyArray.length) {
                this.lookup.put(propertyArray[n].getName(), new Integer(n));
                ++n;
            }
        }
    }
}

