/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.wiresheet;

import com.tridium.ui.theme.Theme;
import com.tridium.ui.theme.WiresheetTheme;
import com.tridium.ui.theme.custom.nss.StyleUtils;
import com.tridium.wiresheet.BWireSheetPane;
import com.tridium.wiresheet.Glyph;
import com.tridium.wiresheet.WsConst;
import com.tridium.wiresheet.WsController;
import com.tridium.wiresheet.WsPrinting;
import javax.baja.gx.BColor;
import javax.baja.gx.BFont;
import javax.baja.gx.BImage;
import javax.baja.gx.BTransform;
import javax.baja.gx.Graphics;
import javax.baja.sys.BComponent;
import javax.baja.sys.BIcon;
import javax.baja.ui.style.IStylable;

public class TitleBarGlyph
extends Glyph {
    BComponent component;
    BImage icon;
    String name;
    String type;
    String statusMessage;

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void paint(Graphics graphics) {
        boolean bl = this.component.isPendingMove();
        WiresheetTheme wiresheetTheme = Theme.wiresheet();
        BImage bImage = bl ? this.icon.getDisabledImage() : this.icon;
        bImage = bImage.transform(BTransform.makeScale((double)((double)this.ws.grid.wixel / 12.0), (double)((double)this.ws.grid.wixel / 12.0)));
        BFont bFont = wiresheetTheme.glyph().getTitleFont((IStylable)this);
        BFont bFont2 = wiresheetTheme.glyph().getSubtitleFont((IStylable)this);
        graphics.push();
        try {
            graphics.setBrush(wiresheetTheme.glyph().getBackground((IStylable)this));
            graphics.fillRect(1.0, 1.0, (double)(this.pw - 2), (double)(this.ws.grid.wixel * 2));
            graphics.clip(0.0, 0.0, (double)(this.pw - this.ws.grid.wixel) - bImage.getWidth(), (double)this.ph);
            graphics.setBrush(wiresheetTheme.glyph().getFontColor((IStylable)this));
            graphics.setFont(WsController.getFont(bFont, this.ws.grid.wixel - 2));
            graphics.drawString(this.name, (double)4, (double)this.ws.grid.wixel);
            graphics.setFont(WsController.getFont(bFont2, this.ws.grid.wixel - 2));
            graphics.drawString(this.type, (double)4, (double)(this.ws.grid.wixel + this.ws.grid.wixel - 2));
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            graphics.pop();
            throw throwable;
        }
        {
            Object var8_9 = null;
        }
        graphics.pop();
        graphics.drawImage(bImage, (double)(this.pw - this.ws.grid.wixel / 2) - bImage.getWidth(), ((double)(this.ws.grid.wixel * 2) - bImage.getHeight()) / (double)2);
    }

    public String getStyleSelector() {
        return "wire-sheet glyph title";
    }

    public String getStyleClasses() {
        String string = super.getStyleClasses();
        string = this.component.isPendingMove() ? StyleUtils.addStyleClass((String)string, (String)"cut") : StyleUtils.removeStyleClass((String)string, (String)"cut");
        return string;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void print(WsPrinting wsPrinting) {
        Graphics graphics = wsPrinting.graphics;
        graphics.push();
        try {
            double d = (double)this.ww * wsPrinting.wixel;
            double d2 = (double)this.wh * wsPrinting.wixel;
            graphics.clip(0.0, 0.0, d, d2);
            graphics.setBrush(BColor.black.toBrush());
            graphics.setFont(wsPrinting.bold);
            graphics.drawString(this.name, 1.0, wsPrinting.bold.getAscent());
            graphics.setBrush(BColor.make((int)0x666666));
            graphics.setFont(wsPrinting.small);
            graphics.drawString(this.type, 1.0, wsPrinting.wixel + wsPrinting.small.getAscent());
            graphics.setBrush(BColor.black.toBrush());
            graphics.strokeLine(0.0, d2, d, d2);
        }
        catch (Throwable throwable) {
            Object var4_6 = null;
            graphics.pop();
            throw throwable;
        }
        {
            Object var4_7 = null;
        }
        graphics.pop();
    }

    public void renamed() {
        this.name = this.component.getDisplayName(null);
        this.statusMessage = this.component.toPathString() + " h:" + this.component.getHandle() + " [" + this.type + ']';
    }

    public void mouseEntered() {
        this.showStatus(this.statusMessage);
    }

    double calcWidth() {
        WiresheetTheme.Glyph glyph = Theme.wiresheet().glyph();
        BFont bFont = glyph.getTitleFont((IStylable)this);
        BFont bFont2 = glyph.getSubtitleFont((IStylable)this);
        double d = Math.floor(Math.max(WsController.getFont(bFont, this.ws.grid.wixel - 2).width(this.name), WsController.getFont(bFont2, this.ws.grid.wixel - 2).width(this.type)));
        BImage bImage = this.icon;
        bImage = bImage.transform(BTransform.makeScale((double)((double)this.ws.grid.wixel / 12.0), (double)((double)this.ws.grid.wixel / 12.0)));
        return d + bImage.getWidth() + (double)this.ws.grid.wixel + 8.0;
    }

    public TitleBarGlyph(BWireSheetPane bWireSheetPane, BComponent bComponent) {
        super(bWireSheetPane);
        this.component = bComponent;
        this.icon = BImage.make((BIcon)bComponent.getIcon());
        if (this.icon == null) {
            this.icon = WsConst.objectIcon;
        }
        this.type = bComponent.getTypeDisplayName(null);
        this.renamed();
    }
}

