/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.wiresheet;

import com.tridium.wiresheet.ComponentGlyph;
import com.tridium.wiresheet.Glyph;
import com.tridium.wiresheet.WsConst;
import javax.baja.ui.MouseCursor;

public class ResizeZone
implements WsConst {
    public static final int TOP = 1;
    public static final int BOTTOM = 2;
    public static final int LEFT = 4;
    public static final int RIGHT = 8;
    public static final int TOP_LEFT = 5;
    public static final int TOP_RIGHT = 9;
    public static final int BOTTOM_LEFT = 6;
    public static final int BOTTOM_RIGHT = 10;
    public final ComponentGlyph glyph;
    public final int edge;
    public final MouseCursor mouseCursor;

    public static MouseCursor edgeToCursor(int n) {
        switch (n) {
            case 1: {
                return MouseCursor.nResize;
            }
            case 2: {
                return MouseCursor.sResize;
            }
            case 4: {
                return MouseCursor.wResize;
            }
            case 8: {
                return MouseCursor.eResize;
            }
            case 5: {
                return MouseCursor.nwResize;
            }
            case 9: {
                return MouseCursor.neResize;
            }
            case 6: {
                return MouseCursor.swResize;
            }
            case 10: {
                return MouseCursor.seResize;
            }
        }
        throw new IllegalStateException();
    }

    public static boolean inX(Glyph glyph, double d) {
        boolean bl = false;
        if ((double)(glyph.x - 3) <= d && d <= (double)(glyph.x + glyph.pw + 3)) {
            bl = true;
        }
        return bl;
    }

    public static boolean inY(Glyph glyph, double d) {
        boolean bl = false;
        if ((double)(glyph.y - 3) <= d && d <= (double)(glyph.y + glyph.ph + 3)) {
            bl = true;
        }
        return bl;
    }

    public static boolean onLeft(Glyph glyph, double d, double d2) {
        boolean bl = false;
        if (ResizeZone.inY(glyph, d2) && (double)(glyph.x - 3) <= d && d <= (double)(glyph.x + 3)) {
            bl = true;
        }
        return bl;
    }

    public static boolean onRight(Glyph glyph, double d, double d2) {
        boolean bl = false;
        if (ResizeZone.inY(glyph, d2) && (double)(glyph.x + glyph.pw - 3) <= d && d <= (double)(glyph.x + glyph.pw + 3)) {
            bl = true;
        }
        return bl;
    }

    public static boolean onTop(Glyph glyph, double d, double d2) {
        boolean bl = false;
        if (ResizeZone.inX(glyph, d) && (double)(glyph.y - 3) <= d2 && d2 <= (double)(glyph.y + 3)) {
            bl = true;
        }
        return bl;
    }

    public static boolean onBottom(Glyph glyph, double d, double d2) {
        boolean bl = false;
        if (ResizeZone.inX(glyph, d) && (double)(glyph.y + glyph.ph - 3) <= d2 && d2 <= (double)(glyph.y + glyph.ph + 3)) {
            bl = true;
        }
        return bl;
    }

    public static int onEdge(Glyph glyph, double d, double d2) {
        boolean bl = ResizeZone.onLeft(glyph, d, d2);
        boolean bl2 = ResizeZone.onRight(glyph, d, d2);
        boolean bl3 = ResizeZone.onTop(glyph, d, d2);
        boolean bl4 = ResizeZone.onBottom(glyph, d, d2);
        if (bl) {
            if (bl3) {
                return 5;
            }
            if (bl4) {
                return 6;
            }
            return 4;
        }
        if (bl2) {
            if (bl3) {
                return 9;
            }
            if (bl4) {
                return 10;
            }
            return 8;
        }
        if (bl3) {
            return 1;
        }
        if (bl4) {
            return 2;
        }
        return 0;
    }

    public static ResizeZone make(ComponentGlyph componentGlyph, double d, double d2) {
        int n = ResizeZone.onEdge(componentGlyph, d, d2);
        if (n == 0) {
            return null;
        }
        return new ResizeZone(componentGlyph, n);
    }

    public final boolean onLeft() {
        boolean bl = false;
        if ((this.edge & 4) != 0) {
            bl = true;
        }
        return bl;
    }

    public final boolean onRight() {
        boolean bl = false;
        if ((this.edge & 8) != 0) {
            bl = true;
        }
        return bl;
    }

    public final boolean onTop() {
        boolean bl = false;
        if ((this.edge & 1) != 0) {
            bl = true;
        }
        return bl;
    }

    public final boolean onBottom() {
        boolean bl = false;
        if ((this.edge & 2) != 0) {
            bl = true;
        }
        return bl;
    }

    public ResizeZone(ComponentGlyph componentGlyph, int n) {
        this.glyph = componentGlyph;
        this.edge = n;
        this.mouseCursor = ResizeZone.edgeToCursor(n);
    }
}

