/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.wiresheet;

import com.tridium.wiresheet.BWireSheetPane;
import com.tridium.wiresheet.LinkGlyph;
import com.tridium.wiresheet.LinkLinkGlyph;
import com.tridium.wiresheet.SlotBarGlyph;
import com.tridium.wiresheet.StdComponentGlyph;
import com.tridium.wiresheet.Woint;
import java.util.ArrayList;
import javax.baja.log.Log;
import javax.baja.sys.BLink;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class LinkSnakeGlyph
extends LinkLinkGlyph {
    private static final int N = 0;
    private static final int S = 1;
    private static final int E = 2;
    private static final int W = 3;
    private static final int LINK_U_TURN = -1;
    public static final Log logger = Log.getLog((String)"link");
    private static int[][] board;
    private static int[] ants0P;
    private static int[] ants0Q;
    private static int[] ants1P;
    private static int[] ants1Q;
    private static int ants0Len;
    private static int ants1Len;
    private boolean doubleBreak;
    private Woint s;
    private Woint t;
    private Woint b;
    private Woint r;
    private Woint s2;
    private Woint t2;
    StdComponentGlyph sourceComp;
    SlotBarGlyph sourceSlot;

    public StdComponentGlyph getSourceComponentGlyph() {
        return this.sourceComp;
    }

    public SlotBarGlyph getSourceSlotGlyph() {
        return this.sourceSlot;
    }

    public String getStatusMessage() {
        return this.sourceComp.titleBar.name + '.' + this.sourceComp.component.getDisplayName(this.sourceSlot.slot, null) + " -> " + this.targetComp.titleBar.name + '.' + this.targetComp.component.getDisplayName(this.targetSlot.slot, null);
    }

    public LinkGlyph.Tile[] buildTiles() {
        try {
            if (this.sourceSlot == null || this.targetSlot == null) {
                return new LinkGlyph.Tile[0];
            }
            ArrayList arrayList = new ArrayList();
            this.s.p = this.sourceSlot.absP() + this.sourceSlot.ww;
            this.s.q = this.sourceSlot.absQ();
            this.t.p = this.targetSlot.absP() - 1;
            this.t.q = this.targetSlot.absQ();
            boolean bl = false;
            bl = this.t.p > this.s.p ? (this.t.q == this.s.q ? this.routeStraight(arrayList) : this.routeLeftToRight(arrayList)) : (this.t.q == this.s.q ? false : this.routeAround(arrayList));
            if (!bl && !this.routeAntRace(arrayList)) {
                this.routeStubs(arrayList);
            }
            return arrayList.toArray(new LinkGlyph.Tile[arrayList.size()]);
        }
        catch (Exception exception) {
            logger.error("LinkSnakeGlyph:" + this.link);
            exception.printStackTrace();
            return new LinkGlyph.Tile[0];
        }
    }

    private final void addTile(ArrayList arrayList, int n, int n2, int n3) {
        arrayList.add(new LinkGlyph.Tile(n, n2, n3, this.ws));
        Scale scale = new Scale(n, n2, this.getSourceSlotGlyph(), this.getTargetSlotGlyph(), n3);
        this.ws.getCanvas().addScale(n, n2, scale);
    }

    private final boolean routeStraight(ArrayList arrayList) {
        int n = this.s.p + 1;
        while (n < this.t.p) {
            if (!this.usableWixel(n, this.s.q, 1)) {
                return false;
            }
            ++n;
        }
        n = this.s.p;
        while (n <= this.t.p) {
            this.addTile(arrayList, n, this.s.q, 1);
            ++n;
        }
        return true;
    }

    private final boolean routeAround(ArrayList arrayList) {
        this.s2.p = this.s.p + 1;
        this.s2.q = this.s.q;
        this.t2.p = this.t.p - 1;
        this.t2.q = this.t.q;
        int n = Math.min(this.s2.p, this.t2.p);
        int n2 = Math.max(this.s2.p, this.t2.p);
        int n3 = Math.min(this.s2.q, this.t2.q);
        int n4 = Math.max(this.s2.q, this.t2.q);
        int n5 = n3 + (n4 - n3) / 2;
        this.b.p = this.s2.p;
        this.b.q = n5;
        this.r.p = this.t2.p;
        this.r.q = n5;
        if (this.isAroundValid(arrayList)) {
            this.drawAround(arrayList);
            return true;
        }
        int n6 = 1;
        while (n5 - n6 >= this.s.q || n5 + n6 <= this.t.q) {
            if (n5 - n6 >= this.s.q) {
                this.b.q = n5 - n6;
                this.r.q = n5 - n6;
                if (this.isAroundValid(arrayList)) {
                    this.drawAround(arrayList);
                    return true;
                }
            }
            if (n5 + n6 <= this.t.q) {
                this.b.q = n5 + n6;
                this.r.q = n5 + n6;
                if (this.isAroundValid(arrayList)) {
                    this.drawAround(arrayList);
                    return true;
                }
            }
            ++n6;
        }
        return false;
    }

    private final boolean isAroundValid(ArrayList arrayList) {
        int n;
        int n2 = this.s2.p;
        int n3 = this.s2.q;
        int n4 = 0;
        if (this.s.q < this.t.q) {
            n4 = 1;
        }
        if (!this.usableWixel(n2, n3, n4 + 7)) {
            return false;
        }
        if (this.s.q < this.t.q) {
            n = this.s2.q + 1;
            while (n < this.b.q) {
                if (!this.usableWixel(this.s2.p, n, 2)) {
                    return false;
                }
                ++n;
            }
        } else {
            n = this.b.q + 1;
            while (n < this.s2.q) {
                if (!this.usableWixel(this.s2.p, n, 2)) {
                    return false;
                }
                ++n;
            }
        }
        int n5 = this.b.p;
        int n6 = this.b.q;
        int n7 = 0;
        if (this.s.q < this.t.q) {
            n7 = 1;
        }
        if (!this.usableWixel(n5, n6, 8 - n7)) {
            return false;
        }
        n = this.r.p + 1;
        while (n < this.b.p) {
            if (!this.usableWixel(n, this.r.q, 1)) {
                return false;
            }
            ++n;
        }
        int n8 = this.r.p;
        int n9 = this.r.q;
        int n10 = 0;
        if (this.s.q < this.t.q) {
            n10 = 1;
        }
        if (!this.usableWixel(n8, n9, n10 + 9)) {
            return false;
        }
        if (this.s.q < this.t.q) {
            n = this.r.q + 1;
            while (n < this.t2.q) {
                if (!this.usableWixel(this.r.p, n, 2)) {
                    return false;
                }
                ++n;
            }
        } else {
            n = this.t2.q + 1;
            while (n < this.r.q) {
                if (!this.usableWixel(this.r.p, n, 2)) {
                    return false;
                }
                ++n;
            }
        }
        int n11 = this.t2.p;
        int n12 = this.t2.q;
        int n13 = 0;
        if (this.s.q < this.t.q) {
            n13 = 1;
        }
        return this.usableWixel(n11, n12, 10 - n13);
    }

    private final boolean routeLeftToRight(ArrayList arrayList) {
        int n;
        int n2 = Math.min(this.s.p, this.t.p);
        int n3 = Math.max(this.s.p, this.t.p);
        int n4 = Math.min(this.s.q, this.t.q);
        int n5 = Math.max(this.s.q, this.t.q);
        this.b.p = n = n2 + (n3 - n2) / 2;
        this.b.q = this.s.q;
        this.r.p = n;
        this.r.q = this.t.q;
        if (this.isLeftToRightValid(n4, n5)) {
            this.drawLeftToRight(arrayList, n4, n5);
            return true;
        }
        int n6 = 1;
        while (n - n6 >= this.s.p || n + n6 <= this.t.p) {
            if (n - n6 >= this.s.p) {
                this.b.p = n - n6;
                this.r.p = n - n6;
                if (this.isLeftToRightValid(n4, n5)) {
                    this.drawLeftToRight(arrayList, n4, n5);
                    return true;
                }
            }
            if (n + n6 <= this.t.p) {
                this.b.p = n + n6;
                this.r.p = n + n6;
                if (this.isLeftToRightValid(n4, n5)) {
                    this.drawLeftToRight(arrayList, n4, n5);
                    return true;
                }
            }
            ++n6;
        }
        return false;
    }

    private final boolean isLeftToRightValid(int n, int n2) {
        int n3 = this.s.p + 1;
        while (n3 < this.b.p) {
            if (!this.usableWixel(n3, this.s.q, 1)) {
                return false;
            }
            ++n3;
        }
        int n4 = this.b.p;
        int n5 = this.b.q;
        int n6 = 0;
        if (this.r.q < this.b.q) {
            n6 = 1;
        }
        if (!this.usableWixel(n4, n5, 8 - n6)) {
            return false;
        }
        n3 = n + 1;
        while (n3 < n2) {
            if (!this.usableWixel(this.b.p, n3, 2)) {
                return false;
            }
            ++n3;
        }
        int n7 = this.r.p;
        int n8 = this.r.q;
        int n9 = 0;
        if (this.r.q < this.b.q) {
            n9 = 1;
        }
        if (!this.usableWixel(n7, n8, n9 + 9)) {
            return false;
        }
        n3 = this.r.p + 1;
        while (n3 < this.t.p) {
            if (!this.usableWixel(n3, this.t.q, 1)) {
                return false;
            }
            ++n3;
        }
        return true;
    }

    private final boolean usableWixel(int n, int n2, int n3) {
        if (n < 0 || n >= this.ws.grid.getWixelWidth()) {
            return false;
        }
        if (n2 < 0 || n2 >= this.ws.grid.getWixelHeight()) {
            return false;
        }
        if (this.hasComponents(n, n2)) {
            return false;
        }
        return this.canCross(n, n2, n3);
    }

    private final boolean hasComponents(int n, int n2) {
        return this.ws.grid.isComponent(n, n2);
    }

    private final boolean canCross(int n, int n2, int n3) {
        ArrayList arrayList = this.ws.getCanvas().getScales(n, n2);
        if (arrayList == null) {
            return true;
        }
        int n4 = 0;
        while (n4 < arrayList.size()) {
            Scale scale = (Scale)arrayList.get(n4);
            if (!(scale.source == this.getSourceSlotGlyph() || scale.target == this.getTargetSlotGlyph() || n3 == 1 && scale.type == 2 || n3 == 2 && scale.type == 1)) {
                return false;
            }
            ++n4;
        }
        return true;
    }

    private final void drawLeftToRight(ArrayList arrayList, int n, int n2) {
        int n3 = this.s.p;
        while (n3 < this.b.p) {
            this.addTile(arrayList, n3, this.s.q, 1);
            ++n3;
        }
        int n4 = this.b.p;
        int n5 = this.b.q;
        int n6 = 0;
        if (this.r.q < this.b.q) {
            n6 = 1;
        }
        this.addTile(arrayList, n4, n5, 8 - n6);
        n3 = n + 1;
        while (n3 < n2) {
            this.addTile(arrayList, this.b.p, n3, 2);
            ++n3;
        }
        int n7 = this.r.p;
        int n8 = this.r.q;
        int n9 = 0;
        if (this.r.q < this.b.q) {
            n9 = 1;
        }
        this.addTile(arrayList, n7, n8, n9 + 9);
        n3 = this.r.p + 1;
        while (n3 <= this.t.p) {
            this.addTile(arrayList, n3, this.t.q, 1);
            ++n3;
        }
    }

    private final void drawAround(ArrayList arrayList) {
        int n;
        this.addTile(arrayList, this.s.p, this.s.q, 1);
        int n2 = this.s2.p;
        int n3 = this.s2.q;
        int n4 = 0;
        if (this.s.q < this.t.q) {
            n4 = 1;
        }
        this.addTile(arrayList, n2, n3, n4 + 7);
        if (this.s.q < this.t.q) {
            n = this.s2.q + 1;
            while (n < this.b.q) {
                this.addTile(arrayList, this.s2.p, n, 2);
                ++n;
            }
        } else {
            n = this.b.q + 1;
            while (n < this.s2.q) {
                this.addTile(arrayList, this.s2.p, n, 2);
                ++n;
            }
        }
        int n5 = this.b.p;
        int n6 = this.b.q;
        int n7 = 0;
        if (this.s.q < this.t.q) {
            n7 = 1;
        }
        this.addTile(arrayList, n5, n6, 8 - n7);
        n = this.r.p + 1;
        while (n < this.b.p) {
            this.addTile(arrayList, n, this.r.q, 1);
            ++n;
        }
        int n8 = this.r.p;
        int n9 = this.r.q;
        int n10 = 0;
        if (this.s.q < this.t.q) {
            n10 = 1;
        }
        this.addTile(arrayList, n8, n9, n10 + 9);
        if (this.s.q < this.t.q) {
            n = this.r.q + 1;
            while (n < this.t2.q) {
                this.addTile(arrayList, this.r.p, n, 2);
                ++n;
            }
        } else {
            n = this.t2.q + 1;
            while (n < this.r.q) {
                this.addTile(arrayList, this.r.p, n, 2);
                ++n;
            }
        }
        int n11 = this.t2.p;
        int n12 = this.t2.q;
        int n13 = 0;
        if (this.s.q < this.t.q) {
            n13 = 1;
        }
        this.addTile(arrayList, n11, n12, 10 - n13);
        this.addTile(arrayList, this.t.p, this.t.q, 1);
    }

    private final void routeStubs(ArrayList arrayList) {
        this.addTile(arrayList, this.s.p, this.s.q, 4);
        this.addTile(arrayList, this.t.p, this.t.q, 3);
    }

    private final void routeFailed() {
        String string = this.sourceComp.component.getType().toString();
        String string2 = this.targetComp.component.getType().toString();
        string = string.substring(string.lastIndexOf(58) + 1, string.length());
        string2 = string2.substring(string2.lastIndexOf(58) + 1, string2.length());
        logger.trace("Failed to draw link between " + string + ':' + this.sourceComp.component.getNavDisplayName(null) + ':' + this.link.getSourceSlotName() + " and " + string2 + ':' + this.targetComp.component.getNavDisplayName(null) + ':' + this.link.getTargetSlotName() + '.');
    }

    private final boolean routeAntRace(ArrayList arrayList) {
        int n = this.s.p + 1;
        int n2 = this.s.q;
        if (n < 0 || n >= this.ws.grid.getWixelWidth() || n2 < 0 || n2 >= this.ws.grid.getWixelHeight() || this.hasComponents(n, n2)) {
            this.routeFailed();
            return false;
        }
        this.initBoard();
        LinkSnakeGlyph.board[this.s.p][this.s.q] = 1;
        int n3 = 2;
        ants0Len = 0;
        ants1Len = 0;
        ants0P = LinkSnakeGlyph.ensureCapacity(ants0P, ++ants0Len);
        ants0Q = LinkSnakeGlyph.ensureCapacity(ants0Q, ants0Len);
        LinkSnakeGlyph.ants0P[LinkSnakeGlyph.ants0Len - 1] = this.s.p + 1;
        LinkSnakeGlyph.ants0Q[LinkSnakeGlyph.ants0Len - 1] = this.s.q;
        while (ants0Len > 0) {
            int n4 = 0;
            while (n4 < ants0Len) {
                int n5 = ants0P[n4];
                int n6 = ants0Q[n4];
                if (board[n5][n6] == 0) {
                    LinkSnakeGlyph.board[n5][n6] = n3;
                    if (n5 == this.t.p - 1 && n6 == this.t.q) {
                        return this.buildAntRoad(arrayList);
                    }
                    this.spawnAnts(n5, n6);
                }
                ++n4;
            }
            ++n3;
            int[] nArray = ants0P;
            int[] nArray2 = ants0Q;
            ants0P = ants1P;
            ants0Q = ants1Q;
            ants0Len = ants1Len;
            ants1P = nArray;
            ants1Q = nArray2;
            ants1Len = 0;
        }
        this.routeFailed();
        return false;
    }

    private final void initBoard() {
        board = new int[this.ws.grid.getWixelWidth()][this.ws.grid.getWixelHeight()];
        int n = 0;
        while (n < this.ws.grid.getWixelWidth()) {
            int n2 = 0;
            while (n2 < this.ws.grid.getWixelHeight()) {
                LinkSnakeGlyph.board[n][n2] = 0;
                ++n2;
            }
            ++n;
        }
    }

    private final void spawnAnts(int n, int n2) {
        if (this.usableWixel(n, n2 - 1, 2)) {
            this.newAnt(n, n2 - 1);
        }
        if (this.usableWixel(n, n2 + 1, 2)) {
            this.newAnt(n, n2 + 1);
        }
        if (this.usableWixel(n - 1, n2, 1)) {
            this.newAnt(n - 1, n2);
        }
        if (this.usableWixel(n + 1, n2, 1)) {
            this.newAnt(n + 1, n2);
        }
    }

    private final void newAnt(int n, int n2) {
        ants1P = LinkSnakeGlyph.ensureCapacity(ants1P, ++ants1Len);
        ants1Q = LinkSnakeGlyph.ensureCapacity(ants1Q, ants1Len);
        LinkSnakeGlyph.ants1P[LinkSnakeGlyph.ants1Len - 1] = n;
        LinkSnakeGlyph.ants1Q[LinkSnakeGlyph.ants1Len - 1] = n2;
    }

    private static final int[] ensureCapacity(int[] nArray, int n) {
        if (n < nArray.length) {
            return nArray;
        }
        int n2 = 1;
        if (nArray.length != 0) {
            n2 = nArray.length * 2;
        }
        int[] nArray2 = new int[n2];
        if (nArray.length > 0) {
            System.arraycopy(nArray, 0, nArray2, 0, nArray.length);
        }
        return nArray2;
    }

    private final boolean buildAntRoad(ArrayList arrayList) {
        int n;
        ArrayList<LinkGlyph.Tile> arrayList2 = new ArrayList<LinkGlyph.Tile>();
        int n2 = this.t.p;
        int n3 = this.t.q;
        arrayList2.add(new LinkGlyph.Tile(n2, n3, 1, this.ws));
        int n4 = this.t.p - 1;
        int n5 = this.t.q;
        int n6 = board[n4][n5];
        while (n4 != this.s.p || n5 != this.s.q) {
            n = n4;
            int n7 = n5;
            if (this.availableCell(n6 - 1, n2, n3, n4, n5, n4, n5 + 1)) {
                ++n7;
            } else if (this.availableCell(n6 - 1, n2, n3, n4, n5, n4 - 1, n5)) {
                --n;
            } else if (this.availableCell(n6 - 1, n2, n3, n4, n5, n4 + 1, n5)) {
                ++n;
            } else if (this.availableCell(n6 - 1, n2, n3, n4, n5, n4, n5 - 1)) {
                --n7;
            } else {
                this.routeFailed();
                return false;
            }
            int n8 = this.getRoadTile(n2, n3, n4, n5, n, n7);
            arrayList2.add(new LinkGlyph.Tile(n4, n5, n8, this.ws));
            n2 = n4;
            n3 = n5;
            n4 = n;
            n5 = n7;
            --n6;
        }
        arrayList2.add(new LinkGlyph.Tile(this.s.p, this.s.q, 1, this.ws));
        n = 0;
        while (n < arrayList2.size()) {
            LinkGlyph.Tile tile = (LinkGlyph.Tile)arrayList2.get(n);
            this.addTile(arrayList, tile.p, tile.q, tile.type);
            ++n;
        }
        return true;
    }

    private final boolean availableCell(int n, int n2, int n3, int n4, int n5, int n6, int n7) {
        if (n6 < 0 || n6 >= this.ws.grid.getWixelWidth()) {
            return false;
        }
        if (n7 < 0 || n7 >= this.ws.grid.getWixelHeight()) {
            return false;
        }
        if (board[n6][n7] != n) {
            return false;
        }
        int n8 = this.getRoadTile(n2, n3, n4, n5, n6, n7);
        if (n8 == -1) {
            return false;
        }
        return this.canCross(n4, n5, n8);
    }

    private final int getRoadTile(int n, int n2, int n3, int n4, int n5, int n6) {
        if (n == n5 && n2 == n6) {
            return -1;
        }
        if (Math.abs(n2 - n6) == 2) {
            return 2;
        }
        if (Math.abs(n - n5) == 2) {
            return 1;
        }
        switch (this.checkCompass(n3, n4, n, n2)) {
            case 0: {
                switch (this.checkCompass(n3, n4, n5, n6)) {
                    case 2: {
                        return 9;
                    }
                    case 3: {
                        return 7;
                    }
                }
                throw new IllegalStateException();
            }
            case 1: {
                switch (this.checkCompass(n3, n4, n5, n6)) {
                    case 2: {
                        return 10;
                    }
                    case 3: {
                        return 8;
                    }
                }
                throw new IllegalStateException();
            }
            case 2: {
                switch (this.checkCompass(n3, n4, n5, n6)) {
                    case 0: {
                        return 9;
                    }
                    case 1: {
                        return 10;
                    }
                }
                throw new IllegalStateException();
            }
            case 3: {
                switch (this.checkCompass(n3, n4, n5, n6)) {
                    case 0: {
                        return 7;
                    }
                    case 1: {
                        return 8;
                    }
                }
                throw new IllegalStateException();
            }
        }
        throw new IllegalStateException();
    }

    private final int checkCompass(int n, int n2, int n3, int n4) {
        if (n3 < n) {
            return 3;
        }
        if (n3 > n) {
            return 2;
        }
        if (n4 < n2) {
            return 0;
        }
        if (n4 > n2) {
            return 1;
        }
        throw new IllegalStateException();
    }

    protected void replaceTilesAt(int n, int n2, int n3) {
        ArrayList<LinkGlyph.Tile> arrayList = new ArrayList<LinkGlyph.Tile>();
        int n4 = 0;
        while (n4 < this.tiles.length) {
            if (this.tiles[n4].p != n || this.tiles[n4].q != n2) {
                arrayList.add(this.tiles[n4]);
            }
            ++n4;
        }
        arrayList.add(new LinkGlyph.Tile(n, n2, n3, this.ws));
        this.tiles = arrayList.toArray(new LinkGlyph.Tile[arrayList.size()]);
    }

    private final /* synthetic */ void this() {
        this.doubleBreak = false;
        this.s = new Woint();
        this.t = new Woint();
        this.b = new Woint();
        this.r = new Woint();
        this.s2 = new Woint();
        this.t2 = new Woint();
    }

    protected LinkSnakeGlyph(BWireSheetPane bWireSheetPane, BLink bLink, StdComponentGlyph stdComponentGlyph, StdComponentGlyph stdComponentGlyph2) {
        super(bWireSheetPane, bLink, stdComponentGlyph);
        this.this();
        this.sourceComp = stdComponentGlyph2;
        this.sourceSlot = stdComponentGlyph2.getVisibleSlotBar(bLink.getSourceSlotName());
    }

    static {
        ants0P = new int[0];
        ants0Q = new int[0];
        ants1P = new int[0];
        ants1Q = new int[0];
        ants0Len = 0;
        ants1Len = 0;
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public class Scale {
        int p;
        int q;
        SlotBarGlyph source;
        SlotBarGlyph target;
        int type;

        LinkSnakeGlyph getOwner() {
            return LinkSnakeGlyph.this;
        }

        Scale(int n, int n2, SlotBarGlyph slotBarGlyph, SlotBarGlyph slotBarGlyph2, int n3) {
            this.p = n;
            this.q = n2;
            this.source = slotBarGlyph;
            this.target = slotBarGlyph2;
            this.type = n3;
        }
    }
}

