/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.wiresheet;

import com.tridium.wiresheet.BWireSheetPane;
import com.tridium.wiresheet.BWsOptions;
import com.tridium.wiresheet.ComponentGlyph;
import com.tridium.wiresheet.Glyph;
import com.tridium.wiresheet.SlotBarGlyph;
import com.tridium.wiresheet.StdComponentGlyph;
import com.tridium.wiresheet.TileImages;
import com.tridium.wiresheet.WsConst;
import com.tridium.wiresheet.WsPrinting;
import javax.baja.gx.BColor;
import javax.baja.gx.Graphics;
import javax.baja.gx.RectGeom;
import javax.baja.naming.BOrd;
import javax.baja.naming.OrdQuery;
import javax.baja.sys.BComponent;
import javax.baja.sys.BObject;
import javax.baja.ui.BWidget;
import javax.baja.ui.Command;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.CommandEvent;
import javax.baja.ui.HyperlinkInfo;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public abstract class LinkGlyph
extends Glyph {
    int minP;
    int minQ;
    int maxP;
    int maxQ;
    Tile[] tiles;
    Object selectionKey;
    String linkName;

    public abstract StdComponentGlyph getSourceComponentGlyph();

    public abstract StdComponentGlyph getTargetComponentGlyph();

    public abstract SlotBarGlyph getSourceSlotGlyph();

    public abstract SlotBarGlyph getTargetSlotGlyph();

    public boolean isLinkedTo(ComponentGlyph componentGlyph) {
        boolean bl = false;
        if (componentGlyph == this.getSourceComponentGlyph() || componentGlyph == this.getTargetComponentGlyph()) {
            bl = true;
        }
        return bl;
    }

    public abstract String getStatusMessage();

    public abstract int getLinkColorCode();

    public boolean isSelectable() {
        return true;
    }

    public final Object getSelectionKey() {
        return this.selectionKey;
    }

    public void popup(double d, double d2) {
        this.ws.controller.doBackgroundPopup(d, d2);
    }

    public void mouseEntered() {
        this.showStatus(this.getStatusMessage());
    }

    public boolean contains(int n, int n2) {
        if (n < this.minP || n > this.maxP || n2 < this.minQ || n2 > this.maxQ) {
            return false;
        }
        Tile[] tileArray = this.tiles;
        int n3 = 0;
        while (n3 < tileArray.length) {
            if (tileArray[n3].contains(n, n2)) {
                return true;
            }
            ++n3;
        }
        return false;
    }

    public boolean inside(RectGeom rectGeom) {
        if ((double)(this.minP * this.ws.grid.wixel) < rectGeom.x) {
            return false;
        }
        if ((double)(this.minQ * this.ws.grid.wixel) < rectGeom.y) {
            return false;
        }
        if ((double)(this.maxP * this.ws.grid.wixel) > rectGeom.x + rectGeom.width) {
            return false;
        }
        return !((double)(this.maxQ * this.ws.grid.wixel) > rectGeom.y + rectGeom.height);
    }

    public final void doLayout(Glyph[] glyphArray) {
        this.tiles = this.buildTiles();
        this.setWixelBounds(0, 0, 0, 0);
    }

    protected final void fillGrid() {
        int n = Integer.MAX_VALUE;
        int n2 = Integer.MAX_VALUE;
        int n3 = Integer.MIN_VALUE;
        int n4 = Integer.MIN_VALUE;
        int n5 = 0;
        while (n5 < this.tiles.length) {
            Tile tile = this.tiles[n5];
            int n6 = tile.p;
            int n7 = tile.q;
            this.ws.grid.set(n6, n7, tile.type);
            n = Math.min(n, n6);
            n2 = Math.min(n2, n7);
            n3 = Math.max(n3, n6);
            n4 = Math.max(n4, n7);
            ++n5;
        }
        this.minP = n;
        this.minQ = n2;
        this.maxP = n3;
        this.maxQ = n4;
    }

    protected abstract Tile[] buildTiles();

    public void repaintSelection() {
        int n = this.minP * this.ws.grid.wixel;
        int n2 = this.minQ * this.ws.grid.wixel;
        int n3 = (this.maxP - this.minP + 1) * this.ws.grid.wixel;
        int n4 = (this.maxQ - this.minQ + 1) * this.ws.grid.wixel;
        this.ws.getCanvas().repaint(n, n2, n3, n4);
    }

    public final void paint(Graphics graphics) {
        Tile[] tileArray;
        Object object;
        int n = -1;
        if (BWsOptions.make().getLinkHighlighting()) {
            object = this.getSourceComponentGlyph();
            tileArray = this.getTargetComponentGlyph();
            if (object != null && ((Glyph)object).isSelected()) {
                n = ((StdComponentGlyph)object).getSelectionIndex();
            }
            if (n == -1 && tileArray != null && tileArray.isSelected()) {
                n = tileArray.getSelectionIndex();
            }
        }
        object = TileImages.get(this.getLinkColorCode(), n, this.isSelected());
        tileArray = this.tiles;
        int n2 = 0;
        while (n2 < tileArray.length) {
            Tile tile = tileArray[n2];
            ((TileImages.Wimages)object).paint(graphics, this.ws.grid.wixel, tile.type, tile.x, tile.y);
            ++n2;
        }
    }

    public void paintSelection(Graphics graphics) {
    }

    public void print(WsPrinting wsPrinting) {
        Graphics graphics = wsPrinting.graphics;
        graphics.setBrush(BColor.black.toBrush());
        Tile[] tileArray = this.tiles;
        double d = wsPrinting.wixel;
        int n = 0;
        while (n < tileArray.length) {
            Tile tile = tileArray[n];
            if (wsPrinting.paintLinks || tile.type != 4 && tile.type != 3) {
                double d2 = (double)tile.p * d;
                double d3 = (double)tile.q * d;
                this.printTile(wsPrinting, d2, d3, tile.type);
                if (tile.type == 4) {
                    if (this.linkName != null) {
                        graphics.setFont(wsPrinting.small);
                        graphics.drawString(this.linkName, d2 + d + (double)2, d3 + wsPrinting.small.getAscent());
                    }
                } else if (tile.type == 3 && this.linkName != null) {
                    graphics.setFont(wsPrinting.small);
                    graphics.drawString(this.linkName, d2 - d, d3 + wsPrinting.small.getAscent());
                }
            }
            ++n;
        }
    }

    private final void printTile(WsPrinting wsPrinting, double d, double d2, int n) {
        Graphics graphics = wsPrinting.graphics;
        double d3 = wsPrinting.wixel;
        double d4 = d3 / (double)2;
        switch (n) {
            case 1: {
                graphics.strokeLine(d, d2 + d4, d + d3, d2 + d4);
                break;
            }
            case 2: {
                graphics.strokeLine(d + d4, d2, d + d4, d2 + d3);
                break;
            }
            case 3: {
                graphics.strokeLine(d, d2 + d4, d + d3, d2 + d4);
                break;
            }
            case 4: {
                graphics.strokeLine(d, d2 + d4, d + d3, d2 + d4);
                break;
            }
            case 5: 
            case 6: {
                graphics.strokeLine(d, d2 + d4, d + d3, d2 + d4);
                graphics.strokeLine(d + d4, d2, d + d4, d2 + d3);
                break;
            }
            case 7: {
                graphics.strokeLine(d, d2 + d4, d + d4, d2);
                break;
            }
            case 8: {
                graphics.strokeLine(d, d2 + d4, d + d4, d2 + d3);
                break;
            }
            case 9: {
                graphics.strokeLine(d + d4, d2, d + d3, d2 + d4);
                break;
            }
            case 10: {
                graphics.strokeLine(d + d4, d2 + d3, d + d3, d2 + d4);
                break;
            }
            default: {
                System.out.println("???printTile??? " + n);
            }
        }
    }

    BOrd getGotoOrd() {
        throw new IllegalStateException();
    }

    String getGotoLinkSourceHandle() {
        return "";
    }

    String getGotoLinkSourceSlotName() {
        return "";
    }

    String getGotoLinkTargetHandle() {
        return "";
    }

    String getGotoLinkTargetSlotName() {
        return "";
    }

    protected String getHandleFromOrd(BOrd bOrd) {
        OrdQuery[] ordQueryArray = bOrd.parse();
        int n = 0;
        while (n < ordQueryArray.length) {
            if (ordQueryArray[n].getScheme().equals("h")) {
                return ordQueryArray[n].getBody();
            }
            ++n;
        }
        BObject bObject = bOrd.get((BObject)this.ws.controller.container);
        if (bObject.isComponent()) {
            return bObject.asComponent().getHandle().toString();
        }
        throw new IllegalStateException();
    }

    public int getMinP() {
        return this.minP;
    }

    public int getMinQ() {
        return this.minQ;
    }

    public int getMaxP() {
        return this.maxP;
    }

    public int getMaxQ() {
        return this.maxQ;
    }

    private final /* synthetic */ void this() {
        this.tiles = new Tile[0];
        this.linkName = null;
    }

    protected LinkGlyph(BWireSheetPane bWireSheetPane, Object object) {
        super(bWireSheetPane);
        this.this();
        this.selectionKey = object;
        this.setWixelBounds(0, 0, 1, 1);
    }

    public static class Tile {
        final int p;
        final int q;
        final int x;
        final int y;
        final int type;

        public final boolean contains(int n, int n2) {
            boolean bl = false;
            if (this.p == n && this.q == n2) {
                bl = true;
            }
            return bl;
        }

        public String toString() {
            return "" + this.p + ',' + this.q + ',' + this.x + ',' + this.y + ',' + this.type;
        }

        public Tile(int n, int n2, int n3, BWireSheetPane bWireSheetPane) {
            this.p = n;
            this.q = n2;
            this.x = n * bWireSheetPane.grid.wixel;
            this.y = n2 * bWireSheetPane.grid.wixel;
            this.type = n3;
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    protected class GotoLinkCommand
    extends Command {
        public CommandArtifact doInvoke(CommandEvent commandEvent) throws Exception {
            BOrd bOrd = LinkGlyph.this.getGotoOrd();
            BComponent bComponent = (BComponent)bOrd.get((BObject)LinkGlyph.this.ws.getView().getCurrentValueSpace());
            BComponent bComponent2 = (BComponent)bComponent.getParent();
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(bComponent2.getNavOrd().toString());
            stringBuffer.append("|view:");
            stringBuffer.append(LinkGlyph.this.ws.getView().getType().toString()).append("?");
            stringBuffer.append("sHandle").append("=").append(LinkGlyph.this.getGotoLinkSourceHandle()).append(";");
            stringBuffer.append("sSlot").append("=").append(LinkGlyph.this.getGotoLinkSourceSlotName()).append(";");
            stringBuffer.append("tHandle").append("=").append(LinkGlyph.this.getGotoLinkTargetHandle()).append(";");
            stringBuffer.append("tSlot").append("=").append(LinkGlyph.this.getGotoLinkTargetSlotName());
            LinkGlyph.this.ws.getWbShell().hyperlink(new HyperlinkInfo(BOrd.make((String)stringBuffer.toString()), commandEvent.getInputEvent()));
            return null;
        }

        protected GotoLinkCommand() {
            super((BWidget)LinkGlyph.this.ws.getCanvas(), WsConst.lex, "linkGotoLink");
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    class GotoCommand
    extends Command {
        public CommandArtifact doInvoke(CommandEvent commandEvent) {
            BOrd bOrd = LinkGlyph.this.getGotoOrd();
            if (bOrd.toString().startsWith("h:")) {
                BComponent bComponent = (BComponent)bOrd.get((BObject)LinkGlyph.this.ws.controller.container);
                bOrd = bComponent.getNavOrd();
            }
            LinkGlyph.this.ws.getWbShell().hyperlink(new HyperlinkInfo(bOrd, commandEvent.getInputEvent()));
            return null;
        }

        GotoCommand() {
            super((BWidget)LinkGlyph.this.ws.getCanvas(), WsConst.lex, "linkGoto");
        }
    }
}

