/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.wiresheet;

import com.tridium.ui.theme.custom.nss.StyleUtils;
import com.tridium.wiresheet.BWireSheetPane;
import com.tridium.wiresheet.ResizeZone;
import com.tridium.wiresheet.WsConst;
import com.tridium.wiresheet.WsPrinting;
import com.tridium.wiresheet.WsSelectedState;
import java.util.ArrayList;
import javax.baja.gx.Graphics;
import javax.baja.gx.IGeom;
import javax.baja.gx.IRectGeom;
import javax.baja.gx.RectGeom;
import javax.baja.nre.util.TextUtil;
import javax.baja.sys.BComponent;
import javax.baja.sys.Slot;
import javax.baja.ui.event.BMouseEvent;
import javax.baja.ui.style.IStylable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public abstract class Glyph
implements WsConst,
IStylable {
    private static final Glyph[] empty = new Glyph[0];
    public final BWireSheetPane ws;
    public int x;
    public int y;
    public int p;
    public int q;
    public int pw;
    public int ph;
    public int ww;
    public int wh;
    public boolean visible;
    private Glyph parent;
    private ArrayList children;
    private boolean selected;
    private boolean mouseOver;
    private int linkOver;
    private String styleId;
    private String styleClasses;

    public final Glyph getParent() {
        return this.parent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final Glyph[] getChildGlyphs() {
        ArrayList arrayList = this.children;
        synchronized (arrayList) {
            int n = this.children.size();
            if (n == 0) {
                return empty;
            }
            return this.children.toArray(new Glyph[n]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void add(Glyph glyph) {
        ArrayList arrayList = this.children;
        synchronized (arrayList) {
            this.children.add(glyph);
            glyph.parent = this;
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void addToTop(Glyph glyph) {
        ArrayList arrayList = this.children;
        synchronized (arrayList) {
            this.children.add(0, glyph);
            glyph.parent = this;
            // MONITOREXIT @DISABLED, blocks:[0, 1] lbl6 : MonitorExitStatement: MONITOREXIT : var2_2
            this.ws.doLayout(this.ws.getChildWidgets());
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void remove(Glyph glyph) {
        ArrayList arrayList = this.children;
        synchronized (arrayList) {
            int n = 0;
            while (true) {
                if (n >= this.children.size()) {
                    // MONITOREXIT @DISABLED, blocks:[1, 3, 6] lbl11 : MonitorExitStatement: MONITOREXIT : var2_2
                    this.ws.doLayout(this.ws.getChildWidgets());
                    return;
                }
                if (this.children.get(n) == glyph) {
                    this.children.remove(n);
                    if (glyph.selected) {
                        this.ws.selection.unselect(glyph);
                    }
                    glyph.parent = null;
                    return;
                }
                ++n;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void removeAll() {
        ArrayList arrayList = this.children;
        synchronized (arrayList) {
            this.children.clear();
            // MONITOREXIT @DISABLED, blocks:[0, 1] lbl5 : MonitorExitStatement: MONITOREXIT : var1_1
            this.ws.doLayout(this.ws.getChildWidgets());
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void toTop(Glyph glyph) {
        ArrayList arrayList = this.children;
        synchronized (arrayList) {
            int n = 0;
            while (n < this.children.size()) {
                if (this.children.get(n) == glyph) {
                    this.children.remove(n);
                    this.children.add(0, glyph);
                    return;
                }
                ++n;
            }
            return;
        }
    }

    public boolean isSelectable() {
        return false;
    }

    public Object getSelectionKey() {
        throw new IllegalStateException();
    }

    public final boolean isSelected() {
        return this.selected;
    }

    void setSelected(boolean bl) {
        this.selected = bl;
        if (bl) {
            StyleUtils.addStyleClass((IStylable)this, (String)"selected");
        } else {
            StyleUtils.removeStyleClass((IStylable)this, (String)"selected");
        }
    }

    WsSelectedState saveSelectedState() {
        return WsSelectedState.make(this.getSelectionKey());
    }

    void restoreSelectedState(WsSelectedState wsSelectedState) {
    }

    public int getLinkHotSpot(int n, int n2) {
        return 0;
    }

    public int getLinkHotSpotWidth() {
        if (this.ww <= 6) {
            return 2;
        }
        return 3;
    }

    public int getLinkOver() {
        return this.linkOver;
    }

    public final void setLinkOver(int n) {
        this.linkOver = n;
        this.repaint();
    }

    public BComponent getLinkComponent() {
        return null;
    }

    public Slot getLinkSlot() {
        return null;
    }

    public int getGridType() {
        return 0;
    }

    public RectGeom getGeom() {
        Glyph[] glyphArray = this.getChildGlyphs();
        RectGeom rectGeom = null;
        int n = 0;
        while (n < glyphArray.length) {
            RectGeom rectGeom2 = glyphArray[n].getGeom();
            if (rectGeom2 != null) {
                rectGeom = rectGeom == null ? rectGeom2 : RectGeom.bounds((IRectGeom)rectGeom, (IRectGeom)rectGeom2, (RectGeom)rectGeom);
            }
            ++n;
        }
        return rectGeom;
    }

    public final int absX() {
        return this.parent == null ? this.x : this.parent.absX() + this.x;
    }

    public final int absY() {
        return this.parent == null ? this.y : this.parent.absY() + this.y;
    }

    public final int absP() {
        return this.parent == null ? this.p : this.parent.absP() + this.p;
    }

    public final int absQ() {
        return this.parent == null ? this.q : this.parent.absQ() + this.q;
    }

    public boolean contains(int n, int n2) {
        boolean bl = false;
        if (n >= 0 && n < this.ww && n2 >= 0 && n2 < this.wh) {
            bl = true;
        }
        return bl;
    }

    public Glyph childAt(int n, int n2) {
        Glyph[] glyphArray = this.getChildGlyphs();
        int n3 = 0;
        while (n3 < glyphArray.length) {
            Glyph glyph = glyphArray[n3];
            if (glyph.contains(n - glyph.p, n2 - glyph.q) && glyph.visible) {
                return glyph;
            }
            ++n3;
        }
        return null;
    }

    public Glyph descendentAt(int n, int n2) {
        Glyph glyph = this.childAt(n, n2);
        if (glyph != null && glyph.visible) {
            Glyph glyph2 = glyph.descendentAt(n - glyph.p, n2 - glyph.q);
            return glyph2 != null ? glyph2 : glyph;
        }
        return null;
    }

    public void setWixelBounds(int n, int n2, int n3, int n4) {
        this.p = n;
        this.x = n * this.ws.grid.wixel;
        this.q = n2;
        this.y = n2 * this.ws.grid.wixel;
        this.ww = n3;
        this.pw = n3 * this.ws.grid.wixel;
        this.wh = n4;
        this.ph = n4 * this.ws.grid.wixel;
    }

    public void layout() {
        Glyph[] glyphArray = this.getChildGlyphs();
        this.doLayout(glyphArray);
        this.fillGrid();
        int n = 0;
        while (n < glyphArray.length) {
            if (glyphArray[n].visible) {
                glyphArray[n].layout();
            }
            ++n;
        }
    }

    protected void fillGrid() {
    }

    protected void doLayout(Glyph[] glyphArray) {
    }

    public ResizeZone getResizeAt(double d, double d2) {
        return null;
    }

    public boolean isMouseOver() {
        return this.mouseOver;
    }

    public final void setMouseOver(boolean bl) {
        this.mouseOver = bl;
        if (bl) {
            this.mouseEntered();
        } else {
            this.mouseExited();
        }
    }

    protected void mouseEntered() {
    }

    protected void mouseExited() {
    }

    public void showStatus(String string) {
        this.ws.getShell().showStatus(string);
    }

    public void popup(double d, double d2) {
    }

    public void doubleClicked(BMouseEvent bMouseEvent) {
    }

    public final void repaint() {
        this.ws.getCanvas().repaint(this.absX(), this.absY(), this.pw, this.ph);
    }

    public void paint(Graphics graphics) {
        this.paintChildren(graphics);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void paintChildren(Graphics graphics) {
        IGeom iGeom = graphics.getClip();
        Glyph[] glyphArray = this.getChildGlyphs();
        int n = glyphArray.length - 1;
        while (n >= 0) {
            Glyph glyph = glyphArray[n];
            if (glyph.visible && iGeom.intersects((double)glyph.x, (double)glyph.y, (double)glyph.pw, (double)glyph.ph)) {
                Object var7_6;
                graphics.push();
                try {
                    graphics.clip((double)glyph.x, (double)glyph.y, (double)glyph.pw, (double)glyph.ph);
                    graphics.translate((double)glyph.x, (double)glyph.y);
                    glyph.paint(graphics);
                }
                catch (Throwable throwable) {
                    var7_6 = null;
                    graphics.pop();
                    throw throwable;
                }
                {
                    var7_6 = null;
                }
                graphics.pop();
            }
            --n;
        }
        return;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void paintChild(Graphics graphics, Glyph glyph) {
        if (!glyph.visible) {
            return;
        }
        IGeom iGeom = graphics.getClip();
        if (!iGeom.intersects((double)glyph.x, (double)glyph.y, (double)glyph.pw, (double)glyph.ph)) return;
        graphics.push();
        try {
            graphics.clip((double)glyph.x, (double)glyph.y, (double)glyph.pw, (double)glyph.ph);
            graphics.translate((double)glyph.x, (double)glyph.y);
            glyph.paint(graphics);
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            graphics.pop();
            throw throwable;
        }
        {
            Object var5_6 = null;
        }
        graphics.pop();
    }

    public void paintSelection(Graphics graphics) {
        throw new IllegalStateException();
    }

    public String getStyleId() {
        return this.styleId;
    }

    public void setStyleId(String string) {
        this.styleId = string;
    }

    public String getStyleClasses() {
        return this.styleClasses;
    }

    public void setStyleClasses(String string) {
        this.styleClasses = string;
    }

    public String getStyleSelector() {
        return "wire-sheet glyph";
    }

    public RectGeom getPrintBounds() {
        return new RectGeom((double)this.absP(), (double)this.absQ(), (double)this.ww, (double)this.wh);
    }

    public void print(WsPrinting wsPrinting) {
        this.printChildren(wsPrinting);
    }

    public void printChildren(WsPrinting wsPrinting) {
        Glyph[] glyphArray = this.getChildGlyphs();
        int n = glyphArray.length - 1;
        while (n >= 0) {
            this.printChild(wsPrinting, glyphArray[n]);
            --n;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void printChild(WsPrinting wsPrinting, Glyph glyph) {
        if (!glyph.visible) {
            return;
        }
        Graphics graphics = wsPrinting.graphics;
        graphics.push();
        try {
            double d = (double)glyph.p * wsPrinting.wixel;
            double d2 = (double)glyph.q * wsPrinting.wixel;
            wsPrinting.graphics.translate(d, d2);
            glyph.print(wsPrinting);
        }
        catch (Throwable throwable) {
            Object var5_7 = null;
            graphics.pop();
            throw throwable;
        }
        {
            Object var5_8 = null;
        }
        graphics.pop();
    }

    public void findLinks(WsPrinting wsPrinting) {
        Glyph[] glyphArray = this.getChildGlyphs();
        int n = 0;
        while (n < glyphArray.length) {
            glyphArray[n].findLinks(wsPrinting);
            ++n;
        }
    }

    public String toString() {
        return TextUtil.getClassName(this.getClass()) + " [" + this.p + ',' + this.q + ',' + this.ww + ',' + this.wh + ']';
    }

    public void dump() {
        System.out.println(this);
        Glyph[] glyphArray = this.getChildGlyphs();
        int n = 0;
        while (n < glyphArray.length) {
            System.out.println("  kids[" + n + "] " + glyphArray[n]);
            ++n;
        }
    }

    private final /* synthetic */ void this() {
        this.visible = true;
        this.children = new ArrayList();
        this.styleId = "";
        this.styleClasses = "";
    }

    protected Glyph(BWireSheetPane bWireSheetPane) {
        this.this();
        this.ws = bWireSheetPane;
    }
}

