/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.wiresheet;

import com.tridium.ui.theme.Theme;
import com.tridium.wiresheet.BThumbnail;
import com.tridium.wiresheet.BWsCanvas;
import com.tridium.wiresheet.BWsOptions;
import com.tridium.wiresheet.WixelGrid;
import com.tridium.wiresheet.WsCommands;
import com.tridium.wiresheet.WsConst;
import com.tridium.wiresheet.WsController;
import com.tridium.wiresheet.WsSelection;
import java.util.HashMap;
import javax.baja.gx.Graphics;
import javax.baja.gx.RectGeom;
import javax.baja.naming.BOrd;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BWidget;
import javax.baja.ui.BWidgetShell;
import javax.baja.ui.pane.BEdgePane;
import javax.baja.ui.pane.BScrollPane;
import javax.baja.wiresheet.BWireSheet;
import javax.baja.workbench.BWbShell;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BWireSheetPane
extends BEdgePane
implements WsConst {
    public static final Property thumbnail = BWireSheetPane.newProperty((int)0, (BValue)new BThumbnail(), null);
    public static final Type TYPE;
    static HashMap scrollMemory;
    public final WsController controller;
    public final WixelGrid grid;
    public final WsSelection selection;
    public final WsCommands commands;
    boolean initialized;
    Context context;
    private BComponent value;
    private RectGeom lastViewport;
    private BOrd ord;
    static /* synthetic */ Class class$com$tridium$wiresheet$BWireSheetPane;

    public BThumbnail getThumbnail() {
        return (BThumbnail)this.get(thumbnail);
    }

    public void setThumbnail(BThumbnail bThumbnail) {
        this.set(thumbnail, (BValue)bThumbnail, null);
    }

    public Type getType() {
        return TYPE;
    }

    public static BWireSheetPane get(BWidget bWidget) {
        if (bWidget instanceof BWireSheetPane) {
            return (BWireSheetPane)bWidget;
        }
        BWidget[] bWidgetArray = bWidget.getChildWidgets();
        int n = 0;
        while (n < bWidgetArray.length) {
            BWireSheetPane bWireSheetPane = BWireSheetPane.get(bWidgetArray[n]);
            if (bWireSheetPane != null) {
                return bWireSheetPane;
            }
            ++n;
        }
        return null;
    }

    public BScrollPane getScrollPane() {
        return (BScrollPane)this.getCenter();
    }

    public BWsCanvas getCanvas() {
        return (BWsCanvas)this.getScrollPane().getContent();
    }

    private final BWbShell findShell(BComponent bComponent) {
        BWidgetShell bWidgetShell;
        if (bComponent == null) {
            return null;
        }
        if (bComponent instanceof BWidget && (bWidgetShell = ((BWidget)bComponent).getShell()) != null && bWidgetShell instanceof BWbShell) {
            return (BWbShell)bWidgetShell;
        }
        return this.findShell((BComponent)bComponent.getParent());
    }

    public final BWbShell getWbShell() {
        try {
            return this.findShell((BComponent)this);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public final BWireSheet getView() {
        BComplex bComplex = this.getParent();
        while (bComplex != null && !(bComplex instanceof BWireSheet)) {
            bComplex = bComplex.getParent();
        }
        return (BWireSheet)bComplex;
    }

    public void deactivated() {
        RectGeom rectGeom = this.getScrollPane().getViewport();
        scrollMemory.put(this.ord, rectGeom);
    }

    public void doLoadValue(BObject bObject, Context context) {
        this.value = (BComponent)bObject;
        this.context = context;
        this.init();
    }

    public void started() {
        this.init();
    }

    private final void init() {
        BWbShell bWbShell = this.getWbShell();
        if (bWbShell == null || this.initialized || this.value == null) {
            return;
        }
        BComponent bComponent = this.value;
        this.getView().registerForComponentEvents(bComponent, 1);
        this.controller.updateTransferStates();
        this.commands.init();
        this.controller.load(this.value.asComponent());
        this.initialized = true;
        final String string = bWbShell.getActiveOrdTarget().getViewParameter("sHandle", "");
        final String string2 = bWbShell.getActiveOrdTarget().getViewParameter("sSlot", "");
        final String string3 = bWbShell.getActiveOrdTarget().getViewParameter("tHandle", "");
        final String string4 = bWbShell.getActiveOrdTarget().getViewParameter("tSlot", "");
        if (string.length() > 0 && string2.length() > 0 && string3.length() > 0 && string4.length() > 0) {
            BWidget.invokeLater((Runnable)new Runnable(){

                public final void run() {
                    BWireSheetPane.this.relayoutSync();
                    BWireSheetPane.this.getCanvas().rootGlyph.linkLayer.selectLink(string, string2, string3, string4);
                }
            });
        } else if (this.getWbShell() != null) {
            this.ord = this.getWbShell().getActiveOrd();
            RectGeom rectGeom = (RectGeom)scrollMemory.get(this.ord);
            if (rectGeom != null) {
                this.getScrollPane().scrollToVisible(rectGeom);
            }
        }
    }

    public void doLayout(BWidget[] bWidgetArray) {
        double d;
        RectGeom rectGeom = this.getCanvas().getRootGlyph().getGeom();
        int n = 120;
        int n2 = 120;
        if (rectGeom != null) {
            n = Math.max(120, (int)rectGeom.x + (int)rectGeom.width + 60);
            n2 = Math.max(120, (int)rectGeom.y + (int)rectGeom.height + 60);
            if (n > BWsOptions.make().getMaxWidth()) {
                n = BWsOptions.make().getMaxWidth();
            }
            if (n2 > BWsOptions.make().getMaxHeight()) {
                n2 = BWsOptions.make().getMaxHeight();
            }
        }
        if (n != this.grid.getWixelWidth() || n2 != this.grid.getWixelHeight()) {
            this.getCanvas().getRootGlyph().setWixelBounds(0, 0, n, n2);
            this.grid.setWixelSize(n, n2);
            this.controller.zoom(0);
        }
        this.getCanvas().setPreferredSize(n * this.grid.wixel, n2 * this.grid.wixel);
        this.getCanvas().relayout();
        double d2 = this.getWidth();
        double d3 = this.getHeight();
        this.getScrollPane().setBounds(0.0, 0.0, d2, d3);
        double d4 = BWsOptions.make().getThumbnailX();
        double d5 = BWsOptions.make().getThumbnailY();
        double d6 = Theme.scrollBar().getFixedWidth();
        this.getThumbnail().computePreferredSize();
        double d7 = this.getThumbnail().getPreferredWidth();
        double d8 = this.getThumbnail().getPreferredHeight();
        double d9 = d4 >= 0.0 ? d4 : d2 - d7 - d6 + d4;
        double d10 = d = d5 >= 0.0 ? d5 : d3 - d8 - d6 + d5;
        if (d9 + d7 > d2 - d6 - (double)5) {
            d9 = d2 - d6 - (double)5 - d7;
        }
        if (d + d8 > d3 - d6 - (double)5) {
            d = d3 - d6 - (double)5 - d8;
        }
        if (d9 < (double)5) {
            d9 = 5;
        }
        if (d < (double)5) {
            d = 5;
        }
        this.getThumbnail().setBounds(d9, d, d7, d8);
    }

    public void paint(Graphics graphics) {
        this.paintChild(graphics, (BWidget)this.getScrollPane());
        if (this.initialized && BWsOptions.make().getShowThumbnail()) {
            RectGeom rectGeom = this.getScrollPane().getViewport();
            if (!rectGeom.equals((Object)this.lastViewport)) {
                this.getThumbnail().repaintBuffer();
            }
            this.lastViewport = rectGeom;
            this.paintChild(graphics, this.getThumbnail());
        }
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final /* synthetic */ void this() {
        this.grid = new WixelGrid(this);
        this.selection = new WsSelection(this);
        this.commands = new WsCommands(this);
    }

    public BWireSheetPane() {
        this.this();
        this.setCenter((BWidget)new BScrollPane((BWidget)new BWsCanvas()));
        this.controller = new WsController(this);
        this.getScrollPane().getHscrollBar().setUnitIncrement(this.grid.wixel);
        this.getScrollPane().getVscrollBar().setUnitIncrement(this.grid.wixel);
        this.getScrollPane().getHscrollBar().setBlockIncrement(this.grid.wixel * 10);
        this.getScrollPane().getVscrollBar().setBlockIncrement(this.grid.wixel * 10);
        this.getScrollPane().getHscrollBar().setSnapToUnitIncrement(true);
        this.getScrollPane().getVscrollBar().setSnapToUnitIncrement(true);
    }

    static {
        Class clazz = class$com$tridium$wiresheet$BWireSheetPane;
        if (clazz == null) {
            clazz = class$com$tridium$wiresheet$BWireSheetPane = BWireSheetPane.class("[Lcom.tridium.wiresheet.BWireSheetPane;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
        scrollMemory = new HashMap();
    }
}

