/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.eas.web;

import com.tridium.eas.BEasService;
import com.tridium.eas.api.EasPartition;
import com.tridium.eas.api.EasPartitionList;
import com.tridium.eas.api.EasSession;
import com.tridium.eas.util.Dbx;
import com.tridium.eas.web.EasServlet;
import com.tridium.eas.xml.XmlDecoder;
import com.tridium.eas.xml.XmlEncoder;
import com.tridium.eas.xml.XmlMessage;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Hashtable;
import java.util.Vector;
import javax.baja.security.BIProtected;
import javax.baja.security.BPermissions;
import javax.baja.user.BUser;
import javax.baja.user.BUserService;
import javax.baja.util.Lexicon;
import javax.baja.web.WebOp;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpUtils;

public class EasPartitionHandler {
    private EasServlet easServlet;
    private static BEasService easService;
    private EasSession easSession;
    static /* synthetic */ Class class$javax$baja$user$BUser;

    public void setEasServlet(EasServlet easServlet) {
        this.easServlet = easServlet;
    }

    public void setEasService(BEasService bEasService) {
        easService = bEasService;
    }

    public void setEasSession(EasSession easSession) {
        this.easSession = easSession;
    }

    public void doGet(WebOp webOp, Lexicon lexicon) throws Exception {
        HttpServletRequest httpServletRequest = webOp.getRequest();
        HttpServletResponse httpServletResponse = webOp.getResponse();
        BUser bUser = this.easServlet.getUser(httpServletRequest);
        if (bUser == null || !easService.isEasPartitioningLicensed()) {
            httpServletResponse.sendError(403);
            return;
        }
        BPermissions bPermissions = bUser.getPermissionsFor((BIProtected)easService);
        String string = EasServlet.getRequestURINoPrefix(httpServletRequest);
        if ((string = string.substring(4, string.length())).equalsIgnoreCase("/partition/createPartition")) {
            if (!bPermissions.hasAdminWrite()) {
                httpServletResponse.sendError(403);
                return;
            }
            String string2 = httpServletRequest.getQueryString();
            Hashtable hashtable = null;
            String string3 = null;
            if (string2 != null) {
                hashtable = HttpUtils.parseQueryString((String)string2);
                string3 = XmlDecoder.decodeUrl(EasServlet.getPostField("partitionName", hashtable));
            }
            this.createPartition(httpServletRequest, httpServletResponse, string3);
        } else if (string.equalsIgnoreCase("/partition/renamePartition")) {
            String string4 = httpServletRequest.getQueryString();
            Hashtable hashtable = null;
            int n = -1;
            String string5 = null;
            if (string4 != null) {
                hashtable = HttpUtils.parseQueryString((String)string4);
                n = Integer.valueOf(EasServlet.getPostField("oldId", hashtable));
                string5 = XmlDecoder.decodeUrl(EasServlet.getPostField("newName", hashtable));
            }
            this.renamePartition(httpServletRequest, httpServletResponse, n, string5);
        } else if (string.equalsIgnoreCase("/partition/partitionList")) {
            this.getPartitionList(httpServletRequest, httpServletResponse);
        } else if (string.equalsIgnoreCase("/partition/userPartitions")) {
            String string6 = httpServletRequest.getQueryString();
            Hashtable hashtable = null;
            String string7 = null;
            if (string6 != null) {
                hashtable = HttpUtils.parseQueryString((String)string6);
                string7 = XmlDecoder.decodeUrl(EasServlet.getPostField("userName", hashtable));
            }
            this.getUserPartitions(httpServletRequest, httpServletResponse, string7);
        } else if (string.equalsIgnoreCase("/partition/objectPartitions")) {
            String string8 = httpServletRequest.getQueryString();
            Hashtable hashtable = null;
            int n = -1;
            String string9 = null;
            if (string8 != null) {
                hashtable = HttpUtils.parseQueryString((String)string8);
                n = Integer.valueOf(EasServlet.getPostField("easType", hashtable));
                string9 = XmlDecoder.decodeUrl(EasServlet.getPostField("easId", hashtable));
            }
            this.getObjectPartitions(httpServletRequest, httpServletResponse, n, string9);
        } else if (string.equalsIgnoreCase("/partition/userList")) {
            this.getUserList(httpServletRequest, httpServletResponse);
        } else if (string.equalsIgnoreCase("/partition/usersForPartition")) {
            String string10 = httpServletRequest.getQueryString();
            Hashtable hashtable = null;
            int n = -1;
            if (string10 != null) {
                hashtable = HttpUtils.parseQueryString((String)string10);
                n = Integer.valueOf(EasServlet.getPostField("partitionId", hashtable));
            }
            this.getUsersForPartition(httpServletRequest, httpServletResponse, n);
        } else if (string.equalsIgnoreCase("/partition/objectsForPartition")) {
            String string11 = httpServletRequest.getQueryString();
            Hashtable hashtable = null;
            int n = -1;
            int n2 = -1;
            if (string11 != null) {
                hashtable = HttpUtils.parseQueryString((String)string11);
                n = Integer.valueOf(EasServlet.getPostField("partitionId", hashtable));
                n2 = Integer.valueOf(EasServlet.getPostField("objType", hashtable));
            }
            this.getObjectsForPartition(httpServletRequest, httpServletResponse, n, n2);
        }
    }

    public void doPost(WebOp webOp, Lexicon lexicon) throws Exception {
        HttpServletRequest httpServletRequest = webOp.getRequest();
        HttpServletResponse httpServletResponse = webOp.getResponse();
        BUser bUser = this.easServlet.getUser(httpServletRequest);
        if (bUser == null || !easService.isEasPartitioningLicensed()) {
            httpServletResponse.sendError(403);
            return;
        }
        BPermissions bPermissions = bUser.getPermissionsFor((BIProtected)easService);
        String string = EasServlet.getRequestURINoPrefix(httpServletRequest);
        if ((string = string.substring(4, string.length())).equalsIgnoreCase("/partition/deletePartition")) {
            if (!bPermissions.hasAdminWrite()) {
                httpServletResponse.sendError(403);
                return;
            }
            String string2 = httpServletRequest.getQueryString();
            Hashtable hashtable = null;
            int n = -1;
            if (string2 != null) {
                hashtable = HttpUtils.parseQueryString((String)string2);
                n = Integer.valueOf(EasServlet.getPostField("partitionId", hashtable));
            }
            this.deletePartition(httpServletRequest, httpServletResponse, n);
        } else if (string.equalsIgnoreCase("/partition/saveUserPartitions")) {
            if (!bPermissions.hasAdminWrite()) {
                httpServletResponse.sendError(403);
                return;
            }
            String string3 = httpServletRequest.getQueryString();
            Hashtable hashtable = null;
            String string4 = null;
            if (string3 != null) {
                hashtable = HttpUtils.parseQueryString((String)string3);
                string4 = XmlDecoder.decodeUrl(EasServlet.getPostField("userName", hashtable));
            }
            this.saveUserPartitions(httpServletRequest, httpServletResponse, string4);
        } else if (string.equalsIgnoreCase("/partition/saveObjectPartitions")) {
            if (!bPermissions.hasAdminWrite()) {
                httpServletResponse.sendError(403);
                return;
            }
            String string5 = httpServletRequest.getQueryString();
            Hashtable hashtable = null;
            int n = -1;
            String string6 = null;
            if (string5 != null) {
                hashtable = HttpUtils.parseQueryString((String)string5);
                n = Integer.valueOf(EasServlet.getPostField("easType", hashtable));
                string6 = XmlDecoder.decodeUrl(EasServlet.getPostField("easId", hashtable));
            }
            this.saveObjectPartitions(httpServletRequest, httpServletResponse, n, string6);
        } else if (string.equalsIgnoreCase("/partition/saveUsersForPartition")) {
            if (!bPermissions.hasAdminWrite()) {
                httpServletResponse.sendError(403);
                return;
            }
            String string7 = httpServletRequest.getQueryString();
            Hashtable hashtable = null;
            int n = -1;
            if (string7 != null) {
                hashtable = HttpUtils.parseQueryString((String)string7);
                n = Integer.valueOf(EasServlet.getPostField("partitionId", hashtable));
            }
            this.saveUsersForPartition(httpServletRequest, httpServletResponse, n);
        } else if (string.equalsIgnoreCase("/partition/saveObjectsForPartition")) {
            if (!bPermissions.hasAdminWrite()) {
                httpServletResponse.sendError(403);
                return;
            }
            String string8 = httpServletRequest.getQueryString();
            Hashtable hashtable = null;
            int n = -1;
            int n2 = -1;
            if (string8 != null) {
                hashtable = HttpUtils.parseQueryString((String)string8);
                n = Integer.valueOf(EasServlet.getPostField("partitionId", hashtable));
                n2 = Integer.valueOf(EasServlet.getPostField("objType", hashtable));
            }
            this.saveObjectsForPartition(httpServletRequest, httpServletResponse, n, n2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private void createPartition(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, String string) throws Exception {
        Object object;
        EasPartition easPartition;
        DataOutputStream dataOutputStream;
        block33: {
            httpServletResponse.setStatus(200);
            dataOutputStream = new DataOutputStream((OutputStream)httpServletResponse.getOutputStream());
            easPartition = null;
            if (string != null) {
                SQLException sQLException3222;
                ResultSet resultSet;
                Connection connection;
                block29: {
                    block28: {
                        connection = null;
                        object = null;
                        resultSet = null;
                        connection = easService.getDatabase().getConnection();
                        object = connection.createStatement();
                        String string2 = "select PARTITION_ID from " + easService.getDatabase().getDBSpecific().getFullTableName("EAS", "PARTITIONS") + " where PARTITION_NAME=" + Dbx.str2db(string);
                        resultSet = object.executeQuery(string2);
                        if (resultSet.next()) {
                            int n = resultSet.getInt(1);
                            easPartition = new EasPartition(string, n);
                            break block28;
                        }
                        boolean bl = true;
                        int n = 10;
                        int n2 = -1;
                        while (bl && --n >= 0) {
                            try {
                                n2 = easService.getDatabase().getNewId();
                                string2 = "insert into " + easService.getDatabase().getDBSpecific().getFullTableName("EAS", "PARTITIONS") + " (PARTITION_ID,PARTITION_NAME) values (" + n2 + "," + Dbx.str2db(string) + ")";
                                bl = object.executeUpdate(string2) != 1;
                            }
                            catch (SQLException sQLException2) {
                                if (n != 0) continue;
                                throw sQLException2;
                            }
                        }
                        if (bl) {
                            BEasService.log.error("Could not create partition " + string);
                            break block28;
                        }
                        easPartition = new EasPartition(string, n2);
                    }
                    Object var15_17 = null;
                    if (resultSet == null) break block29;
                    try {
                        resultSet.close();
                    }
                    catch (SQLException sQLException3222) {
                        sQLException3222.printStackTrace();
                    }
                }
                if (object != null) {
                    try {
                        object.close();
                    }
                    catch (SQLException sQLException3222) {
                        sQLException3222.printStackTrace();
                    }
                }
                if (connection != null) {
                    easService.getDatabase().freeConnection(connection);
                }
                break block33;
                {
                    catch (Exception exception) {
                        SQLException sQLException42222;
                        BEasService.log.error("Could not create partition " + string, (Throwable)exception);
                        Object var15_18 = null;
                        if (resultSet != null) {
                            try {
                                resultSet.close();
                            }
                            catch (SQLException sQLException42222) {
                                sQLException42222.printStackTrace();
                            }
                        }
                        if (object != null) {
                            try {
                                object.close();
                            }
                            catch (SQLException sQLException42222) {
                                sQLException42222.printStackTrace();
                            }
                        }
                        if (connection != null) {
                            easService.getDatabase().freeConnection(connection);
                        }
                    }
                }
                catch (Throwable throwable) {
                    SQLException sQLException52222;
                    Object var15_19 = null;
                    if (resultSet != null) {
                        try {
                            resultSet.close();
                        }
                        catch (SQLException sQLException52222) {
                            sQLException52222.printStackTrace();
                        }
                    }
                    if (object != null) {
                        try {
                            object.close();
                        }
                        catch (SQLException sQLException52222) {
                            sQLException52222.printStackTrace();
                        }
                    }
                    if (connection != null) {
                        easService.getDatabase().freeConnection(connection);
                    }
                    throw throwable;
                }
            }
        }
        int n = 0;
        if (easPartition != null) {
            n = 1;
        }
        dataOutputStream.writeInt(n);
        if (easPartition != null) {
            object = new XmlEncoder(dataOutputStream);
            ((XmlEncoder)((Object)object)).encodeDocument(easPartition);
        }
        dataOutputStream.flush();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private void renamePartition(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, int n, String string) throws Exception {
        Object object;
        EasPartition easPartition;
        DataOutputStream dataOutputStream;
        block19: {
            httpServletResponse.setStatus(200);
            dataOutputStream = new DataOutputStream((OutputStream)httpServletResponse.getOutputStream());
            easPartition = null;
            if (string != null) {
                Connection connection;
                block17: {
                    block16: {
                        connection = null;
                        object = null;
                        connection = easService.getDatabase().getConnection();
                        object = connection.createStatement();
                        String string2 = "update " + easService.getDatabase().getDBSpecific().getFullTableName("EAS", "PARTITIONS") + " set PARTITION_NAME=" + Dbx.str2db(string) + " where PARTITION_ID=" + n;
                        if (object.executeUpdate(string2) < 1) break block16;
                        easPartition = new EasPartition(string, n);
                    }
                    Object var11_12 = null;
                    if (object == null) break block17;
                    try {
                        object.close();
                    }
                    catch (SQLException sQLException) {
                        sQLException.printStackTrace();
                    }
                }
                if (connection != null) {
                    easService.getDatabase().freeConnection(connection);
                }
                break block19;
                {
                    catch (Exception exception) {
                        BEasService.log.error("Could not rename partition to " + string, (Throwable)exception);
                        Object var11_13 = null;
                        if (object != null) {
                            try {
                                object.close();
                            }
                            catch (SQLException sQLException) {
                                sQLException.printStackTrace();
                            }
                        }
                        if (connection != null) {
                            easService.getDatabase().freeConnection(connection);
                        }
                    }
                }
                catch (Throwable throwable) {
                    Object var11_14 = null;
                    if (object != null) {
                        try {
                            object.close();
                        }
                        catch (SQLException sQLException) {
                            sQLException.printStackTrace();
                        }
                    }
                    if (connection != null) {
                        easService.getDatabase().freeConnection(connection);
                    }
                    throw throwable;
                }
            }
        }
        int n2 = 0;
        if (easPartition != null) {
            n2 = 1;
        }
        dataOutputStream.writeInt(n2);
        if (easPartition != null) {
            object = new XmlEncoder(dataOutputStream);
            ((XmlEncoder)((Object)object)).encodeDocument(easPartition);
        }
        dataOutputStream.flush();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private void getPartitionList(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        EasPartitionList easPartitionList;
        DataOutputStream dataOutputStream;
        block28: {
            SQLException sQLException2222;
            ResultSet resultSet;
            Statement statement;
            Connection connection;
            block24: {
                httpServletResponse.setStatus(200);
                dataOutputStream = new DataOutputStream((OutputStream)httpServletResponse.getOutputStream());
                easPartitionList = null;
                connection = null;
                statement = null;
                resultSet = null;
                connection = easService.getDatabase().getConnection();
                statement = connection.createStatement();
                String string = "select PARTITION_NAME, PARTITION_ID from " + easService.getDatabase().getDBSpecific().getFullTableName("EAS", "PARTITIONS");
                resultSet = statement.executeQuery(string);
                while (resultSet.next()) {
                    if (easPartitionList == null) {
                        easPartitionList = new EasPartitionList("partitionList");
                    }
                    easPartitionList.addPartition(new EasPartition(resultSet.getString(1), resultSet.getInt(2)));
                }
                Object var10_11 = null;
                if (resultSet == null) break block24;
                try {
                    resultSet.close();
                }
                catch (SQLException sQLException2222) {
                    sQLException2222.printStackTrace();
                }
            }
            if (statement != null) {
                try {
                    statement.close();
                }
                catch (SQLException sQLException2222) {
                    sQLException2222.printStackTrace();
                }
            }
            if (connection != null) {
                easService.getDatabase().freeConnection(connection);
            }
            break block28;
            {
                catch (Exception exception) {
                    SQLException sQLException32222;
                    BEasService.log.error("Encountered problem loading available partition list.", (Throwable)exception);
                    Object var10_12 = null;
                    if (resultSet != null) {
                        try {
                            resultSet.close();
                        }
                        catch (SQLException sQLException32222) {
                            sQLException32222.printStackTrace();
                        }
                    }
                    if (statement != null) {
                        try {
                            statement.close();
                        }
                        catch (SQLException sQLException32222) {
                            sQLException32222.printStackTrace();
                        }
                    }
                    if (connection != null) {
                        easService.getDatabase().freeConnection(connection);
                    }
                }
            }
            catch (Throwable throwable) {
                SQLException sQLException42222;
                Object var10_13 = null;
                if (resultSet != null) {
                    try {
                        resultSet.close();
                    }
                    catch (SQLException sQLException42222) {
                        sQLException42222.printStackTrace();
                    }
                }
                if (statement != null) {
                    try {
                        statement.close();
                    }
                    catch (SQLException sQLException42222) {
                        sQLException42222.printStackTrace();
                    }
                }
                if (connection != null) {
                    easService.getDatabase().freeConnection(connection);
                }
                throw throwable;
            }
        }
        int n = 0;
        if (easPartitionList != null) {
            n = 1;
        }
        dataOutputStream.writeInt(n);
        if (easPartitionList != null) {
            XmlEncoder xmlEncoder = new XmlEncoder(dataOutputStream);
            xmlEncoder.encodeDocument(easPartitionList);
        }
        dataOutputStream.flush();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private void getUserPartitions(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, String string) throws Exception {
        EasPartitionList easPartitionList;
        DataOutputStream dataOutputStream;
        block29: {
            httpServletResponse.setStatus(200);
            dataOutputStream = new DataOutputStream((OutputStream)httpServletResponse.getOutputStream());
            easPartitionList = null;
            Connection connection = null;
            Statement statement = null;
            ResultSet resultSet = null;
            if (string != null) {
                SQLException sQLException2222;
                block25: {
                    connection = easService.getDatabase().getConnection();
                    statement = connection.createStatement();
                    String string2 = "select P.PARTITION_NAME, U.PARTITION_ID from " + easService.getDatabase().getDBSpecific().getFullTableName("EAS", "PARTITIONS") + " P, " + easService.getDatabase().getDBSpecific().getFullTableName("EAS", "USER_PARTITIONS") + " U " + "where P.PARTITION_ID = U.PARTITION_ID" + " and U.USERNAME=" + Dbx.str2db(string);
                    resultSet = statement.executeQuery(string2);
                    while (resultSet.next()) {
                        if (easPartitionList == null) {
                            easPartitionList = new EasPartitionList("partitionList");
                        }
                        easPartitionList.addPartition(new EasPartition(resultSet.getString(1), resultSet.getInt(2)));
                    }
                    Object var11_12 = null;
                    if (resultSet == null) break block25;
                    try {
                        resultSet.close();
                    }
                    catch (SQLException sQLException2222) {
                        sQLException2222.printStackTrace();
                    }
                }
                if (statement != null) {
                    try {
                        statement.close();
                    }
                    catch (SQLException sQLException2222) {
                        sQLException2222.printStackTrace();
                    }
                }
                if (connection != null) {
                    easService.getDatabase().freeConnection(connection);
                }
                break block29;
                {
                    catch (Exception exception) {
                        SQLException sQLException32222;
                        BEasService.log.error("Encountered problem loading user partition list for " + string, (Throwable)exception);
                        Object var11_13 = null;
                        if (resultSet != null) {
                            try {
                                resultSet.close();
                            }
                            catch (SQLException sQLException32222) {
                                sQLException32222.printStackTrace();
                            }
                        }
                        if (statement != null) {
                            try {
                                statement.close();
                            }
                            catch (SQLException sQLException32222) {
                                sQLException32222.printStackTrace();
                            }
                        }
                        if (connection != null) {
                            easService.getDatabase().freeConnection(connection);
                        }
                    }
                }
                catch (Throwable throwable) {
                    SQLException sQLException42222;
                    Object var11_14 = null;
                    if (resultSet != null) {
                        try {
                            resultSet.close();
                        }
                        catch (SQLException sQLException42222) {
                            sQLException42222.printStackTrace();
                        }
                    }
                    if (statement != null) {
                        try {
                            statement.close();
                        }
                        catch (SQLException sQLException42222) {
                            sQLException42222.printStackTrace();
                        }
                    }
                    if (connection != null) {
                        easService.getDatabase().freeConnection(connection);
                    }
                    throw throwable;
                }
            }
        }
        int n = 0;
        if (easPartitionList != null) {
            n = 1;
        }
        dataOutputStream.writeInt(n);
        if (easPartitionList != null) {
            XmlEncoder xmlEncoder = new XmlEncoder(dataOutputStream);
            xmlEncoder.encodeDocument(easPartitionList);
        }
        dataOutputStream.flush();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private void getObjectPartitions(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, int n, String string) throws Exception {
        EasPartitionList easPartitionList;
        DataOutputStream dataOutputStream;
        block31: {
            httpServletResponse.setStatus(200);
            dataOutputStream = new DataOutputStream((OutputStream)httpServletResponse.getOutputStream());
            easPartitionList = null;
            Connection connection = null;
            Statement statement = null;
            ResultSet resultSet = null;
            if (string != null) {
                SQLException sQLException2222;
                block27: {
                    connection = easService.getDatabase().getConnection();
                    statement = connection.createStatement();
                    StringBuffer stringBuffer = new StringBuffer();
                    stringBuffer.append("select P.PARTITION_NAME, T.PARTITION_ID from " + easService.getDatabase().getDBSpecific().getFullTableName("EAS", "PARTITIONS") + " P, ");
                    if (n == 4) {
                        stringBuffer.append(easService.getDatabase().getDBSpecific().getFullTableName("EAS", "RATE_PARTITIONS") + " T " + "where T.RATE_ID=" + Dbx.str2db(string));
                    } else {
                        stringBuffer.append(easService.getDatabase().getDBSpecific().getFullTableName("EAS", "OBJECT_PARTITIONS") + " T " + "where T.TYPE_ID=" + n + " and T.OBJECT_ID=" + string);
                    }
                    stringBuffer.append(" and P.PARTITION_ID = T.PARTITION_ID");
                    resultSet = statement.executeQuery(stringBuffer.toString());
                    while (resultSet.next()) {
                        if (easPartitionList == null) {
                            easPartitionList = new EasPartitionList("partitionList");
                        }
                        easPartitionList.addPartition(new EasPartition(resultSet.getString(1), resultSet.getInt(2)));
                    }
                    Object var12_13 = null;
                    if (resultSet == null) break block27;
                    try {
                        resultSet.close();
                    }
                    catch (SQLException sQLException2222) {
                        sQLException2222.printStackTrace();
                    }
                }
                if (statement != null) {
                    try {
                        statement.close();
                    }
                    catch (SQLException sQLException2222) {
                        sQLException2222.printStackTrace();
                    }
                }
                if (connection != null) {
                    easService.getDatabase().freeConnection(connection);
                }
                break block31;
                {
                    catch (Exception exception) {
                        SQLException sQLException32222;
                        BEasService.log.error("Encountered problem loading object partition list for " + n + ", " + string, (Throwable)exception);
                        Object var12_14 = null;
                        if (resultSet != null) {
                            try {
                                resultSet.close();
                            }
                            catch (SQLException sQLException32222) {
                                sQLException32222.printStackTrace();
                            }
                        }
                        if (statement != null) {
                            try {
                                statement.close();
                            }
                            catch (SQLException sQLException32222) {
                                sQLException32222.printStackTrace();
                            }
                        }
                        if (connection != null) {
                            easService.getDatabase().freeConnection(connection);
                        }
                    }
                }
                catch (Throwable throwable) {
                    SQLException sQLException42222;
                    Object var12_15 = null;
                    if (resultSet != null) {
                        try {
                            resultSet.close();
                        }
                        catch (SQLException sQLException42222) {
                            sQLException42222.printStackTrace();
                        }
                    }
                    if (statement != null) {
                        try {
                            statement.close();
                        }
                        catch (SQLException sQLException42222) {
                            sQLException42222.printStackTrace();
                        }
                    }
                    if (connection != null) {
                        easService.getDatabase().freeConnection(connection);
                    }
                    throw throwable;
                }
            }
        }
        int n2 = 0;
        if (easPartitionList != null) {
            n2 = 1;
        }
        dataOutputStream.writeInt(n2);
        if (easPartitionList != null) {
            XmlEncoder xmlEncoder = new XmlEncoder(dataOutputStream);
            xmlEncoder.encodeDocument(easPartitionList);
        }
        dataOutputStream.flush();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private void deletePartition(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, int n) throws Exception {
        block15: {
            Statement statement;
            Connection connection;
            block13: {
                httpServletResponse.setStatus(100);
                httpServletResponse.getOutputStream();
                connection = null;
                statement = null;
                connection = easService.getDatabase().getConnection();
                statement = connection.createStatement();
                String string = "delete from " + easService.getDatabase().getDBSpecific().getFullTableName("EAS", "PARTITIONS") + " where PARTITION_ID=" + n;
                statement.executeUpdate(string);
                string = "delete from " + easService.getDatabase().getDBSpecific().getFullTableName("EAS", "USER_PARTITIONS") + " where PARTITION_ID=" + n;
                statement.executeUpdate(string);
                string = "delete from " + easService.getDatabase().getDBSpecific().getFullTableName("EAS", "OBJECT_PARTITIONS") + " where PARTITION_ID=" + n;
                statement.executeUpdate(string);
                string = "delete from " + easService.getDatabase().getDBSpecific().getFullTableName("EAS", "RATE_PARTITIONS") + " where PARTITION_ID=" + n;
                statement.executeUpdate(string);
                Object var8_8 = null;
                if (statement == null) break block13;
                try {
                    statement.close();
                }
                catch (SQLException sQLException) {
                    sQLException.printStackTrace();
                }
            }
            if (connection != null) {
                easService.getDatabase().freeConnection(connection);
            }
            break block15;
            {
                catch (Exception exception) {
                    BEasService.log.error("Encountered problem deleting partition with id " + n, (Throwable)exception);
                    Object var8_9 = null;
                    if (statement != null) {
                        try {
                            statement.close();
                        }
                        catch (SQLException sQLException) {
                            sQLException.printStackTrace();
                        }
                    }
                    if (connection != null) {
                        easService.getDatabase().freeConnection(connection);
                    }
                }
            }
            catch (Throwable throwable) {
                Object var8_10 = null;
                if (statement != null) {
                    try {
                        statement.close();
                    }
                    catch (SQLException sQLException) {
                        sQLException.printStackTrace();
                    }
                }
                if (connection != null) {
                    easService.getDatabase().freeConnection(connection);
                }
                throw throwable;
            }
        }
        httpServletResponse.setStatus(201);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private void saveUserPartitions(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, String string) throws Exception {
        block27: {
            httpServletResponse.setStatus(100);
            httpServletResponse.getOutputStream();
            Connection connection = null;
            Statement statement = null;
            ResultSet resultSet = null;
            if (string != null) {
                SQLException sQLException2222;
                block23: {
                    ServletInputStream servletInputStream = httpServletRequest.getInputStream();
                    XmlDecoder xmlDecoder = new XmlDecoder((InputStream)servletInputStream);
                    EasPartitionList easPartitionList = (EasPartitionList)xmlDecoder.decodeDocument(false);
                    connection = easService.getDatabase().getConnection();
                    statement = connection.createStatement();
                    String string2 = "delete from " + easService.getDatabase().getDBSpecific().getFullTableName("EAS", "USER_PARTITIONS") + " where USERNAME=" + Dbx.str2db(string);
                    statement.executeUpdate(string2);
                    EasPartition[] easPartitionArray = easPartitionList.getPartitions();
                    if (easPartitionArray != null) {
                        for (int i = 0; i < easPartitionArray.length; ++i) {
                            int n = easPartitionArray[i].getId();
                            string2 = "insert into " + easService.getDatabase().getDBSpecific().getFullTableName("EAS", "USER_PARTITIONS") + " (PARTITION_ID,USERNAME) values (" + n + "," + Dbx.str2db(string) + ")";
                            statement.executeUpdate(string2);
                        }
                    }
                    Object var15_15 = null;
                    if (resultSet == null) break block23;
                    try {
                        resultSet.close();
                    }
                    catch (SQLException sQLException2222) {
                        sQLException2222.printStackTrace();
                    }
                }
                if (statement != null) {
                    try {
                        statement.close();
                    }
                    catch (SQLException sQLException2222) {
                        sQLException2222.printStackTrace();
                    }
                }
                if (connection != null) {
                    easService.getDatabase().freeConnection(connection);
                }
                break block27;
                {
                    catch (Exception exception) {
                        SQLException sQLException32222;
                        BEasService.log.error("Encountered problem saving user partition list for " + string, (Throwable)exception);
                        Object var15_16 = null;
                        if (resultSet != null) {
                            try {
                                resultSet.close();
                            }
                            catch (SQLException sQLException32222) {
                                sQLException32222.printStackTrace();
                            }
                        }
                        if (statement != null) {
                            try {
                                statement.close();
                            }
                            catch (SQLException sQLException32222) {
                                sQLException32222.printStackTrace();
                            }
                        }
                        if (connection != null) {
                            easService.getDatabase().freeConnection(connection);
                        }
                    }
                }
                catch (Throwable throwable) {
                    SQLException sQLException42222;
                    Object var15_17 = null;
                    if (resultSet != null) {
                        try {
                            resultSet.close();
                        }
                        catch (SQLException sQLException42222) {
                            sQLException42222.printStackTrace();
                        }
                    }
                    if (statement != null) {
                        try {
                            statement.close();
                        }
                        catch (SQLException sQLException42222) {
                            sQLException42222.printStackTrace();
                        }
                    }
                    if (connection != null) {
                        easService.getDatabase().freeConnection(connection);
                    }
                    throw throwable;
                }
            }
        }
        httpServletResponse.setStatus(201);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private void saveObjectPartitions(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, int n, String string) throws Exception {
        block27: {
            httpServletResponse.setStatus(100);
            httpServletResponse.getOutputStream();
            Connection connection = null;
            Statement statement = null;
            ResultSet resultSet = null;
            if (string != null) {
                SQLException sQLException2222;
                block23: {
                    ServletInputStream servletInputStream = httpServletRequest.getInputStream();
                    XmlDecoder xmlDecoder = new XmlDecoder((InputStream)servletInputStream);
                    EasPartitionList easPartitionList = (EasPartitionList)xmlDecoder.decodeDocument(false);
                    connection = easService.getDatabase().getConnection();
                    statement = connection.createStatement();
                    String string2 = null;
                    string2 = n == 4 ? "delete from " + easService.getDatabase().getDBSpecific().getFullTableName("EAS", "RATE_PARTITIONS") + " where RATE_ID=" + Dbx.str2db(string) : "delete from " + easService.getDatabase().getDBSpecific().getFullTableName("EAS", "OBJECT_PARTITIONS") + " where TYPE_ID=" + n + " and OBJECT_ID=" + string;
                    statement.executeUpdate(string2);
                    EasPartition[] easPartitionArray = easPartitionList.getPartitions();
                    if (easPartitionArray != null) {
                        for (int i = 0; i < easPartitionArray.length; ++i) {
                            int n2 = easPartitionArray[i].getId();
                            string2 = null;
                            string2 = n == 4 ? "insert into " + easService.getDatabase().getDBSpecific().getFullTableName("EAS", "RATE_PARTITIONS") + " (PARTITION_ID,RATE_ID) values (" + n2 + "," + Dbx.str2db(string) + ")" : "insert into " + easService.getDatabase().getDBSpecific().getFullTableName("EAS", "OBJECT_PARTITIONS") + " (PARTITION_ID,TYPE_ID,OBJECT_ID) values (" + n2 + "," + n + "," + string + ")";
                            statement.executeUpdate(string2);
                        }
                    }
                    Object var16_16 = null;
                    if (resultSet == null) break block23;
                    try {
                        resultSet.close();
                    }
                    catch (SQLException sQLException2222) {
                        sQLException2222.printStackTrace();
                    }
                }
                if (statement != null) {
                    try {
                        statement.close();
                    }
                    catch (SQLException sQLException2222) {
                        sQLException2222.printStackTrace();
                    }
                }
                if (connection != null) {
                    easService.getDatabase().freeConnection(connection);
                }
                break block27;
                {
                    catch (Exception exception) {
                        SQLException sQLException32222;
                        BEasService.log.error("Encountered problem saving object partition list for " + n + ", " + string, (Throwable)exception);
                        Object var16_17 = null;
                        if (resultSet != null) {
                            try {
                                resultSet.close();
                            }
                            catch (SQLException sQLException32222) {
                                sQLException32222.printStackTrace();
                            }
                        }
                        if (statement != null) {
                            try {
                                statement.close();
                            }
                            catch (SQLException sQLException32222) {
                                sQLException32222.printStackTrace();
                            }
                        }
                        if (connection != null) {
                            easService.getDatabase().freeConnection(connection);
                        }
                    }
                }
                catch (Throwable throwable) {
                    SQLException sQLException42222;
                    Object var16_18 = null;
                    if (resultSet != null) {
                        try {
                            resultSet.close();
                        }
                        catch (SQLException sQLException42222) {
                            sQLException42222.printStackTrace();
                        }
                    }
                    if (statement != null) {
                        try {
                            statement.close();
                        }
                        catch (SQLException sQLException42222) {
                            sQLException42222.printStackTrace();
                        }
                    }
                    if (connection != null) {
                        easService.getDatabase().freeConnection(connection);
                    }
                    throw throwable;
                }
            }
        }
        httpServletResponse.setStatus(201);
    }

    private void getUserList(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws IOException {
        DataOutputStream dataOutputStream = new DataOutputStream((OutputStream)httpServletResponse.getOutputStream());
        String[] stringArray = null;
        try {
            BUserService bUserService = BUserService.getService();
            bUserService.lease();
            BUser[] bUserArray = (BUser[])bUserService.getChildren(class$javax$baja$user$BUser == null ? (class$javax$baja$user$BUser = EasPartitionHandler.class$("javax.baja.user.BUser")) : class$javax$baja$user$BUser);
            if (bUserArray != null) {
                stringArray = new String[bUserArray.length];
                for (int i = 0; i < bUserArray.length; ++i) {
                    stringArray[i] = bUserArray[i].getUsername();
                }
            }
        }
        catch (Exception exception) {
            BEasService.log.error("Could not load user names.", (Throwable)exception);
        }
        int n = 0;
        if (stringArray != null) {
            n = stringArray.length;
        }
        dataOutputStream.writeInt(n);
        if (stringArray != null) {
            for (int i = 0; i < n; ++i) {
                dataOutputStream.writeUTF(stringArray[i]);
            }
        }
        dataOutputStream.flush();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private void getUsersForPartition(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, int n) throws Exception {
        Vector<String> vector;
        DataOutputStream dataOutputStream;
        block29: {
            SQLException sQLException2222;
            Object var11_12;
            ResultSet resultSet;
            Statement statement;
            Connection connection;
            block25: {
                httpServletResponse.setStatus(200);
                dataOutputStream = new DataOutputStream((OutputStream)httpServletResponse.getOutputStream());
                vector = null;
                connection = null;
                statement = null;
                resultSet = null;
                connection = easService.getDatabase().getConnection();
                statement = connection.createStatement();
                String string = "select USERNAME from " + easService.getDatabase().getDBSpecific().getFullTableName("EAS", "USER_PARTITIONS") + " where PARTITION_ID=" + n;
                resultSet = statement.executeQuery(string);
                while (resultSet.next()) {
                    if (vector == null) {
                        vector = new Vector<String>();
                    }
                    vector.addElement(resultSet.getString(1));
                }
                var11_12 = null;
                if (resultSet == null) break block25;
                try {
                    resultSet.close();
                }
                catch (SQLException sQLException2222) {
                    sQLException2222.printStackTrace();
                }
            }
            if (statement != null) {
                try {
                    statement.close();
                }
                catch (SQLException sQLException2222) {
                    sQLException2222.printStackTrace();
                }
            }
            if (connection != null) {
                easService.getDatabase().freeConnection(connection);
            }
            break block29;
            {
                catch (Exception exception) {
                    BEasService.log.error("Encountered problem loading users for partition.", (Throwable)exception);
                    var11_12 = null;
                    if (resultSet != null) {
                        try {
                            resultSet.close();
                        }
                        catch (SQLException sQLException2222) {
                            sQLException2222.printStackTrace();
                        }
                    }
                    if (statement != null) {
                        try {
                            statement.close();
                        }
                        catch (SQLException sQLException2222) {
                            sQLException2222.printStackTrace();
                        }
                    }
                    if (connection != null) {
                        easService.getDatabase().freeConnection(connection);
                    }
                }
            }
            catch (Throwable throwable) {
                SQLException sQLException32222;
                Object var11_13 = null;
                if (resultSet != null) {
                    try {
                        resultSet.close();
                    }
                    catch (SQLException sQLException32222) {
                        sQLException32222.printStackTrace();
                    }
                }
                if (statement != null) {
                    try {
                        statement.close();
                    }
                    catch (SQLException sQLException32222) {
                        sQLException32222.printStackTrace();
                    }
                }
                if (connection != null) {
                    easService.getDatabase().freeConnection(connection);
                }
                throw throwable;
            }
        }
        int n2 = 0;
        if (vector != null) {
            n2 = vector.size();
        }
        dataOutputStream.writeInt(n2);
        if (vector != null) {
            for (int i = 0; i < n2; ++i) {
                dataOutputStream.writeUTF((String)vector.elementAt(i));
            }
        }
        dataOutputStream.flush();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private void saveUsersForPartition(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, int n) throws Exception {
        block28: {
            SQLException sQLException2222;
            ResultSet resultSet;
            Statement statement;
            Connection connection;
            block24: {
                httpServletResponse.setStatus(100);
                httpServletResponse.getOutputStream();
                connection = null;
                statement = null;
                resultSet = null;
                ServletInputStream servletInputStream = httpServletRequest.getInputStream();
                XmlDecoder xmlDecoder = new XmlDecoder((InputStream)servletInputStream);
                XmlMessage xmlMessage = (XmlMessage)xmlDecoder.decodeDocument(false);
                int n2 = xmlMessage.getInt("count", 0);
                String[] stringArray = null;
                if (n2 > 0) {
                    stringArray = new String[n2];
                    for (int i = 0; i < n2; ++i) {
                        stringArray[i] = xmlMessage.getString("user" + i);
                    }
                }
                connection = easService.getDatabase().getConnection();
                statement = connection.createStatement();
                String string = "delete from " + easService.getDatabase().getDBSpecific().getFullTableName("EAS", "USER_PARTITIONS") + " where PARTITION_ID=" + n;
                statement.executeUpdate(string);
                if (stringArray != null) {
                    for (int i = 0; i < n2; ++i) {
                        string = "insert into " + easService.getDatabase().getDBSpecific().getFullTableName("EAS", "USER_PARTITIONS") + " (PARTITION_ID,USERNAME) values (" + n + "," + Dbx.str2db(stringArray[i]) + ")";
                        statement.executeUpdate(string);
                    }
                }
                Object var15_16 = null;
                if (resultSet == null) break block24;
                try {
                    resultSet.close();
                }
                catch (SQLException sQLException2222) {
                    sQLException2222.printStackTrace();
                }
            }
            if (statement != null) {
                try {
                    statement.close();
                }
                catch (SQLException sQLException2222) {
                    sQLException2222.printStackTrace();
                }
            }
            if (connection != null) {
                easService.getDatabase().freeConnection(connection);
            }
            break block28;
            {
                catch (Exception exception) {
                    SQLException sQLException32222;
                    BEasService.log.error("Encountered problem saving users for partition.", (Throwable)exception);
                    Object var15_17 = null;
                    if (resultSet != null) {
                        try {
                            resultSet.close();
                        }
                        catch (SQLException sQLException32222) {
                            sQLException32222.printStackTrace();
                        }
                    }
                    if (statement != null) {
                        try {
                            statement.close();
                        }
                        catch (SQLException sQLException32222) {
                            sQLException32222.printStackTrace();
                        }
                    }
                    if (connection != null) {
                        easService.getDatabase().freeConnection(connection);
                    }
                }
            }
            catch (Throwable throwable) {
                SQLException sQLException42222;
                Object var15_18 = null;
                if (resultSet != null) {
                    try {
                        resultSet.close();
                    }
                    catch (SQLException sQLException42222) {
                        sQLException42222.printStackTrace();
                    }
                }
                if (statement != null) {
                    try {
                        statement.close();
                    }
                    catch (SQLException sQLException42222) {
                        sQLException42222.printStackTrace();
                    }
                }
                if (connection != null) {
                    easService.getDatabase().freeConnection(connection);
                }
                throw throwable;
            }
        }
        httpServletResponse.setStatus(201);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private void getObjectsForPartition(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, int n, int n2) throws Exception {
        Object object;
        int n3;
        XmlMessage xmlMessage;
        DataOutputStream dataOutputStream;
        block29: {
            SQLException sQLException2222;
            ResultSet resultSet;
            Statement statement;
            Connection connection;
            block25: {
                httpServletResponse.setStatus(200);
                dataOutputStream = new DataOutputStream((OutputStream)httpServletResponse.getOutputStream());
                xmlMessage = new XmlMessage("protectedObjects");
                n3 = 0;
                connection = null;
                statement = null;
                resultSet = null;
                connection = easService.getDatabase().getConnection();
                statement = connection.createStatement();
                if (n2 == 4) {
                    object = "select RATE_ID from " + easService.getDatabase().getDBSpecific().getFullTableName("EAS", "RATE_PARTITIONS") + " where PARTITION_ID=" + n;
                    resultSet = statement.executeQuery((String)object);
                    while (resultSet.next()) {
                        xmlMessage.add("objType" + n3, n2);
                        xmlMessage.add("objId" + n3, resultSet.getString(1));
                        ++n3;
                    }
                } else {
                    object = "select OBJECT_ID from " + easService.getDatabase().getDBSpecific().getFullTableName("EAS", "OBJECT_PARTITIONS") + " where PARTITION_ID=" + n + " and TYPE_ID=" + n2;
                    resultSet = statement.executeQuery((String)object);
                    while (resultSet.next()) {
                        xmlMessage.add("objType" + n3, n2);
                        xmlMessage.add("objId" + n3, resultSet.getInt(1));
                        ++n3;
                    }
                }
                Object var13_13 = null;
                if (resultSet == null) break block25;
                try {
                    resultSet.close();
                }
                catch (SQLException sQLException2222) {
                    sQLException2222.printStackTrace();
                }
            }
            if (statement != null) {
                try {
                    statement.close();
                }
                catch (SQLException sQLException2222) {
                    sQLException2222.printStackTrace();
                }
            }
            if (connection != null) {
                easService.getDatabase().freeConnection(connection);
            }
            break block29;
            {
                catch (Exception exception) {
                    SQLException sQLException32222;
                    BEasService.log.error("Encountered problem loading users for partition.", (Throwable)exception);
                    Object var13_14 = null;
                    if (resultSet != null) {
                        try {
                            resultSet.close();
                        }
                        catch (SQLException sQLException32222) {
                            sQLException32222.printStackTrace();
                        }
                    }
                    if (statement != null) {
                        try {
                            statement.close();
                        }
                        catch (SQLException sQLException32222) {
                            sQLException32222.printStackTrace();
                        }
                    }
                    if (connection != null) {
                        easService.getDatabase().freeConnection(connection);
                    }
                }
            }
            catch (Throwable throwable) {
                SQLException sQLException42222;
                Object var13_15 = null;
                if (resultSet != null) {
                    try {
                        resultSet.close();
                    }
                    catch (SQLException sQLException42222) {
                        sQLException42222.printStackTrace();
                    }
                }
                if (statement != null) {
                    try {
                        statement.close();
                    }
                    catch (SQLException sQLException42222) {
                        sQLException42222.printStackTrace();
                    }
                }
                if (connection != null) {
                    easService.getDatabase().freeConnection(connection);
                }
                throw throwable;
            }
        }
        dataOutputStream.writeInt(n3);
        if (n3 > 0) {
            object = new XmlEncoder(dataOutputStream);
            ((XmlEncoder)((Object)object)).encodeDocument(xmlMessage);
        }
        dataOutputStream.flush();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private void saveObjectsForPartition(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, int n, int n2) throws Exception {
        block31: {
            SQLException sQLException2222;
            ResultSet resultSet;
            Statement statement;
            Connection connection;
            block27: {
                String string;
                httpServletResponse.setStatus(100);
                httpServletResponse.getOutputStream();
                connection = null;
                statement = null;
                resultSet = null;
                connection = easService.getDatabase().getConnection();
                statement = connection.createStatement();
                ServletInputStream servletInputStream = httpServletRequest.getInputStream();
                XmlDecoder xmlDecoder = new XmlDecoder((InputStream)servletInputStream);
                XmlMessage xmlMessage = (XmlMessage)xmlDecoder.decodeDocument(false);
                int n3 = xmlMessage.getInt("count", 0);
                if (n2 == 4) {
                    string = "delete from " + easService.getDatabase().getDBSpecific().getFullTableName("EAS", "RATE_PARTITIONS") + " where PARTITION_ID=" + n;
                    statement.executeUpdate(string);
                } else if (n2 == 0 || n2 == 1 || n2 == 2) {
                    string = "delete from " + easService.getDatabase().getDBSpecific().getFullTableName("EAS", "OBJECT_PARTITIONS") + " where (PARTITION_ID=" + n + ") and (TYPE_ID=" + 0 + " or TYPE_ID=" + 1 + " or TYPE_ID=" + 2 + ")";
                    statement.executeUpdate(string);
                } else {
                    string = "delete from " + easService.getDatabase().getDBSpecific().getFullTableName("EAS", "OBJECT_PARTITIONS") + " where PARTITION_ID=" + n + " and TYPE_ID=" + n2;
                    statement.executeUpdate(string);
                }
                if (n3 > 0) {
                    for (int i = 0; i < n3; ++i) {
                        String string2;
                        int n4 = xmlMessage.getInt("objType" + i);
                        String string3 = xmlMessage.getString("objId" + i);
                        if (n4 == 4) {
                            string2 = "insert into " + easService.getDatabase().getDBSpecific().getFullTableName("EAS", "RATE_PARTITIONS") + " (PARTITION_ID,RATE_ID) values (" + n + "," + Dbx.str2db(string3) + ")";
                            statement.executeUpdate(string2);
                            continue;
                        }
                        string2 = "insert into " + easService.getDatabase().getDBSpecific().getFullTableName("EAS", "OBJECT_PARTITIONS") + " (PARTITION_ID,TYPE_ID,OBJECT_ID) values (" + n + "," + n4 + "," + string3 + ")";
                        statement.executeUpdate(string2);
                    }
                }
                Object var17_18 = null;
                if (resultSet == null) break block27;
                try {
                    resultSet.close();
                }
                catch (SQLException sQLException2222) {
                    sQLException2222.printStackTrace();
                }
            }
            if (statement != null) {
                try {
                    statement.close();
                }
                catch (SQLException sQLException2222) {
                    sQLException2222.printStackTrace();
                }
            }
            if (connection != null) {
                easService.getDatabase().freeConnection(connection);
            }
            break block31;
            {
                catch (Exception exception) {
                    SQLException sQLException32222;
                    BEasService.log.error("Encountered problem saving objects for partition.", (Throwable)exception);
                    Object var17_19 = null;
                    if (resultSet != null) {
                        try {
                            resultSet.close();
                        }
                        catch (SQLException sQLException32222) {
                            sQLException32222.printStackTrace();
                        }
                    }
                    if (statement != null) {
                        try {
                            statement.close();
                        }
                        catch (SQLException sQLException32222) {
                            sQLException32222.printStackTrace();
                        }
                    }
                    if (connection != null) {
                        easService.getDatabase().freeConnection(connection);
                    }
                }
            }
            catch (Throwable throwable) {
                SQLException sQLException42222;
                Object var17_20 = null;
                if (resultSet != null) {
                    try {
                        resultSet.close();
                    }
                    catch (SQLException sQLException42222) {
                        sQLException42222.printStackTrace();
                    }
                }
                if (statement != null) {
                    try {
                        statement.close();
                    }
                    catch (SQLException sQLException42222) {
                        sQLException42222.printStackTrace();
                    }
                }
                if (connection != null) {
                    easService.getDatabase().freeConnection(connection);
                }
                throw throwable;
            }
        }
        httpServletResponse.setStatus(201);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

