/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.eas.web;

import com.tridium.eas.BEasService;
import com.tridium.eas.api.DataPoint;
import com.tridium.eas.api.EasSession;
import com.tridium.eas.api.Meter;
import com.tridium.eas.cost.RateLoader;
import com.tridium.eas.cost.datatypes.RateBillingPeriod;
import com.tridium.eas.cost.rate.Rate;
import com.tridium.eas.cost.rate.RateHistory;
import com.tridium.eas.cost.rate.components.RateComponent;
import com.tridium.eas.cost.report.AnalyzerReport;
import com.tridium.eas.cost.report.Budget;
import com.tridium.eas.cost.report.ReconciliationNote;
import com.tridium.eas.cost.report.ReconciliationNotes;
import com.tridium.eas.cost.report.ReconciliationReport;
import com.tridium.eas.cost.report.ReconciliationRow;
import com.tridium.eas.util.DBSpecific;
import com.tridium.eas.util.Dbx;
import com.tridium.eas.web.EasServlet;
import com.tridium.eas.xml.XmlDecoder;
import com.tridium.eas.xml.XmlEncoder;
import com.tridium.eas.xml.XmlSupport;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.baja.security.BIProtected;
import javax.baja.security.BPermissions;
import javax.baja.sys.Sys;
import javax.baja.units.BUnit;
import javax.baja.user.BUser;
import javax.baja.util.Lexicon;
import javax.baja.web.WebOp;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpUtils;

public class EasCostHandler
implements RateLoader {
    private EasServlet easServlet;
    private static BEasService easService;
    private EasSession easSession;
    public static final String RATE_HISTORY_PREFIX = "meter";

    public Rate loadRateByName(String string) throws Exception {
        return EasCostHandler.loadRate(string);
    }

    public RateHistory loadRateHistoryById(int n) throws Exception {
        return EasCostHandler.loadRateHistory(n);
    }

    public void setEasServlet(EasServlet easServlet) {
        this.easServlet = easServlet;
    }

    public void setEasService(BEasService bEasService) {
        easService = bEasService;
    }

    public void setEasSession(EasSession easSession) {
        this.easSession = easSession;
    }

    public void doGet(WebOp webOp, Lexicon lexicon) throws Exception {
        HttpServletRequest httpServletRequest = webOp.getRequest();
        HttpServletResponse httpServletResponse = webOp.getResponse();
        BUser bUser = this.easServlet.getUser(httpServletRequest);
        if (bUser == null) {
            httpServletResponse.sendError(403);
            return;
        }
        BPermissions bPermissions = bUser.getPermissionsFor((BIProtected)easService);
        String string = EasServlet.getRequestURINoPrefix(httpServletRequest);
        if ((string = string.substring(4, string.length())).equalsIgnoreCase("/cost/ratelist")) {
            this.getRateNames(httpServletRequest, httpServletResponse);
        } else if (string.equalsIgnoreCase("/cost/costMeterList")) {
            String string2 = httpServletRequest.getQueryString();
            Hashtable hashtable = null;
            String string3 = null;
            if (string2 != null) {
                hashtable = HttpUtils.parseQueryString((String)string2);
                string3 = XmlDecoder.decodeUrl(EasServlet.getPostField("rateName", hashtable));
            }
            this.getCostMeterNames(httpServletRequest, httpServletResponse, string3);
        } else if (string.equalsIgnoreCase("/cost/rateHistory")) {
            String string4 = httpServletRequest.getQueryString();
            Hashtable hashtable = null;
            int n = -1;
            if (string4 != null) {
                hashtable = HttpUtils.parseQueryString((String)string4);
                n = Integer.valueOf(EasServlet.getPostField("meterId", hashtable));
            }
            this.getRateHistoryById(httpServletRequest, httpServletResponse, n);
        } else if (string.equalsIgnoreCase("/cost/rate")) {
            String string5 = httpServletRequest.getQueryString();
            Hashtable hashtable = null;
            String string6 = null;
            if (string5 != null) {
                hashtable = HttpUtils.parseQueryString((String)string5);
                string6 = XmlDecoder.decodeUrl(EasServlet.getPostField("name", hashtable));
            }
            this.getRateByName(httpServletRequest, httpServletResponse, string6);
        } else if (string.equalsIgnoreCase("/cost/reconciliationList")) {
            String string7 = httpServletRequest.getQueryString();
            Hashtable hashtable = null;
            String string8 = null;
            if (string7 != null) {
                hashtable = HttpUtils.parseQueryString((String)string7);
                string8 = XmlDecoder.decodeUrl(EasServlet.getPostField("directory", hashtable));
            }
            this.getReconciliationNames(httpServletRequest, httpServletResponse, string8);
        } else if (string.equalsIgnoreCase("/cost/reconciliation")) {
            String string9 = httpServletRequest.getQueryString();
            Hashtable hashtable = null;
            String string10 = null;
            String string11 = null;
            String string12 = null;
            boolean bl = false;
            boolean bl2 = true;
            String string13 = null;
            boolean bl3 = false;
            boolean bl4 = false;
            BUnit bUnit = null;
            double d = 65.0;
            boolean bl5 = false;
            int n = 4;
            double d2 = 100.0;
            boolean bl6 = false;
            DataPoint dataPoint = null;
            if (string9 != null) {
                hashtable = HttpUtils.parseQueryString((String)string9);
                string10 = XmlDecoder.decodeUrl(EasServlet.getPostField("directory", hashtable));
                string11 = XmlDecoder.decodeUrl(EasServlet.getPostField("name", hashtable));
                string12 = XmlDecoder.decodeUrl(EasServlet.getPostField("billPeriod", hashtable));
                bl = Boolean.valueOf(EasServlet.getPostField("run", hashtable));
                bl2 = Boolean.valueOf(EasServlet.getPostField("allowFuture", hashtable));
                string13 = XmlDecoder.decodeUrl(EasServlet.getPostField(RATE_HISTORY_PREFIX, hashtable));
                bl3 = Boolean.valueOf(EasServlet.getPostField("floorNorm", hashtable));
                bl4 = Boolean.valueOf(EasServlet.getPostField("weatherNorm", hashtable));
                bUnit = BUnit.getUnit((String)XmlDecoder.decodeUrl(EasServlet.getPostField("normUnits", hashtable)));
                d = Double.valueOf(EasServlet.getPostField("normTemp", hashtable));
                bl5 = Boolean.valueOf(EasServlet.getPostField("dataCleanse", hashtable));
                n = Integer.valueOf(EasServlet.getPostField("dataCleanseWindow", hashtable));
                d2 = Double.valueOf(EasServlet.getPostField("dataCleansePercentage", hashtable));
                bl6 = Boolean.valueOf(EasServlet.getPostField("dpNormalization", hashtable));
                dataPoint = DataPoint.get(Integer.valueOf(EasServlet.getPostField("normalizer", hashtable)), this.easSession);
            }
            this.getReconciliation(httpServletRequest, httpServletResponse, string10, string11, string12, bl, bl2, string13, bl3, bl4, bUnit, d, bl5, n, d2, bl6, dataPoint);
        } else if (string.equalsIgnoreCase("/cost/analyzerReport")) {
            String string14 = httpServletRequest.getQueryString();
            Hashtable hashtable = null;
            String string15 = null;
            String string16 = null;
            if (string14 != null) {
                hashtable = HttpUtils.parseQueryString((String)string14);
                string15 = XmlDecoder.decodeUrl(EasServlet.getPostField("userName", hashtable));
                string16 = XmlDecoder.decodeUrl(EasServlet.getPostField("reportName", hashtable));
            }
            this.getAnalyzerReportByName(httpServletRequest, httpServletResponse, string15, string16);
        } else if (string.equalsIgnoreCase("/cost/budget")) {
            String string17 = httpServletRequest.getQueryString();
            Hashtable hashtable = null;
            int n = -1;
            String string18 = null;
            if (string17 != null) {
                hashtable = HttpUtils.parseQueryString((String)string17);
                n = Integer.valueOf(EasServlet.getPostField("meterId", hashtable));
                string18 = XmlDecoder.decodeUrl(EasServlet.getPostField("billCycle", hashtable));
            }
            this.getBudget(httpServletRequest, httpServletResponse, n, string18);
        }
    }

    public void doPost(WebOp webOp, Lexicon lexicon) throws Exception {
        HttpServletRequest httpServletRequest = webOp.getRequest();
        HttpServletResponse httpServletResponse = webOp.getResponse();
        BUser bUser = this.easServlet.getUser(httpServletRequest);
        if (bUser == null) {
            httpServletResponse.sendError(403);
            return;
        }
        BPermissions bPermissions = bUser.getPermissionsFor((BIProtected)easService);
        String string = EasServlet.getRequestURINoPrefix(httpServletRequest);
        if ((string = string.substring(4, string.length())).equalsIgnoreCase("/cost/saveRateHistory")) {
            if (!bPermissions.hasAdminWrite()) {
                httpServletResponse.sendError(403);
                return;
            }
            String string2 = httpServletRequest.getQueryString();
            Hashtable hashtable = null;
            int n = -1;
            if (string2 != null) {
                hashtable = HttpUtils.parseQueryString((String)string2);
                n = Integer.valueOf(EasServlet.getPostField("meterId", hashtable));
            }
            this.setRateHistory(httpServletRequest, httpServletResponse, n);
        } else if (string.equalsIgnoreCase("/cost/saveRate")) {
            if (!bPermissions.hasAdminWrite()) {
                httpServletResponse.sendError(403);
                return;
            }
            this.setRate(httpServletRequest, httpServletResponse);
        } else if (string.equalsIgnoreCase("/cost/renameRate")) {
            if (!bPermissions.hasAdminWrite()) {
                httpServletResponse.sendError(403);
                return;
            }
            String string3 = httpServletRequest.getQueryString();
            Hashtable hashtable = null;
            String string4 = null;
            String string5 = null;
            if (string3 != null) {
                hashtable = HttpUtils.parseQueryString((String)string3);
                string4 = XmlDecoder.decodeUrl(EasServlet.getPostField("oldName", hashtable));
                string5 = XmlDecoder.decodeUrl(EasServlet.getPostField("newName", hashtable));
            }
            this.setRateName(httpServletRequest, httpServletResponse, string4, string5);
        } else if (string.equalsIgnoreCase("/cost/deleteRate")) {
            if (!bPermissions.hasAdminWrite()) {
                httpServletResponse.sendError(403);
                return;
            }
            String string6 = httpServletRequest.getQueryString();
            Hashtable hashtable = null;
            String string7 = null;
            if (string6 != null) {
                hashtable = HttpUtils.parseQueryString((String)string6);
                string7 = XmlDecoder.decodeUrl(EasServlet.getPostField("rateName", hashtable));
            }
            this.removeRate(httpServletRequest, httpServletResponse, string7);
        } else if (string.equalsIgnoreCase("/cost/saveReconciliation")) {
            String string8 = httpServletRequest.getQueryString();
            Hashtable hashtable = null;
            int n = -1;
            String string9 = null;
            if (string8 != null) {
                hashtable = HttpUtils.parseQueryString((String)string8);
                n = Integer.valueOf(EasServlet.getPostField("meterId", hashtable));
                string9 = XmlDecoder.decodeUrl(EasServlet.getPostField("billCycle", hashtable));
            }
            this.setReconciliationReport(httpServletRequest, httpServletResponse, n, string9);
        } else if (string.equalsIgnoreCase("/cost/deleteReconciliation")) {
            if (!bPermissions.hasAdminWrite()) {
                httpServletResponse.sendError(403);
                return;
            }
            String string10 = httpServletRequest.getQueryString();
            Hashtable hashtable = null;
            int n = -1;
            String string11 = null;
            if (string10 != null) {
                hashtable = HttpUtils.parseQueryString((String)string10);
                n = Integer.valueOf(EasServlet.getPostField("meterId", hashtable));
                string11 = XmlDecoder.decodeUrl(EasServlet.getPostField("billCycle", hashtable));
            }
            this.removeReconciliationReport(httpServletRequest, httpServletResponse, n, string11);
        } else if (string.equalsIgnoreCase("/cost/runReconciliation")) {
            String string12 = httpServletRequest.getQueryString();
            Hashtable hashtable = null;
            String string13 = null;
            String string14 = null;
            boolean bl = false;
            boolean bl2 = false;
            BUnit bUnit = null;
            double d = 65.0;
            boolean bl3 = false;
            int n = 4;
            double d2 = 100.0;
            boolean bl4 = false;
            DataPoint dataPoint = null;
            if (string12 != null) {
                hashtable = HttpUtils.parseQueryString((String)string12);
                string13 = XmlDecoder.decodeUrl(EasServlet.getPostField(RATE_HISTORY_PREFIX, hashtable));
                string14 = XmlDecoder.decodeUrl(EasServlet.getPostField("billPeriod", hashtable));
                bl = Boolean.valueOf(EasServlet.getPostField("floorNorm", hashtable));
                bl2 = Boolean.valueOf(EasServlet.getPostField("weatherNorm", hashtable));
                bUnit = BUnit.getUnit((String)XmlDecoder.decodeUrl(EasServlet.getPostField("normUnits", hashtable)));
                d = Double.valueOf(EasServlet.getPostField("normTemp", hashtable));
                bl3 = Boolean.valueOf(EasServlet.getPostField("dataCleanse", hashtable));
                n = Integer.valueOf(EasServlet.getPostField("dataCleanseWindow", hashtable));
                d2 = Double.valueOf(EasServlet.getPostField("dataCleansePercentage", hashtable));
                bl4 = Boolean.valueOf(EasServlet.getPostField("dpNormalization", hashtable));
                dataPoint = DataPoint.get(Integer.valueOf(EasServlet.getPostField("normalizer", hashtable)), this.easSession);
            }
            this.runReconciliation(httpServletRequest, httpServletResponse, string13, string14, bl, bl2, bUnit, d, bl3, n, d2, bl4, dataPoint);
        } else if (string.equalsIgnoreCase("/cost/runAlternateReconciliation")) {
            String string15 = httpServletRequest.getQueryString();
            Hashtable hashtable = null;
            String[] stringArray = null;
            String string16 = null;
            boolean bl = true;
            boolean bl5 = false;
            boolean bl6 = false;
            BUnit bUnit = null;
            double d = 65.0;
            boolean bl7 = false;
            int n = 4;
            double d3 = 100.0;
            boolean bl8 = false;
            DataPoint dataPoint = null;
            if (string15 != null) {
                hashtable = HttpUtils.parseQueryString((String)string15);
                String string17 = XmlDecoder.decodeUrl(EasServlet.getPostField("meters", hashtable));
                StringTokenizer stringTokenizer = new StringTokenizer(string17, ";");
                int n2 = Integer.parseInt(stringTokenizer.nextToken());
                if (n2 > 0) {
                    stringArray = new String[n2];
                    for (int i = 0; i < n2; ++i) {
                        stringArray[i] = XmlEncoder.decodeXmlString(stringTokenizer.nextToken());
                    }
                }
                string16 = XmlDecoder.decodeUrl(EasServlet.getPostField("billPeriod", hashtable));
                bl = Boolean.valueOf(EasServlet.getPostField("aggregateTimestamps", hashtable));
                bl5 = Boolean.valueOf(EasServlet.getPostField("floorNorm", hashtable));
                bl6 = Boolean.valueOf(EasServlet.getPostField("weatherNorm", hashtable));
                bUnit = BUnit.getUnit((String)XmlDecoder.decodeUrl(EasServlet.getPostField("normUnits", hashtable)));
                d = Double.valueOf(EasServlet.getPostField("normTemp", hashtable));
                bl7 = Boolean.valueOf(EasServlet.getPostField("dataCleanse", hashtable));
                n = Integer.valueOf(EasServlet.getPostField("dataCleanseWindow", hashtable));
                d3 = Double.valueOf(EasServlet.getPostField("dataCleansePercentage", hashtable));
                bl8 = Boolean.valueOf(EasServlet.getPostField("dpNormalization", hashtable));
                dataPoint = DataPoint.get(Integer.valueOf(EasServlet.getPostField("normalizer", hashtable)), this.easSession);
            }
            this.runAlternateReconciliation(httpServletRequest, httpServletResponse, stringArray, string16, bl, bl5, bl6, bUnit, d, bl7, n, d3, bl8, dataPoint);
        } else if (string.equalsIgnoreCase("/cost/saveAnalyzerReport")) {
            String string18 = httpServletRequest.getQueryString();
            Hashtable hashtable = null;
            String string19 = null;
            if (string18 != null) {
                hashtable = HttpUtils.parseQueryString((String)string18);
                string19 = XmlDecoder.decodeUrl(EasServlet.getPostField("userName", hashtable));
            }
            this.setAnalyzerReport(httpServletRequest, httpServletResponse, string19);
        } else if (string.equalsIgnoreCase("/cost/saveBudget")) {
            if (!bPermissions.hasAdminWrite()) {
                httpServletResponse.sendError(403);
                return;
            }
            String string20 = httpServletRequest.getQueryString();
            Hashtable hashtable = null;
            int n = -1;
            if (string20 != null) {
                hashtable = HttpUtils.parseQueryString((String)string20);
                n = Integer.valueOf(EasServlet.getPostField("meterId", hashtable));
            }
            this.setBudget(httpServletRequest, httpServletResponse, n);
        } else if (string.equalsIgnoreCase("/cost/deleteBudget")) {
            if (!bPermissions.hasAdminWrite()) {
                httpServletResponse.sendError(403);
                return;
            }
            String string21 = httpServletRequest.getQueryString();
            Hashtable hashtable = null;
            int n = -1;
            String string22 = null;
            if (string21 != null) {
                hashtable = HttpUtils.parseQueryString((String)string21);
                n = Integer.valueOf(EasServlet.getPostField("meterId", hashtable));
                string22 = XmlDecoder.decodeUrl(EasServlet.getPostField("billCycle", hashtable));
            }
            this.removeBudget(httpServletRequest, httpServletResponse, n, string22);
        }
    }

    private void getRateNames(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws IOException {
        DataOutputStream dataOutputStream = new DataOutputStream((OutputStream)httpServletResponse.getOutputStream());
        String[] stringArray = null;
        try {
            stringArray = EasCostHandler.loadRateNames();
        }
        catch (Exception exception) {
            BEasService.log.error("Could not load rate names.", (Throwable)exception);
        }
        int n = 0;
        if (stringArray != null) {
            n = stringArray.length;
        }
        dataOutputStream.writeInt(n);
        if (stringArray != null) {
            for (int i = 0; i < n; ++i) {
                dataOutputStream.writeUTF(stringArray[i]);
            }
        }
        dataOutputStream.flush();
    }

    private void getCostMeterNames(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, String string) throws IOException {
        DataOutputStream dataOutputStream = new DataOutputStream((OutputStream)httpServletResponse.getOutputStream());
        String[] stringArray = EasCostHandler.loadCostMeterNames(string, this.easSession);
        int n = 0;
        if (stringArray != null) {
            n = stringArray.length;
        }
        dataOutputStream.writeInt(n);
        if (stringArray != null) {
            for (int i = 0; i < n; ++i) {
                dataOutputStream.writeUTF(stringArray[i]);
            }
        }
        dataOutputStream.flush();
    }

    private void getRateByName(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, String string) throws IOException {
        DataOutputStream dataOutputStream = new DataOutputStream((OutputStream)httpServletResponse.getOutputStream());
        Rate rate = null;
        try {
            rate = EasCostHandler.loadRate(string);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        int n = 0;
        if (rate != null) {
            n = 1;
        }
        dataOutputStream.writeInt(n);
        if (rate != null) {
            XmlEncoder xmlEncoder = new XmlEncoder(dataOutputStream);
            xmlEncoder.encodeDocument(rate);
        }
        dataOutputStream.flush();
    }

    private void setRate(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws IOException {
        ServletInputStream servletInputStream = httpServletRequest.getInputStream();
        try {
            XmlDecoder xmlDecoder = new XmlDecoder((InputStream)servletInputStream);
            Rate rate = (Rate)xmlDecoder.decodeDocument();
            EasCostHandler.saveRate(rate);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        servletInputStream.close();
    }

    private void setRateName(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, String string, String string2) throws IOException {
        try {
            Rate rate = EasCostHandler.loadRate(string);
            if (rate != null) {
                rate.setName(string2);
                File file = EasCostHandler.loadRateFile(string);
                if (file != null) {
                    file.delete();
                }
                EasCostHandler.saveRate(rate);
                this.adjustRateHistories(string, string2);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void removeRate(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, String string) throws IOException {
        try {
            File file = EasCostHandler.loadRateFile(string);
            if (file != null) {
                file.delete();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void getRateHistoryById(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, int n) throws IOException {
        DataOutputStream dataOutputStream = new DataOutputStream((OutputStream)httpServletResponse.getOutputStream());
        RateHistory rateHistory = null;
        try {
            rateHistory = EasCostHandler.loadRateHistory(n);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        int n2 = 0;
        if (rateHistory != null) {
            n2 = 1;
        }
        dataOutputStream.writeInt(n2);
        if (rateHistory != null) {
            XmlEncoder xmlEncoder = new XmlEncoder(dataOutputStream);
            xmlEncoder.encodeDocument(rateHistory);
        }
        dataOutputStream.flush();
    }

    private void setRateHistory(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, int n) throws IOException {
        ServletInputStream servletInputStream = httpServletRequest.getInputStream();
        try {
            XmlDecoder xmlDecoder = new XmlDecoder((InputStream)servletInputStream);
            RateHistory rateHistory = (RateHistory)xmlDecoder.decodeDocument();
            EasCostHandler.saveRateHistory(rateHistory, n);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        servletInputStream.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private void adjustRateHistories(String string, String string2) throws IOException {
        block15: {
            Connection connection;
            Statement statement;
            block13: {
                statement = null;
                connection = null;
                connection = easService.getDatabase().getConnection();
                statement = connection.createStatement();
                DBSpecific dBSpecific = easService.getDatabase().getDBSpecific();
                String string3 = "update " + dBSpecific.getFullTableName("EAS", "RATE_ATTACHMENTS") + " set RATE_NAME=" + Dbx.str2db(string2) + " where RATE_NAME=" + Dbx.str2db(string);
                statement.executeUpdate(string3);
                string3 = "update " + dBSpecific.getFullTableName("EAS", "ACTUAL_COSTS") + " set RATE_NAME=" + Dbx.str2db(string2) + " where RATE_NAME=" + Dbx.str2db(string);
                statement.executeUpdate(string3);
                string3 = "update " + dBSpecific.getFullTableName("EAS", "BILLING_CYCLES") + " set RATE_NAME=" + Dbx.str2db(string2) + " where RATE_NAME=" + Dbx.str2db(string);
                statement.executeUpdate(string3);
                Object var8_8 = null;
                if (statement == null) break block13;
                try {
                    statement.close();
                }
                catch (SQLException sQLException) {
                    sQLException.printStackTrace();
                }
            }
            if (connection != null) {
                easService.getDatabase().freeConnection(connection);
            }
            break block15;
            {
                catch (Exception exception) {
                    exception.printStackTrace();
                    Object var8_9 = null;
                    if (statement != null) {
                        try {
                            statement.close();
                        }
                        catch (SQLException sQLException) {
                            sQLException.printStackTrace();
                        }
                    }
                    if (connection != null) {
                        easService.getDatabase().freeConnection(connection);
                    }
                }
            }
            catch (Throwable throwable) {
                Object var8_10 = null;
                if (statement != null) {
                    try {
                        statement.close();
                    }
                    catch (SQLException sQLException) {
                        sQLException.printStackTrace();
                    }
                }
                if (connection != null) {
                    easService.getDatabase().freeConnection(connection);
                }
                throw throwable;
            }
        }
    }

    private void getReconciliationNames(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, String string) throws IOException {
        DataOutputStream dataOutputStream = new DataOutputStream((OutputStream)httpServletResponse.getOutputStream());
        String[] stringArray = EasCostHandler.loadReconciliationReportNames(string);
        int n = 0;
        if (stringArray != null) {
            n = stringArray.length;
        }
        dataOutputStream.writeInt(n);
        if (stringArray != null) {
            for (int i = 0; i < n; ++i) {
                dataOutputStream.writeUTF(stringArray[i]);
            }
        }
        dataOutputStream.flush();
    }

    private void getReconciliation(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, String string, String string2, String string3, boolean bl, boolean bl2, String string4, boolean bl3, boolean bl4, BUnit bUnit, double d, boolean bl5, int n, double d2, boolean bl6, DataPoint dataPoint) throws IOException {
        Object object;
        int n2;
        DataOutputStream dataOutputStream = new DataOutputStream((OutputStream)httpServletResponse.getOutputStream());
        ReconciliationReport reconciliationReport = null;
        try {
            reconciliationReport = EasCostHandler.loadReconciliationReport(string, string3);
            if (reconciliationReport != null && bl) {
                n2 = Integer.parseInt(string4.substring(RATE_HISTORY_PREFIX.length()));
                object = EasCostHandler.loadRateHistory(n2);
                Meter meter = Meter.get(n2, this.easSession);
                if (object != null && meter != null) {
                    reconciliationReport.runReport(string3, (RateHistory)object, meter, bl2, bl3, bl4, bUnit, d, bl5, n, d2, bl6, dataPoint);
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        n2 = 0;
        if (reconciliationReport != null) {
            n2 = 1;
        }
        dataOutputStream.writeInt(n2);
        if (reconciliationReport != null) {
            object = new XmlEncoder(dataOutputStream);
            ((XmlEncoder)((Object)object)).encodeDocument(reconciliationReport);
        }
        dataOutputStream.flush();
    }

    private void setReconciliationReport(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, int n, String string) throws IOException {
        ServletInputStream servletInputStream = httpServletRequest.getInputStream();
        try {
            XmlDecoder xmlDecoder = new XmlDecoder((InputStream)servletInputStream);
            ReconciliationReport reconciliationReport = (ReconciliationReport)xmlDecoder.decodeDocument();
            EasCostHandler.saveReconciliationReport(n, string, reconciliationReport);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        servletInputStream.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private void removeReconciliationReport(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, int n, String string) throws IOException {
        block18: {
            Connection connection;
            Statement statement;
            block16: {
                statement = null;
                connection = null;
                connection = easService.getDatabase().getConnection();
                statement = connection.createStatement();
                ReconciliationReport.deleteFromRdb(n, string, statement, easService.getDatabase().getDBSpecific());
                Object var9_7 = null;
                if (statement == null) break block16;
                try {
                    statement.close();
                }
                catch (SQLException sQLException) {
                    sQLException.printStackTrace();
                }
            }
            if (connection != null) {
                easService.getDatabase().freeConnection(connection);
            }
            break block18;
            {
                catch (Exception exception) {
                    exception.printStackTrace();
                    Object var9_8 = null;
                    if (statement != null) {
                        try {
                            statement.close();
                        }
                        catch (SQLException sQLException) {
                            sQLException.printStackTrace();
                        }
                    }
                    if (connection != null) {
                        easService.getDatabase().freeConnection(connection);
                    }
                }
            }
            catch (Throwable throwable) {
                Object var9_9 = null;
                if (statement != null) {
                    try {
                        statement.close();
                    }
                    catch (SQLException sQLException) {
                        sQLException.printStackTrace();
                    }
                }
                if (connection != null) {
                    easService.getDatabase().freeConnection(connection);
                }
                throw throwable;
            }
        }
        try {
            File file = EasCostHandler.loadReconciliationNotesFile(n, string);
            if (file != null) {
                file.delete();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void runReconciliation(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, String string, String string2, boolean bl, boolean bl2, BUnit bUnit, double d, boolean bl3, int n, double d2, boolean bl4, DataPoint dataPoint) throws IOException {
        Object object;
        ReconciliationReport reconciliationReport = null;
        ServletInputStream servletInputStream = httpServletRequest.getInputStream();
        try {
            object = new XmlDecoder((InputStream)servletInputStream);
            reconciliationReport = (ReconciliationReport)((XmlDecoder)((Object)object)).decodeDocument();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        object = new DataOutputStream((OutputStream)httpServletResponse.getOutputStream());
        RateHistory rateHistory = null;
        int n2 = Integer.parseInt(string.substring(RATE_HISTORY_PREFIX.length()));
        try {
            rateHistory = EasCostHandler.loadRateHistory(n2);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        Meter meter = Meter.get(n2, this.easSession);
        int n3 = 0;
        if (rateHistory != null && meter != null && reconciliationReport != null) {
            try {
                reconciliationReport.runReport(string2, rateHistory, meter, true, bl, bl2, bUnit, d, bl3, n, d2, bl4, dataPoint);
                n3 = 1;
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        ((DataOutputStream)object).writeInt(n3);
        if (n3 > 0) {
            XmlEncoder xmlEncoder = new XmlEncoder((OutputStream)object);
            xmlEncoder.encodeDocument(reconciliationReport);
        }
        ((DataOutputStream)object).flush();
        ((FilterOutputStream)object).close();
        servletInputStream.close();
    }

    private void runAlternateReconciliation(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, String[] stringArray, String string, boolean bl, boolean bl2, boolean bl3, BUnit bUnit, double d, boolean bl4, int n, double d2, boolean bl5, DataPoint dataPoint) throws IOException {
        int n2;
        Object object;
        ReconciliationReport reconciliationReport = null;
        RateHistory rateHistory = null;
        ServletInputStream servletInputStream = httpServletRequest.getInputStream();
        try {
            object = new XmlDecoder((InputStream)servletInputStream);
            reconciliationReport = (ReconciliationReport)((XmlDecoder)((Object)object)).decodeDocument(false);
            rateHistory = (RateHistory)((XmlDecoder)((Object)object)).decodeDocument();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        object = new DataOutputStream((OutputStream)httpServletResponse.getOutputStream());
        Meter[] meterArray = null;
        if (stringArray != null) {
            meterArray = new Meter[stringArray.length];
            for (n2 = 0; n2 < meterArray.length; ++n2) {
                int n3 = Integer.parseInt(stringArray[n2].substring(RATE_HISTORY_PREFIX.length()));
                meterArray[n2] = Meter.get(n3, this.easSession);
            }
        }
        n2 = 0;
        if (rateHistory != null && meterArray != null && reconciliationReport != null) {
            try {
                if (bl || meterArray.length <= 1) {
                    reconciliationReport.runReport(string, rateHistory, meterArray, bl2, bl3, bUnit, d, bl4, n, d2, bl5, dataPoint);
                } else {
                    ReconciliationReport reconciliationReport2 = new ReconciliationReport(reconciliationReport.getName());
                    ReconciliationReport[] reconciliationReportArray = new ReconciliationReport[2];
                    for (int i = 0; i < meterArray.length; ++i) {
                        reconciliationReport.runReport(string, rateHistory, meterArray[i], true, bl2, bl3, bUnit, d, bl4, n, d2, bl5, dataPoint);
                        reconciliationReportArray[0] = reconciliationReport2;
                        reconciliationReportArray[1] = reconciliationReport;
                        reconciliationReport2 = ReconciliationReport.consolidateReconciliations(reconciliationReportArray);
                    }
                    if (meterArray.length > 0) {
                        reconciliationReport = reconciliationReport2;
                    }
                }
                n2 = 1;
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        ((DataOutputStream)object).writeInt(n2);
        if (n2 > 0) {
            XmlEncoder xmlEncoder = new XmlEncoder((OutputStream)object);
            xmlEncoder.encodeDocument(reconciliationReport);
        }
        ((DataOutputStream)object).flush();
        ((FilterOutputStream)object).close();
        servletInputStream.close();
    }

    private void getAnalyzerReportByName(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, String string, String string2) throws IOException {
        DataOutputStream dataOutputStream = new DataOutputStream((OutputStream)httpServletResponse.getOutputStream());
        AnalyzerReport analyzerReport = null;
        try {
            analyzerReport = EasCostHandler.loadAnalyzerReport(string, string2);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        int n = 0;
        if (analyzerReport != null) {
            n = 1;
        }
        dataOutputStream.writeInt(n);
        if (analyzerReport != null) {
            XmlEncoder xmlEncoder = new XmlEncoder(dataOutputStream);
            xmlEncoder.encodeDocument(analyzerReport);
        }
        dataOutputStream.flush();
    }

    private void setAnalyzerReport(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, String string) throws IOException {
        httpServletResponse.setStatus(100);
        httpServletResponse.getOutputStream();
        ServletInputStream servletInputStream = httpServletRequest.getInputStream();
        try {
            XmlDecoder xmlDecoder = new XmlDecoder((InputStream)servletInputStream);
            AnalyzerReport analyzerReport = (AnalyzerReport)xmlDecoder.decodeDocument(false);
            EasCostHandler.saveAnalyzerReport(analyzerReport, string);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        httpServletResponse.setStatus(201);
    }

    private void getBudget(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, int n, String string) throws IOException {
        DataOutputStream dataOutputStream = new DataOutputStream((OutputStream)httpServletResponse.getOutputStream());
        Budget budget = null;
        try {
            budget = EasCostHandler.loadBudget(n, string);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        int n2 = 0;
        if (budget != null) {
            n2 = 1;
        }
        dataOutputStream.writeInt(n2);
        if (budget != null) {
            XmlEncoder xmlEncoder = new XmlEncoder(dataOutputStream);
            xmlEncoder.encodeDocument(budget);
        }
        dataOutputStream.flush();
    }

    private void setBudget(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, int n) throws IOException {
        ServletInputStream servletInputStream = httpServletRequest.getInputStream();
        try {
            XmlDecoder xmlDecoder = new XmlDecoder((InputStream)servletInputStream);
            Budget budget = (Budget)xmlDecoder.decodeDocument();
            EasCostHandler.saveBudget(n, budget);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        servletInputStream.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private void removeBudget(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, int n, String string) throws IOException {
        block15: {
            Connection connection;
            Statement statement;
            block13: {
                statement = null;
                connection = null;
                connection = easService.getDatabase().getConnection();
                statement = connection.createStatement();
                Budget.deleteFromRdb(n, string, statement, easService.getDatabase().getDBSpecific());
                Object var9_7 = null;
                if (statement == null) break block13;
                try {
                    statement.close();
                }
                catch (SQLException sQLException) {
                    sQLException.printStackTrace();
                }
            }
            if (connection != null) {
                easService.getDatabase().freeConnection(connection);
            }
            break block15;
            {
                catch (Exception exception) {
                    exception.printStackTrace();
                    Object var9_8 = null;
                    if (statement != null) {
                        try {
                            statement.close();
                        }
                        catch (SQLException sQLException) {
                            sQLException.printStackTrace();
                        }
                    }
                    if (connection != null) {
                        easService.getDatabase().freeConnection(connection);
                    }
                }
            }
            catch (Throwable throwable) {
                Object var9_9 = null;
                if (statement != null) {
                    try {
                        statement.close();
                    }
                    catch (SQLException sQLException) {
                        sQLException.printStackTrace();
                    }
                }
                if (connection != null) {
                    easService.getDatabase().freeConnection(connection);
                }
                throw throwable;
            }
        }
    }

    private static Rate[] loadRates() throws IOException {
        File file = EasCostHandler.getRateDirectory();
        if (file == null) {
            return null;
        }
        String[] stringArray = file.list();
        if (stringArray == null) {
            return null;
        }
        Rate[] rateArray = new Rate[stringArray.length];
        int n = 0;
        for (int i = 0; i < stringArray.length; ++i) {
            if (!stringArray[i].endsWith(".xml")) continue;
            try {
                XmlDecoder xmlDecoder = new XmlDecoder(new File(file, stringArray[i]));
                rateArray[n] = (Rate)xmlDecoder.decodeDocument();
                ++n;
                continue;
            }
            catch (Exception exception) {
                System.out.println("Error loading rates.");
                exception.printStackTrace();
            }
        }
        Rate[] rateArray2 = new Rate[n];
        System.arraycopy(rateArray, 0, rateArray2, 0, n);
        return rateArray2;
    }

    private static File getRateDirectory() throws IOException {
        File file = Sys.getStationHome();
        File file2 = new File(file, "eas\\rates");
        if (!file2.exists()) {
            file2.mkdirs();
        }
        return file2;
    }

    private static String[] loadRateNames() throws IOException {
        Rate[] rateArray = EasCostHandler.loadRates();
        if (rateArray == null) {
            return null;
        }
        String[] stringArray = new String[rateArray.length];
        for (int i = 0; i < rateArray.length; ++i) {
            stringArray[i] = rateArray[i].getName();
        }
        return stringArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private static String[] loadCostMeterNames(String string, EasSession easSession) throws IOException {
        SQLException sQLException222;
        String[] stringArray;
        Connection connection;
        ResultSet resultSet;
        Statement statement;
        block22: {
            if (string == null) {
                return null;
            }
            statement = null;
            resultSet = null;
            connection = null;
            connection = easService.getDatabase().getConnection();
            statement = connection.createStatement();
            DBSpecific dBSpecific = easService.getDatabase().getDBSpecific();
            String string2 = "select distinct METER_ID from " + dBSpecific.getFullTableName("EAS", "RATE_ATTACHMENTS") + " where RATE_NAME=" + Dbx.str2db(string);
            resultSet = statement.executeQuery(string2);
            int n = 0;
            Vector<Integer> vector = new Vector<Integer>();
            while (resultSet.next()) {
                vector.addElement(new Integer(resultSet.getInt(1)));
                ++n;
            }
            String[] stringArray2 = new String[n];
            for (int i = 0; i < n; ++i) {
                int n2 = (Integer)vector.elementAt(i);
                Meter meter = Meter.get(n2, easSession);
                stringArray2[i] = (meter.getSite() != null ? meter.getSite().getName() + ": " : "") + meter.getName();
            }
            stringArray = stringArray2;
            Object var14_15 = null;
            if (resultSet == null) break block22;
            try {
                resultSet.close();
            }
            catch (SQLException sQLException222) {
                sQLException222.printStackTrace();
            }
        }
        if (statement != null) {
            try {
                statement.close();
            }
            catch (SQLException sQLException222) {
                sQLException222.printStackTrace();
            }
        }
        if (connection != null) {
            easService.getDatabase().freeConnection(connection);
        }
        return stringArray;
        catch (Exception exception) {
            SQLException sQLException3222;
            block24: {
                try {
                    exception.printStackTrace();
                    Object var14_16 = null;
                    if (resultSet == null) break block24;
                }
                catch (Throwable throwable) {
                    SQLException sQLException4222;
                    Object var14_17 = null;
                    if (resultSet != null) {
                        try {
                            resultSet.close();
                        }
                        catch (SQLException sQLException4222) {
                            sQLException4222.printStackTrace();
                        }
                    }
                    if (statement != null) {
                        try {
                            statement.close();
                        }
                        catch (SQLException sQLException4222) {
                            sQLException4222.printStackTrace();
                        }
                    }
                    if (connection != null) {
                        easService.getDatabase().freeConnection(connection);
                    }
                    throw throwable;
                }
                try {
                    resultSet.close();
                }
                catch (SQLException sQLException3222) {
                    sQLException3222.printStackTrace();
                }
            }
            if (statement != null) {
                try {
                    statement.close();
                }
                catch (SQLException sQLException3222) {
                    sQLException3222.printStackTrace();
                }
            }
            if (connection != null) {
                easService.getDatabase().freeConnection(connection);
            }
        }
        return null;
    }

    public static Rate loadRate(String string) throws Exception {
        Object object;
        Rate rate;
        if (string == null) {
            return null;
        }
        File file = EasCostHandler.getRateDirectory();
        if (file == null) {
            return null;
        }
        File file2 = new File(file, string + ".xml");
        if (file2.exists() && (rate = (Rate)((XmlDecoder)((Object)(object = new XmlDecoder(file2)))).decodeDocument()).getName().equals(string)) {
            return rate;
        }
        object = EasCostHandler.loadRates();
        if (object == null) {
            return null;
        }
        for (int i = 0; i < ((Object)object).length; ++i) {
            if (!string.equals(((Rate)object[i]).getName())) continue;
            return object[i];
        }
        return null;
    }

    private static File loadRateFile(String string) throws Exception {
        Object object;
        Rate rate;
        if (string == null) {
            return null;
        }
        File file = EasCostHandler.getRateDirectory();
        if (file == null) {
            return null;
        }
        File file2 = new File(file, string + ".xml");
        if (file2.exists() && (rate = (Rate)((XmlDecoder)((Object)(object = new XmlDecoder(file2)))).decodeDocument()).getName().equals(string)) {
            return file2;
        }
        object = file.list();
        if (object == null) {
            return null;
        }
        for (int i = 0; i < ((Object)object).length; ++i) {
            XmlDecoder xmlDecoder;
            Rate rate2;
            if (!((String)object[i]).endsWith(".xml") || !(rate2 = (Rate)(xmlDecoder = new XmlDecoder(file2 = new File(file, (String)object[i]))).decodeDocument()).getName().equals(string)) continue;
            return file2;
        }
        return null;
    }

    private static void saveRate(Rate rate) throws Exception {
        if (rate == null || rate.getName() == null) {
            throw new IllegalArgumentException("Cannot save null rate (or rate with null name).");
        }
        File file = EasCostHandler.getRateDirectory();
        if (file == null) {
            throw new IOException("Cannot find eas/rates directory.");
        }
        File file2 = new File(file, rate.getName() + ".xml");
        XmlEncoder xmlEncoder = new XmlEncoder(file2);
        xmlEncoder.encodeDocument(rate);
        xmlEncoder.close();
    }

    private static void saveRates(Rate[] rateArray) throws Exception {
        if (rateArray == null) {
            throw new IllegalArgumentException("Cannot save null rates.");
        }
        for (int i = 0; i < rateArray.length; ++i) {
            EasCostHandler.saveRate(rateArray[i]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private static RateHistory[] loadRateHistories() throws IOException {
        SQLException sQLException222;
        RateHistory[] rateHistoryArray;
        Connection connection;
        ResultSet resultSet;
        Statement statement;
        block21: {
            statement = null;
            resultSet = null;
            connection = null;
            connection = easService.getDatabase().getConnection();
            statement = connection.createStatement();
            DBSpecific dBSpecific = easService.getDatabase().getDBSpecific();
            String string = "select distinct METER_ID from " + dBSpecific.getFullTableName("EAS", "RATE_ATTACHMENTS");
            resultSet = statement.executeQuery(string);
            int n = 0;
            Vector<Integer> vector = new Vector<Integer>();
            while (resultSet.next()) {
                vector.addElement(new Integer(resultSet.getInt(1)));
                ++n;
            }
            RateHistory[] rateHistoryArray2 = new RateHistory[n];
            for (int i = 0; i < n; ++i) {
                int n2 = (Integer)vector.elementAt(i);
                rateHistoryArray2[i] = RateHistory.loadFromRdb(n2, statement, dBSpecific);
            }
            rateHistoryArray = rateHistoryArray2;
            Object var11_12 = null;
            if (resultSet == null) break block21;
            try {
                resultSet.close();
            }
            catch (SQLException sQLException222) {
                sQLException222.printStackTrace();
            }
        }
        if (statement != null) {
            try {
                statement.close();
            }
            catch (SQLException sQLException222) {
                sQLException222.printStackTrace();
            }
        }
        if (connection != null) {
            easService.getDatabase().freeConnection(connection);
        }
        return rateHistoryArray;
        catch (Exception exception) {
            SQLException sQLException3222;
            block23: {
                try {
                    exception.printStackTrace();
                    Object var11_13 = null;
                    if (resultSet == null) break block23;
                }
                catch (Throwable throwable) {
                    SQLException sQLException4222;
                    Object var11_14 = null;
                    if (resultSet != null) {
                        try {
                            resultSet.close();
                        }
                        catch (SQLException sQLException4222) {
                            sQLException4222.printStackTrace();
                        }
                    }
                    if (statement != null) {
                        try {
                            statement.close();
                        }
                        catch (SQLException sQLException4222) {
                            sQLException4222.printStackTrace();
                        }
                    }
                    if (connection != null) {
                        easService.getDatabase().freeConnection(connection);
                    }
                    throw throwable;
                }
                try {
                    resultSet.close();
                }
                catch (SQLException sQLException3222) {
                    sQLException3222.printStackTrace();
                }
            }
            if (statement != null) {
                try {
                    statement.close();
                }
                catch (SQLException sQLException3222) {
                    sQLException3222.printStackTrace();
                }
            }
            if (connection != null) {
                easService.getDatabase().freeConnection(connection);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static RateHistory loadRateHistory(int n) throws Exception {
        RateHistory rateHistory;
        Connection connection;
        Statement statement;
        block12: {
            statement = null;
            connection = null;
            connection = easService.getDatabase().getConnection();
            statement = connection.createStatement();
            rateHistory = RateHistory.loadFromRdb(n, statement, easService.getDatabase().getDBSpecific());
            Object var5_5 = null;
            if (statement == null) break block12;
            try {
                statement.close();
            }
            catch (SQLException sQLException) {
                sQLException.printStackTrace();
            }
        }
        if (connection != null) {
            easService.getDatabase().freeConnection(connection);
        }
        return rateHistory;
        catch (Exception exception) {
            block13: {
                try {
                    exception.printStackTrace();
                    Object var5_6 = null;
                    if (statement == null) break block13;
                }
                catch (Throwable throwable) {
                    Object var5_7 = null;
                    if (statement != null) {
                        try {
                            statement.close();
                        }
                        catch (SQLException sQLException) {
                            sQLException.printStackTrace();
                        }
                    }
                    if (connection != null) {
                        easService.getDatabase().freeConnection(connection);
                    }
                    throw throwable;
                }
                try {
                    statement.close();
                }
                catch (SQLException sQLException) {
                    sQLException.printStackTrace();
                }
            }
            if (connection != null) {
                easService.getDatabase().freeConnection(connection);
            }
        }
        return null;
    }

    private static void saveRateHistory(RateHistory rateHistory) throws Exception {
        int n = Integer.parseInt(rateHistory.getName().substring(RATE_HISTORY_PREFIX.length()));
        EasCostHandler.saveRateHistory(rateHistory, n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private static void saveRateHistory(RateHistory rateHistory, int n) throws Exception {
        block15: {
            Connection connection;
            Statement statement;
            block13: {
                statement = null;
                connection = null;
                connection = easService.getDatabase().getConnection();
                statement = connection.createStatement();
                rateHistory.saveToRdb(n, statement, easService.getDatabase().getDBSpecific());
                Object var6_4 = null;
                if (statement == null) break block13;
                try {
                    statement.close();
                }
                catch (SQLException sQLException) {
                    sQLException.printStackTrace();
                }
            }
            if (connection != null) {
                easService.getDatabase().freeConnection(connection);
            }
            break block15;
            {
                catch (Exception exception) {
                    exception.printStackTrace();
                    Object var6_5 = null;
                    if (statement != null) {
                        try {
                            statement.close();
                        }
                        catch (SQLException sQLException) {
                            sQLException.printStackTrace();
                        }
                    }
                    if (connection != null) {
                        easService.getDatabase().freeConnection(connection);
                    }
                }
            }
            catch (Throwable throwable) {
                Object var6_6 = null;
                if (statement != null) {
                    try {
                        statement.close();
                    }
                    catch (SQLException sQLException) {
                        sQLException.printStackTrace();
                    }
                }
                if (connection != null) {
                    easService.getDatabase().freeConnection(connection);
                }
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private static String[] loadReconciliationReportNames(String string) throws IOException {
        SQLException sQLException222;
        String[] stringArray;
        Connection connection;
        ResultSet resultSet;
        Statement statement;
        block35: {
            int n;
            int n2 = Integer.parseInt(string.substring(RATE_HISTORY_PREFIX.length()));
            statement = null;
            resultSet = null;
            connection = null;
            connection = easService.getDatabase().getConnection();
            statement = connection.createStatement();
            DBSpecific dBSpecific = easService.getDatabase().getDBSpecific();
            String string2 = "select distinct MONTH, YEAR from " + dBSpecific.getFullTableName("EAS", "MISC_COSTS") + " where METER_ID=" + n2;
            resultSet = statement.executeQuery(string2);
            int n3 = 0;
            String string3 = RATE_HISTORY_PREFIX + n2 + "_";
            Vector<String> vector = new Vector<String>();
            while (resultSet.next()) {
                int n4 = resultSet.getInt(1);
                n = resultSet.getInt(2);
                String string4 = "";
                switch (n4) {
                    case 0: {
                        string4 = "Jan" + n;
                        break;
                    }
                    case 1: {
                        string4 = "Feb" + n;
                        break;
                    }
                    case 2: {
                        string4 = "Mar" + n;
                        break;
                    }
                    case 3: {
                        string4 = "Apr" + n;
                        break;
                    }
                    case 4: {
                        string4 = "May" + n;
                        break;
                    }
                    case 5: {
                        string4 = "Jun" + n;
                        break;
                    }
                    case 6: {
                        string4 = "Jul" + n;
                        break;
                    }
                    case 7: {
                        string4 = "Aug" + n;
                        break;
                    }
                    case 8: {
                        string4 = "Sep" + n;
                        break;
                    }
                    case 9: {
                        string4 = "Oct" + n;
                        break;
                    }
                    case 10: {
                        string4 = "Nov" + n;
                        break;
                    }
                    case 11: {
                        string4 = "Dec" + n;
                    }
                }
                vector.addElement(string3 + string4);
                ++n3;
            }
            String[] stringArray2 = new String[n3];
            for (n = 0; n < n3; ++n) {
                stringArray2[n] = (String)vector.elementAt(n);
            }
            stringArray = stringArray2;
            Object var14_16 = null;
            if (resultSet == null) break block35;
            try {
                resultSet.close();
            }
            catch (SQLException sQLException222) {
                sQLException222.printStackTrace();
            }
        }
        if (statement != null) {
            try {
                statement.close();
            }
            catch (SQLException sQLException222) {
                sQLException222.printStackTrace();
            }
        }
        if (connection != null) {
            easService.getDatabase().freeConnection(connection);
        }
        return stringArray;
        catch (Exception exception) {
            SQLException sQLException3222;
            block37: {
                try {
                    exception.printStackTrace();
                    Object var14_17 = null;
                    if (resultSet == null) break block37;
                }
                catch (Throwable throwable) {
                    SQLException sQLException4222;
                    Object var14_18 = null;
                    if (resultSet != null) {
                        try {
                            resultSet.close();
                        }
                        catch (SQLException sQLException4222) {
                            sQLException4222.printStackTrace();
                        }
                    }
                    if (statement != null) {
                        try {
                            statement.close();
                        }
                        catch (SQLException sQLException4222) {
                            sQLException4222.printStackTrace();
                        }
                    }
                    if (connection != null) {
                        easService.getDatabase().freeConnection(connection);
                    }
                    throw throwable;
                }
                try {
                    resultSet.close();
                }
                catch (SQLException sQLException3222) {
                    sQLException3222.printStackTrace();
                }
            }
            if (statement != null) {
                try {
                    statement.close();
                }
                catch (SQLException sQLException3222) {
                    sQLException3222.printStackTrace();
                }
            }
            if (connection != null) {
                easService.getDatabase().freeConnection(connection);
            }
        }
        return null;
    }

    public static void deleteReconciliationNotesDirectory(int n) {
        try {
            File file = EasCostHandler.getReconciliationNotesDirectory(RATE_HISTORY_PREFIX + n);
            if (file == null) {
                return;
            }
            String[] stringArray = file.list();
            if (stringArray != null) {
                for (int i = 0; i < stringArray.length; ++i) {
                    File file2 = new File(file, stringArray[i]);
                    file2.delete();
                }
            }
            file.delete();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private static File getReconciliationNotesDirectory(String string) throws IOException {
        File file = Sys.getStationHome();
        File file2 = new File(file, "eas\\reconciliationNotes\\" + string);
        if (!file2.exists()) {
            file2.mkdirs();
        }
        return file2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private static ReconciliationReport loadReconciliationReport(String string, String string2) throws Exception {
        Object object;
        Object object2;
        Object object3;
        ReconciliationReport reconciliationReport;
        String string3;
        block31: {
            Statement statement;
            RateComponent[] rateComponentArray;
            block29: {
                if (string == null || string2 == null) {
                    return null;
                }
                int n = Integer.parseInt(string.substring(RATE_HISTORY_PREFIX.length()));
                string3 = string + "_" + string2;
                RateHistory rateHistory = EasCostHandler.loadRateHistory(n);
                if (rateHistory == null) {
                    return null;
                }
                reconciliationReport = null;
                Rate[] rateArray = rateHistory.generateRates();
                if (rateArray == null) {
                    return null;
                }
                reconciliationReport = new ReconciliationReport(string3);
                for (int i = 0; i < rateArray.length; ++i) {
                    reconciliationReport.addReconciliationRow(new ReconciliationRow(rateArray[i].getName()));
                    if (RateHistory.findMatchingRateBillingPeriod(reconciliationReport.getRateBillingPeriods(), rateArray[i].getName()) == null) {
                        long l = rateHistory.computeDefaultStartTime(rateArray[i].getName(), string2);
                        long l2 = rateHistory.computeDefaultEndTime(rateArray[i].getName(), string2);
                        reconciliationReport.addRateBillingPeriod(new RateBillingPeriod(rateArray[i].getName(), l, l2));
                    }
                    if ((rateComponentArray = rateArray[i].getRateComponents()) == null) continue;
                    object3 = rateArray[i].getName();
                    int n2 = ((String)object3).length();
                    object2 = rateArray[i].getCurrency();
                    object = rateArray[i].getConsumptionUnits();
                    BUnit bUnit = rateArray[i].getDemandUnits();
                    BUnit bUnit2 = rateArray[i].getReactiveEnergyUnits();
                    BUnit bUnit3 = rateArray[i].getApparentEnergyUnits();
                    BUnit bUnit4 = rateArray[i].getReactivePowerUnits();
                    BUnit bUnit5 = rateArray[i].getApparentPowerUnits();
                    for (int j = 0; j < rateComponentArray.length; ++j) {
                        String string4 = (String)object3 + rateComponentArray[j].getName();
                        Object object4 = object;
                        switch (rateComponentArray[j].getApplicableData()) {
                            case 0: {
                                object4 = object;
                                break;
                            }
                            case 1: {
                                object4 = bUnit;
                                break;
                            }
                            case 2: {
                                object4 = bUnit2;
                                break;
                            }
                            case 4: {
                                object4 = bUnit3;
                                break;
                            }
                            case 3: {
                                object4 = bUnit4;
                                break;
                            }
                            case 5: {
                                object4 = bUnit5;
                            }
                        }
                        reconciliationReport.addReconciliationRow(new ReconciliationRow(string4, n2, (RateComponent)rateComponentArray[j].newCopy(), 0.0, false, (BUnit)object2, (BUnit)object4));
                    }
                }
                statement = null;
                rateComponentArray = null;
                rateComponentArray = easService.getDatabase().getConnection();
                statement = rateComponentArray.createStatement();
                reconciliationReport = ReconciliationReport.loadFromRdb(reconciliationReport, n, string2, statement, easService.getDatabase().getDBSpecific());
                Object var22_26 = null;
                if (statement == null) break block29;
                try {
                    statement.close();
                }
                catch (SQLException sQLException) {
                    sQLException.printStackTrace();
                }
            }
            if (rateComponentArray != null) {
                easService.getDatabase().freeConnection((Connection)rateComponentArray);
            }
            break block31;
            {
                catch (Exception exception) {
                    exception.printStackTrace();
                    Object var22_27 = null;
                    if (statement != null) {
                        try {
                            statement.close();
                        }
                        catch (SQLException sQLException) {
                            sQLException.printStackTrace();
                        }
                    }
                    if (rateComponentArray != null) {
                        easService.getDatabase().freeConnection((Connection)rateComponentArray);
                    }
                }
            }
            catch (Throwable throwable) {
                Object var22_28 = null;
                if (statement != null) {
                    try {
                        statement.close();
                    }
                    catch (SQLException sQLException) {
                        sQLException.printStackTrace();
                    }
                }
                if (rateComponentArray != null) {
                    easService.getDatabase().freeConnection((Connection)rateComponentArray);
                }
                throw throwable;
            }
        }
        object3 = EasCostHandler.getReconciliationNotesDirectory(string);
        if (object3 == null) {
            return reconciliationReport;
        }
        File file = new File((File)object3, string3 + ".xml");
        if (file.exists() && ((ReconciliationNotes)(object = (ReconciliationNotes)((XmlDecoder)((Object)(object2 = new XmlDecoder(file)))).decodeDocument())).getName().equals(string3)) {
            reconciliationReport.setReconciliationNotes(((ReconciliationNotes)object).getReconciliationNotes());
        }
        return reconciliationReport;
    }

    private static File loadReconciliationNotesFile(int n, String string) throws Exception {
        Object object;
        ReconciliationNotes reconciliationNotes;
        String string2 = RATE_HISTORY_PREFIX + n;
        String string3 = string2 + "_" + string;
        File file = EasCostHandler.getReconciliationNotesDirectory(string2);
        if (file == null) {
            return null;
        }
        File file2 = new File(file, string3 + ".xml");
        if (file2.exists() && (reconciliationNotes = (ReconciliationNotes)((XmlDecoder)((Object)(object = new XmlDecoder(file2)))).decodeDocument()).getName().equals(string3)) {
            return file2;
        }
        object = file.list();
        if (object == null) {
            return null;
        }
        for (int i = 0; i < ((Object)object).length; ++i) {
            XmlDecoder xmlDecoder;
            ReconciliationNotes reconciliationNotes2;
            if (!((String)object[i]).endsWith(".xml") || !(reconciliationNotes2 = (ReconciliationNotes)(xmlDecoder = new XmlDecoder(file2 = new File(file, (String)object[i]))).decodeDocument()).getName().equals(string3)) continue;
            return file2;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private static void saveReconciliationReport(int n, String string, ReconciliationReport reconciliationReport) throws Exception {
        Object object2222;
        String string2;
        block21: {
            Connection connection;
            Statement statement;
            block19: {
                if (reconciliationReport == null || reconciliationReport.getName() == null) {
                    throw new IllegalArgumentException("Cannot save null reconciliation (or reconciliation with null name).");
                }
                statement = null;
                connection = null;
                connection = easService.getDatabase().getConnection();
                statement = connection.createStatement();
                reconciliationReport.saveToRdb(n, string, statement, easService.getDatabase().getDBSpecific());
                string2 = null;
                if (statement == null) break block19;
                try {
                    statement.close();
                }
                catch (SQLException object2222) {
                    ((Throwable)object2222).printStackTrace();
                }
            }
            if (connection != null) {
                easService.getDatabase().freeConnection(connection);
            }
            break block21;
            {
                catch (Exception exception) {
                    exception.printStackTrace();
                    string2 = null;
                    if (statement != null) {
                        try {
                            statement.close();
                        }
                        catch (SQLException object2222) {
                            ((Throwable)object2222).printStackTrace();
                        }
                    }
                    if (connection != null) {
                        easService.getDatabase().freeConnection(connection);
                    }
                }
            }
            catch (Throwable throwable) {
                Object var7_6 = null;
                if (statement != null) {
                    try {
                        statement.close();
                    }
                    catch (SQLException sQLException) {
                        sQLException.printStackTrace();
                    }
                }
                if (connection != null) {
                    easService.getDatabase().freeConnection(connection);
                }
                throw throwable;
            }
        }
        ReconciliationNote[] reconciliationNoteArray = reconciliationReport.getReconciliationNotes();
        if (reconciliationNoteArray == null || reconciliationNoteArray.length <= 0) {
            try {
                File file = EasCostHandler.loadReconciliationNotesFile(n, string);
                if (file != null) {
                    file.delete();
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            return;
        }
        String string3 = RATE_HISTORY_PREFIX + n;
        string2 = string3 + "_" + string;
        object2222 = new ReconciliationNotes(string2, reconciliationNoteArray);
        File file = EasCostHandler.getReconciliationNotesDirectory(string3);
        if (file == null) {
            throw new IOException("Cannot find eas/reconciliationNotes/" + string3 + " directory.");
        }
        File file2 = new File(file, string2 + ".xml");
        XmlEncoder xmlEncoder = new XmlEncoder(file2);
        xmlEncoder.encodeDocument((XmlSupport)object2222);
        xmlEncoder.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private static AnalyzerReport[] loadAnalyzerReports(String string) throws IOException {
        AnalyzerReport[] analyzerReportArray;
        block26: {
            SQLException sQLException2222;
            ResultSet resultSet;
            Statement statement;
            Connection connection;
            block22: {
                if (string == null) {
                    return null;
                }
                connection = null;
                statement = null;
                resultSet = null;
                analyzerReportArray = null;
                connection = easService.getDatabase().getConnection();
                statement = connection.createStatement();
                String string2 = "select REPORT_DATA from " + easService.getDatabase().getDBSpecific().getFullTableName("EAS", "SAVED_REPORTS") + " where REPORT_USER=" + Dbx.str2db(string) + " and REPORT_TYPE=" + Dbx.str2db("whatIfAnalyzer");
                resultSet = statement.executeQuery(string2);
                int n = 0;
                while (resultSet.next()) {
                    XmlDecoder xmlDecoder = new XmlDecoder(new BufferedInputStream(resultSet.getBinaryStream(1)));
                    analyzerReportArray[n] = (AnalyzerReport)xmlDecoder.decodeDocument();
                    ++n;
                }
                Object var9_9 = null;
                if (resultSet == null) break block22;
                try {
                    resultSet.close();
                }
                catch (SQLException sQLException2222) {
                    sQLException2222.printStackTrace();
                }
            }
            if (statement != null) {
                try {
                    statement.close();
                }
                catch (SQLException sQLException2222) {
                    sQLException2222.printStackTrace();
                }
            }
            if (connection != null) {
                easService.getDatabase().freeConnection(connection);
            }
            break block26;
            {
                catch (Exception exception) {
                    SQLException sQLException32222;
                    exception.printStackTrace();
                    Object var9_10 = null;
                    if (resultSet != null) {
                        try {
                            resultSet.close();
                        }
                        catch (SQLException sQLException32222) {
                            sQLException32222.printStackTrace();
                        }
                    }
                    if (statement != null) {
                        try {
                            statement.close();
                        }
                        catch (SQLException sQLException32222) {
                            sQLException32222.printStackTrace();
                        }
                    }
                    if (connection != null) {
                        easService.getDatabase().freeConnection(connection);
                    }
                }
            }
            catch (Throwable throwable) {
                SQLException sQLException42222;
                Object var9_11 = null;
                if (resultSet != null) {
                    try {
                        resultSet.close();
                    }
                    catch (SQLException sQLException42222) {
                        sQLException42222.printStackTrace();
                    }
                }
                if (statement != null) {
                    try {
                        statement.close();
                    }
                    catch (SQLException sQLException42222) {
                        sQLException42222.printStackTrace();
                    }
                }
                if (connection != null) {
                    easService.getDatabase().freeConnection(connection);
                }
                throw throwable;
            }
        }
        return analyzerReportArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static AnalyzerReport loadAnalyzerReport(String string, String string2) throws Exception {
        AnalyzerReport analyzerReport;
        block27: {
            SQLException sQLException2222;
            ResultSet resultSet;
            Statement statement;
            Connection connection;
            block23: {
                block22: {
                    if (string2 == null) {
                        return null;
                    }
                    connection = null;
                    statement = null;
                    resultSet = null;
                    analyzerReport = null;
                    connection = easService.getDatabase().getConnection();
                    statement = connection.createStatement();
                    String string3 = "select REPORT_DATA from " + easService.getDatabase().getDBSpecific().getFullTableName("EAS", "SAVED_REPORTS") + " where REPORT_USER=" + Dbx.str2db(string != null ? string : "public") + " and REPORT_NAME=" + Dbx.str2db(string2) + " and REPORT_TYPE=" + Dbx.str2db("whatIfAnalyzer");
                    resultSet = statement.executeQuery(string3);
                    if (resultSet.next()) {
                        XmlDecoder xmlDecoder = new XmlDecoder(new BufferedInputStream(resultSet.getBinaryStream(1)));
                        analyzerReport = (AnalyzerReport)xmlDecoder.decodeDocument();
                        break block22;
                    }
                    string3 = "select REPORT_DATA from " + easService.getDatabase().getDBSpecific().getFullTableName("EAS", "SAVED_REPORTS") + " where PUBLIC_REPORT=1" + " and REPORT_NAME=" + Dbx.str2db(string2) + " and REPORT_TYPE=" + Dbx.str2db("whatIfAnalyzer");
                    resultSet = statement.executeQuery(string3);
                    if (!resultSet.next()) break block22;
                    XmlDecoder xmlDecoder = new XmlDecoder(new BufferedInputStream(resultSet.getBinaryStream(1)));
                    analyzerReport = (AnalyzerReport)xmlDecoder.decodeDocument();
                }
                Object var9_10 = null;
                if (resultSet == null) break block23;
                try {
                    resultSet.close();
                }
                catch (SQLException sQLException2222) {
                    sQLException2222.printStackTrace();
                }
            }
            if (statement != null) {
                try {
                    statement.close();
                }
                catch (SQLException sQLException2222) {
                    sQLException2222.printStackTrace();
                }
            }
            if (connection != null) {
                easService.getDatabase().freeConnection(connection);
            }
            break block27;
            {
                catch (SQLException sQLException3) {
                    SQLException sQLException42222;
                    sQLException3.printStackTrace();
                    Object var9_11 = null;
                    if (resultSet != null) {
                        try {
                            resultSet.close();
                        }
                        catch (SQLException sQLException42222) {
                            sQLException42222.printStackTrace();
                        }
                    }
                    if (statement != null) {
                        try {
                            statement.close();
                        }
                        catch (SQLException sQLException42222) {
                            sQLException42222.printStackTrace();
                        }
                    }
                    if (connection != null) {
                        easService.getDatabase().freeConnection(connection);
                    }
                }
            }
            catch (Throwable throwable) {
                SQLException sQLException52222;
                Object var9_12 = null;
                if (resultSet != null) {
                    try {
                        resultSet.close();
                    }
                    catch (SQLException sQLException52222) {
                        sQLException52222.printStackTrace();
                    }
                }
                if (statement != null) {
                    try {
                        statement.close();
                    }
                    catch (SQLException sQLException52222) {
                        sQLException52222.printStackTrace();
                    }
                }
                if (connection != null) {
                    easService.getDatabase().freeConnection(connection);
                }
                throw throwable;
            }
        }
        return analyzerReport;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private static void saveAnalyzerReport(AnalyzerReport analyzerReport, String string) throws Exception {
        block57: {
            InputStream inputStream;
            Statement statement;
            Statement statement2;
            ResultSet resultSet;
            Connection connection;
            block45: {
                if (analyzerReport == null || analyzerReport.getName() == null) {
                    throw new IllegalArgumentException("Cannot save null analyzer report (or analyzer report with null name).");
                }
                String string2 = analyzerReport.getName();
                if (string == null) {
                    string = "public";
                }
                int n = -1;
                boolean bl = false;
                connection = null;
                resultSet = null;
                statement2 = null;
                statement = null;
                inputStream = null;
                connection = easService.getDatabase().getConnection();
                statement2 = connection.createStatement();
                String string3 = "select REPORT_ID from " + easService.getDatabase().getDBSpecific().getFullTableName("EAS", "SAVED_REPORTS") + " where REPORT_USER=" + Dbx.str2db(string != null ? string : "public") + " and PUBLIC_REPORT=" + (string == null || string.equals("public") ? 1 : 0) + " and REPORT_NAME=" + Dbx.str2db(string2) + " and REPORT_TYPE=" + Dbx.str2db("whatIfAnalyzer");
                resultSet = statement2.executeQuery(string3);
                if (resultSet.next()) {
                    n = resultSet.getInt(1);
                    bl = true;
                }
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                XmlEncoder xmlEncoder = new XmlEncoder(byteArrayOutputStream);
                xmlEncoder.encodeDocument(analyzerReport);
                xmlEncoder.close();
                byte[] byArray = byteArrayOutputStream.toByteArray();
                byteArrayOutputStream.close();
                if (bl) {
                    statement = connection.prepareStatement("update " + easService.getDatabase().getDBSpecific().getFullTableName("EAS", "SAVED_REPORTS") + " set REPORT_DATA = ? where REPORT_ID=" + n);
                    inputStream = new ByteArrayInputStream(byArray);
                    statement.setBinaryStream(1, inputStream, inputStream.available());
                    statement.executeUpdate();
                    break block45;
                }
                statement = connection.prepareStatement("insert into " + easService.getDatabase().getDBSpecific().getFullTableName("EAS", "SAVED_REPORTS") + " (REPORT_ID, PUBLIC_REPORT, REPORT_USER, REPORT_NAME, REPORT_TYPE, REPORT_DATA) VALUES (?, ?, ?, ?, ?, ?)");
                statement.setInt(2, string.equals("public") ? 1 : 0);
                statement.setString(3, string);
                statement.setString(4, string2);
                statement.setString(5, "whatIfAnalyzer");
                boolean bl2 = true;
                int n2 = 10;
                while (bl2 && --n2 >= 0) {
                    block46: {
                        inputStream = new ByteArrayInputStream(byArray);
                        statement.setBinaryStream(6, inputStream, inputStream.available());
                        try {
                            statement.setInt(1, easService.getDatabase().getNewId());
                            bl2 = statement.executeUpdate() != 1;
                        }
                        catch (Exception exception) {
                            if (n2 != 0) break block46;
                            throw exception;
                        }
                    }
                    try {
                        inputStream.close();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    inputStream = null;
                }
                if (!bl2) break block45;
                BEasService.log.error("Could not save what if analyzer report " + string2);
            }
            Object var18_20 = null;
            try {
                inputStream.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (resultSet != null) {
                try {
                    resultSet.close();
                }
                catch (SQLException exception) {
                    exception.printStackTrace();
                }
            }
            if (statement2 != null) {
                try {
                    statement2.close();
                }
                catch (SQLException exception) {
                    exception.printStackTrace();
                }
            }
            if (statement != null) {
                try {
                    statement.close();
                }
                catch (SQLException exception) {
                    exception.printStackTrace();
                }
            }
            try {
                connection.commit();
            }
            catch (SQLException exception) {
                // empty catch block
            }
            if (connection != null) {
                easService.getDatabase().freeConnection(connection);
            }
            break block57;
            {
                catch (SQLException sQLException) {
                    BEasService.log.error("Error saving what if analyzer report", (Throwable)sQLException);
                    Object var18_21 = null;
                    try {
                        inputStream.close();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (resultSet != null) {
                        try {
                            resultSet.close();
                        }
                        catch (SQLException exception) {
                            exception.printStackTrace();
                        }
                    }
                    if (statement2 != null) {
                        try {
                            statement2.close();
                        }
                        catch (SQLException exception) {
                            exception.printStackTrace();
                        }
                    }
                    if (statement != null) {
                        try {
                            statement.close();
                        }
                        catch (SQLException exception) {
                            exception.printStackTrace();
                        }
                    }
                    try {
                        connection.commit();
                    }
                    catch (SQLException exception) {
                        // empty catch block
                    }
                    if (connection != null) {
                        easService.getDatabase().freeConnection(connection);
                    }
                }
            }
            catch (Throwable throwable) {
                Object var18_22 = null;
                try {
                    inputStream.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (resultSet != null) {
                    try {
                        resultSet.close();
                    }
                    catch (SQLException exception) {
                        exception.printStackTrace();
                    }
                }
                if (statement2 != null) {
                    try {
                        statement2.close();
                    }
                    catch (SQLException exception) {
                        exception.printStackTrace();
                    }
                }
                if (statement != null) {
                    try {
                        statement.close();
                    }
                    catch (SQLException exception) {
                        exception.printStackTrace();
                    }
                }
                try {
                    connection.commit();
                }
                catch (SQLException exception) {
                    // empty catch block
                }
                if (connection != null) {
                    easService.getDatabase().freeConnection(connection);
                }
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private static Budget loadBudget(int n, String string) throws Exception {
        Budget budget;
        Connection connection;
        Statement statement;
        block12: {
            statement = null;
            connection = null;
            connection = easService.getDatabase().getConnection();
            statement = connection.createStatement();
            budget = Budget.loadFromRdb(n, string, statement, easService.getDatabase().getDBSpecific());
            Object var6_6 = null;
            if (statement == null) break block12;
            try {
                statement.close();
            }
            catch (SQLException sQLException) {
                sQLException.printStackTrace();
            }
        }
        if (connection != null) {
            easService.getDatabase().freeConnection(connection);
        }
        return budget;
        catch (Exception exception) {
            block13: {
                try {
                    exception.printStackTrace();
                    Object var6_7 = null;
                    if (statement == null) break block13;
                }
                catch (Throwable throwable) {
                    Object var6_8 = null;
                    if (statement != null) {
                        try {
                            statement.close();
                        }
                        catch (SQLException sQLException) {
                            sQLException.printStackTrace();
                        }
                    }
                    if (connection != null) {
                        easService.getDatabase().freeConnection(connection);
                    }
                    throw throwable;
                }
                try {
                    statement.close();
                }
                catch (SQLException sQLException) {
                    sQLException.printStackTrace();
                }
            }
            if (connection != null) {
                easService.getDatabase().freeConnection(connection);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private static void saveBudget(int n, Budget budget) throws Exception {
        block15: {
            Connection connection;
            Statement statement;
            block13: {
                statement = null;
                connection = null;
                connection = easService.getDatabase().getConnection();
                statement = connection.createStatement();
                budget.saveToRdb(n, statement, easService.getDatabase().getDBSpecific());
                Object var6_4 = null;
                if (statement == null) break block13;
                try {
                    statement.close();
                }
                catch (SQLException sQLException) {
                    sQLException.printStackTrace();
                }
            }
            if (connection != null) {
                easService.getDatabase().freeConnection(connection);
            }
            break block15;
            {
                catch (Exception exception) {
                    exception.printStackTrace();
                    Object var6_5 = null;
                    if (statement != null) {
                        try {
                            statement.close();
                        }
                        catch (SQLException sQLException) {
                            sQLException.printStackTrace();
                        }
                    }
                    if (connection != null) {
                        easService.getDatabase().freeConnection(connection);
                    }
                }
            }
            catch (Throwable throwable) {
                Object var6_6 = null;
                if (statement != null) {
                    try {
                        statement.close();
                    }
                    catch (SQLException sQLException) {
                        sQLException.printStackTrace();
                    }
                }
                if (connection != null) {
                    easService.getDatabase().freeConnection(connection);
                }
                throw throwable;
            }
        }
    }
}

