/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.eas.util;

import com.tridium.eas.BDatabaseConfiguration;
import com.tridium.eas.enums.BDatabaseTypeEnum;
import com.tridium.eas.util.MSSqlServer;
import com.tridium.eas.util.Oracle;
import java.io.File;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import javax.baja.log.Log;
import javax.baja.naming.BHost;
import javax.baja.naming.BLocalHost;
import javax.baja.sys.Sys;

public class SqlUtil {
    public static final Object systemTableLock = new Object();
    public static BDatabaseConfiguration dbConfig = null;
    public static BDatabaseTypeEnum databaseType = BDatabaseTypeEnum.sqlServer;
    public static String databaseUser = null;
    public static String databasePass = null;
    public static String databaseName = null;
    public static File databaseDataFile = null;
    public static File databaseLogFile = null;
    public static String databaseCatalog = null;
    public static String databaseSchema = null;
    public static boolean databaseRemote = false;
    public static final Log log = Log.getLog((String)"eas");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void checkSchema(Connection connection, String string) throws SQLException {
        if (string == null) {
            return;
        }
        if (databaseType == BDatabaseTypeEnum.sqlServer) {
            return;
        }
        if (databaseType == BDatabaseTypeEnum.oracle) {
            return;
        }
        Object object = systemTableLock;
        synchronized (object) {
            Statement statement = connection.createStatement();
            try {
                statement.executeUpdate("create schema " + string);
            }
            catch (SQLException sQLException) {
                log.error("Error while checking schema", (Throwable)sQLException);
            }
            statement.close();
            connection.commit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean doesTableExist(Connection connection, String string, String string2) throws SQLException {
        if (databaseType == BDatabaseTypeEnum.sqlServer) {
            return MSSqlServer.doesTableExist(connection, string2);
        }
        if (databaseType == BDatabaseTypeEnum.oracle) {
            return Oracle.doesTableExist(connection, string2);
        }
        if (string != null) {
            string = string.toUpperCase();
        }
        string2 = string2.toUpperCase();
        boolean bl = false;
        Object object = systemTableLock;
        synchronized (object) {
            StringBuffer stringBuffer = new StringBuffer(100);
            stringBuffer.append("select true from sys.systables where tablename='").append(string2).append("' and sys.systables.schemaid=( select schemaid from sys.sysschemas where schemaname='").append(string).append("' )");
            PreparedStatement preparedStatement = connection.prepareStatement(stringBuffer.toString());
            ResultSet resultSet = preparedStatement.executeQuery();
            if (resultSet.next()) {
                bl = resultSet.getBoolean(1);
            }
            resultSet.close();
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void backupTable(Connection connection, String string, String string2) throws SQLException {
        if (databaseType == BDatabaseTypeEnum.sqlServer) {
            MSSqlServer.backupTable(connection, string2);
            return;
        }
        if (databaseType == BDatabaseTypeEnum.oracle) {
            Oracle.backupTable(connection, string2);
            return;
        }
        Object object = systemTableLock;
        synchronized (object) {
            for (int i = 0; i < 100; ++i) {
                String string3 = string2 + "_old" + i;
                if (SqlUtil.doesTableExist(connection, string, string3)) continue;
                SqlUtil.renameTable(connection, string, string2, string3);
                return;
            }
        }
        throw new IllegalStateException("Way too many old tables!");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void renameTable(Connection connection, String string, String string2, String string3) throws SQLException {
        if (databaseType == BDatabaseTypeEnum.sqlServer) {
            MSSqlServer.renameTable(connection, string2, string3);
            return;
        }
        if (databaseType == BDatabaseTypeEnum.oracle) {
            Oracle.renameTable(connection, string2, string3);
            return;
        }
        String string4 = SqlUtil.getFullName(string, string2);
        String string5 = SqlUtil.getFullName(string, string3);
        Object object = systemTableLock;
        synchronized (object) {
            try {
                SqlUtil.copyTable(connection, string, string2, string3);
            }
            catch (Exception exception) {
                log.error("Could not copy database table " + string4, (Throwable)exception);
            }
            log.warning("Dropping database table " + string4);
            Statement statement = connection.createStatement();
            statement.executeUpdate("drop table " + string4);
            statement.close();
        }
    }

    public static void copyTable(Connection connection, String string, String string2, String string3) throws SQLException {
        if (string != null) {
            string = string.toUpperCase();
        }
        string2 = string2.toUpperCase();
        string3 = string3.toUpperCase();
        String string4 = SqlUtil.getFullName(string, string3);
        String string5 = SqlUtil.getFullName(string, string2);
        databaseSchema = string;
        SqlUtil.setDatabase();
        StringBuffer stringBuffer = new StringBuffer(100);
        connection.setAutoCommit(false);
        Statement statement = connection.createStatement();
        try {
            ResultSet resultSet = connection.getMetaData().getColumns(databaseCatalog, databaseSchema, string2, null);
            boolean bl = true;
            while (resultSet.next()) {
                String string6;
                stringBuffer.setLength(0);
                if (bl) {
                    stringBuffer.append("create table " + string4 + "(");
                } else {
                    stringBuffer.append("alter table " + string4 + " add column ");
                }
                String string7 = resultSet.getString(4);
                String string8 = resultSet.getString(6);
                stringBuffer.append(string7 + " " + string8);
                if (string8.equalsIgnoreCase("VARCHAR") || string8.equalsIgnoreCase("CHAR")) {
                    int n = resultSet.getInt(7);
                    stringBuffer.append("(" + n + ")");
                }
                if ((string6 = resultSet.getString(18)).equalsIgnoreCase("NO")) {
                    stringBuffer.append(" NOT NULL");
                }
                if (bl) {
                    stringBuffer.append(")");
                    bl = false;
                }
                statement.executeUpdate(stringBuffer.toString());
            }
            connection.commit();
            statement.execute("insert into " + string4 + " select * from " + string5);
            statement.close();
            connection.commit();
        }
        catch (SQLException sQLException) {
            connection.rollback();
            throw sQLException;
        }
    }

    public static String getFullName(String string, String string2) {
        if (databaseType == BDatabaseTypeEnum.oracle) {
            return Oracle.getFullName(string2);
        }
        String string3 = null;
        databaseSchema = string;
        SqlUtil.setDatabase();
        string3 = databaseSchema == null ? string2 : databaseSchema + "." + string2;
        if (databaseType == BDatabaseTypeEnum.sqlServer) {
            string3 = "[" + databaseName + "].[" + databaseSchema + "].[" + string2 + "]";
        }
        return string3;
    }

    public static String getTableName(String string) {
        int n = string.indexOf(46);
        if (n > 0) {
            return string.substring(n + 1);
        }
        return string;
    }

    public static String ordToTable(String string) {
        char[] cArray = string.toCharArray();
        char[] cArray2 = new char[cArray.length * 2];
        int n = 0;
        for (int i = 1; i < cArray.length; ++i) {
            int n2 = cArray[i];
            if (n2 == 95) {
                cArray2[n++] = 95;
                cArray2[n++] = 95;
                continue;
            }
            cArray2[n++] = n2 == 47 ? 95 : n2;
        }
        return new String(cArray2, 0, n);
    }

    public static String tableToOrd(String string) {
        char[] cArray = string.toCharArray();
        char[] cArray2 = new char[cArray.length + 1];
        int n = 0;
        cArray2[n++] = 47;
        for (int i = 0; i < cArray.length; ++i) {
            char c = cArray[i];
            if (c == '_') {
                if (i + 1 < cArray.length && cArray[i + 1] == '_') {
                    cArray2[n++] = 95;
                    ++i;
                    continue;
                }
                cArray2[n++] = 47;
                continue;
            }
            cArray2[n++] = c;
        }
        return new String(cArray2, 0, n);
    }

    public static long getTimestamp(ResultSet resultSet, int n) throws SQLException {
        Timestamp timestamp = resultSet.getTimestamp(n);
        long l = timestamp.getTime();
        if (l % 1000L == 0L) {
            l += (long)(timestamp.getNanos() / 1000000);
        }
        return timestamp.getTime();
    }

    public static void setDatabase() {
        if (databaseType == BDatabaseTypeEnum.sqlServer) {
            databaseCatalog = databaseName;
            databaseSchema = "dbo";
        }
        if (databaseType == BDatabaseTypeEnum.oracle) {
            databaseCatalog = "USER_CATALOG";
            databaseSchema = databaseUser;
        }
    }

    public static void initDatabaseParameters(BDatabaseConfiguration bDatabaseConfiguration, Connection connection) {
        dbConfig = bDatabaseConfiguration;
        databaseType = bDatabaseConfiguration.getDatabaseType();
        if (databaseType == BDatabaseTypeEnum.sqlServer) {
            databaseUser = bDatabaseConfiguration.getDatabaseUser();
            databasePass = bDatabaseConfiguration.getDatabasePassword().getString();
            databaseName = bDatabaseConfiguration.getDatabaseName();
            databaseRemote = false;
            if ((BHost)bDatabaseConfiguration.getHostAddress().get() != BLocalHost.INSTANCE) {
                databaseRemote = true;
            }
            if (databaseName.equals("")) {
                databaseName = Sys.getStation().getStationName();
                bDatabaseConfiguration.setString(BDatabaseConfiguration.sqlServerDatabaseName, databaseName, BDatabaseConfiguration.noDbDisconnect);
            }
            databaseDataFile = new File(bDatabaseConfiguration.getSqlServerDbDataFilename());
            if (bDatabaseConfiguration.getSqlServerDbDataFilename().equals("")) {
                databaseDataFile = new File(Sys.getStationHome().getPath() + "\\" + "MSSqlData" + "\\" + databaseName + "_Data.mdf");
                bDatabaseConfiguration.setSqlServerDbDataFilename(databaseDataFile.getPath());
            }
            databaseLogFile = new File(bDatabaseConfiguration.getSqlServerDbLogFilename());
            if (bDatabaseConfiguration.getSqlServerDbLogFilename().equals("")) {
                databaseLogFile = new File(Sys.getStationHome().getPath() + "\\" + "MSSqlData" + "\\" + databaseName + "_Log.ldf");
                bDatabaseConfiguration.setSqlServerDbLogFilename(databaseLogFile.getPath());
            }
            MSSqlServer.prepareSqlStatements(connection);
        }
        if (databaseType == BDatabaseTypeEnum.oracle) {
            databaseUser = bDatabaseConfiguration.getDatabaseUser();
            databasePass = bDatabaseConfiguration.getDatabasePassword().getString();
            databaseName = bDatabaseConfiguration.getDatabaseName();
            databaseSchema = databaseUser;
            Oracle.prepareSqlStatements(connection);
            try {
                Oracle.makeRefTable(connection);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        SqlUtil.setDatabase();
    }
}

