/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.eas.util;

import com.tridium.eas.util.SqlUtil;
import java.io.File;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Vector;

public class Oracle
extends SqlUtil {
    private static boolean sqlStatementsPrepared = false;
    private static PreparedStatement psGetTableSummary;
    private static PreparedStatement psGetTableList;
    private static PreparedStatement psGetTSColumnName;
    private static PreparedStatement psGetColumnNameType;
    private static PreparedStatement psInsertRefTable;
    private static PreparedStatement psGetOracleTableName;
    private static PreparedStatement psGetNiagaraTableName;
    private static PreparedStatement psOracleTableExists;
    private static PreparedStatement psNiagaraTableExistsInRefTable;
    private static PreparedStatement psRenameTable;
    public static boolean cancelBackup;
    private static String vykonRefTable;
    private static String dummyTableName;
    private static String oracleTablePrefix;

    public static synchronized void prepareSqlStatements(Connection connection) {
        sqlStatementsPrepared = true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static synchronized String getNiagaraTableName(Connection connection, String string) throws Exception {
        String string2;
        block8: {
            string2 = null;
            ResultSet resultSet = null;
            if (!Oracle.doesOracleTableExist(connection, vykonRefTable)) {
                return string2;
            }
            try {
                try {
                    String string3 = string.substring(oracleTablePrefix.length(), string.length());
                    Integer n = new Integer(string3);
                    StringBuffer stringBuffer = new StringBuffer(100);
                    stringBuffer.append("select TableName from ").append(vykonRefTable).append(" where TableID = ?");
                    psGetNiagaraTableName = connection.prepareStatement(stringBuffer.toString());
                    psGetNiagaraTableName.setInt(1, n);
                    resultSet = psGetNiagaraTableName.executeQuery();
                    if (resultSet.next()) {
                        string2 = resultSet.getString(1);
                    }
                    resultSet.close();
                    psGetNiagaraTableName.close();
                }
                catch (Exception exception) {
                    log.error("Error in Oracle.getNiagaraTableName " + string, (Throwable)exception);
                    throw exception;
                }
                Object var8_8 = null;
                if (resultSet == null) break block8;
            }
            catch (Throwable throwable) {
                Object var8_9 = null;
                if (resultSet != null) {
                    resultSet.close();
                }
                if (psGetNiagaraTableName == null) throw throwable;
                psGetNiagaraTableName.close();
                throw throwable;
            }
            resultSet.close();
        }
        if (psGetNiagaraTableName == null) return string2;
        psGetNiagaraTableName.close();
        return string2;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static synchronized String getOracleTableName(Connection connection, String string) throws SQLException {
        String string2;
        block8: {
            ResultSet resultSet = null;
            string2 = null;
            if (!Oracle.doesOracleTableExist(connection, vykonRefTable)) {
                return string2;
            }
            try {
                try {
                    StringBuffer stringBuffer = new StringBuffer(100);
                    stringBuffer.append("select TableID from ").append(vykonRefTable).append(" where TableName = ?");
                    psGetOracleTableName = connection.prepareStatement(stringBuffer.toString());
                    psGetOracleTableName.setString(1, string.toUpperCase());
                    resultSet = psGetOracleTableName.executeQuery();
                    if (resultSet.next()) {
                        string2 = oracleTablePrefix + resultSet.getInt(1);
                    }
                    resultSet.close();
                    psGetOracleTableName.close();
                }
                catch (SQLException sQLException) {
                    log.error("Error in Oracle.getOracleTableName " + string, (Throwable)sQLException);
                    throw sQLException;
                }
                Object var6_6 = null;
                if (resultSet == null) break block8;
            }
            catch (Throwable throwable) {
                Object var6_7 = null;
                if (resultSet != null) {
                    resultSet.close();
                }
                if (psGetOracleTableName == null) throw throwable;
                psGetOracleTableName.close();
                throw throwable;
            }
            resultSet.close();
        }
        if (psGetOracleTableName == null) return string2;
        psGetOracleTableName.close();
        return string2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static synchronized boolean makeOracleTableName(Connection connection, String string) throws Exception {
        boolean bl = false;
        if (!Oracle.doesOracleTableExist(connection, vykonRefTable)) {
            return bl;
        }
        try {
            try {
                if (!Oracle.doesNiagaraTableExistInRefTable(connection, string)) {
                    StringBuffer stringBuffer = new StringBuffer(100);
                    stringBuffer.append("insert into ").append(vykonRefTable).append(" values( ( select ( MAX( TableID ) + 1 ) from ").append(vykonRefTable).append(" ), ? )");
                    psInsertRefTable = connection.prepareStatement(stringBuffer.toString());
                    psInsertRefTable.setString(1, string.toUpperCase());
                    psInsertRefTable.execute();
                    connection.commit();
                }
                bl = true;
            }
            catch (Exception exception) {
                log.error("Error in Oracle.makeOracleTableName " + string, (Throwable)exception);
                throw exception;
            }
            Object var5_5 = null;
            if (psInsertRefTable == null) return bl;
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            if (psInsertRefTable == null) throw throwable;
            psInsertRefTable.close();
            throw throwable;
        }
        psInsertRefTable.close();
        return bl;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static synchronized boolean doesNiagaraTableExistInRefTable(Connection connection, String string) throws SQLException {
        boolean bl;
        block6: {
            bl = false;
            ResultSet resultSet = null;
            try {
                try {
                    StringBuffer stringBuffer = new StringBuffer(100);
                    stringBuffer.append("select tableID from ").append(vykonRefTable).append(" where tableName = ?");
                    psNiagaraTableExistsInRefTable = connection.prepareStatement(stringBuffer.toString());
                    psNiagaraTableExistsInRefTable.setString(1, string.toUpperCase());
                    resultSet = psNiagaraTableExistsInRefTable.executeQuery();
                    bl = resultSet.next();
                }
                catch (SQLException sQLException) {
                    log.error("Error in Oracle.doesNiagaraTableExistInRefTable " + string, (Throwable)sQLException);
                    throw sQLException;
                }
                Object var6_6 = null;
                if (resultSet == null) break block6;
            }
            catch (Throwable throwable) {
                Object var6_7 = null;
                if (resultSet != null) {
                    resultSet.close();
                }
                if (psNiagaraTableExistsInRefTable == null) throw throwable;
                psNiagaraTableExistsInRefTable.close();
                throw throwable;
            }
            resultSet.close();
        }
        if (psNiagaraTableExistsInRefTable == null) return bl;
        psNiagaraTableExistsInRefTable.close();
        return bl;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static synchronized void makeRefTable(Connection connection) throws Exception {
        if (Oracle.doesOracleTableExist(connection, vykonRefTable)) {
            return;
        }
        Statement statement = null;
        String string = "create table " + vykonRefTable + " ( TableID INTEGER NOT NULL, TableName VARCHAR2( 256 ) NOT NULL UNIQUE )";
        String string2 = "alter table " + vykonRefTable + " ADD ( CONSTRAINT " + vykonRefTable + "_PK PRIMARY KEY ( TableID ) )";
        String string3 = "insert into " + vykonRefTable + " values( 0, '" + dummyTableName + "' )";
        try {
            try {
                connection.setAutoCommit(false);
                statement = connection.createStatement();
                statement.execute(string);
                statement.execute(string2);
                statement.execute(string3);
                connection.commit();
                connection.setAutoCommit(true);
            }
            catch (Exception exception) {
                log.error("Error in Oracle.makeRefTable", (Throwable)exception);
                throw exception;
            }
            Object var7_5 = null;
            if (statement == null) return;
        }
        catch (Throwable throwable) {
            Object var7_6 = null;
            if (statement == null) throw throwable;
            statement.close();
            throw throwable;
        }
        statement.close();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static synchronized boolean doesOracleTableExist(Connection connection, String string) throws SQLException {
        boolean bl;
        block6: {
            bl = false;
            ResultSet resultSet = null;
            try {
                try {
                    StringBuffer stringBuffer = new StringBuffer(100);
                    stringBuffer.append("select table_name from user_tables where table_name = ?");
                    psOracleTableExists = connection.prepareStatement(stringBuffer.toString());
                    psOracleTableExists.setString(1, string.toUpperCase());
                    resultSet = psOracleTableExists.executeQuery();
                    bl = resultSet.next();
                }
                catch (SQLException sQLException) {
                    log.error("Error in Oracle.doesOracleTableExist " + string, (Throwable)sQLException);
                    throw sQLException;
                }
                Object var6_6 = null;
                if (resultSet == null) break block6;
            }
            catch (Throwable throwable) {
                Object var6_7 = null;
                if (resultSet != null) {
                    resultSet.close();
                }
                if (psOracleTableExists == null) throw throwable;
                psOracleTableExists.close();
                throw throwable;
            }
            resultSet.close();
        }
        if (psOracleTableExists == null) return bl;
        psOracleTableExists.close();
        return bl;
    }

    public static synchronized File backupDatabase() throws Exception {
        File file = null;
        return file;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static synchronized void renameTable(Connection connection, String string, String string2) throws SQLException {
        try {
            try {
                StringBuffer stringBuffer = new StringBuffer(100);
                stringBuffer.append("rename ").append(string).append(" to ").append(string2);
                psRenameTable = connection.prepareStatement(stringBuffer.toString());
                psRenameTable.execute();
                log.warning("Oracle Rename table " + string + " to " + string2);
            }
            catch (SQLException sQLException) {
                log.error("Oracle Can Not Rename table " + string + " to " + string2, (Throwable)sQLException);
                throw sQLException;
            }
            Object var5_5 = null;
            if (psRenameTable == null) return;
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            if (psRenameTable == null) throw throwable;
            psRenameTable.close();
            throw throwable;
        }
        psRenameTable.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void backupTable(Connection connection, String string) throws SQLException {
        Object object = systemTableLock;
        synchronized (object) {
            String string2 = Oracle.getOracleTableName(connection, string);
            for (int i = 0; i < 100; ++i) {
                String string3 = string2 + "_old" + i;
                if (Oracle.doesTableExist(connection, string3)) continue;
                Oracle.renameTable(connection, string2, string3);
                return;
            }
        }
        throw new IllegalStateException("Way too many old tables!");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized String getFullName(String string) {
        Connection connection = null;
        String string2 = null;
        try {
            try {
                connection = dbConfig.getConnection();
                string2 = Oracle.getOracleTableName(connection, string);
            }
            catch (Exception exception) {
                log.error("Error in Oracle.getFullName " + string, (Throwable)exception);
                Object var5_4 = null;
                dbConfig.freeConnection(connection);
            }
            Object var5_3 = null;
            dbConfig.freeConnection(connection);
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            dbConfig.freeConnection(connection);
            throw throwable;
        }
        return string2;
    }

    public static synchronized boolean doesTableExist(Connection connection, String string) throws SQLException {
        boolean bl = false;
        String string2 = null;
        try {
            string2 = Oracle.getOracleTableName(connection, string);
            if (string2 == null) {
                return bl;
            }
            bl = Oracle.doesOracleTableExist(connection, string2);
        }
        catch (SQLException sQLException) {
            log.error("Error in Oracle.doesTableExist " + string, (Throwable)sQLException);
            throw sQLException;
        }
        return bl;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static synchronized String[] getTables(Connection connection) throws SQLException {
        Object[] objectArray;
        block7: {
            ResultSet resultSet = null;
            objectArray = null;
            try {
                try {
                    Vector<String> vector = new Vector<String>();
                    String string = "select tableName from " + vykonRefTable;
                    psGetTableList = connection.prepareStatement(string);
                    resultSet = psGetTableList.executeQuery();
                    while (resultSet.next()) {
                        String string2 = resultSet.getString(1);
                        if (string2.equalsIgnoreCase(dummyTableName)) continue;
                        vector.addElement(string2);
                    }
                    objectArray = new String[vector.size()];
                    vector.copyInto(objectArray);
                }
                catch (SQLException sQLException) {
                    log.error("Error in Oracle.getTables", (Throwable)sQLException);
                    throw sQLException;
                }
                Object var7_7 = null;
                if (resultSet == null) break block7;
            }
            catch (Throwable throwable) {
                Object var7_8 = null;
                if (resultSet != null) {
                    resultSet.close();
                }
                if (psGetTableList == null) throw throwable;
                psGetTableList.close();
                throw throwable;
            }
            resultSet.close();
        }
        if (psGetTableList == null) return objectArray;
        psGetTableList.close();
        return objectArray;
    }

    public static boolean databaseExists(Connection connection) throws SQLException {
        boolean bl = false;
        if (databaseName == null) {
            return bl;
        }
        return true;
    }

    public static boolean databaseFilesExist() {
        boolean bl = false;
        try {
            if (databaseDataFile.exists() && databaseLogFile.exists()) {
                bl = true;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return bl;
    }

    static {
        cancelBackup = false;
        vykonRefTable = "V##NAMES";
        dummyTableName = "V####Dummy";
        oracleTablePrefix = "V##";
    }
}

