/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.eas.ui.widgets;

import com.tridium.eas.ui.DecimalFormatter;
import com.tridium.eas.ui.widgets.ColorIcon;
import com.tridium.eas.ui.widgets.EasButton;
import com.tridium.eas.ui.widgets.NumberTextField;
import com.tridium.eas.ui.widgets.ValueColor;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Iterator;
import javax.baja.util.Lexicon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JColorChooser;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class ValueColorEditor
extends JComponent
implements ActionListener,
DocumentListener {
    private static final int MARGIN = 2;
    private static final String DEFAULT = "default";
    public static final String COLOR_CHANGED = "colorChanged";
    public static final String VALUE_CHANGED = "valueChanged";
    public static final String DEFAULT_TOGGLED = "defaultToggled";
    private Color color;
    private JButton colorButton;
    private JPanel valuePanel;
    private NumberTextField valueField;
    private JLabel defaultLabel;
    private JCheckBox defaultCheck;
    private ArrayList listeners;
    private Lexicon lex;

    public ValueColorEditor(Color color, Lexicon lexicon) {
        this.lex = lexicon;
        this.build(0.0f, color, true);
    }

    public ValueColorEditor(float f, Color color, Lexicon lexicon) {
        this.lex = lexicon;
        this.build(f, color, false);
    }

    public ValueColorEditor(ValueColor valueColor, Lexicon lexicon) {
        this.lex = lexicon;
        this.build(valueColor.getValue(), valueColor.getColor(), valueColor.isDefault());
    }

    public void setValueEditable(boolean bl) {
        if (!bl) {
            if (!this.isDefault()) {
                this.setDefaultDisplay(this.valueField.getText());
            }
            this.setValueComponent(this.defaultLabel);
            this.defaultCheck.setVisible(false);
        } else {
            if (this.isDefault()) {
                this.setDefaultDisplay(DEFAULT);
                this.setValueComponent(this.defaultLabel);
            } else {
                this.setValueComponent(this.valueField);
            }
            this.defaultCheck.setVisible(true);
        }
    }

    public ValueColor getValue() {
        if (this.isDefault()) {
            return new ValueColor(this.getColor());
        }
        return new ValueColor(this.getValue(0.0f), this.getColor());
    }

    public void setValue(ValueColor valueColor) {
        boolean bl = valueColor.isDefault();
        this.setDefault(bl);
        if (!bl) {
            this.valueField.setText(DecimalFormatter.format(valueColor.getValue()));
        }
        this.updateValueComponent();
        this.setColor(valueColor.getColor());
    }

    public float getValue(float f) {
        if (this.isDefault()) {
            return f;
        }
        return this.valueField.getFloatValue();
    }

    public void setValue(float f) {
        this.valueField.setText(DecimalFormatter.format(f));
    }

    public Color getColor() {
        return this.color;
    }

    public void setColor(Color color) {
        this.color = color;
        this.colorButton.setIcon(new ColorIcon(color));
    }

    public boolean isDefault() {
        return this.defaultCheck.isSelected();
    }

    public void setDefault(boolean bl) {
        this.defaultCheck.setSelected(bl);
    }

    public void setDefaultDisplay(String string) {
        if (string == null) {
            this.defaultLabel.setText(DEFAULT);
        } else {
            this.defaultLabel.setText(string);
        }
        this.defaultLabel.repaint();
    }

    private void build(float f, Color color, boolean bl) {
        this.valuePanel = new JPanel(false);
        this.valuePanel.setLayout(new BorderLayout());
        this.add(this.valuePanel);
        this.valueField = new NumberTextField(8, 16);
        this.valueField.setAllowNegative(true);
        this.valueField.getDocument().addDocumentListener(this);
        this.setValue(f);
        this.defaultLabel = new JLabel(DEFAULT);
        this.colorButton = new EasButton(new ColorIcon(Color.black));
        this.setColor(color);
        this.colorButton.addActionListener(this);
        this.add(this.colorButton);
        this.defaultCheck = new JCheckBox(DEFAULT);
        this.defaultCheck.setSelected(bl);
        this.defaultCheck.addActionListener(this);
        this.add(this.defaultCheck);
        this.updateValueComponent();
    }

    public Dimension getPreferredSize() {
        int n = 0;
        int n2 = 0;
        Dimension dimension = this.colorButton.getPreferredSize();
        Dimension dimension2 = this.valueField.getPreferredSize();
        Dimension dimension3 = this.defaultLabel.getPreferredSize();
        Dimension dimension4 = this.defaultCheck.getPreferredSize();
        Insets insets = this.getInsets();
        n = dimension.width + Math.max(dimension2.width, dimension3.width) + dimension4.width;
        n2 = Math.max(dimension.height, dimension2.height);
        n2 = Math.max(n2, dimension3.height);
        n2 = Math.max(n2, dimension4.height);
        return new Dimension(n, n2 + 4);
    }

    public void doLayout() {
        int n = this.getWidth();
        int n2 = this.getHeight();
        Dimension dimension = this.colorButton.getPreferredSize();
        Dimension dimension2 = this.valueField.getPreferredSize();
        Dimension dimension3 = this.defaultLabel.getPreferredSize();
        Dimension dimension4 = this.defaultCheck.getPreferredSize();
        Insets insets = this.getInsets();
        int n3 = n2 - insets.top - insets.bottom;
        int n4 = insets.left;
        this.colorButton.setBounds(n4, insets.top + (n3 - dimension.height) / 2, dimension.width, dimension.height);
        int n5 = Math.max(dimension2.width, dimension3.width);
        int n6 = Math.max(dimension2.height, dimension3.height);
        this.valuePanel.setBounds(n4 += dimension.width + 2, insets.top + (n3 - n6) / 2, n5, n6);
        this.defaultCheck.setBounds(n4 += n5 + 2, insets.top + (n3 - dimension4.height) / 2, dimension4.width, dimension4.height);
    }

    private void updateValueComponent() {
        boolean bl = this.isDefault();
        if (bl) {
            this.setValueComponent(this.defaultLabel);
        } else {
            this.setValueComponent(this.valueField);
        }
    }

    private void setValueComponent(Component component) {
        if (this.valuePanel.getComponentCount() == 1 && this.valuePanel.getComponent(0) == component) {
            return;
        }
        this.valuePanel.removeAll();
        this.valuePanel.add(component, "Center");
        this.valuePanel.invalidate();
        this.validate();
        this.repaint();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Color color;
        Object object = actionEvent.getSource();
        if (object == this.defaultCheck) {
            if (this.defaultCheck.isSelected()) {
                this.setValueComponent(this.defaultLabel);
            } else {
                this.setValueComponent(this.valueField);
                this.valueField.requestFocus();
                this.valueField.setCaretPosition(this.valueField.getText().length());
                this.valueField.selectAll();
            }
            this.fireAction(DEFAULT_TOGGLED);
            this.fireAction(VALUE_CHANGED);
        } else if (object == this.colorButton && (color = JColorChooser.showDialog(this, "Select Value Color", this.color)) != null) {
            this.setColor(color);
            this.fireAction(COLOR_CHANGED);
        }
    }

    public void changedUpdate(DocumentEvent documentEvent) {
        this.fireAction(VALUE_CHANGED);
    }

    public void insertUpdate(DocumentEvent documentEvent) {
        this.fireAction(VALUE_CHANGED);
    }

    public void removeUpdate(DocumentEvent documentEvent) {
        this.fireAction(VALUE_CHANGED);
    }

    public void addActionListener(ActionListener actionListener) {
        if (this.listeners == null) {
            this.listeners = new ArrayList(1);
        }
        this.listeners.add(actionListener);
    }

    public void removeActionListener(ActionListener actionListener) {
        if (this.listeners == null) {
            return;
        }
        this.listeners.remove(actionListener);
    }

    protected void fireAction(String string) {
        if (this.listeners == null) {
            return;
        }
        ActionEvent actionEvent = new ActionEvent(this, 1001, string);
        Iterator iterator = this.listeners.iterator();
        while (iterator.hasNext()) {
            ((ActionListener)iterator.next()).actionPerformed(actionEvent);
        }
    }
}

