/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.eas.ui.widgets;

import com.tridium.eas.ui.widgets.UserObjectComparator;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import javax.swing.AbstractListModel;

public class SortedListModel
extends AbstractListModel {
    private ArrayList listItems = new ArrayList();
    private Comparator comparator = null;

    public SortedListModel() {
        this.comparator = new UserObjectComparator();
    }

    public SortedListModel(Comparator comparator) {
        this.comparator = comparator;
    }

    public void removeAllElements() {
        int n = this.getSize();
        this.listItems.clear();
        if (n > 0) {
            this.fireIntervalRemoved(this, 0, n - 1);
        }
    }

    public int addElement(Object object) {
        Object e;
        if (this.contains(object)) {
            return this.indexOf(object);
        }
        int n = 0;
        Iterator iterator = this.listItems.iterator();
        while (iterator.hasNext() && this.comparator.compare(object, e = iterator.next()) >= 0) {
            ++n;
        }
        this.listItems.add(n, object);
        this.fireIntervalAdded(this, n, n);
        return n;
    }

    public boolean contains(Object object) {
        return this.listItems.contains(object);
    }

    public Object getElementAt(int n) {
        return this.listItems.get(n);
    }

    public void removeElement(Object object) {
        if (this.contains(object)) {
            this.removeElementAt(this.indexOf(object));
        }
    }

    public void removeElementAt(int n) {
        this.listItems.remove(n);
        this.fireIntervalRemoved(this, n, n);
    }

    public int getSize() {
        return this.listItems.size();
    }

    public int indexOf(Object object) {
        return this.listItems.indexOf(object);
    }
}

